/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.dml;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.condition.ShadowColumnCondition;
import org.apache.shardingsphere.shadow.route.engine.dml.AbstractShadowDMLStatementRouteEngine;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;

public final class ShadowInsertStatementRoutingEngine
extends AbstractShadowDMLStatementRouteEngine {
    private final InsertStatementContext insertStatementContext;

    @Override
    protected Optional<Collection<ShadowColumnCondition>> parseShadowColumnConditions() {
        LinkedList result = new LinkedList();
        Iterator<String> columnNamesIt = this.parseColumnNames().iterator();
        List insertValueContexts = this.insertStatementContext.getInsertValueContexts();
        int index = 0;
        while (columnNamesIt.hasNext()) {
            String columnName = columnNamesIt.next();
            Optional<Collection<Comparable<?>>> columnValues = this.getColumnValues(insertValueContexts, index);
            columnValues.ifPresent(values -> result.add(new ShadowColumnCondition(this.getSingleTableName(), columnName, (Collection<Comparable<?>>)values)));
            ++index;
        }
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    private Optional<Collection<Comparable<?>>> getColumnValues(List<InsertValueContext> insertValueContexts, int index) {
        LinkedList<Comparable> result = new LinkedList<Comparable>();
        for (InsertValueContext each : insertValueContexts) {
            Object valueObject = each.getValue(index);
            if (valueObject instanceof Comparable) {
                result.add((Comparable)valueObject);
                continue;
            }
            return Optional.empty();
        }
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    private Collection<String> parseColumnNames() {
        return this.insertStatementContext.getInsertColumnNames();
    }

    @Override
    protected Collection<SimpleTableSegment> getAllTables() {
        return this.insertStatementContext.getAllTables();
    }

    @Override
    protected ShadowOperationType getShadowOperationType() {
        return ShadowOperationType.INSERT;
    }

    @Override
    protected Optional<Collection<String>> parseSqlNotes() {
        LinkedList result = new LinkedList();
        ((InsertStatement)this.insertStatementContext.getSqlStatement()).getCommentSegments().forEach(each -> result.add(each.getText()));
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    @Generated
    public ShadowInsertStatementRoutingEngine(InsertStatementContext insertStatementContext) {
        this.insertStatementContext = insertStatementContext;
    }
}

