/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine.dml;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.shadow.api.shadow.ShadowOperationType;
import org.apache.shardingsphere.shadow.api.shadow.column.ColumnShadowAlgorithm;
import org.apache.shardingsphere.shadow.api.shadow.note.NoteShadowAlgorithm;
import org.apache.shardingsphere.shadow.condition.ShadowColumnCondition;
import org.apache.shardingsphere.shadow.condition.ShadowDetermineCondition;
import org.apache.shardingsphere.shadow.route.engine.ShadowRouteEngine;
import org.apache.shardingsphere.shadow.route.engine.determiner.ShadowDeterminerFactory;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;

public abstract class AbstractShadowDMLStatementRouteEngine
implements ShadowRouteEngine {
    private final Map<String, String> tableAliasNameMappings = new LinkedHashMap<String, String>();

    @Override
    public void route(RouteContext routeContext, ShadowRule shadowRule) {
        this.findShadowDataSourceMappings(shadowRule).ifPresent(shadowDataSourceMappings -> this.shadowRouteDecorate(routeContext, (Map<String, String>)shadowDataSourceMappings));
    }

    private Optional<Map<String, String>> findShadowDataSourceMappings(ShadowRule shadowRule) {
        Collection<String> relatedShadowTables = this.getRelatedShadowTables(this.getAllTables(), shadowRule);
        if (relatedShadowTables.isEmpty() && this.isMatchDefaultShadowAlgorithm(shadowRule)) {
            return Optional.of(shadowRule.getAllShadowDataSourceMappings());
        }
        ShadowOperationType shadowOperationType = this.getShadowOperationType();
        for (String each : relatedShadowTables) {
            if (!this.isShadowTable(each, shadowRule, shadowOperationType)) continue;
            return shadowRule.getRelatedShadowDataSourceMappings(each);
        }
        return Optional.empty();
    }

    private Collection<String> getRelatedShadowTables(Collection<SimpleTableSegment> simpleTableSegments, ShadowRule shadowRule) {
        LinkedHashSet<String> tableNames = new LinkedHashSet<String>();
        for (SimpleTableSegment each : simpleTableSegments) {
            String tableName = each.getTableName().getIdentifier().getValue();
            String alias = each.getAlias().isPresent() ? (String)each.getAlias().get() : tableName;
            tableNames.add(tableName);
            this.tableAliasNameMappings.put(alias, tableName);
        }
        return shadowRule.getRelatedShadowTables(tableNames);
    }

    private boolean isMatchDefaultShadowAlgorithm(ShadowRule shadowRule) {
        ShadowAlgorithm shadowAlgorithm;
        Optional<Collection<String>> sqlNotes = this.parseSqlNotes();
        if (!sqlNotes.isPresent()) {
            return false;
        }
        Optional<ShadowAlgorithm> defaultShadowAlgorithm = shadowRule.getDefaultShadowAlgorithm();
        if (defaultShadowAlgorithm.isPresent() && (shadowAlgorithm = defaultShadowAlgorithm.get()) instanceof NoteShadowAlgorithm) {
            ShadowDetermineCondition shadowDetermineCondition = new ShadowDetermineCondition("", ShadowOperationType.NOTE_MATCH);
            return this.isMatchNoteShadowAlgorithm((NoteShadowAlgorithm)shadowAlgorithm, shadowDetermineCondition.initSqlNotes(sqlNotes.get()), shadowRule);
        }
        return false;
    }

    private boolean isShadowTable(String tableName, ShadowRule shadowRule, ShadowOperationType shadowOperationType) {
        ShadowDetermineCondition shadowCondition = new ShadowDetermineCondition(tableName, shadowOperationType);
        if (this.isContainsShadowInSqlNotes(tableName, shadowRule, shadowCondition)) {
            return true;
        }
        return this.isContainsShadowInColumns(tableName, shadowRule, shadowCondition);
    }

    private boolean isContainsShadowInSqlNotes(String tableName, ShadowRule shadowRule, ShadowDetermineCondition shadowCondition) {
        return this.parseSqlNotes().filter(strings -> shadowRule.getRelatedNoteShadowAlgorithms(tableName).filter(shadowAlgorithms -> this.isMatchAnyNoteShadowAlgorithms((Collection<NoteShadowAlgorithm<Comparable<?>>>)shadowAlgorithms, shadowCondition.initSqlNotes((Collection<String>)strings), shadowRule)).isPresent()).isPresent();
    }

    private boolean isMatchAnyNoteShadowAlgorithms(Collection<NoteShadowAlgorithm<Comparable<?>>> shadowAlgorithms, ShadowDetermineCondition shadowCondition, ShadowRule shadowRule) {
        for (NoteShadowAlgorithm<Comparable<?>> each : shadowAlgorithms) {
            if (!this.isMatchNoteShadowAlgorithm(each, shadowCondition, shadowRule)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchNoteShadowAlgorithm(NoteShadowAlgorithm<Comparable<?>> noteShadowAlgorithm, ShadowDetermineCondition shadowCondition, ShadowRule shadowRule) {
        return ShadowDeterminerFactory.newInstance(noteShadowAlgorithm).isShadow(shadowCondition, shadowRule);
    }

    private boolean isContainsShadowInColumns(String tableName, ShadowRule shadowRule, ShadowDetermineCondition shadowCondition) {
        return shadowRule.getRelatedColumnShadowAlgorithms(tableName, shadowCondition.getShadowOperationType()).filter(shadowAlgorithms -> this.parseShadowColumnConditions().filter(columnConditions -> this.isMatchAnyColumnShadowAlgorithms((Collection<ColumnShadowAlgorithm<Comparable<?>>>)shadowAlgorithms, shadowCondition.initShadowColumnCondition((Collection<ShadowColumnCondition>)columnConditions), shadowRule)).isPresent()).isPresent();
    }

    private boolean isMatchAnyColumnShadowAlgorithms(Collection<ColumnShadowAlgorithm<Comparable<?>>> shadowAlgorithms, ShadowDetermineCondition shadowCondition, ShadowRule shadowRule) {
        for (ColumnShadowAlgorithm<Comparable<?>> each : shadowAlgorithms) {
            if (!this.isMatchColumnShadowAlgorithm(each, shadowCondition, shadowRule)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchColumnShadowAlgorithm(ColumnShadowAlgorithm<Comparable<?>> columnShadowAlgorithm, ShadowDetermineCondition shadowCondition, ShadowRule shadowRule) {
        return ShadowDeterminerFactory.newInstance(columnShadowAlgorithm).isShadow(shadowCondition, shadowRule);
    }

    protected abstract Optional<Collection<ShadowColumnCondition>> parseShadowColumnConditions();

    protected abstract Optional<Collection<String>> parseSqlNotes();

    protected abstract ShadowOperationType getShadowOperationType();

    protected abstract Collection<SimpleTableSegment> getAllTables();

    protected String getSingleTableName() {
        return this.tableAliasNameMappings.entrySet().iterator().next().getValue();
    }

    @Generated
    public Map<String, String> getTableAliasNameMappings() {
        return this.tableAliasNameMappings;
    }
}

