/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.shadow.rule.ShadowRule;

public interface ShadowRouteEngine {
    default public void shadowRouteDecorate(RouteContext routeContext, Map<String, String> shadowDataSourceMappings) {
        Collection routeUnits = routeContext.getRouteUnits();
        LinkedList<RouteUnit> toBeAdded = new LinkedList<RouteUnit>();
        for (RouteUnit each : routeUnits) {
            RouteMapper dataSourceMapper = each.getDataSourceMapper();
            String shadowActualName = shadowDataSourceMappings.get(dataSourceMapper.getActualName());
            if (null == shadowActualName) continue;
            toBeAdded.add(new RouteUnit(new RouteMapper(dataSourceMapper.getLogicName(), shadowActualName), each.getTableMappers()));
        }
        routeUnits.clear();
        routeUnits.addAll(toBeAdded);
    }

    public void route(RouteContext var1, ShadowRule var2);
}

