/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.checker;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.scope.SchemaRuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.resource.RequiredResourceMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.shadow.distsql.parser.segment.ShadowAlgorithmSegment;

public class ShadowRuleStatementChecker {
    public static final String SHADOW = "shadow";

    public static void checkConfigurationExist(String schemaName, SchemaRuleConfiguration configuration) throws DistSQLException {
        DistSQLException.predictionThrow((null != configuration ? 1 : 0) != 0, (DistSQLException)new RequiredRuleMissedException(SHADOW, schemaName));
    }

    public static void checkResourceExist(Collection<String> resources, ShardingSphereMetaData metaData, String schemaName) throws DistSQLException {
        Collection notExistedResources = metaData.getResource().getNotExistedResources(resources);
        DistSQLException.predictionThrow((boolean)notExistedResources.isEmpty(), (DistSQLException)new RequiredResourceMissedException(schemaName, notExistedResources));
    }

    public static void checkAlgorithmCompleteness(Collection<ShadowAlgorithmSegment> algorithmSegments) throws DistSQLException {
        Set incompleteAlgorithms = algorithmSegments.stream().filter(each -> !each.isComplete()).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)incompleteAlgorithms.isEmpty(), (DistSQLException)new InvalidAlgorithmConfigurationException(SHADOW));
    }

    public static void checkRulesExist(Collection<String> requireRules, Collection<String> currentRules, Function<Set<String>, DistSQLException> thrower) throws DistSQLException {
        ShadowRuleStatementChecker.checkAnyDifferent(requireRules, currentRules, thrower);
    }

    public static void checkAlgorithmExist(Collection<String> requireAlgorithms, Collection<String> currentAlgorithms, Function<Set<String>, DistSQLException> thrower) throws DistSQLException {
        ShadowRuleStatementChecker.checkAnyDifferent(requireAlgorithms, currentAlgorithms, thrower);
    }

    public static void checkAnyDuplicate(Collection<String> rules, Function<Set<String>, DistSQLException> thrower) throws DistSQLException {
        Set<String> duplicateRequire = ShadowRuleStatementChecker.getDuplicate(rules);
        DistSQLException.predictionThrow((boolean)duplicateRequire.isEmpty(), (DistSQLException)thrower.apply(duplicateRequire));
    }

    public static void checkAnyDuplicate(Collection<String> requireRules, Collection<String> currentRules, Function<Set<String>, DistSQLException> thrower) throws DistSQLException {
        Set<String> identical = ShadowRuleStatementChecker.getIdentical(requireRules, currentRules);
        DistSQLException.predictionThrow((boolean)identical.isEmpty(), (DistSQLException)thrower.apply(identical));
    }

    public static void checkAnyDifferent(Collection<String> requireRules, Collection<String> currentRules, Function<Set<String>, DistSQLException> thrower) throws DistSQLException {
        Set<String> different = ShadowRuleStatementChecker.getDifferent(requireRules, currentRules);
        DistSQLException.predictionThrow((boolean)different.isEmpty(), (DistSQLException)thrower.apply(different));
    }

    private static Set<String> getDuplicate(Collection<String> require) {
        return require.stream().collect(Collectors.groupingBy(each -> each, Collectors.counting())).entrySet().stream().filter(each -> (Long)each.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private static Set<String> getDifferent(Collection<String> require, Collection<String> current) {
        return require.stream().filter(each -> !current.contains(each)).collect(Collectors.toSet());
    }

    private static Set<String> getIdentical(Collection<String> require, Collection<String> current) {
        return require.stream().filter(current::contains).collect(Collectors.toSet());
    }
}

