/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.builder.util;

import com.google.common.base.Strings;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;

public class IndexMetaDataUtil {
    private static final String UNDERLINE = "_";
    private static final String GENERATED_LOGIC_INDEX_NAME_SUFFIX = "idx";

    public static String getLogicIndexName(String actualIndexName, String actualTableName) {
        String indexNameSuffix = UNDERLINE + actualTableName;
        return actualIndexName.endsWith(indexNameSuffix) ? actualIndexName.substring(0, actualIndexName.lastIndexOf(indexNameSuffix)) : actualIndexName;
    }

    public static String getActualIndexName(String logicIndexName, String actualTableName) {
        return Strings.isNullOrEmpty((String)actualTableName) ? logicIndexName : logicIndexName + UNDERLINE + actualTableName;
    }

    public static String getGeneratedLogicIndexName(Collection<ColumnSegment> columns) {
        StringBuilder builder = new StringBuilder();
        for (ColumnSegment each : columns) {
            builder.append(each.getIdentifier().getValue()).append(UNDERLINE);
        }
        return builder.append(GENERATED_LOGIC_INDEX_NAME_SUFFIX).toString();
    }

    @Generated
    private IndexMetaDataUtil() {
    }
}

