/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.builder;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.builder.spi.RuleBasedTableMetaDataBuilder;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.ordered.OrderedSPIRegistry;

public final class TableMetaDataBuilder {
    public static Map<String, TableMetaData> load(Collection<String> tableNames, SchemaBuilderMaterials materials) throws SQLException {
        LinkedHashMap<String, TableMetaData> result = new LinkedHashMap<String, TableMetaData>();
        for (Map.Entry entry : OrderedSPIRegistry.getRegisteredServices(RuleBasedTableMetaDataBuilder.class, materials.getRules()).entrySet()) {
            if (!(entry.getKey() instanceof TableContainedRule)) continue;
            TableContainedRule rule = (TableContainedRule)entry.getKey();
            RuleBasedTableMetaDataBuilder builder = (RuleBasedTableMetaDataBuilder)entry.getValue();
            Collection needLoadTables = tableNames.stream().filter(each -> rule.getTables().contains(each)).filter(each -> !result.containsKey(each)).collect(Collectors.toList());
            if (needLoadTables.isEmpty()) continue;
            result.putAll(builder.load(needLoadTables, rule, materials));
        }
        return result;
    }

    public static TableMetaData decorateFederationTableMetaData(TableMetaData tableMetaData, Collection<ShardingSphereRule> rules) {
        return TableMetaDataBuilder.decorateTableName(tableMetaData, rules);
    }

    public static TableMetaData decorateKernelTableMetaData(TableMetaData tableMetaData, Collection<ShardingSphereRule> rules) {
        TableMetaData result = TableMetaDataBuilder.decorateTableName(tableMetaData, rules);
        for (Map.Entry entry : OrderedSPIRegistry.getRegisteredServices(RuleBasedTableMetaDataBuilder.class, rules).entrySet()) {
            if (!(entry.getKey() instanceof TableContainedRule)) continue;
            result = ((RuleBasedTableMetaDataBuilder)entry.getValue()).decorate(result.getName(), result, (TableContainedRule)entry.getKey());
        }
        return result;
    }

    private static TableMetaData decorateTableName(TableMetaData tableMetaData, Collection<ShardingSphereRule> rules) {
        for (ShardingSphereRule each : rules) {
            Optional<String> logicTable;
            if (!(each instanceof DataNodeContainedRule) || !(logicTable = ((DataNodeContainedRule)each).findLogicTableByActualTable(tableMetaData.getName())).isPresent()) continue;
            return new TableMetaData(logicTable.get(), tableMetaData.getColumns().values(), tableMetaData.getIndexes().values());
        }
        return new TableMetaData(tableMetaData.getName(), tableMetaData.getColumns().values(), tableMetaData.getIndexes().values());
    }

    @Generated
    private TableMetaDataBuilder() {
    }

    static {
        ShardingSphereServiceLoader.register(RuleBasedTableMetaDataBuilder.class);
    }
}

