/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.rule;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class ShardingSphereRuleMetaData {
    private final Collection<RuleConfiguration> configurations;
    private final Collection<ShardingSphereRule> rules;

    public <T extends ShardingSphereRule> Collection<T> findRules(Class<T> clazz) {
        return this.rules.stream().filter(each -> clazz.isAssignableFrom(each.getClass())).map(clazz::cast).collect(Collectors.toList());
    }

    public <T extends ShardingSphereRule> Optional<T> findSingleRule(Class<T> clazz) {
        Collection<T> foundRules = this.findRules(clazz);
        return foundRules.isEmpty() ? Optional.empty() : Optional.of(foundRules.iterator().next());
    }

    @Generated
    public ShardingSphereRuleMetaData(Collection<RuleConfiguration> configurations, Collection<ShardingSphereRule> rules) {
        this.configurations = configurations;
        this.rules = rules;
    }

    @Generated
    public Collection<RuleConfiguration> getConfigurations() {
        return this.configurations;
    }

    @Generated
    public Collection<ShardingSphereRule> getRules() {
        return this.rules;
    }
}

