/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.singletable.rule;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.scope.SchemaRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.infra.rule.identifier.type.TableContainedRule;
import org.apache.shardingsphere.singletable.rule.SingleTableDataNode;
import org.apache.shardingsphere.singletable.rule.SingleTableDataNodeLoader;

public final class SingleTableRule
implements SchemaRule,
DataNodeContainedRule,
TableContainedRule,
MutableDataNodeRule {
    private final Collection<String> dataSourceNames;
    private final Map<String, SingleTableDataNode> singleTableDataNodes;

    public SingleTableRule(DatabaseType databaseType, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules, ConfigurationProperties props) {
        Map<String, DataSource> aggregateDataSourceMap = this.getAggregateDataSourceMap(dataSourceMap, builtRules);
        this.dataSourceNames = aggregateDataSourceMap.keySet();
        this.singleTableDataNodes = SingleTableDataNodeLoader.load(databaseType, aggregateDataSourceMap, this.getExcludedTables(builtRules), props);
    }

    private Map<String, DataSource> getAggregateDataSourceMap(Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> builtRules) {
        Map<String, DataSource> result = new LinkedHashMap<String, DataSource>(dataSourceMap);
        for (ShardingSphereRule each : builtRules) {
            if (!(each instanceof DataSourceContainedRule)) continue;
            result = this.getAggregateDataSourceMap(result, (DataSourceContainedRule)each);
        }
        return result;
    }

    private Map<String, DataSource> getAggregateDataSourceMap(Map<String, DataSource> dataSourceMap, DataSourceContainedRule builtRule) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>();
        for (Map.Entry entry : builtRule.getDataSourceMapper().entrySet()) {
            for (String each : (Collection)entry.getValue()) {
                if (!dataSourceMap.containsKey(each)) continue;
                result.putIfAbsent((String)entry.getKey(), dataSourceMap.remove(each));
            }
        }
        result.putAll(dataSourceMap);
        return result;
    }

    public boolean isSingleTablesInSameDataSource(Collection<String> singleTableNames) {
        Set dataSourceNames = singleTableNames.stream().map(this.singleTableDataNodes::get).filter(Objects::nonNull).map(SingleTableDataNode::getDataSourceName).collect(Collectors.toSet());
        return dataSourceNames.size() <= 1;
    }

    public boolean isAllTablesInSameDataSource(RouteContext routeContext, Collection<String> singleTableNames) {
        if (!this.isSingleTablesInSameDataSource(singleTableNames)) {
            return false;
        }
        SingleTableDataNode dataNode = this.singleTableDataNodes.get(singleTableNames.iterator().next());
        for (RouteUnit each : routeContext.getRouteUnits()) {
            if (each.getDataSourceMapper().getLogicName().equals(dataNode.getDataSourceName())) continue;
            return false;
        }
        return true;
    }

    public Collection<String> getSingleTableNames(Collection<String> logicTableNames) {
        return logicTableNames.stream().filter(this.singleTableDataNodes::containsKey).collect(Collectors.toCollection(LinkedList::new));
    }

    public void addDataNode(String tableName, String dataSourceName) {
        if (this.dataSourceNames.contains(dataSourceName) && !this.singleTableDataNodes.containsKey(tableName)) {
            this.singleTableDataNodes.put(tableName, new SingleTableDataNode(tableName, dataSourceName));
        }
    }

    public void dropDataNode(String tableName) {
        this.singleTableDataNodes.remove(tableName);
    }

    private Collection<String> getExcludedTables(Collection<ShardingSphereRule> rules) {
        return rules.stream().filter(each -> each instanceof DataNodeContainedRule).flatMap(each -> ((DataNodeContainedRule)each).getAllTables().stream()).collect(Collectors.toSet());
    }

    public Map<String, Collection<DataNode>> getAllDataNodes() {
        return this.singleTableDataNodes.values().stream().map(each -> new DataNode(each.getDataSourceName(), each.getTableName())).collect(Collectors.groupingBy(DataNode::getTableName, LinkedHashMap::new, Collectors.toCollection(LinkedList::new)));
    }

    public Collection<String> getAllActualTables() {
        return Collections.emptyList();
    }

    public Optional<String> findFirstActualTable(String logicTable) {
        return Optional.empty();
    }

    public boolean isNeedAccumulate(Collection<String> tables) {
        return false;
    }

    public Optional<String> findLogicTableByActualTable(String actualTable) {
        return Optional.empty();
    }

    public Optional<String> findActualTableByCatalog(String catalog, String logicTable) {
        return Optional.empty();
    }

    public Collection<String> getAllTables() {
        return this.singleTableDataNodes.keySet();
    }

    public Collection<String> getTables() {
        return this.singleTableDataNodes.keySet();
    }

    public String getType() {
        return SingleTableRule.class.getSimpleName();
    }

    @Generated
    public Collection<String> getDataSourceNames() {
        return this.dataSourceNames;
    }

    @Generated
    public Map<String, SingleTableDataNode> getSingleTableDataNodes() {
        return this.singleTableDataNodes;
    }
}

