/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.mysql.visitor.statement.impl;

import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.operation.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.type.DCLSQLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementParser;
import org.apache.shardingsphere.sql.parser.mysql.visitor.statement.impl.MySQLStatementSQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.ACLTypeEnum;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.GrantLevelSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.PrivilegeTypeEnum;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.NumberLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLAlterUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLCreateRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLCreateUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLDropRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLDropUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLGrantStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLRenameUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLRevokeStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLSetDefaultRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLSetPasswordStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLSetRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.ACLAttributeEnum;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.MySQLPrivilegeSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.MySQLRoleOrPrivilegeSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.PasswordOrLockOptionSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.SSLTypeEnum;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.TLSOptionSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.UserResourceSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.UserResourceSpecifiedLimitEnum;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.UserSegment;

public final class MySQLDCLStatementSQLVisitor
extends MySQLStatementSQLVisitor
implements DCLSQLVisitor,
SQLStatementVisitor {
    public MySQLDCLStatementSQLVisitor(Properties props) {
        super(props);
    }

    @Override
    public ASTNode visitGrantRoleOrPrivilegeTo(MySQLStatementParser.GrantRoleOrPrivilegeToContext ctx) {
        MySQLGrantStatement result = new MySQLGrantStatement();
        this.fillRoleOrPrivileges(result, ctx.roleOrPrivileges());
        for (MySQLStatementParser.UserNameContext each : ctx.userList().userName()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitGrantRoleOrPrivilegeOnTo(MySQLStatementParser.GrantRoleOrPrivilegeOnToContext ctx) {
        MySQLGrantStatement result = new MySQLGrantStatement();
        if (null != ctx.roleOrPrivileges()) {
            this.fillRoleOrPrivileges(result, ctx.roleOrPrivileges());
        } else {
            result.setAllPrivileges(true);
        }
        result.setLevel(this.generateGrantLevel(ctx.grantIdentifier()));
        for (MySQLStatementParser.UserNameContext each : ctx.userList().userName()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)each));
        }
        if (null != ctx.aclType()) {
            switch (ctx.aclType().getText().toLowerCase()) {
                case "function": {
                    result.setAclType(ACLTypeEnum.FUNCTION);
                    break;
                }
                case "procedure": {
                    result.setAclType(ACLTypeEnum.PROCEDURE);
                    break;
                }
                default: {
                    result.setAclType(ACLTypeEnum.TABLE);
                }
            }
        }
        return result;
    }

    @Override
    public ASTNode visitGrantProxy(MySQLStatementParser.GrantProxyContext ctx) {
        MySQLGrantStatement result = new MySQLGrantStatement();
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.PROXY().getSymbol().getStartIndex(), ctx.PROXY().getSymbol().getStopIndex(), PrivilegeTypeEnum.GRANT_ACL);
        result.getRoleOrPrivileges().add(new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege));
        for (MySQLStatementParser.UserNameContext each : ctx.userList().userName()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    private void fillRoleOrPrivileges(MySQLGrantStatement statement, MySQLStatementParser.RoleOrPrivilegesContext ctx) {
        for (MySQLStatementParser.RoleOrPrivilegeContext each : ctx.roleOrPrivilege()) {
            statement.getRoleOrPrivileges().add((MySQLRoleOrPrivilegeSegment)this.visit((ParseTree)each));
        }
    }

    private void fillRoleOrPrivileges(MySQLRevokeStatement statement, MySQLStatementParser.RoleOrPrivilegesContext ctx) {
        for (MySQLStatementParser.RoleOrPrivilegeContext each : ctx.roleOrPrivilege()) {
            statement.getRoleOrPrivileges().add((MySQLRoleOrPrivilegeSegment)this.visit((ParseTree)each));
        }
    }

    private GrantLevelSegment generateGrantLevel(MySQLStatementParser.GrantIdentifierContext ctx) {
        if (ctx instanceof MySQLStatementParser.GrantLevelGlobalContext) {
            return new GrantLevelSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), "*", "*");
        }
        if (ctx instanceof MySQLStatementParser.GrantLevelSchemaGlobalContext) {
            String schemaName = new IdentifierValue(((MySQLStatementParser.GrantLevelSchemaGlobalContext)ctx).schemaName().getText()).getValue();
            return new GrantLevelSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), schemaName, "*");
        }
        String schemaName = null;
        if (null != ((MySQLStatementParser.GrantLevelTableContext)ctx).tableName().owner()) {
            schemaName = new IdentifierValue(((MySQLStatementParser.GrantLevelTableContext)ctx).tableName().owner().getText()).getValue();
        }
        String tableName = new IdentifierValue(((MySQLStatementParser.GrantLevelTableContext)ctx).tableName().name().getText()).getValue();
        return new GrantLevelSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), schemaName, tableName);
    }

    @Override
    public ASTNode visitRoleOrDynamicPrivilege(MySQLStatementParser.RoleOrDynamicPrivilegeContext ctx) {
        String role = new IdentifierValue(ctx.roleIdentifierOrText().getText()).getValue();
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), role, null, null);
    }

    @Override
    public ASTNode visitRoleAtHost(MySQLStatementParser.RoleAtHostContext ctx) {
        String role = new IdentifierValue(ctx.roleIdentifierOrText().getText()).getValue();
        String host = new IdentifierValue(ctx.textOrIdentifier().getText()).getValue();
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), role, host, null);
    }

    @Override
    public ASTNode visitStaticPrivilegeSelect(MySQLStatementParser.StaticPrivilegeSelectContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.SELECT_ACL);
        if (null != ctx.columnNames()) {
            for (MySQLStatementParser.ColumnNameContext each : ctx.columnNames().columnName()) {
                privilege.getColumns().add(new IdentifierValue(each.getText()).getValue());
            }
        }
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeInsert(MySQLStatementParser.StaticPrivilegeInsertContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.INSERT_ACL);
        if (null != ctx.columnNames()) {
            for (MySQLStatementParser.ColumnNameContext each : ctx.columnNames().columnName()) {
                privilege.getColumns().add(new IdentifierValue(each.getText()).getValue());
            }
        }
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeUpdate(MySQLStatementParser.StaticPrivilegeUpdateContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.UPDATE_ACL);
        if (null != ctx.columnNames()) {
            for (MySQLStatementParser.ColumnNameContext each : ctx.columnNames().columnName()) {
                privilege.getColumns().add(new IdentifierValue(each.getText()).getValue());
            }
        }
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeReferences(MySQLStatementParser.StaticPrivilegeReferencesContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.REFERENCES_ACL);
        if (null != ctx.columnNames()) {
            for (MySQLStatementParser.ColumnNameContext each : ctx.columnNames().columnName()) {
                privilege.getColumns().add(new IdentifierValue(each.getText()).getValue());
            }
        }
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeDelete(MySQLStatementParser.StaticPrivilegeDeleteContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.DELETE_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeUsage(MySQLStatementParser.StaticPrivilegeUsageContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.USAGE_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeIndex(MySQLStatementParser.StaticPrivilegeIndexContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.INDEX_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeAlter(MySQLStatementParser.StaticPrivilegeAlterContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.ALTER_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeCreate(MySQLStatementParser.StaticPrivilegeCreateContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.CREATE_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeDrop(MySQLStatementParser.StaticPrivilegeDropContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.DROP_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeExecute(MySQLStatementParser.StaticPrivilegeExecuteContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.EXECUTE_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeReload(MySQLStatementParser.StaticPrivilegeReloadContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.RELOAD_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeShutdown(MySQLStatementParser.StaticPrivilegeShutdownContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.SHUTDOWN_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeProcess(MySQLStatementParser.StaticPrivilegeProcessContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.PROCESS_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeFile(MySQLStatementParser.StaticPrivilegeFileContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.FILE_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeGrant(MySQLStatementParser.StaticPrivilegeGrantContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.GRANT_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeShowDatabases(MySQLStatementParser.StaticPrivilegeShowDatabasesContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.SHOW_DB_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeSuper(MySQLStatementParser.StaticPrivilegeSuperContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.SUPER_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeCreateTemporaryTables(MySQLStatementParser.StaticPrivilegeCreateTemporaryTablesContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.CREATE_TMP_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeLockTables(MySQLStatementParser.StaticPrivilegeLockTablesContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.LOCK_TABLES_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeReplicationSlave(MySQLStatementParser.StaticPrivilegeReplicationSlaveContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.REPL_SLAVE_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeReplicationClient(MySQLStatementParser.StaticPrivilegeReplicationClientContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.REPL_CLIENT_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeCreateView(MySQLStatementParser.StaticPrivilegeCreateViewContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.CREATE_VIEW_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeShowView(MySQLStatementParser.StaticPrivilegeShowViewContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.SHOW_VIEW_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeCreateRoutine(MySQLStatementParser.StaticPrivilegeCreateRoutineContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.CREATE_PROC_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeAlterRoutine(MySQLStatementParser.StaticPrivilegeAlterRoutineContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.ALTER_PROC_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeCreateUser(MySQLStatementParser.StaticPrivilegeCreateUserContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.CREATE_USER_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeEvent(MySQLStatementParser.StaticPrivilegeEventContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.EVENT_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeTrigger(MySQLStatementParser.StaticPrivilegeTriggerContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.TRIGGER_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeCreateTablespace(MySQLStatementParser.StaticPrivilegeCreateTablespaceContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.CREATE_TABLESPACE_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeCreateRole(MySQLStatementParser.StaticPrivilegeCreateRoleContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.CREATE_ROLE_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitStaticPrivilegeDropRole(MySQLStatementParser.StaticPrivilegeDropRoleContext ctx) {
        MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.DROP_ROLE_ACL);
        return new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege);
    }

    @Override
    public ASTNode visitRevokeFrom(MySQLStatementParser.RevokeFromContext ctx) {
        MySQLRevokeStatement result = new MySQLRevokeStatement();
        if (null != ctx.roleOrPrivileges()) {
            this.fillRoleOrPrivileges(result, ctx.roleOrPrivileges());
        } else if (null != ctx.ALL()) {
            result.setAllPrivileges(true);
        }
        for (MySQLStatementParser.UserNameContext each : ctx.userList().userName()) {
            result.getFromUsers().add((UserSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitRevokeOnFrom(MySQLStatementParser.RevokeOnFromContext ctx) {
        MySQLRevokeStatement result = new MySQLRevokeStatement();
        if (null != ctx.roleOrPrivileges()) {
            this.fillRoleOrPrivileges(result, ctx.roleOrPrivileges());
        } else if (null != ctx.ALL()) {
            result.setAllPrivileges(true);
        } else if (null != ctx.PROXY()) {
            MySQLPrivilegeSegment privilege = new MySQLPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), PrivilegeTypeEnum.DROP_ROLE_ACL);
            result.getRoleOrPrivileges().add(new MySQLRoleOrPrivilegeSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), null, null, privilege));
            result.setOnUser((UserSegment)this.visit((ParseTree)ctx.userName()));
        }
        if (null != ctx.grantIdentifier()) {
            result.setLevel(this.generateGrantLevel(ctx.grantIdentifier()));
        }
        for (MySQLStatementParser.UserNameContext each : ctx.userList().userName()) {
            result.getFromUsers().add((UserSegment)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateUser(MySQLStatementParser.CreateUserContext ctx) {
        MySQLCreateUserStatement result = new MySQLCreateUserStatement();
        for (MySQLStatementParser.CreateUserEntryContext createUserEntryContext : ctx.createUserList().createUserEntry()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)createUserEntryContext));
        }
        if (null != ctx.defaultRoleClause()) {
            for (MySQLStatementParser.RoleNameContext roleNameContext : ctx.defaultRoleClause().roleName()) {
                result.getDefaultRoles().add(roleNameContext.getText());
            }
        }
        if (null != ctx.requireClause()) {
            result.setTlsOptionSegment((TLSOptionSegment)this.visit((ParseTree)ctx.requireClause()));
        }
        if (null != ctx.connectOptions()) {
            result.setUserResource((UserResourceSegment)this.visit((ParseTree)ctx.connectOptions()));
        }
        if (null != ctx.accountLockPasswordExpireOptions()) {
            result.setPasswordOrLockOption((PasswordOrLockOptionSegment)this.visit((ParseTree)ctx.accountLockPasswordExpireOptions()));
        }
        return result;
    }

    @Override
    public ASTNode visitRequireClause(MySQLStatementParser.RequireClauseContext ctx) {
        TLSOptionSegment result = new TLSOptionSegment();
        if (null != ctx.NONE()) {
            result.setType(SSLTypeEnum.SSL_TYPE_NONE);
        } else if (null != ctx.X509()) {
            result.setType(SSLTypeEnum.SSL_TYPE_X509);
        } else if (null != ctx.SSL()) {
            result.setType(SSLTypeEnum.SSL_TYPE_ANY);
        } else {
            result.setType(SSLTypeEnum.SSL_TYPE_SPECIFIED);
            for (MySQLStatementParser.TlsOptionContext each : ctx.tlsOption()) {
                if (null != each.SUBJECT()) {
                    result.setX509Subject(each.string_().getText());
                    continue;
                }
                if (null != each.ISSUER()) {
                    result.setX509Issuer(each.string_().getText());
                    continue;
                }
                if (null == each.CIPHER()) continue;
                result.setX509Cipher(each.string_().getText());
            }
        }
        return result;
    }

    @Override
    public ASTNode visitConnectOptions(MySQLStatementParser.ConnectOptionsContext ctx) {
        UserResourceSegment result = new UserResourceSegment();
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        for (MySQLStatementParser.ConnectOptionContext each : ctx.connectOption()) {
            if (null != each.MAX_QUERIES_PER_HOUR()) {
                result.setSpecifiedLimits(UserResourceSpecifiedLimitEnum.QUERIES_PER_HOUR);
                result.setQuestions(new NumberLiteralValue(each.NUMBER_().getText()).getValue().intValue());
            }
            if (null != each.MAX_UPDATES_PER_HOUR()) {
                result.setSpecifiedLimits(UserResourceSpecifiedLimitEnum.UPDATES_PER_HOUR);
                result.setUpdates(new NumberLiteralValue(each.NUMBER_().getText()).getValue().intValue());
            }
            if (null != each.MAX_CONNECTIONS_PER_HOUR()) {
                result.setSpecifiedLimits(UserResourceSpecifiedLimitEnum.CONNECTIONS_PER_HOUR);
                result.setConnPerHour(new NumberLiteralValue(each.NUMBER_().getText()).getValue().intValue());
            }
            if (null == each.MAX_USER_CONNECTIONS()) continue;
            result.setSpecifiedLimits(UserResourceSpecifiedLimitEnum.USER_CONNECTIONS);
            result.setUserConn(new NumberLiteralValue(each.NUMBER_().getText()).getValue().intValue());
        }
        return result;
    }

    @Override
    public ASTNode visitCreateUserEntryNoOption(MySQLStatementParser.CreateUserEntryNoOptionContext ctx) {
        UserSegment result = (UserSegment)this.visit((ParseTree)ctx.userName());
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        return result;
    }

    @Override
    public ASTNode visitCreateUserEntryIdentifiedBy(MySQLStatementParser.CreateUserEntryIdentifiedByContext ctx) {
        UserSegment result = (UserSegment)this.visit((ParseTree)ctx.userName());
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        if (null != ctx.string_()) {
            result.setAuth(((StringLiteralValue)this.visit((ParseTree)ctx.string_())).getValue());
            result.setHasPasswordGenerator(false);
            result.setUsesIdentifiedByClause(true);
            result.setDiscardOldPassword(false);
        } else {
            result.setHasPasswordGenerator(true);
            result.setUsesIdentifiedByClause(true);
            result.setDiscardOldPassword(false);
            result.setUsesIdentifiedWithClause(false);
        }
        result.setRetainCurrentPassword(false);
        return result;
    }

    @Override
    public ASTNode visitCreateUserEntryIdentifiedWith(MySQLStatementParser.CreateUserEntryIdentifiedWithContext ctx) {
        UserSegment result = (UserSegment)this.visit((ParseTree)ctx.userName());
        result.setStartIndex(ctx.start.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        if (null != ctx.textOrIdentifier()) {
            result.setPlugin(ctx.textOrIdentifier().getText());
            result.setHasPasswordGenerator(false);
            result.setUsesIdentifiedByClause(true);
            result.setDiscardOldPassword(false);
            result.setRetainCurrentPassword(false);
        } else if (null != ctx.AS()) {
            result.setPlugin(ctx.textOrIdentifier().getText());
            result.setAuth(((StringLiteralValue)this.visit((ParseTree)ctx.string_())).getValue());
            result.setHasPasswordGenerator(false);
            result.setUsesIdentifiedByClause(true);
            result.setDiscardOldPassword(false);
            result.setRetainCurrentPassword(false);
        } else if (null != ctx.BY() && null != ctx.string_()) {
            result.setPlugin(ctx.textOrIdentifier().getText());
            result.setAuth(((StringLiteralValue)this.visit((ParseTree)ctx.string_())).getValue());
            result.setHasPasswordGenerator(false);
            result.setUsesIdentifiedByClause(true);
            result.setUsesIdentifiedWithClause(true);
            result.setDiscardOldPassword(false);
            result.setRetainCurrentPassword(false);
        } else {
            result.setPlugin(ctx.textOrIdentifier().getText());
            result.setAuth(((StringLiteralValue)this.visit((ParseTree)ctx.string_())).getValue());
            result.setHasPasswordGenerator(true);
            result.setUsesIdentifiedByClause(true);
            result.setUsesIdentifiedWithClause(true);
            result.setDiscardOldPassword(false);
            result.setRetainCurrentPassword(false);
        }
        return result;
    }

    @Override
    public ASTNode visitAccountLockPasswordExpireOptions(MySQLStatementParser.AccountLockPasswordExpireOptionsContext ctx) {
        PasswordOrLockOptionSegment result = new PasswordOrLockOptionSegment();
        for (MySQLStatementParser.AccountLockPasswordExpireOptionContext each : ctx.accountLockPasswordExpireOption()) {
            this.fillAccountLockPasswordExpireOption(result, each);
        }
        return result;
    }

    private void fillAccountLockPasswordExpireOption(PasswordOrLockOptionSegment segment, MySQLStatementParser.AccountLockPasswordExpireOptionContext ctx) {
        if (null != ctx.ACCOUNT()) {
            this.fillAccountLock(segment, ctx);
        } else if (null != ctx.PASSWORD() && null != ctx.EXPIRE()) {
            this.fillPasswordExpire(segment, ctx);
        } else if (null != ctx.PASSWORD() && null != ctx.HISTORY()) {
            this.fillPasswordHistory(segment, ctx);
        } else if (null != ctx.PASSWORD() && null != ctx.REUSE()) {
            this.fillPasswordReuse(segment, ctx);
        } else if (null != ctx.PASSWORD() && null != ctx.REQUIRE()) {
            this.fillPasswordRequire(segment, ctx);
        } else if (null != ctx.FAILED_LOGIN_ATTEMPTS()) {
            segment.setUpdateFailedLoginAttempts(true);
            segment.setFailedLoginAttempts(new NumberLiteralValue(ctx.NUMBER_().getText()).getValue().intValue());
        } else if (null != ctx.UNBOUNDED()) {
            segment.setUpdatePasswordLockTime(true);
            segment.setPasswordLockTime(-1);
        } else {
            segment.setUpdatePasswordLockTime(true);
            segment.setPasswordLockTime(new NumberLiteralValue(ctx.NUMBER_().getText()).getValue().intValue());
        }
    }

    private void fillAccountLock(PasswordOrLockOptionSegment segment, MySQLStatementParser.AccountLockPasswordExpireOptionContext ctx) {
        if (null != ctx.LOCK()) {
            segment.setUpdateAccountLockedColumn(true);
            segment.setAccountLocked(true);
        } else {
            segment.setUpdateAccountLockedColumn(true);
            segment.setAccountLocked(false);
        }
    }

    private void fillPasswordExpire(PasswordOrLockOptionSegment segment, MySQLStatementParser.AccountLockPasswordExpireOptionContext ctx) {
        if (null != ctx.INTERVAL()) {
            segment.setExpireAfterDays(new NumberLiteralValue(ctx.NUMBER_().getText()).getValue().intValue());
            segment.setUpdatePasswordExpiredColumn(false);
            segment.setUpdatePasswordExpiredFields(true);
            segment.setUseDefaultPasswordLifeTime(false);
        } else if (null != ctx.NEVER()) {
            segment.setExpireAfterDays(0);
            segment.setUpdatePasswordExpiredColumn(false);
            segment.setUpdatePasswordExpiredFields(true);
            segment.setUseDefaultPasswordLifeTime(false);
        } else if (null != ctx.DEFAULT()) {
            segment.setExpireAfterDays(0);
            segment.setUpdatePasswordExpiredColumn(false);
            segment.setUpdatePasswordExpiredFields(true);
            segment.setUseDefaultPasswordLifeTime(true);
        } else {
            segment.setExpireAfterDays(0);
            segment.setUpdatePasswordExpiredColumn(true);
            segment.setUpdatePasswordExpiredFields(true);
            segment.setUseDefaultPasswordLifeTime(true);
        }
    }

    private void fillPasswordHistory(PasswordOrLockOptionSegment segment, MySQLStatementParser.AccountLockPasswordExpireOptionContext ctx) {
        if (null != ctx.DEFAULT()) {
            segment.setPasswordHistoryLength(0);
            segment.setUpdatePasswordHistory(true);
            segment.setUseDefaultPasswordHistory(true);
        } else {
            segment.setPasswordHistoryLength(new NumberLiteralValue(ctx.NUMBER_().getText()).getValue().intValue());
            segment.setUpdatePasswordHistory(true);
            segment.setUseDefaultPasswordHistory(false);
        }
    }

    private void fillPasswordReuse(PasswordOrLockOptionSegment segment, MySQLStatementParser.AccountLockPasswordExpireOptionContext ctx) {
        if (null != ctx.DEFAULT()) {
            segment.setPasswordReuseInterval(0);
            segment.setUpdatePasswordReuseInterval(true);
            segment.setUseDefaultPasswordReuseInterval(true);
        } else {
            segment.setPasswordReuseInterval(new NumberLiteralValue(ctx.NUMBER_().getText()).getValue().intValue());
            segment.setUpdatePasswordReuseInterval(true);
            segment.setUseDefaultPasswordReuseInterval(false);
        }
    }

    private void fillPasswordRequire(PasswordOrLockOptionSegment segment, MySQLStatementParser.AccountLockPasswordExpireOptionContext ctx) {
        if (null != ctx.DEFAULT()) {
            segment.setUpdatePasswordRequireCurrent(ACLAttributeEnum.DEFAULT);
        } else if (null != ctx.OPTIONAL()) {
            segment.setUpdatePasswordRequireCurrent(ACLAttributeEnum.NO);
        } else {
            segment.setUpdatePasswordRequireCurrent(ACLAttributeEnum.YES);
        }
    }

    @Override
    public ASTNode visitUserName(MySQLStatementParser.UserNameContext ctx) {
        UserSegment result = new UserSegment();
        if (null != ctx.userIdentifierOrText()) {
            result.setUser(new IdentifierValue(ctx.userIdentifierOrText().textOrIdentifier(0).getText()).getValue());
            if (null != ctx.userIdentifierOrText().AT_()) {
                result.setHost(new IdentifierValue(ctx.userIdentifierOrText().textOrIdentifier(1).getText()).getValue());
            }
        }
        return result;
    }

    @Override
    public ASTNode visitDropUser(MySQLStatementParser.DropUserContext ctx) {
        MySQLDropUserStatement result = new MySQLDropUserStatement();
        result.getUsers().addAll(ctx.userName().stream().map(RuleContext::getText).collect(Collectors.toList()));
        return result;
    }

    @Override
    public ASTNode visitAlterUser(MySQLStatementParser.AlterUserContext ctx) {
        return new MySQLAlterUserStatement();
    }

    @Override
    public ASTNode visitRenameUser(MySQLStatementParser.RenameUserContext ctx) {
        return new MySQLRenameUserStatement();
    }

    @Override
    public ASTNode visitCreateRole(MySQLStatementParser.CreateRoleContext ctx) {
        return new MySQLCreateRoleStatement();
    }

    @Override
    public ASTNode visitDropRole(MySQLStatementParser.DropRoleContext ctx) {
        return new MySQLDropRoleStatement();
    }

    @Override
    public ASTNode visitSetDefaultRole(MySQLStatementParser.SetDefaultRoleContext ctx) {
        return new MySQLSetDefaultRoleStatement();
    }

    @Override
    public ASTNode visitSetRole(MySQLStatementParser.SetRoleContext ctx) {
        return new MySQLSetRoleStatement();
    }

    @Override
    public ASTNode visitSetPassword(MySQLStatementParser.SetPasswordContext ctx) {
        return new MySQLSetPasswordStatement();
    }

    @Generated
    public MySQLDCLStatementSQLVisitor() {
    }
}

