/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.converter;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.DatabaseDiscoveryRuleSegment;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;

public final class DatabaseDiscoveryRuleStatementConverter {
    public static DatabaseDiscoveryRuleConfiguration convert(Collection<DatabaseDiscoveryRuleSegment> ruleSegments) {
        LinkedList<DatabaseDiscoveryDataSourceRuleConfiguration> dataSources = new LinkedList<DatabaseDiscoveryDataSourceRuleConfiguration>();
        HashMap<String, ShardingSphereAlgorithmConfiguration> discoveryTypes = new HashMap<String, ShardingSphereAlgorithmConfiguration>(ruleSegments.size(), 1.0f);
        for (DatabaseDiscoveryRuleSegment each : ruleSegments) {
            String type = DatabaseDiscoveryRuleStatementConverter.getDatabaseDiscoveryType(each.getName(), each.getDiscoveryTypeName());
            dataSources.add(new DatabaseDiscoveryDataSourceRuleConfiguration(each.getName(), new LinkedList(each.getDataSources()), type));
            discoveryTypes.put(type, new ShardingSphereAlgorithmConfiguration(each.getDiscoveryTypeName(), each.getProps()));
        }
        return new DatabaseDiscoveryRuleConfiguration(dataSources, discoveryTypes);
    }

    private static String getDatabaseDiscoveryType(String ruleName, String type) {
        return String.format("%s_%s", ruleName, type);
    }

    @Generated
    private DatabaseDiscoveryRuleStatementConverter() {
    }
}

