/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.statement;

import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.driver.executor.DriverExecutor;
import org.apache.shardingsphere.driver.executor.callback.ExecuteCallback;
import org.apache.shardingsphere.driver.executor.callback.ExecuteUpdateCallback;
import org.apache.shardingsphere.driver.executor.callback.impl.StatementExecuteQueryCallback;
import org.apache.shardingsphere.driver.jdbc.adapter.AbstractStatementAdapter;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.driver.jdbc.core.resultset.GeneratedKeysResultSet;
import org.apache.shardingsphere.driver.jdbc.core.resultset.ShardingSphereResultSet;
import org.apache.shardingsphere.driver.jdbc.exception.SQLExceptionErrorCode;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.context.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroup;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawSQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback.RawSQLExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorDriverManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.raw.RawExecutionPrepareEngine;
import org.apache.shardingsphere.infra.merge.MergeEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.parser.ShardingSphereSQLParserEngine;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.RawExecutionRule;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.DALStatement;

public final class ShardingSphereStatement
extends AbstractStatementAdapter {
    private final ShardingSphereConnection connection;
    private final MetaDataContexts metaDataContexts;
    private final List<Statement> statements;
    private final StatementOption statementOption;
    private final DriverExecutor executor;
    private final KernelProcessor kernelProcessor;
    private boolean returnGeneratedKeys;
    private ExecutionContext executionContext;
    private ResultSet currentResultSet;

    public ShardingSphereStatement(ShardingSphereConnection connection) {
        this(connection, 1003, 1007, 1);
    }

    public ShardingSphereStatement(ShardingSphereConnection connection, int resultSetType, int resultSetConcurrency) {
        this(connection, resultSetType, resultSetConcurrency, 1);
    }

    public ShardingSphereStatement(ShardingSphereConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(Statement.class);
        this.connection = connection;
        this.metaDataContexts = connection.getContextManager().getMetaDataContexts();
        this.statements = new LinkedList<Statement>();
        this.statementOption = new StatementOption(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.executor = new DriverExecutor(connection);
        this.kernelProcessor = new KernelProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ShardingSphereResultSet result;
        if (Strings.isNullOrEmpty((String)sql)) {
            SQLExceptionErrorCode errorCode = SQLExceptionErrorCode.SQL_STRING_NULL_OR_EMPTY;
            throw new SQLException(errorCode.getErrorMessage(), errorCode.getSqlState(), errorCode.getErrorCode());
        }
        try {
            this.executionContext = this.createExecutionContext(sql);
            List<QueryResult> queryResults = this.executeQuery0();
            MergedResult mergedResult = this.mergeQuery(queryResults);
            result = new ShardingSphereResultSet(this.getShardingSphereResultSets(), mergedResult, this, this.executionContext);
        }
        finally {
            this.currentResultSet = null;
        }
        this.currentResultSet = result;
        return result;
    }

    private List<ResultSet> getShardingSphereResultSets() throws SQLException {
        return this.executionContext.getRouteContext().isFederated() ? Collections.singletonList(this.executor.getFederationExecutor().getResultSet()) : this.statements.stream().map(this::getResultSet).collect(Collectors.toList());
    }

    private List<QueryResult> executeQuery0() throws SQLException {
        if (this.metaDataContexts.getMetaData(this.connection.getSchema()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof RawExecutionRule)) {
            return this.executor.getRawExecutor().execute(this.createRawExecutionContext(), this.executionContext.getLogicSQL(), new RawSQLExecutorCallback()).stream().map(each -> (QueryResult)each).collect(Collectors.toList());
        }
        if (this.executionContext.getRouteContext().isFederated()) {
            return this.executeFederationQuery();
        }
        ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionContext();
        this.cacheStatements(executionGroupContext.getInputGroups());
        StatementExecuteQueryCallback callback = new StatementExecuteQueryCallback(this.metaDataContexts.getMetaData(this.connection.getSchema()).getResource().getDatabaseType(), this.executionContext.getSqlStatementContext().getSqlStatement(), SQLExecutorExceptionHandler.isExceptionThrown());
        return this.executor.getRegularExecutor().executeQuery(executionGroupContext, this.executionContext.getLogicSQL(), callback);
    }

    private List<QueryResult> executeFederationQuery() throws SQLException {
        if (this.executionContext.getExecutionUnits().isEmpty()) {
            return Collections.emptyList();
        }
        StatementExecuteQueryCallback callback = new StatementExecuteQueryCallback(this.metaDataContexts.getMetaData(this.connection.getSchema()).getResource().getDatabaseType(), this.executionContext.getSqlStatementContext().getSqlStatement(), SQLExecutorExceptionHandler.isExceptionThrown());
        return this.executor.getFederationExecutor().executeQuery(this.createDriverExecutionPrepareEngine(), (JDBCExecutorCallback)callback, this.executionContext);
    }

    private DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> createDriverExecutionPrepareEngine() {
        int maxConnectionsSizePerQuery = (Integer)this.metaDataContexts.getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new DriverExecutionPrepareEngine("JDBC.STATEMENT", maxConnectionsSizePerQuery, (ExecutorDriverManager)this.connection.getConnectionManager(), (StorageResourceOption)this.statementOption, this.metaDataContexts.getMetaData(this.connection.getSchema()).getRuleMetaData().getRules());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            this.executionContext = this.createExecutionContext(sql);
            if (this.metaDataContexts.getMetaData(this.connection.getSchema()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof RawExecutionRule)) {
                int n = this.accumulate(this.executor.getRawExecutor().execute(this.createRawExecutionContext(), this.executionContext.getLogicSQL(), new RawSQLExecutorCallback()));
                return n;
            }
            ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionContext();
            this.cacheStatements(executionGroupContext.getInputGroups());
            int n = this.executeUpdate(executionGroupContext, (actualSQL, statement) -> statement.executeUpdate(actualSQL), this.executionContext.getSqlStatementContext(), this.executionContext.getRouteContext().getRouteUnits());
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 == autoGeneratedKeys) {
            this.returnGeneratedKeys = true;
        }
        try {
            this.executionContext = this.createExecutionContext(sql);
            if (this.metaDataContexts.getMetaData(this.connection.getSchema()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof RawExecutionRule)) {
                int n = this.accumulate(this.executor.getRawExecutor().execute(this.createRawExecutionContext(), this.executionContext.getLogicSQL(), new RawSQLExecutorCallback()));
                return n;
            }
            ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionContext();
            this.cacheStatements(executionGroupContext.getInputGroups());
            int n = this.executeUpdate(executionGroupContext, (actualSQL, statement) -> statement.executeUpdate(actualSQL, autoGeneratedKeys), this.executionContext.getSqlStatementContext(), this.executionContext.getRouteContext().getRouteUnits());
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            this.executionContext = this.createExecutionContext(sql);
            if (this.metaDataContexts.getMetaData(this.connection.getSchema()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof RawExecutionRule)) {
                int n = this.accumulate(this.executor.getRawExecutor().execute(this.createRawExecutionContext(), this.executionContext.getLogicSQL(), new RawSQLExecutorCallback()));
                return n;
            }
            ExecutionGroupContext<JDBCExecutionUnit> executionGroups = this.createExecutionContext();
            this.cacheStatements(executionGroups.getInputGroups());
            int n = this.executeUpdate(executionGroups, (actualSQL, statement) -> statement.executeUpdate(actualSQL, columnIndexes), this.executionContext.getSqlStatementContext(), this.executionContext.getRouteContext().getRouteUnits());
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            this.executionContext = this.createExecutionContext(sql);
            if (this.metaDataContexts.getMetaData(this.connection.getSchema()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof RawExecutionRule)) {
                int n = this.accumulate(this.executor.getRawExecutor().execute(this.createRawExecutionContext(), this.executionContext.getLogicSQL(), new RawSQLExecutorCallback()));
                return n;
            }
            ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionContext();
            this.cacheStatements(executionGroupContext.getInputGroups());
            int n = this.executeUpdate(executionGroupContext, (actualSQL, statement) -> statement.executeUpdate(actualSQL, columnNames), this.executionContext.getSqlStatementContext(), this.executionContext.getRouteContext().getRouteUnits());
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    private int executeUpdate(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, final ExecuteUpdateCallback updater, SQLStatementContext<?> sqlStatementContext, Collection<RouteUnit> routeUnits) throws SQLException {
        boolean isExceptionThrown = SQLExecutorExceptionHandler.isExceptionThrown();
        JDBCExecutorCallback<Integer> callback = new JDBCExecutorCallback<Integer>(this.metaDataContexts.getMetaData(this.connection.getSchema()).getResource().getDatabaseType(), sqlStatementContext.getSqlStatement(), isExceptionThrown){

            protected Integer executeSQL(String sql, Statement statement, ConnectionMode connectionMode) throws SQLException {
                return updater.executeUpdate(sql, statement);
            }

            protected Optional<Integer> getSaneResult(SQLStatement sqlStatement) {
                return Optional.empty();
            }
        };
        return this.executor.getRegularExecutor().executeUpdate(executionGroupContext, this.executionContext.getLogicSQL(), routeUnits, callback);
    }

    private int accumulate(Collection<ExecuteResult> results) {
        int result = 0;
        for (ExecuteResult each : results) {
            result += ((UpdateResult)each).getUpdateCount();
        }
        return result;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.execute0(sql, (actualSQL, statement) -> statement.execute(actualSQL));
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 == autoGeneratedKeys) {
            this.returnGeneratedKeys = true;
        }
        return this.execute0(sql, (actualSQL, statement) -> statement.execute(actualSQL, autoGeneratedKeys));
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.returnGeneratedKeys = true;
        return this.execute0(sql, (actualSQL, statement) -> statement.execute(actualSQL, columnIndexes));
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.returnGeneratedKeys = true;
        return this.execute0(sql, (actualSQL, statement) -> statement.execute(actualSQL, columnNames));
    }

    private boolean execute(ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, final ExecuteCallback executeCallback, SQLStatement sqlStatement, Collection<RouteUnit> routeUnits) throws SQLException {
        boolean isExceptionThrown = SQLExecutorExceptionHandler.isExceptionThrown();
        JDBCExecutorCallback<Boolean> jdbcExecutorCallback = new JDBCExecutorCallback<Boolean>(this.metaDataContexts.getMetaData(this.connection.getSchema()).getResource().getDatabaseType(), sqlStatement, isExceptionThrown){

            protected Boolean executeSQL(String sql, Statement statement, ConnectionMode connectionMode) throws SQLException {
                return executeCallback.execute(sql, statement);
            }

            protected Optional<Boolean> getSaneResult(SQLStatement sqlStatement) {
                return Optional.empty();
            }
        };
        return this.executor.getRegularExecutor().execute(executionGroupContext, this.executionContext.getLogicSQL(), routeUnits, jdbcExecutorCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute0(String sql, ExecuteCallback callback) throws SQLException {
        try {
            this.executionContext = this.createExecutionContext(sql);
            if (this.metaDataContexts.getMetaData(this.connection.getSchema()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof RawExecutionRule)) {
                Collection results = this.executor.getRawExecutor().execute(this.createRawExecutionContext(), this.executionContext.getLogicSQL(), new RawSQLExecutorCallback());
                boolean bl = results.iterator().next() instanceof QueryResult;
                return bl;
            }
            if (this.executionContext.getRouteContext().isFederated()) {
                List<QueryResult> queryResults = this.executeFederationQuery();
                boolean bl = !queryResults.isEmpty();
                return bl;
            }
            ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.createExecutionContext();
            this.cacheStatements(executionGroupContext.getInputGroups());
            boolean bl = this.execute(executionGroupContext, callback, this.executionContext.getSqlStatementContext().getSqlStatement(), this.executionContext.getRouteContext().getRouteUnits());
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    private void clearStatements() throws SQLException {
        for (Statement each : this.statements) {
            each.close();
        }
        this.statements.clear();
    }

    private LogicSQL createLogicSQL(String sql) {
        ShardingSphereSQLParserEngine sqlParserEngine = new ShardingSphereSQLParserEngine(DatabaseTypeRegistry.getTrunkDatabaseTypeName((DatabaseType)this.metaDataContexts.getMetaData(this.connection.getSchema()).getResource().getDatabaseType()), this.metaDataContexts.getProps());
        SQLStatement sqlStatement = sqlParserEngine.parse(sql, false);
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)this.metaDataContexts.getMetaDataMap(), Collections.emptyList(), (SQLStatement)sqlStatement, (String)this.connection.getSchema());
        return new LogicSQL(sqlStatementContext, sql, Collections.emptyList());
    }

    private ExecutionContext createExecutionContext(String sql) throws SQLException {
        this.clearStatements();
        LogicSQL logicSQL = this.createLogicSQL(sql);
        SQLCheckEngine.check((SQLStatement)logicSQL.getSqlStatementContext().getSqlStatement(), (List)logicSQL.getParameters(), (Collection)this.metaDataContexts.getMetaData(this.connection.getSchema()).getRuleMetaData().getRules(), (String)this.connection.getSchema(), (Map)this.metaDataContexts.getMetaDataMap(), null);
        return this.kernelProcessor.generateExecutionContext(logicSQL, this.metaDataContexts.getMetaData(this.connection.getSchema()), this.metaDataContexts.getProps());
    }

    private ExecutionGroupContext<JDBCExecutionUnit> createExecutionContext() throws SQLException {
        DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine = this.createDriverExecutionPrepareEngine();
        return prepareEngine.prepare(this.executionContext.getRouteContext(), this.executionContext.getExecutionUnits());
    }

    private ExecutionGroupContext<RawSQLExecutionUnit> createRawExecutionContext() throws SQLException {
        int maxConnectionsSizePerQuery = (Integer)this.metaDataContexts.getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return new RawExecutionPrepareEngine(maxConnectionsSizePerQuery, this.metaDataContexts.getMetaData(this.connection.getSchema()).getRuleMetaData().getRules()).prepare(this.executionContext.getRouteContext(), this.executionContext.getExecutionUnits());
    }

    private void cacheStatements(Collection<ExecutionGroup<JDBCExecutionUnit>> executionGroups) {
        for (ExecutionGroup<JDBCExecutionUnit> each : executionGroups) {
            this.statements.addAll(each.getInputs().stream().map(JDBCExecutionUnit::getStorageResource).collect(Collectors.toList()));
        }
        this.replay();
    }

    private void replay() {
        for (Statement each : this.statements) {
            this.getMethodInvocationRecorder().replay(each);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        if (this.executionContext.getSqlStatementContext() instanceof SelectStatementContext || this.executionContext.getSqlStatementContext().getSqlStatement() instanceof DALStatement) {
            List<ResultSet> resultSets = this.getResultSets();
            MergedResult mergedResult = this.mergeQuery(this.getQueryResults(resultSets));
            this.currentResultSet = new ShardingSphereResultSet(resultSets, mergedResult, this, this.executionContext);
        }
        return this.currentResultSet;
    }

    private ResultSet getResultSet(Statement statement) {
        try {
            return statement.getResultSet();
        }
        catch (SQLException ex) {
            throw new ShardingSphereException((Exception)ex);
        }
    }

    private List<ResultSet> getResultSets() throws SQLException {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>(this.statements.size());
        for (Statement each : this.statements) {
            result.add(each.getResultSet());
        }
        if (this.executionContext.getRouteContext().isFederated()) {
            result.add(this.executor.getFederationExecutor().getResultSet());
        }
        return result;
    }

    private List<QueryResult> getQueryResults(List<ResultSet> resultSets) throws SQLException {
        ArrayList<QueryResult> result = new ArrayList<QueryResult>(resultSets.size());
        for (ResultSet each : resultSets) {
            if (null == each) continue;
            result.add((QueryResult)new JDBCStreamQueryResult(each));
        }
        return result;
    }

    private MergedResult mergeQuery(List<QueryResult> queryResults) throws SQLException {
        ShardingSphereMetaData metaData = this.metaDataContexts.getMetaData(this.connection.getSchema());
        MergeEngine mergeEngine = new MergeEngine("logic_db", metaData.getResource().getDatabaseType(), metaData.getSchema(), this.metaDataContexts.getProps(), metaData.getRuleMetaData().getRules());
        return mergeEngine.merge(queryResults, this.executionContext.getSqlStatementContext());
    }

    @Override
    public int getResultSetType() {
        return this.statementOption.getResultSetType();
    }

    @Override
    public int getResultSetConcurrency() {
        return this.statementOption.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() {
        return this.statementOption.getResultSetHoldability();
    }

    @Override
    public boolean isAccumulate() {
        return this.metaDataContexts.getMetaData(this.connection.getSchema()).getRuleMetaData().getRules().stream().anyMatch(each -> each instanceof DataNodeContainedRule && ((DataNodeContainedRule)each).isNeedAccumulate(this.executionContext.getSqlStatementContext().getTablesContext().getTableNames()));
    }

    public Collection<Statement> getRoutedStatements() {
        return this.statements;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Optional<GeneratedKeyContext> generatedKey = this.findGeneratedKey();
        if (this.returnGeneratedKeys && generatedKey.isPresent() && !generatedKey.get().getGeneratedValues().isEmpty()) {
            return new GeneratedKeysResultSet(generatedKey.get().getColumnName(), generatedKey.get().getGeneratedValues().iterator(), this);
        }
        LinkedList<Comparable> generatedValues = new LinkedList<Comparable>();
        for (Statement statement : this.statements) {
            ResultSet resultSet = statement.getGeneratedKeys();
            while (resultSet.next()) {
                generatedValues.add((Comparable)resultSet.getObject(1));
            }
        }
        return new GeneratedKeysResultSet(null, generatedValues.iterator(), this);
    }

    private Optional<GeneratedKeyContext> findGeneratedKey() {
        return this.executionContext.getSqlStatementContext() instanceof InsertStatementContext ? ((InsertStatementContext)this.executionContext.getSqlStatementContext()).getGeneratedKeyContext() : Optional.empty();
    }

    @Override
    @Generated
    public ShardingSphereConnection getConnection() {
        return this.connection;
    }

    @Override
    @Generated
    protected DriverExecutor getExecutor() {
        return this.executor;
    }
}

