/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.driver.jdbc.adapter.AbstractDataSourceAdapter;
import org.apache.shardingsphere.driver.state.DriverStateContext;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.checker.RuleConfigurationCheckerFactory;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.config.scope.GlobalRuleConfiguration;
import org.apache.shardingsphere.infra.config.scope.SchemaRuleConfiguration;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderFactory;

public final class ShardingSphereDataSource
extends AbstractDataSourceAdapter
implements AutoCloseable {
    private final String schemaName;
    private final ContextManager contextManager;

    public ShardingSphereDataSource(String schemaName, ModeConfiguration modeConfig) throws SQLException {
        this.schemaName = schemaName;
        this.contextManager = this.createContextManager(schemaName, modeConfig, new HashMap<String, DataSource>(), new LinkedList<RuleConfiguration>(), new Properties(), false);
    }

    public ShardingSphereDataSource(String schemaName, ModeConfiguration modeConfig, Map<String, DataSource> dataSourceMap, Collection<RuleConfiguration> ruleConfigs, Properties props) throws SQLException {
        this.checkRuleConfiguration(schemaName, ruleConfigs);
        this.schemaName = schemaName;
        this.contextManager = this.createContextManager(schemaName, modeConfig, dataSourceMap, ruleConfigs, props, null == modeConfig || modeConfig.isOverwrite());
    }

    private void checkRuleConfiguration(String schemaName, Collection<RuleConfiguration> ruleConfigs) {
        ruleConfigs.forEach(each -> RuleConfigurationCheckerFactory.newInstance((RuleConfiguration)each).ifPresent(optional -> optional.check(schemaName, each)));
    }

    private ContextManager createContextManager(String schemaName, ModeConfiguration modeConfig, Map<String, DataSource> dataSourceMap, Collection<RuleConfiguration> ruleConfigs, Properties props, boolean isOverwrite) throws SQLException {
        Map<String, Map<String, DataSource>> dataSourcesMap = Collections.singletonMap(schemaName, dataSourceMap);
        Map schemaRuleConfigs = Collections.singletonMap(schemaName, ruleConfigs.stream().filter(each -> each instanceof SchemaRuleConfiguration).collect(Collectors.toList()));
        Collection globalRuleConfigs = ruleConfigs.stream().filter(each -> each instanceof GlobalRuleConfiguration).collect(Collectors.toList());
        return ContextManagerBuilderFactory.newInstance((ModeConfiguration)modeConfig).build(modeConfig, dataSourcesMap, schemaRuleConfigs, globalRuleConfigs, props, isOverwrite, null);
    }

    @Override
    public Connection getConnection() {
        return DriverStateContext.getConnection(this.schemaName, this.contextManager);
    }

    @Override
    public Connection getConnection(String username, String password) {
        return this.getConnection();
    }

    public void close(Collection<String> dataSourceNames) throws Exception {
        Map dataSourceMap = this.contextManager.getDataSourceMap(this.schemaName);
        for (String each : dataSourceNames) {
            this.close((DataSource)dataSourceMap.get(each));
        }
        this.contextManager.close();
    }

    private void close(DataSource dataSource) throws Exception {
        if (dataSource instanceof AutoCloseable) {
            ((AutoCloseable)((Object)dataSource)).close();
        }
    }

    @Override
    public void close() throws Exception {
        this.close(this.contextManager.getDataSourceMap(this.schemaName).keySet());
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        Map dataSourceMap = this.contextManager.getDataSourceMap(this.schemaName);
        return dataSourceMap.isEmpty() ? 0 : ((DataSource)dataSourceMap.values().iterator().next()).getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        for (DataSource each : this.contextManager.getDataSourceMap(this.schemaName).values()) {
            each.setLoginTimeout(seconds);
        }
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public ContextManager getContextManager() {
        return this.contextManager;
    }
}

