/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.executor;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.driver.executor.DriverJDBCExecutor;
import org.apache.shardingsphere.driver.jdbc.core.connection.ShardingSphereConnection;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawExecutor;
import org.apache.shardingsphere.infra.executor.sql.federate.FederationExecutor;
import org.apache.shardingsphere.infra.executor.sql.federate.FederationExecutorFactory;
import org.apache.shardingsphere.infra.optimize.context.OptimizerContext;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;

public final class DriverExecutor
implements AutoCloseable {
    private final DriverJDBCExecutor regularExecutor;
    private final RawExecutor rawExecutor;
    private final FederationExecutor federationExecutor;

    public DriverExecutor(ShardingSphereConnection connection) {
        MetaDataContexts metaDataContexts = connection.getContextManager().getMetaDataContexts();
        JDBCExecutor jdbcExecutor = new JDBCExecutor(metaDataContexts.getExecutorEngine(), connection.isHoldTransaction());
        this.regularExecutor = new DriverJDBCExecutor(connection.getSchema(), metaDataContexts, jdbcExecutor);
        this.rawExecutor = new RawExecutor(metaDataContexts.getExecutorEngine(), connection.isHoldTransaction(), metaDataContexts.getProps());
        this.federationExecutor = FederationExecutorFactory.newInstance((String)connection.getSchema(), (OptimizerContext)metaDataContexts.getOptimizerContext(), (ConfigurationProperties)metaDataContexts.getProps(), (JDBCExecutor)jdbcExecutor);
    }

    @Override
    public void close() throws SQLException {
        this.federationExecutor.close();
    }

    @Generated
    public DriverJDBCExecutor getRegularExecutor() {
        return this.regularExecutor;
    }

    @Generated
    public RawExecutor getRawExecutor() {
        return this.rawExecutor;
    }

    @Generated
    public FederationExecutor getFederationExecutor() {
        return this.federationExecutor;
    }
}

