/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.memory;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.metadata.resource.ShardingSphereResource;
import org.apache.shardingsphere.infra.metadata.schema.loader.SchemaLoader;
import org.apache.shardingsphere.infra.rule.builder.schema.SchemaRulesBuilder;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilder;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsBuilder;
import org.apache.shardingsphere.transaction.ShardingSphereTransactionManagerEngine;
import org.apache.shardingsphere.transaction.context.TransactionContexts;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.rule.builder.DefaultTransactionRuleConfigurationBuilder;

public final class MemoryContextManagerBuilder
implements ContextManagerBuilder {
    public ContextManager build(ModeConfiguration modeConfig, Map<String, Map<String, DataSource>> dataSourcesMap, Map<String, Collection<RuleConfiguration>> schemaRuleConfigs, Collection<RuleConfiguration> globalRuleConfigs, Properties props, boolean isOverwrite, Integer port) throws SQLException {
        Map rules = SchemaRulesBuilder.buildRules(dataSourcesMap, schemaRuleConfigs, (Properties)props);
        Map schemas = new SchemaLoader(dataSourcesMap, schemaRuleConfigs, rules, props).load();
        MetaDataContexts metaDataContexts = new MetaDataContextsBuilder(dataSourcesMap, schemaRuleConfigs, globalRuleConfigs, schemas, rules, props).build(null);
        TransactionContexts transactionContexts = this.createTransactionContexts(metaDataContexts);
        ContextManager result = new ContextManager();
        result.init(metaDataContexts, transactionContexts);
        return result;
    }

    private TransactionContexts createTransactionContexts(MetaDataContexts metaDataContexts) {
        HashMap<String, ShardingSphereTransactionManagerEngine> engines = new HashMap<String, ShardingSphereTransactionManagerEngine>(metaDataContexts.getAllSchemaNames().size(), 1.0f);
        TransactionRule transactionRule = this.getTransactionRule(metaDataContexts);
        for (String each : metaDataContexts.getAllSchemaNames()) {
            ShardingSphereTransactionManagerEngine engine = new ShardingSphereTransactionManagerEngine();
            ShardingSphereResource resource = metaDataContexts.getMetaData(each).getResource();
            engine.init(resource.getDatabaseType(), resource.getDataSources(), transactionRule);
            engines.put(each, engine);
        }
        return new TransactionContexts(engines);
    }

    private TransactionRule getTransactionRule(MetaDataContexts metaDataContexts) {
        Optional<TransactionRule> transactionRule = metaDataContexts.getGlobalRuleMetaData().getRules().stream().filter(each -> each instanceof TransactionRule).map(each -> (TransactionRule)each).findFirst();
        return transactionRule.orElseGet(() -> new TransactionRule(new DefaultTransactionRuleConfigurationBuilder().build()));
    }

    public String getType() {
        return "Memory";
    }

    public boolean isDefault() {
        return true;
    }
}

