/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.aware.DataSourceNameAware;
import org.apache.shardingsphere.infra.aware.DataSourceNameAwareFactory;
import org.apache.shardingsphere.readwritesplitting.api.rule.ReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.spi.ReplicaLoadBalanceAlgorithm;

public final class ReadwriteSplittingDataSourceRule {
    private final String name;
    private final String autoAwareDataSourceName;
    private final String writeDataSourceName;
    private final List<String> readDataSourceNames;
    private final ReplicaLoadBalanceAlgorithm loadBalancer;
    private final Collection<String> disabledDataSourceNames = new HashSet<String>();

    public ReadwriteSplittingDataSourceRule(ReadwriteSplittingDataSourceRuleConfiguration config, ReplicaLoadBalanceAlgorithm loadBalancer) {
        this.checkConfiguration(config);
        this.name = config.getName();
        this.autoAwareDataSourceName = config.getAutoAwareDataSourceName();
        this.writeDataSourceName = config.getWriteDataSourceName();
        this.readDataSourceNames = config.getReadDataSourceNames();
        this.loadBalancer = loadBalancer;
    }

    private void checkConfiguration(ReadwriteSplittingDataSourceRuleConfiguration config) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)config.getName()) ? 1 : 0) != 0, (Object)"Name is required.");
        if (Strings.isNullOrEmpty((String)config.getAutoAwareDataSourceName())) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)config.getWriteDataSourceName()) ? 1 : 0) != 0, (Object)"Write data source name is required.");
            Preconditions.checkArgument((null != config.getReadDataSourceNames() && !config.getReadDataSourceNames().isEmpty() ? 1 : 0) != 0, (Object)"Read data source names are required.");
        }
    }

    public List<String> getReadDataSourceNames() {
        return this.readDataSourceNames.stream().filter(each -> !this.disabledDataSourceNames.contains(each)).collect(Collectors.toList());
    }

    public void updateDisabledDataSourceNames(String dataSourceName, boolean isDisabled) {
        if (isDisabled) {
            this.disabledDataSourceNames.add(dataSourceName);
        } else {
            this.disabledDataSourceNames.remove(dataSourceName);
        }
    }

    public Map<String, Collection<String>> getDataSourceMapper() {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>(1, 1.0f);
        LinkedList<String> actualDataSourceNames = new LinkedList<String>();
        if (Strings.isNullOrEmpty((String)this.autoAwareDataSourceName)) {
            actualDataSourceNames.add(this.writeDataSourceName);
            actualDataSourceNames.addAll(this.readDataSourceNames);
        } else {
            Optional dataSourceNameAware = DataSourceNameAwareFactory.getInstance().getDataSourceNameAware();
            if (dataSourceNameAware.isPresent()) {
                actualDataSourceNames.add(((DataSourceNameAware)dataSourceNameAware.get()).getPrimaryDataSourceName(this.autoAwareDataSourceName));
                actualDataSourceNames.addAll(((DataSourceNameAware)dataSourceNameAware.get()).getReplicaDataSourceNames(this.autoAwareDataSourceName));
            }
        }
        result.put(this.name, actualDataSourceNames);
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getAutoAwareDataSourceName() {
        return this.autoAwareDataSourceName;
    }

    @Generated
    public String getWriteDataSourceName() {
        return this.writeDataSourceName;
    }

    @Generated
    public ReplicaLoadBalanceAlgorithm getLoadBalancer() {
        return this.loadBalancer;
    }
}

