/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.route.impl;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.aware.DataSourceNameAware;
import org.apache.shardingsphere.infra.aware.DataSourceNameAwareFactory;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingDataSourceRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.SelectStatementHandler;
import org.apache.shardingsphere.transaction.TransactionHolder;

public final class ReadwriteSplittingDataSourceRouter {
    private final ReadwriteSplittingDataSourceRule rule;

    public String route(SQLStatement sqlStatement) {
        Optional dataSourceNameAware;
        String autoAwareDataSourceName;
        if (this.isPrimaryRoute(sqlStatement)) {
            autoAwareDataSourceName = this.rule.getAutoAwareDataSourceName();
            if (Strings.isNullOrEmpty((String)autoAwareDataSourceName)) {
                return this.rule.getWriteDataSourceName();
            }
            dataSourceNameAware = DataSourceNameAwareFactory.getInstance().getDataSourceNameAware();
            if (dataSourceNameAware.isPresent()) {
                return ((DataSourceNameAware)dataSourceNameAware.get()).getPrimaryDataSourceName(autoAwareDataSourceName);
            }
        }
        if (Strings.isNullOrEmpty((String)(autoAwareDataSourceName = this.rule.getAutoAwareDataSourceName()))) {
            return this.rule.getLoadBalancer().getDataSource(this.rule.getName(), this.rule.getWriteDataSourceName(), this.rule.getReadDataSourceNames());
        }
        dataSourceNameAware = DataSourceNameAwareFactory.getInstance().getDataSourceNameAware();
        if (dataSourceNameAware.isPresent()) {
            Collection replicaDataSourceNames = ((DataSourceNameAware)dataSourceNameAware.get()).getReplicaDataSourceNames(autoAwareDataSourceName);
            return this.rule.getLoadBalancer().getDataSource(this.rule.getName(), this.rule.getWriteDataSourceName(), new ArrayList(replicaDataSourceNames));
        }
        return this.rule.getLoadBalancer().getDataSource(this.rule.getName(), this.rule.getWriteDataSourceName(), this.rule.getReadDataSourceNames());
    }

    private boolean isPrimaryRoute(SQLStatement sqlStatement) {
        return this.containsLockSegment(sqlStatement) || !(sqlStatement instanceof SelectStatement) || HintManager.isWriteRouteOnly() || TransactionHolder.isTransaction();
    }

    private boolean containsLockSegment(SQLStatement sqlStatement) {
        return sqlStatement instanceof SelectStatement && SelectStatementHandler.getLockSegment((SelectStatement)((SelectStatement)sqlStatement)).isPresent();
    }

    @Generated
    public ReadwriteSplittingDataSourceRouter(ReadwriteSplittingDataSourceRule rule) {
        this.rule = rule;
    }
}

