/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.route;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.readwritesplitting.route.impl.ReadwriteSplittingDataSourceRouter;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingDataSourceRule;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingRule;

public final class ReadwriteSplittingSQLRouter
implements SQLRouter<ReadwriteSplittingRule> {
    public RouteContext createRouteContext(LogicSQL logicSQL, ShardingSphereMetaData metaData, ReadwriteSplittingRule rule, ConfigurationProperties props) {
        RouteContext result = new RouteContext();
        String dataSourceName = new ReadwriteSplittingDataSourceRouter(rule.getSingleDataSourceRule()).route(logicSQL.getSqlStatementContext().getSqlStatement());
        result.getRouteUnits().add(new RouteUnit(new RouteMapper("logic_db", dataSourceName), Collections.emptyList()));
        return result;
    }

    public void decorateRouteContext(RouteContext routeContext, LogicSQL logicSQL, ShardingSphereMetaData metaData, ReadwriteSplittingRule rule, ConfigurationProperties props) {
        LinkedList<RouteUnit> toBeRemoved = new LinkedList<RouteUnit>();
        LinkedList<RouteUnit> toBeAdded = new LinkedList<RouteUnit>();
        for (RouteUnit each : routeContext.getRouteUnits()) {
            String dataSourceName = each.getDataSourceMapper().getLogicName();
            Optional<ReadwriteSplittingDataSourceRule> dataSourceRule = rule.findDataSourceRule(dataSourceName);
            if (!dataSourceRule.isPresent() || !dataSourceRule.get().getName().equalsIgnoreCase(each.getDataSourceMapper().getActualName())) continue;
            toBeRemoved.add(each);
            String actualDataSourceName = new ReadwriteSplittingDataSourceRouter(dataSourceRule.get()).route(logicSQL.getSqlStatementContext().getSqlStatement());
            toBeAdded.add(new RouteUnit(new RouteMapper(each.getDataSourceMapper().getLogicName(), actualDataSourceName), each.getTableMappers()));
        }
        routeContext.getRouteUnits().removeAll(toBeRemoved);
        routeContext.getRouteUnits().addAll(toBeAdded);
    }

    public int getOrder() {
        return 20;
    }

    public Class<ReadwriteSplittingRule> getTypeClass() {
        return ReadwriteSplittingRule.class;
    }
}

