/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.management.DefaultManagementStrategy;
import org.apache.camel.management.mbean.ManagedBacklogDebugger;
import org.apache.camel.management.mbean.ManagedBacklogTracer;
import org.apache.camel.management.mbean.ManagedCamelContext;
import org.apache.camel.management.mbean.ManagedComponent;
import org.apache.camel.management.mbean.ManagedConsumer;
import org.apache.camel.management.mbean.ManagedDataFormat;
import org.apache.camel.management.mbean.ManagedEndpoint;
import org.apache.camel.management.mbean.ManagedErrorHandler;
import org.apache.camel.management.mbean.ManagedEventNotifier;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.management.mbean.ManagedProducer;
import org.apache.camel.management.mbean.ManagedRoute;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.management.mbean.ManagedThreadPool;
import org.apache.camel.management.mbean.ManagedTracer;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.ManagementAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedManagementStrategy
extends DefaultManagementStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedManagementStrategy.class);

    public ManagedManagementStrategy() {
    }

    @Deprecated
    public ManagedManagementStrategy(ManagementAgent managementAgent) {
        this.setManagementAgent(managementAgent);
    }

    public ManagedManagementStrategy(CamelContext camelContext, ManagementAgent managementAgent) {
        this.setCamelContext(camelContext);
        this.setManagementAgent(managementAgent);
    }

    @Override
    public void manageObject(Object managedObject) throws Exception {
        this.manageNamedObject(managedObject, null);
    }

    @Override
    public void manageNamedObject(Object managedObject, Object preferredName) throws Exception {
        ObjectName objectName = this.getObjectName(managedObject, preferredName);
        if (objectName != null) {
            this.getManagementAgent().register(managedObject, objectName);
        }
    }

    @Override
    public <T> T getManagedObjectName(Object managedObject, String customName, Class<T> nameType) throws Exception {
        if (managedObject == null) {
            return null;
        }
        ObjectName objectName = null;
        if (managedObject instanceof ManagedCamelContext) {
            ManagedCamelContext mcc = (ManagedCamelContext)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForCamelContext(mcc.getContext());
        } else if (managedObject instanceof ManagedComponent) {
            ManagedComponent mc = (ManagedComponent)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForComponent(mc.getComponent(), mc.getComponentName());
        } else if (managedObject instanceof ManagedDataFormat) {
            ManagedDataFormat md = (ManagedDataFormat)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForDataFormat(md.getContext(), md.getDataFormat());
        } else if (managedObject instanceof ManagedEndpoint) {
            ManagedEndpoint me = (ManagedEndpoint)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForEndpoint(me.getEndpoint());
        } else if (managedObject instanceof Endpoint) {
            objectName = this.getManagementNamingStrategy().getObjectNameForEndpoint((Endpoint)managedObject);
        } else if (managedObject instanceof ManagedRoute) {
            ManagedRoute mr = (ManagedRoute)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForRoute(mr.getRoute());
        } else if (managedObject instanceof ManagedErrorHandler) {
            ManagedErrorHandler meh = (ManagedErrorHandler)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForErrorHandler(meh.getRouteContext(), meh.getErrorHandler(), meh.getErrorHandlerBuilder());
        } else if (managedObject instanceof ManagedProcessor) {
            ManagedProcessor mp = (ManagedProcessor)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForProcessor(mp.getContext(), mp.getProcessor(), mp.getDefinition());
        } else if (managedObject instanceof ManagedConsumer) {
            ManagedConsumer ms = (ManagedConsumer)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForConsumer(ms.getContext(), ms.getConsumer());
        } else if (managedObject instanceof ManagedProducer) {
            ManagedProducer ms = (ManagedProducer)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForProducer(ms.getContext(), ms.getProducer());
        } else if (managedObject instanceof ManagedTracer) {
            ManagedTracer mt = (ManagedTracer)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForTracer(mt.getContext(), mt.getTracer());
        } else if (managedObject instanceof ManagedBacklogTracer) {
            ManagedBacklogTracer mt = (ManagedBacklogTracer)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForTracer(mt.getContext(), mt.getBacklogTracer());
        } else if (managedObject instanceof ManagedBacklogDebugger) {
            ManagedBacklogDebugger md = (ManagedBacklogDebugger)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForTracer(md.getContext(), md.getBacklogDebugger());
        } else if (managedObject instanceof ManagedEventNotifier) {
            ManagedEventNotifier men = (ManagedEventNotifier)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForEventNotifier(men.getContext(), men.getEventNotifier());
        } else if (managedObject instanceof ManagedThreadPool) {
            ManagedThreadPool mes = (ManagedThreadPool)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForThreadPool(mes.getContext(), mes.getThreadPool(), mes.getId(), mes.getSourceId());
        } else if (managedObject instanceof ManagedService) {
            ManagedService ms = (ManagedService)managedObject;
            if (ms.getService() instanceof Endpoint) {
                return null;
            }
            objectName = this.getManagementNamingStrategy().getObjectNameForService(ms.getContext(), ms.getService());
        }
        return nameType.cast(objectName);
    }

    @Override
    public void unmanageObject(Object managedObject) throws Exception {
        ObjectName objectName = this.getManagedObjectName(managedObject, null, ObjectName.class);
        this.unmanageNamedObject(objectName);
    }

    @Override
    public void unmanageNamedObject(Object name) throws Exception {
        ObjectName objectName = this.getObjectName(null, name);
        if (objectName != null) {
            this.getManagementAgent().unregister(objectName);
        }
    }

    @Override
    public boolean isManaged(Object managedObject, Object name) {
        try {
            ObjectName objectName = this.getObjectName(managedObject, name);
            if (objectName != null) {
                return this.getManagementAgent().isRegistered(objectName);
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot check whether the managed object is registered. This exception will be ignored.", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean manageProcessor(ProcessorDefinition<?> definition) {
        return true;
    }

    private ObjectName getObjectName(Object managedObject, Object preferedName) throws Exception {
        ObjectName objectName;
        if (preferedName != null && preferedName instanceof String) {
            String customName = (String)preferedName;
            objectName = this.getManagedObjectName(managedObject, customName, ObjectName.class);
        } else {
            objectName = preferedName != null && preferedName instanceof ObjectName ? (ObjectName)preferedName : this.getManagedObjectName(managedObject, null, ObjectName.class);
        }
        return objectName;
    }

    @Override
    protected void doStart() throws Exception {
        LOG.info("JMX is enabled");
        this.doStartManagementStrategy();
    }
}

