/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.processor;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.processor.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptedAssertionProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptedAssertionProcessor.class);

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData request, WSDocInfo wsDocInfo) throws WSSecurityException {
        Element encryptedDataElement;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found EncryptedAssertion element");
        }
        if ((encryptedDataElement = XMLUtils.getDirectChildElement((Node)elem, (String)"EncryptedData", (String)"http://www.w3.org/2001/04/xmlenc#")) == null) {
            return Collections.emptyList();
        }
        String typeStr = encryptedDataElement.getAttributeNS(null, "Type");
        if (typeStr != null && !"http://www.w3.org/2001/04/xmlenc#Element".equals(typeStr)) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "badElement", new Object[]{"Element", typeStr});
        }
        QName el = new QName(encryptedDataElement.getNamespaceURI(), encryptedDataElement.getLocalName());
        Processor proc = request.getWssConfig().getProcessor(el);
        if (proc != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing decrypted element with: " + proc.getClass().getName());
            }
            return proc.handleToken(encryptedDataElement, request, wsDocInfo);
        }
        return Collections.emptyList();
    }
}

