/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.jaxrs.ext.search.collections.CollectionCheckInfo;

public class Beanspector<T> {
    private final Map<Class<?>, Class<?>> primitiveWrappers = this.getPrimitiveWrappers();
    private Class<T> tclass;
    private T tobj;
    private Map<String, Method> getters = new LinkedHashMap<String, Method>();
    private Map<String, Method> setters = new LinkedHashMap<String, Method>();

    public Beanspector(Class<T> tclass) {
        if (tclass == null) {
            throw new IllegalArgumentException("tclass is null");
        }
        this.tclass = tclass;
        this.init();
    }

    public Beanspector(T tobj) {
        if (tobj == null) {
            throw new IllegalArgumentException("tobj is null");
        }
        this.tobj = tobj;
        this.init();
    }

    private void init() {
        if (this.tclass == null) {
            this.tclass = this.tobj.getClass();
        }
        for (Method m : this.tclass.getMethods()) {
            if (this.isGetter(m)) {
                this.getters.put(this.getPropertyName(m), m);
                continue;
            }
            if (!this.isSetter(m)) continue;
            this.setters.put(this.getPropertyName(m), m);
        }
        HashSet<String> pairs = new HashSet<String>(this.getters.keySet());
        pairs.retainAll(this.setters.keySet());
        for (String accessor : pairs) {
            Class<?> setterClass;
            Class<?> getterClass = this.getters.get(accessor).getReturnType();
            if (getterClass.equals(setterClass = this.setters.get(accessor).getParameterTypes()[0])) continue;
            throw new IllegalArgumentException(String.format("Accessor '%s' type mismatch, getter type is %s while setter type is %s", accessor, getterClass.getName(), setterClass.getName()));
        }
    }

    public T getBean() {
        return this.tobj;
    }

    public Set<String> getGettersNames() {
        return Collections.unmodifiableSet(this.getters.keySet());
    }

    public Set<String> getSettersNames() {
        return Collections.unmodifiableSet(this.setters.keySet());
    }

    public TypeInfo getAccessorTypeInfo(String getterOrSetterName) throws Exception {
        Method m = this.getters.get(getterOrSetterName.toLowerCase());
        if (m == null) {
            m = this.setters.get(getterOrSetterName);
        }
        if (m == null) {
            String msg = String.format("Accessor '%s' not found, known setters are: %s, known getters are: %s", getterOrSetterName, this.setters.keySet(), this.getters.keySet());
            throw new IntrospectionException(msg);
        }
        return new TypeInfo(m.getReturnType(), m.getGenericReturnType(), this.primitiveToWrapper(m.getReturnType()));
    }

    public Beanspector<T> swap(T newobject) throws Exception {
        if (newobject == null) {
            throw new IllegalArgumentException("newobject is null");
        }
        this.tobj = newobject;
        return this;
    }

    public Beanspector<T> instantiate() throws Exception {
        this.tobj = this.tclass.newInstance();
        return this;
    }

    public Beanspector<T> setValue(String setterName, Object value) throws Throwable {
        Method m = this.setters.get(setterName.toLowerCase());
        if (m == null) {
            String msg = String.format("Setter '%s' not found, known setters are: %s", setterName, this.setters.keySet());
            throw new IntrospectionException(msg);
        }
        this.setValue(m, value);
        return this;
    }

    public Beanspector<T> setValue(Map<String, Object> settersWithValues) throws Throwable {
        for (Map.Entry<String, Object> entry : settersWithValues.entrySet()) {
            this.setValue(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Beanspector<T> setValue(Method setter, Object value) throws Throwable {
        Class<?> paramType = setter.getParameterTypes()[0];
        try {
            setter.invoke(this.tobj, value);
            return this;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (IllegalArgumentException e) {
            String msg = String.format("; setter parameter type: %s, set value type: %s", paramType.getName(), value.getClass().getName());
            throw new IllegalArgumentException(e.getMessage() + msg);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public Object getValue(String getterName) throws Throwable {
        return this.getValue(this.getters.get(getterName));
    }

    public Object getValue(Method getter) throws Throwable {
        try {
            return getter.invoke(this.tobj, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        catch (Exception e) {
            throw e;
        }
    }

    private Map<Class<?>, Class<?>> getPrimitiveWrappers() {
        HashMap wrappers = new HashMap();
        wrappers.put(Boolean.TYPE, Boolean.class);
        wrappers.put(Byte.TYPE, Byte.class);
        wrappers.put(Character.TYPE, Character.class);
        wrappers.put(Short.TYPE, Short.class);
        wrappers.put(Integer.TYPE, Integer.class);
        wrappers.put(Long.TYPE, Long.class);
        wrappers.put(Double.TYPE, Double.class);
        wrappers.put(Float.TYPE, Float.class);
        return wrappers;
    }

    private Class<?> primitiveToWrapper(Class<?> cls) {
        return cls.isPrimitive() ? this.primitiveWrappers.get(cls) : cls;
    }

    private boolean isGetter(Method m) {
        return m.getParameterTypes().length == 0 && (m.getName().startsWith("get") || m.getName().startsWith("is"));
    }

    private String getPropertyName(Method m) {
        String result = m.getName().toLowerCase();
        result = result.startsWith("is") ? result.substring(2, result.length()) : result.substring(3, result.length());
        return result;
    }

    private boolean isSetter(Method m) {
        return m.getReturnType().equals(Void.TYPE) && m.getParameterTypes().length == 1 && (m.getName().startsWith("set") || m.getName().startsWith("is"));
    }

    public static class TypeInfo {
        private Class<?> cls;
        private Class<?> wrapper;
        private Type genericType;
        private CollectionCheckInfo checkInfo;

        public TypeInfo(Class<?> cls, Type genericType) {
            this(cls, genericType, cls);
        }

        public TypeInfo(Class<?> cls, Type genericType, Class<?> wrapper) {
            this.cls = cls;
            this.genericType = genericType;
            this.wrapper = wrapper;
        }

        public Class<?> getTypeClass() {
            return this.cls;
        }

        public Class<?> getWrappedTypeClass() {
            return this.wrapper;
        }

        public Type getGenericType() {
            return this.genericType;
        }

        public CollectionCheckInfo getCollectionCheckInfo() {
            return this.checkInfo;
        }

        public void setCollectionCheckInfo(CollectionCheckInfo info) {
            this.checkInfo = info;
        }
    }
}

