/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ComponentConfiguration;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.impl.DefaultComponentConfiguration;
import org.apache.camel.impl.MappedEndpointConfiguration;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultComponent
extends ServiceSupport
implements Component {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultComponent.class);
    private CamelContext camelContext;

    public DefaultComponent() {
    }

    public DefaultComponent(CamelContext context) {
        this.camelContext = context;
    }

    @Deprecated
    protected String preProcessUri(String uri) {
        String encodedUri = UnsafeUriCharactersEncoder.encode(uri);
        if (!encodedUri.equals(uri)) {
            LOG.warn("Supplied URI '{}' contains unsafe characters, please check encoding", (Object)URISupport.sanitizeUri(uri));
        }
        return encodedUri;
    }

    @Override
    public Endpoint createEndpoint(String uri) throws Exception {
        Map<String, Object> parameters;
        ObjectHelper.notNull(this.getCamelContext(), "camelContext");
        String encodedUri = this.preProcessUri(uri);
        URI u = new URI(encodedUri);
        String path = URISupport.extractRemainderPath(u, this.useRawUri());
        if (this.useRawUri()) {
            int idx = uri.indexOf(63);
            String query = idx > -1 ? uri.substring(idx + 1) : u.getRawQuery();
            parameters = URISupport.parseQuery(query, true);
        } else {
            parameters = URISupport.parseParameters(u);
        }
        URISupport.resolveRawParameterValues(parameters);
        uri = this.useRawUri() ? uri : encodedUri;
        this.validateURI(uri, path, parameters);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating endpoint uri=[{}], path=[{}], parameters=[{}]", new Object[]{URISupport.sanitizeUri(uri), URISupport.sanitizePath(path), parameters});
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Creating endpoint uri=[{}], path=[{}]", new Object[]{URISupport.sanitizeUri(uri), URISupport.sanitizePath(path)});
        }
        Endpoint endpoint = this.createEndpoint(uri, path, parameters);
        if (endpoint == null) {
            return null;
        }
        if (!parameters.isEmpty()) {
            endpoint.configureProperties(parameters);
            if (this.useIntrospectionOnEndpoint()) {
                this.setProperties(endpoint, parameters);
            }
            if (!endpoint.isLenientProperties()) {
                this.validateParameters(uri, parameters, null);
            }
        }
        this.afterConfiguration(uri, path, endpoint, parameters);
        return endpoint;
    }

    @Override
    public ComponentConfiguration createComponentConfiguration() {
        return new DefaultComponentConfiguration(this);
    }

    @Override
    public EndpointConfiguration createConfiguration(String uri) throws Exception {
        MappedEndpointConfiguration config = new MappedEndpointConfiguration(this.getCamelContext());
        config.setURI(new URI(uri));
        return config;
    }

    @Override
    public boolean useRawUri() {
        return false;
    }

    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
    }

    protected void validateParameters(String uri, Map<String, Object> parameters, String optionPrefix) {
        Map<String, Object> param = parameters;
        if (optionPrefix != null) {
            param = IntrospectionSupport.extractProperties(parameters, optionPrefix);
        }
        if (param.size() > 0) {
            throw new ResolveEndpointFailedException(uri, "There are " + param.size() + " parameters that couldn't be set on the endpoint." + " Check the uri if the parameters are spelt correctly and that they are properties of the endpoint." + " Unknown parameters=[" + param + "]");
        }
    }

    protected void validateURI(String uri, String path, Map<String, Object> parameters) {
        Pattern pattern;
        Matcher m;
        if (uri.contains("&&") && !(m = (pattern = Pattern.compile("RAW(.*&&.*)")).matcher(uri)).find()) {
            throw new ResolveEndpointFailedException(uri, "Invalid uri syntax: Double && marker found. Check the uri and remove the duplicate & marker.");
        }
        if (uri.endsWith("&")) {
            throw new ResolveEndpointFailedException(uri, "Invalid uri syntax: Trailing & marker found. Check the uri and remove the trailing & marker.");
        }
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext context) {
        this.camelContext = context;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.getCamelContext(), "camelContext");
    }

    @Override
    protected void doStop() throws Exception {
    }

    protected abstract Endpoint createEndpoint(String var1, String var2, Map<String, Object> var3) throws Exception;

    protected void setProperties(Object bean, Map<String, Object> parameters) throws Exception {
        EndpointHelper.setReferenceProperties(this.getCamelContext(), bean, parameters);
        EndpointHelper.setProperties(this.getCamelContext(), bean, parameters);
    }

    protected boolean useIntrospectionOnEndpoint() {
        return true;
    }

    public <T> T getAndRemoveParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.getAndRemoveParameter(parameters, key, type, null);
    }

    public <T> T getAndRemoveParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        Object value = parameters.remove(key);
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            return null;
        }
        return CamelContextHelper.convertTo(this.getCamelContext(), type, value);
    }

    public <T> T getAndRemoveOrResolveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.getAndRemoveOrResolveReferenceParameter(parameters, key, type, null);
    }

    public <T> T getAndRemoveOrResolveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        String value = this.getAndRemoveParameter(parameters, key, String.class);
        if (value == null) {
            return defaultValue;
        }
        if (EndpointHelper.isReferenceParameter(value)) {
            return EndpointHelper.resolveReferenceParameter(this.getCamelContext(), value, type);
        }
        return this.getCamelContext().getTypeConverter().convertTo(type, value);
    }

    public <T> T resolveAndRemoveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type) {
        return this.resolveAndRemoveReferenceParameter(parameters, key, type, null);
    }

    public <T> T resolveAndRemoveReferenceParameter(Map<String, Object> parameters, String key, Class<T> type, T defaultValue) {
        String value = this.getAndRemoveParameter(parameters, key, String.class);
        if (value == null) {
            return defaultValue;
        }
        return EndpointHelper.resolveReferenceParameter(this.getCamelContext(), value.toString(), type);
    }

    public <T> List<T> resolveAndRemoveReferenceListParameter(Map<String, Object> parameters, String key, Class<T> elementType) {
        return this.resolveAndRemoveReferenceListParameter(parameters, key, elementType, new ArrayList(0));
    }

    public <T> List<T> resolveAndRemoveReferenceListParameter(Map<String, Object> parameters, String key, Class<T> elementType, List<T> defaultValue) {
        String value = this.getAndRemoveParameter(parameters, key, String.class);
        if (value == null) {
            return defaultValue;
        }
        return EndpointHelper.resolveReferenceListParameter(this.getCamelContext(), value.toString(), elementType);
    }

    protected String ifStartsWithReturnRemainder(String prefix, String text) {
        String remainder;
        if (text.startsWith(prefix) && (remainder = text.substring(prefix.length())).length() > 0) {
            return remainder;
        }
        return null;
    }
}

