/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging.slf4j;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Slf4jEventSender
implements LogEventSender {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(LogEvent event) {
        String cat = "org.apache.cxf.services." + event.getPortTypeName().getLocalPart() + "." + (Object)((Object)event.getType());
        Logger log = LoggerFactory.getLogger((String)cat);
        HashSet<String> keys = new HashSet<String>();
        try {
            this.put(keys, "type", event.getType().toString());
            this.put(keys, "address", event.getAddress());
            this.put(keys, "content-type", event.getContentType());
            this.put(keys, "encoding", event.getEncoding());
            this.put(keys, "exchangeId", event.getExchangeId());
            this.put(keys, "httpMethod", event.getHttpMethod());
            this.put(keys, "messageId", event.getMessageId());
            this.put(keys, "responseCode", event.getResponseCode());
            this.put(keys, "serviceName", this.localPart(event.getServiceName()));
            this.put(keys, "portName", this.localPart(event.getPortName()));
            this.put(keys, "portTypeName", this.localPart(event.getPortTypeName()));
            if (event.getFullContentFile() != null) {
                this.put(keys, "fullContentFile", event.getFullContentFile().getAbsolutePath());
            }
            this.put(keys, "headers", event.getHeaders().toString());
            log.info(this.getLogMessage(event));
        }
        finally {
            for (String key : keys) {
                MDC.remove((String)key);
            }
        }
    }

    private String localPart(QName name) {
        return name == null ? null : name.getLocalPart();
    }

    private String getLogMessage(LogEvent event) {
        return event.getPayload();
    }

    private void put(Set<String> keys, String key, String value) {
        if (value != null) {
            MDC.put((String)key, (String)value);
            keys.add(key);
        }
    }
}

