/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.blueprint.codec;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.aries.jmx.blueprint.BlueprintMetadataMBean;
import org.apache.aries.jmx.blueprint.codec.BPMetadata;
import org.apache.aries.jmx.blueprint.codec.TransferObject;
import org.apache.aries.jmx.blueprint.codec.Util;
import org.osgi.service.blueprint.reflect.BeanArgument;

public class BPBeanArgument
implements TransferObject {
    private int index;
    private BPMetadata value;
    private String valueType;

    public BPBeanArgument(CompositeData argument) {
        this.index = (Integer)argument.get("Index");
        Byte[] buf = (Byte[])argument.get("Value");
        this.value = Util.boxedBinary2BPMetadata(buf);
        this.valueType = (String)argument.get("ValueType");
    }

    public BPBeanArgument(BeanArgument argument) {
        this.index = argument.getIndex();
        this.value = Util.metadata2BPMetadata(argument.getValue());
        this.valueType = argument.getValueType();
    }

    public CompositeData asCompositeData() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Index", this.index);
        items.put("Value", Util.bpMetadata2BoxedBinary(this.value));
        items.put("ValueType", this.valueType);
        try {
            return new CompositeDataSupport(BlueprintMetadataMBean.BEAN_ARGUMENT_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public BPMetadata getValue() {
        return this.value;
    }

    public String getValueType() {
        return this.valueType;
    }
}

