/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.catalog.URISupport;

public class EndpointValidationResult
implements Serializable {
    private final String uri;
    private int errors;
    private String syntaxError;
    private String unknownComponent;
    private String incapable;
    private Set<String> unknown;
    private Map<String, String[]> unknownSuggestions;
    private Set<String> required;
    private Map<String, String> invalidEnum;
    private Map<String, String[]> invalidEnumChoices;
    private Map<String, String[]> invalidEnumSuggestions;
    private Map<String, String> invalidReference;
    private Map<String, String> invalidBoolean;
    private Map<String, String> invalidInteger;
    private Map<String, String> invalidNumber;
    private Map<String, String> defaultValues;

    public EndpointValidationResult(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public int getNumberOfErrors() {
        return this.errors;
    }

    public boolean isSuccess() {
        boolean ok;
        boolean bl = ok = this.syntaxError == null && this.unknownComponent == null && this.incapable == null && this.unknown == null && this.required == null;
        if (ok) {
            ok = this.invalidEnum == null && this.invalidEnumChoices == null && this.invalidReference == null && this.invalidBoolean == null && this.invalidInteger == null && this.invalidNumber == null;
        }
        return ok;
    }

    public void addSyntaxError(String syntaxError) {
        this.syntaxError = syntaxError;
        ++this.errors;
    }

    public void addIncapable(String uri) {
        this.incapable = uri;
        ++this.errors;
    }

    public void addUnknownComponent(String name) {
        this.unknownComponent = name;
        ++this.errors;
    }

    public void addUnknown(String name) {
        if (this.unknown == null) {
            this.unknown = new LinkedHashSet<String>();
        }
        if (!this.unknown.contains(name)) {
            this.unknown.add(name);
            ++this.errors;
        }
    }

    public void addUnknownSuggestions(String name, String[] suggestions) {
        if (this.unknownSuggestions == null) {
            this.unknownSuggestions = new LinkedHashMap<String, String[]>();
        }
        this.unknownSuggestions.put(name, suggestions);
    }

    public void addRequired(String name) {
        if (this.required == null) {
            this.required = new LinkedHashSet<String>();
        }
        if (!this.required.contains(name)) {
            this.required.add(name);
            ++this.errors;
        }
    }

    public void addInvalidEnum(String name, String value) {
        if (this.invalidEnum == null) {
            this.invalidEnum = new LinkedHashMap<String, String>();
        }
        if (!this.invalidEnum.containsKey(name)) {
            this.invalidEnum.put(name, value);
            ++this.errors;
        }
    }

    public void addInvalidEnumChoices(String name, String[] choices) {
        if (this.invalidEnumChoices == null) {
            this.invalidEnumChoices = new LinkedHashMap<String, String[]>();
        }
        this.invalidEnumChoices.put(name, choices);
    }

    public void addInvalidEnumSuggestions(String name, String[] suggestions) {
        if (this.invalidEnumSuggestions == null) {
            this.invalidEnumSuggestions = new LinkedHashMap<String, String[]>();
        }
        this.invalidEnumSuggestions.put(name, suggestions);
    }

    public void addInvalidReference(String name, String value) {
        if (this.invalidReference == null) {
            this.invalidReference = new LinkedHashMap<String, String>();
        }
        if (!this.invalidReference.containsKey(name)) {
            this.invalidReference.put(name, value);
            ++this.errors;
        }
    }

    public void addInvalidBoolean(String name, String value) {
        if (this.invalidBoolean == null) {
            this.invalidBoolean = new LinkedHashMap<String, String>();
        }
        if (!this.invalidBoolean.containsKey(name)) {
            this.invalidBoolean.put(name, value);
            ++this.errors;
        }
    }

    public void addInvalidInteger(String name, String value) {
        if (this.invalidInteger == null) {
            this.invalidInteger = new LinkedHashMap<String, String>();
        }
        if (!this.invalidInteger.containsKey(name)) {
            this.invalidInteger.put(name, value);
            ++this.errors;
        }
    }

    public void addInvalidNumber(String name, String value) {
        if (this.invalidNumber == null) {
            this.invalidNumber = new LinkedHashMap<String, String>();
        }
        if (!this.invalidNumber.containsKey(name)) {
            this.invalidNumber.put(name, value);
            ++this.errors;
        }
    }

    public void addDefaultValue(String name, String value) {
        if (this.defaultValues == null) {
            this.defaultValues = new LinkedHashMap<String, String>();
        }
        this.defaultValues.put(name, value);
    }

    public String getSyntaxError() {
        return this.syntaxError;
    }

    public String getIncapable() {
        return this.incapable;
    }

    public Set<String> getUnknown() {
        return this.unknown;
    }

    public Map<String, String[]> getUnknownSuggestions() {
        return this.unknownSuggestions;
    }

    public String getUnknownComponent() {
        return this.unknownComponent;
    }

    public Set<String> getRequired() {
        return this.required;
    }

    public Map<String, String> getInvalidEnum() {
        return this.invalidEnum;
    }

    public Map<String, String[]> getInvalidEnumChoices() {
        return this.invalidEnumChoices;
    }

    public Map<String, String> getInvalidReference() {
        return this.invalidReference;
    }

    public Map<String, String> getInvalidBoolean() {
        return this.invalidBoolean;
    }

    public Map<String, String> getInvalidInteger() {
        return this.invalidInteger;
    }

    public Map<String, String> getInvalidNumber() {
        return this.invalidNumber;
    }

    public Map<String, String> getDefaultValues() {
        return this.defaultValues;
    }

    public String summaryErrorMessage(boolean includeHeader) {
        if (this.isSuccess()) {
            return null;
        }
        if (this.incapable != null) {
            return "\tIncapable of parsing uri: " + this.incapable;
        }
        if (this.syntaxError != null) {
            return "\tSyntax error: " + this.syntaxError;
        }
        if (this.unknownComponent != null) {
            return "\tUnknown component: " + this.unknownComponent;
        }
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        if (this.unknown != null) {
            for (String string : this.unknown) {
                if (this.unknownSuggestions != null && this.unknownSuggestions.containsKey(string)) {
                    String[] suggestions = this.unknownSuggestions.get(string);
                    if (suggestions != null && suggestions.length > 0) {
                        String str = Arrays.asList(suggestions).toString();
                        options.put(string, "Unknown option. Did you mean: " + str);
                        continue;
                    }
                    options.put(string, "Unknown option");
                    continue;
                }
                options.put(string, "Unknown option");
            }
        }
        if (this.required != null) {
            for (String string : this.required) {
                options.put(string, "Missing required option");
            }
        }
        if (this.invalidEnum != null) {
            for (Map.Entry entry : this.invalidEnum.entrySet()) {
                String[] suggestions;
                String name = (String)entry.getKey();
                String[] choices = this.invalidEnumChoices.get(name);
                String defaultValue = this.defaultValues != null ? this.defaultValues.get(entry.getKey()) : null;
                String str = Arrays.asList(choices).toString();
                String msg = "Invalid enum value: " + (String)entry.getValue() + ". Possible values: " + str;
                if (this.invalidEnumSuggestions != null && (suggestions = this.invalidEnumSuggestions.get(name)) != null && suggestions.length > 0) {
                    str = Arrays.asList(suggestions).toString();
                    msg = msg + ". Did you mean: " + str;
                }
                if (defaultValue != null) {
                    msg = msg + ". Default value: " + defaultValue;
                }
                options.put((String)entry.getKey(), msg);
            }
        }
        if (this.invalidReference != null) {
            for (Map.Entry entry : this.invalidReference.entrySet()) {
                boolean empty = URISupport.isEmpty(entry.getValue());
                if (empty) {
                    options.put((String)entry.getKey(), "Empty reference value");
                    continue;
                }
                if (!((String)entry.getValue()).startsWith("#")) {
                    options.put((String)entry.getKey(), "Invalid reference value: " + (String)entry.getValue() + " must start with #");
                    continue;
                }
                options.put((String)entry.getKey(), "Invalid reference value: " + (String)entry.getValue());
            }
        }
        if (this.invalidBoolean != null) {
            for (Map.Entry entry : this.invalidBoolean.entrySet()) {
                boolean empty = URISupport.isEmpty(entry.getValue());
                if (empty) {
                    options.put((String)entry.getKey(), "Empty boolean value");
                    continue;
                }
                options.put((String)entry.getKey(), "Invalid boolean value: " + (String)entry.getValue());
            }
        }
        if (this.invalidInteger != null) {
            for (Map.Entry entry : this.invalidInteger.entrySet()) {
                boolean empty = URISupport.isEmpty(entry.getValue());
                if (empty) {
                    options.put((String)entry.getKey(), "Empty integer value");
                    continue;
                }
                options.put((String)entry.getKey(), "Invalid integer value: " + (String)entry.getValue());
            }
        }
        if (this.invalidNumber != null) {
            for (Map.Entry entry : this.invalidNumber.entrySet()) {
                boolean empty = URISupport.isEmpty(entry.getValue());
                if (empty) {
                    options.put((String)entry.getKey(), "Empty number value");
                    continue;
                }
                options.put((String)entry.getKey(), "Invalid number value: " + (String)entry.getValue());
            }
        }
        int maxLen = 24;
        for (String key : options.keySet()) {
            maxLen = Math.max(maxLen, key.length());
        }
        String string = "%" + maxLen + "s    %s";
        StringBuilder sb = new StringBuilder();
        if (includeHeader) {
            sb.append("Endpoint validator error\n");
            sb.append("---------------------------------------------------------------------------------------------------------------------------------------\n");
            sb.append("\n");
        }
        sb.append("\t").append(this.uri).append("\n");
        for (Map.Entry option : options.entrySet()) {
            String out = String.format(string, option.getKey(), option.getValue());
            sb.append("\n\t").append(out);
        }
        return sb.toString();
    }
}

