/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.util.Iterator;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.EventType;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.HandlerException;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Record;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.RecordImpl;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.reactor.Reactor;
import org.apache.qpid.proton.reactor.Selectable;
import org.apache.qpid.proton.reactor.Task;
import org.apache.qpid.proton.reactor.impl.ReactorImpl;

class EventImpl
implements Event {
    EventType type = null;
    Object context;
    EventImpl next;
    RecordImpl attachments = new RecordImpl();
    private Handler delegated = null;

    EventImpl() {
    }

    void init(EventType type, Object context) {
        this.type = type;
        this.context = context;
        this.attachments.clear();
    }

    void clear() {
        this.type = null;
        this.context = null;
        this.attachments.clear();
    }

    @Override
    public EventType getEventType() {
        return this.type;
    }

    @Override
    public Event.Type getType() {
        if (this.type instanceof Event.Type) {
            return (Event.Type)this.type;
        }
        return Event.Type.NON_CORE_EVENT;
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public Handler getRootHandler() {
        return ReactorImpl.ROOT.get(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(Handler handler) throws HandlerException {
        Handler old_delegated = this.delegated;
        try {
            this.delegated = handler;
            try {
                handler.handle(this);
            }
            catch (HandlerException handlerException) {
                throw handlerException;
            }
            catch (RuntimeException runtimeException) {
                throw new HandlerException(handler, (Throwable)runtimeException);
            }
            this.delegate();
        }
        finally {
            this.delegated = old_delegated;
        }
    }

    @Override
    public void delegate() throws HandlerException {
        if (this.delegated == null) {
            return;
        }
        Iterator<Handler> children = this.delegated.children();
        this.delegated = null;
        while (children.hasNext()) {
            this.dispatch(children.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redispatch(EventType as_type, Handler handler) throws HandlerException {
        if (!as_type.isValid()) {
            throw new IllegalArgumentException("Can only redispatch valid event types");
        }
        EventType old = this.type;
        try {
            this.type = as_type;
            this.dispatch(handler);
        }
        finally {
            this.type = old;
        }
    }

    @Override
    public Connection getConnection() {
        if (this.context instanceof Connection) {
            return (Connection)this.context;
        }
        if (this.context instanceof Transport) {
            Transport transport = this.getTransport();
            if (transport == null) {
                return null;
            }
            return ((TransportImpl)transport).getConnectionImpl();
        }
        Session ssn = this.getSession();
        if (ssn == null) {
            return null;
        }
        return ssn.getConnection();
    }

    @Override
    public Session getSession() {
        if (this.context instanceof Session) {
            return (Session)this.context;
        }
        Link link2 = this.getLink();
        if (link2 == null) {
            return null;
        }
        return link2.getSession();
    }

    @Override
    public Link getLink() {
        if (this.context instanceof Link) {
            return (Link)this.context;
        }
        Delivery dlv = this.getDelivery();
        if (dlv == null) {
            return null;
        }
        return dlv.getLink();
    }

    @Override
    public Sender getSender() {
        if (this.context instanceof Sender) {
            return (Sender)this.context;
        }
        Link link2 = this.getLink();
        if (link2 instanceof Sender) {
            return (Sender)link2;
        }
        return null;
    }

    @Override
    public Receiver getReceiver() {
        if (this.context instanceof Receiver) {
            return (Receiver)this.context;
        }
        Link link2 = this.getLink();
        if (link2 instanceof Receiver) {
            return (Receiver)link2;
        }
        return null;
    }

    @Override
    public Delivery getDelivery() {
        if (this.context instanceof Delivery) {
            return (Delivery)this.context;
        }
        return null;
    }

    @Override
    public Transport getTransport() {
        if (this.context instanceof Transport) {
            return (Transport)this.context;
        }
        if (this.context instanceof Connection) {
            return ((Connection)this.context).getTransport();
        }
        return null;
    }

    @Override
    public Selectable getSelectable() {
        if (this.context instanceof Selectable) {
            return (Selectable)this.context;
        }
        return null;
    }

    @Override
    public Reactor getReactor() {
        if (this.context instanceof Reactor) {
            return (Reactor)this.context;
        }
        if (this.context instanceof Task) {
            return ((Task)this.context).getReactor();
        }
        if (this.context instanceof Transport) {
            return ((TransportImpl)this.context).getReactor();
        }
        if (this.context instanceof Delivery) {
            return ((Delivery)this.context).getLink().getSession().getConnection().getReactor();
        }
        if (this.context instanceof Link) {
            return ((Link)this.context).getSession().getConnection().getReactor();
        }
        if (this.context instanceof Session) {
            return ((Session)this.context).getConnection().getReactor();
        }
        if (this.context instanceof Connection) {
            return ((Connection)this.context).getReactor();
        }
        if (this.context instanceof Selectable) {
            return ((Selectable)this.context).getReactor();
        }
        return null;
    }

    @Override
    public Task getTask() {
        if (this.context instanceof Task) {
            return (Task)this.context;
        }
        return null;
    }

    @Override
    public Record attachments() {
        return this.attachments;
    }

    @Override
    public Event copy() {
        EventImpl newEvent = new EventImpl();
        newEvent.init(this.type, this.context);
        newEvent.attachments.copy(this.attachments);
        return newEvent;
    }

    public String toString() {
        return "EventImpl{type=" + this.type + ", context=" + this.context + '}';
    }
}

