/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws.jetty8;

import java.io.IOException;
import org.apache.activemq.transport.ws.AbstractMQTTSocket;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.eclipse.jetty.websocket.WebSocket;
import org.fusesource.mqtt.codec.DISCONNECT;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTSocket
extends AbstractMQTTSocket
implements WebSocket.OnBinaryMessage {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTSocket.class);
    private WebSocket.Connection outbound;

    public MQTTSocket(String remoteAddress) {
        super(remoteAddress);
    }

    @Override
    public void sendToMQTT(MQTTFrame command) throws IOException {
        ByteSequence bytes = this.wireFormat.marshal(command);
        this.outbound.sendMessage(bytes.getData(), 0, bytes.getLength());
    }

    @Override
    public void handleStopped() throws IOException {
        if (this.outbound != null && this.outbound.isOpen()) {
            this.outbound.close();
        }
    }

    public void onOpen(WebSocket.Connection connection) {
        this.outbound = connection;
    }

    public void onMessage(byte[] bytes, int offset, int length) {
        if (!this.transportStartedAtLeastOnce()) {
            LOG.debug("Waiting for MQTTSocket to be properly started...");
            try {
                this.socketTransportStarted.await();
            }
            catch (InterruptedException e) {
                LOG.warn("While waiting for MQTTSocket to be properly started, we got interrupted!! Should be okay, but you could see race conditions...");
            }
        }
        this.receiveCounter += length;
        try {
            MQTTFrame frame = (MQTTFrame)this.wireFormat.unmarshal(new ByteSequence(bytes, offset, length));
            this.getProtocolConverter().onMQTTCommand(frame);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    public void onClose(int closeCode, String message) {
        try {
            this.getProtocolConverter().onMQTTCommand(new DISCONNECT().encode());
        }
        catch (Exception e) {
            LOG.warn("Failed to close WebSocket", (Throwable)e);
        }
    }
}

