/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swagger;

import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.config.DefaultReaderConfig;
import io.swagger.jaxrs.config.ReaderConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.model.AbstractResourceInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.doc.DocumentationProvider;
import org.apache.cxf.jaxrs.model.doc.JavaDocProvider;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.swagger.AbstractSwaggerFeature;
import org.apache.cxf.jaxrs.swagger.Swagger2Serializers;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

public class Swagger2Feature
extends AbstractSwaggerFeature {
    private String host;
    private String[] schemes;
    private boolean prettyPrint;
    private boolean scanAllResources;
    private String ignoreRoutes;
    private boolean dynamicBasePath;
    private boolean replaceTags;
    private DocumentationProvider javadocProvider;

    @Override
    protected void addSwaggerResource(Server server) {
        List cris = Collections.emptyList();
        if (!this.runAsFilter) {
            ArrayList<ApiListingResource> serviceBeans = new ArrayList<ApiListingResource>();
            ApiListingResource apiListingResource = new ApiListingResource();
            serviceBeans.add(apiListingResource);
            JAXRSServiceFactoryBean sfb = (JAXRSServiceFactoryBean)server.getEndpoint().get((Object)JAXRSServiceFactoryBean.class.getName());
            sfb.setResourceClassesFromBeans(serviceBeans);
            cris = sfb.getClassResourceInfo();
            for (ClassResourceInfo cri : cris) {
                if (ApiListingResource.class != cri.getResourceClass()) continue;
                InjectionUtils.injectContextProxiesAndApplication((AbstractResourceInfo)cri, (Object)apiListingResource, null);
            }
        }
        ArrayList<Object> providers = new ArrayList<Object>();
        if (this.runAsFilter) {
            providers.add((Object)new SwaggerContainerRequestFilter());
        }
        providers.add((Object)new Swagger2Serializers(this.dynamicBasePath, this.replaceTags, this.javadocProvider, cris));
        providers.add(new ReaderConfigFilter());
        ((ServerProviderFactory)server.getEndpoint().get((Object)ServerProviderFactory.class.getName())).setUserProviders(providers);
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setResourcePackage(this.getResourcePackage());
        beanConfig.setVersion(this.getVersion());
        beanConfig.setBasePath(this.getBasePath());
        beanConfig.setHost(this.getHost());
        beanConfig.setSchemes(this.getSchemes());
        beanConfig.setTitle(this.getTitle());
        beanConfig.setDescription(this.getDescription());
        beanConfig.setContact(this.getContact());
        beanConfig.setLicense(this.getLicense());
        beanConfig.setLicenseUrl(this.getLicenseUrl());
        beanConfig.setTermsOfServiceUrl(this.getTermsOfServiceUrl());
        beanConfig.setScan(this.isScan());
        beanConfig.setPrettyPrint(this.isPrettyPrint());
        beanConfig.setFilterClass(this.getFilterClass());
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String[] getSchemes() {
        return this.schemes;
    }

    public void setSchemes(String[] schemes) {
        this.schemes = schemes;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isScanAllResources() {
        return this.scanAllResources;
    }

    public void setScanAllResources(boolean scanAllResources) {
        this.scanAllResources = scanAllResources;
    }

    public String getIgnoreRoutes() {
        return this.ignoreRoutes;
    }

    public void setIgnoreRoutes(String ignoreRoutes) {
        this.ignoreRoutes = ignoreRoutes;
    }

    public void setDynamicBasePath(boolean dynamicBasePath) {
        this.dynamicBasePath = dynamicBasePath;
    }

    public void setReplaceTags(boolean replaceTags) {
        this.replaceTags = replaceTags;
    }

    public void setJavaDocPath(String javaDocPath) throws Exception {
        this.javadocProvider = new JavaDocProvider(javaDocPath);
    }

    public void setJavaDocPaths(String ... javaDocPaths) throws Exception {
        this.javadocProvider = new JavaDocProvider(javaDocPaths);
    }

    public void setJavaDocURLs(URL[] javaDocURLs) {
        this.javadocProvider = new JavaDocProvider(javaDocURLs);
    }

    @Override
    protected void setBasePathByAddress(String address) {
        if (!address.startsWith("/")) {
            URI u = URI.create(address);
            this.setBasePath(u.getPath());
            this.setHost(u.getPort() < 0 ? u.getHost() : u.getHost() + ":" + u.getPort());
        } else {
            this.setBasePath(address);
        }
    }

    private class ReaderConfigFilter
    implements ContainerRequestFilter {
        @Context
        private MessageContext mc;

        private ReaderConfigFilter() {
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            ServletContext servletContext = this.mc.getServletContext();
            if (servletContext != null && servletContext.getAttribute(ReaderConfig.class.getName()) == null) {
                if (this.mc.getServletConfig() != null && Boolean.valueOf(this.mc.getServletConfig().getInitParameter("scan.all.resources")).booleanValue()) {
                    this.addReaderConfig(this.mc.getServletConfig().getInitParameter("ignore.routes"));
                } else if (Swagger2Feature.this.isScanAllResources()) {
                    this.addReaderConfig(Swagger2Feature.this.getIgnoreRoutes());
                }
            }
        }

        private void addReaderConfig(String ignoreRoutesParam) {
            DefaultReaderConfig rc = new DefaultReaderConfig();
            rc.setScanAllResources(true);
            if (ignoreRoutesParam != null) {
                LinkedHashSet<String> routes = new LinkedHashSet<String>();
                for (String route : StringUtils.split((String)ignoreRoutesParam, (String)",")) {
                    routes.add(route.trim());
                }
                rc.setIgnoredRoutes(routes);
            }
            this.mc.getServletContext().setAttribute(ReaderConfig.class.getName(), (Object)rc);
        }
    }

    @PreMatching
    private static class SwaggerContainerRequestFilter
    extends ApiListingResource
    implements ContainerRequestFilter {
        private static final String APIDOCS_LISTING_PATH_JSON = "swagger.json";
        private static final String APIDOCS_LISTING_PATH_YAML = "swagger.yaml";
        @Context
        private MessageContext mc;

        private SwaggerContainerRequestFilter() {
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            UriInfo ui = this.mc.getUriInfo();
            if (ui.getPath().endsWith(APIDOCS_LISTING_PATH_JSON)) {
                Response r = this.getListingJson(null, this.mc.getServletConfig(), this.mc.getHttpHeaders(), ui);
                requestContext.abortWith(r);
            } else if (ui.getPath().endsWith(APIDOCS_LISTING_PATH_YAML)) {
                Response r = this.getListingYaml(null, this.mc.getServletConfig(), this.mc.getHttpHeaders(), ui);
                requestContext.abortWith(r);
            }
        }
    }
}

