/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.event.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.webconsole.plugins.event.internal.ConfigurationListener;
import org.apache.felix.webconsole.plugins.event.internal.EventHandler;
import org.apache.felix.webconsole.plugins.event.internal.PluginServlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventAdmin;

public class OptionalFeaturesHandler
implements ServiceListener {
    private static final String EVENT_ADMIN_CLASS_NAME = "org.osgi.service.event.EventAdmin";
    private static final String CONFIGURATION_ADMIN_CLASS_NAME = "org.osgi.service.cm.ConfigurationAdmin";
    private static final String EVENT_HANDLER_CLASS_NAME = "org.osgi.service.event.EventHandler";
    private static final String FILTER = "(|(objectClass=org.osgi.service.event.EventAdmin)(objectClass=org.osgi.service.cm.ConfigurationAdmin))";
    private ServiceReference eventAdminServiceRef;
    private ServiceRegistration eventHandlerRegistration;
    private Long configAdminServiceId;
    private ServiceRegistration configListenerRegistration;
    private final BundleContext bundleContext;
    private final PluginServlet plugin;

    public OptionalFeaturesHandler(PluginServlet plugin, BundleContext context) {
        this.plugin = plugin;
        this.bundleContext = context;
        ServiceReference ref = this.bundleContext.getServiceReference(EVENT_ADMIN_CLASS_NAME);
        if (ref != null) {
            this.bindEventAdmin(ref);
        }
        this.configAdminServiceId = null;
        ServiceReference cfaRef = this.bundleContext.getServiceReference(CONFIGURATION_ADMIN_CLASS_NAME);
        if (cfaRef != null) {
            Long id = (Long)cfaRef.getProperty("service.id");
            this.bindConfigAdmin(id);
        }
        try {
            context.addServiceListener((ServiceListener)this, FILTER);
        }
        catch (InvalidSyntaxException ise) {
            // empty catch block
        }
    }

    public void destroy() {
        this.bundleContext.removeServiceListener((ServiceListener)this);
        this.unbindEventAdmin(this.eventAdminServiceRef);
        this.unbindConfigAdmin(this.configAdminServiceId);
    }

    public void serviceChanged(ServiceEvent event) {
        final ServiceReference ref = event.getServiceReference();
        String[] objectClasses = (String[])ref.getProperty("objectClass");
        if (objectClasses != null) {
            for (int i = 0; i < objectClasses.length; ++i) {
                if (objectClasses[i].equals(EVENT_ADMIN_CLASS_NAME)) {
                    if (event.getType() == 1) {
                        new Thread(){

                            public void run() {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                OptionalFeaturesHandler.this.bindEventAdmin(ref);
                            }
                        }.start();
                        continue;
                    }
                    if (event.getType() != 4) continue;
                    new Thread(){

                        public void run() {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            OptionalFeaturesHandler.this.unbindEventAdmin(ref);
                        }
                    }.start();
                    continue;
                }
                if (!objectClasses[i].equals(CONFIGURATION_ADMIN_CLASS_NAME)) continue;
                final Long id = (Long)event.getServiceReference().getProperty("service.id");
                if (event.getType() == 1) {
                    new Thread(){

                        public void run() {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            OptionalFeaturesHandler.this.bindConfigAdmin(id);
                        }
                    }.start();
                    continue;
                }
                if (event.getType() != 4) continue;
                new Thread(){

                    public void run() {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        OptionalFeaturesHandler.this.unbindConfigAdmin(id);
                    }
                }.start();
            }
        }
    }

    synchronized void bindEventAdmin(ServiceReference ref) {
        if (this.eventAdminServiceRef != null) {
            this.unbindEventAdmin(this.eventAdminServiceRef);
        }
        this.eventAdminServiceRef = ref;
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Event handler for the Apache Felix Web Console");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("event.topics", "*");
        this.plugin.setEventAdmin((EventAdmin)this.bundleContext.getService(ref));
        this.eventHandlerRegistration = this.bundleContext.registerService(EVENT_HANDLER_CLASS_NAME, (Object)new EventHandler(this.plugin.getCollector()), props);
    }

    synchronized void unbindEventAdmin(ServiceReference ref) {
        if (this.eventAdminServiceRef != null && this.eventAdminServiceRef.equals(ref)) {
            this.bundleContext.ungetService(ref);
            this.eventAdminServiceRef = null;
            this.plugin.setEventAdmin(null);
            if (this.eventHandlerRegistration != null) {
                this.eventHandlerRegistration.unregister();
                this.eventHandlerRegistration = null;
            }
        }
    }

    synchronized void bindConfigAdmin(Long id) {
        if (this.configAdminServiceId != null) {
            this.unbindConfigAdmin(this.configAdminServiceId);
        }
        this.plugin.setConfigAdminAvailable(true);
        this.configAdminServiceId = id;
        this.configListenerRegistration = ConfigurationListener.create(this.bundleContext, this.plugin);
    }

    synchronized void unbindConfigAdmin(Long id) {
        if (this.configAdminServiceId != null && this.configAdminServiceId.equals(id)) {
            this.configAdminServiceId = null;
            this.plugin.setConfigAdminAvailable(false);
            if (this.configListenerRegistration != null) {
                this.configListenerRegistration.unregister();
                this.configListenerRegistration = null;
            }
        }
    }
}

