/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.InvocationHandlerAware;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.LocalClientState;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;

public class ClientProxyImpl
extends AbstractClient
implements InvocationHandlerAware,
InvocationHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(ClientProxyImpl.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ClientProxyImpl.class);
    private static final String SLASH = "/";
    private static final String BUFFER_PROXY_RESPONSE = "buffer.proxy.response";
    private ClassResourceInfo cri;
    private ClassLoader proxyLoader;
    private boolean inheritHeaders;
    private boolean isRoot;
    private Map<String, Object> valuesMap = Collections.emptyMap();
    private BodyWriter bodyWriter = new BodyWriter();

    public ClientProxyImpl(URI baseURI, ClassLoader loader, ClassResourceInfo cri, boolean isRoot, boolean inheritHeaders, Object ... varValues) {
        this(new LocalClientState(baseURI), loader, cri, isRoot, inheritHeaders, varValues);
    }

    public ClientProxyImpl(ClientState initialState, ClassLoader loader, ClassResourceInfo cri, boolean isRoot, boolean inheritHeaders, Object ... varValues) {
        super(initialState);
        this.proxyLoader = loader;
        this.cri = cri;
        this.isRoot = isRoot;
        this.inheritHeaders = inheritHeaders;
        this.initValuesMap(varValues);
    }

    private void initValuesMap(Object ... varValues) {
        if (this.isRoot) {
            List vars = this.cri.getURITemplate().getVariables();
            this.valuesMap = new LinkedHashMap<String, Object>();
            for (int i = 0; i < vars.size(); ++i) {
                if (varValues.length > 0) {
                    if (i < varValues.length) {
                        this.valuesMap.put((String)vars.get(i), varValues[i]);
                        continue;
                    }
                    org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("ROOT_VARS_MISMATCH", BUNDLE, new Object[]{vars.size(), varValues.length});
                    LOG.info(msg.toString());
                    break;
                }
                this.valuesMap.put((String)vars.get(i), "");
            }
        }
    }

    @Override
    public Object invoke(Object o, Method m, Object[] params) throws Throwable {
        Class<?> declaringClass = m.getDeclaringClass();
        if (Client.class == declaringClass || InvocationHandlerAware.class == declaringClass || Object.class == declaringClass) {
            return m.invoke((Object)this, params);
        }
        this.resetResponse();
        OperationResourceInfo ori = this.cri.getMethodDispatcher().getOperationResourceInfo(m);
        if (ori == null) {
            ClientProxyImpl.reportInvalidResourceMethod(m, "INVALID_RESOURCE_METHOD");
        }
        MultivaluedMap<ParameterType, Parameter> types = ClientProxyImpl.getParametersInfo(m, params, ori);
        List<Parameter> beanParamsList = ClientProxyImpl.getParameters(types, ParameterType.BEAN);
        int bodyIndex = ClientProxyImpl.getBodyIndex(types, ori);
        List<Object> pathParams = this.getPathParamValues(m, params, types, beanParamsList, ori, bodyIndex);
        UriBuilder builder = this.getCurrentBuilder().clone();
        if (this.isRoot) {
            this.addNonEmptyPath(builder, ori.getClassResourceInfo().getURITemplate().getValue());
        }
        this.addNonEmptyPath(builder, ori.getURITemplate().getValue());
        this.handleMatrixes(m, params, types, beanParamsList, builder);
        this.handleQueries(m, params, types, beanParamsList, builder);
        URI uri = builder.buildFromEncoded(pathParams.toArray()).normalize();
        MultivaluedMap<String, String> headers = this.getHeaders();
        MetadataMap paramHeaders = new MetadataMap();
        this.handleHeaders(m, params, (MultivaluedMap<String, String>)paramHeaders, beanParamsList, types);
        this.handleCookies(m, params, (MultivaluedMap<String, String>)paramHeaders, beanParamsList, types);
        if (ori.isSubResourceLocator()) {
            ClassResourceInfo subCri = this.cri.getSubResource(m.getReturnType(), m.getReturnType());
            if (subCri == null) {
                ClientProxyImpl.reportInvalidResourceMethod(m, "INVALID_SUBRESOURCE");
            }
            MetadataMap subHeaders = paramHeaders;
            if (this.inheritHeaders) {
                subHeaders.putAll(headers);
            }
            ClientState newState = this.getState().newState(uri, (MultivaluedMap<String, String>)subHeaders, this.getTemplateParametersMap(ori.getURITemplate(), pathParams));
            ClientProxyImpl proxyImpl = new ClientProxyImpl(newState, this.proxyLoader, subCri, false, this.inheritHeaders, new Object[0]);
            proxyImpl.setConfiguration(this.getConfiguration());
            return JAXRSClientFactory.createProxy(m.getReturnType(), this.proxyLoader, proxyImpl);
        }
        headers.putAll((Map)paramHeaders);
        this.setRequestHeaders(headers, ori, types.containsKey((Object)ParameterType.FORM), bodyIndex == -1 || params[bodyIndex] == null ? null : params[bodyIndex].getClass(), m.getReturnType());
        this.getState().setTemplates(this.getTemplateParametersMap(ori.getURITemplate(), pathParams));
        Object body = null;
        if (bodyIndex != -1) {
            body = params[bodyIndex];
            if (body == null) {
                bodyIndex = -1;
            }
        } else if (types.containsKey((Object)ParameterType.FORM)) {
            body = this.handleForm(m, params, types, beanParamsList);
        } else if (types.containsKey((Object)ParameterType.REQUEST_BODY)) {
            body = this.handleMultipart(types, ori, params);
        }
        return this.doChainedInvocation(uri, headers, ori, body, bodyIndex, null, null);
    }

    private void addNonEmptyPath(UriBuilder builder, String pathValue) {
        if (!SLASH.equals(pathValue)) {
            builder.path(pathValue);
        }
    }

    private static MultivaluedMap<ParameterType, Parameter> getParametersInfo(Method m, Object[] params, OperationResourceInfo ori) {
        MetadataMap map = new MetadataMap();
        List parameters = ori.getParameters();
        if (parameters.size() == 0) {
            return map;
        }
        int requestBodyParam = 0;
        int multipartParam = 0;
        for (Parameter p : parameters) {
            if (ClientProxyImpl.isIgnorableParameter(m, p)) continue;
            if (p.getType() == ParameterType.REQUEST_BODY) {
                ++requestBodyParam;
                if (ClientProxyImpl.getMultipart(ori, p.getIndex()) != null) {
                    ++multipartParam;
                }
            }
            map.add((Object)p.getType(), (Object)p);
        }
        if (map.containsKey((Object)ParameterType.REQUEST_BODY)) {
            if (requestBodyParam > 1 && requestBodyParam != multipartParam) {
                ClientProxyImpl.reportInvalidResourceMethod(ori.getMethodToInvoke(), "SINGLE_BODY_ONLY");
            }
            if (map.containsKey((Object)ParameterType.FORM)) {
                ClientProxyImpl.reportInvalidResourceMethod(ori.getMethodToInvoke(), "ONLY_FORM_ALLOWED");
            }
        }
        return map;
    }

    private static boolean isIgnorableParameter(Method m, Parameter p) {
        if (p.getType() == ParameterType.CONTEXT) {
            return true;
        }
        return p.getType() == ParameterType.REQUEST_BODY && m.getParameterTypes()[p.getIndex()] == AsyncResponse.class;
    }

    private static int getBodyIndex(MultivaluedMap<ParameterType, Parameter> map, OperationResourceInfo ori) {
        int index;
        List list = (List)map.get((Object)ParameterType.REQUEST_BODY);
        int n = index = list == null || list.size() > 1 ? -1 : ((Parameter)list.get(0)).getIndex();
        if (ori.isSubResourceLocator() && index != -1) {
            ClientProxyImpl.reportInvalidResourceMethod(ori.getMethodToInvoke(), "NO_BODY_IN_SUBRESOURCE");
        }
        return index;
    }

    private void checkResponse(Method m, Response r, Message inMessage) throws Throwable {
        Object t = null;
        int status = r.getStatus();
        if (status >= 300) {
            Class<?>[] exTypes = m.getExceptionTypes();
            if (exTypes.length == 0) {
                exTypes = new Class[]{WebApplicationException.class};
            }
            for (Class<?> exType : exTypes) {
                ResponseExceptionMapper<?> mapper = ClientProxyImpl.findExceptionMapper(inMessage, exType);
                if (mapper == null || (t = mapper.fromResponse(r)) == null) continue;
                throw t;
            }
            if (t == null && m.getReturnType() == Response.class && m.getExceptionTypes().length == 0) {
                return;
            }
            t = this.convertToWebApplicationException(r);
            if (inMessage.getExchange().get((Object)Message.RESPONSE_CODE) == null) {
                throw t;
            }
            Endpoint ep = (Endpoint)inMessage.getExchange().get(Endpoint.class);
            inMessage.getExchange().put(InterceptorProvider.class, (Object)this.getConfiguration());
            inMessage.setContent(Exception.class, (Object)new Fault((Throwable)t));
            inMessage.getInterceptorChain().abort();
            if (ep.getInFaultObserver() != null) {
                ep.getInFaultObserver().onMessage(inMessage);
            }
            throw t;
        }
    }

    private static ResponseExceptionMapper<?> findExceptionMapper(Message message, Class<?> exType) {
        ClientProviderFactory pf = ClientProviderFactory.getInstance(message);
        return pf.createResponseExceptionMapper(message, exType);
    }

    private MultivaluedMap<String, String> setRequestHeaders(MultivaluedMap<String, String> headers, OperationResourceInfo ori, boolean formParams, Class<?> bodyClass, Class<?> responseClass) {
        List<Object> accepts;
        if (headers.getFirst((Object)"Content-Type") == null) {
            if (formParams || bodyClass != null && MultivaluedMap.class.isAssignableFrom(bodyClass)) {
                headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
            } else {
                String cType = ori.getConsumeTypes().isEmpty() || ((MediaType)ori.getConsumeTypes().get(0)).equals((Object)MediaType.WILDCARD_TYPE) ? "application/xml" : JAXRSUtils.mediaTypeToString((MediaType)((MediaType)ori.getConsumeTypes().get(0)), (String[])new String[0]);
                headers.putSingle((Object)"Content-Type", (Object)cType);
            }
        }
        if ((accepts = this.getAccept(headers)) == null) {
            boolean produceWildcard;
            boolean bl = produceWildcard = ori.getProduceTypes().size() == 0 || ((MediaType)ori.getProduceTypes().get(0)).equals((Object)MediaType.WILDCARD_TYPE);
            accepts = produceWildcard ? (InjectionUtils.isPrimitive(responseClass) ? Collections.singletonList(MediaType.TEXT_PLAIN_TYPE) : Collections.singletonList(MediaType.APPLICATION_XML_TYPE)) : (responseClass == Void.class || responseClass == Void.TYPE ? Collections.singletonList(MediaType.WILDCARD_TYPE) : ori.getProduceTypes());
            for (MediaType mediaType : accepts) {
                headers.add((Object)"Accept", (Object)JAXRSUtils.mediaTypeToString((MediaType)mediaType, (String[])new String[0]));
            }
        }
        return headers;
    }

    private List<MediaType> getAccept(MultivaluedMap<String, String> allHeaders) {
        List headers = (List)allHeaders.get((Object)"Accept");
        if (headers == null || headers.size() == 0) {
            return null;
        }
        ArrayList<MediaType> types = new ArrayList<MediaType>();
        for (String s : headers) {
            types.add(JAXRSUtils.toMediaType((String)s));
        }
        return types;
    }

    private List<Object> getPathParamValues(Method m, Object[] params, MultivaluedMap<ParameterType, Parameter> map, List<Parameter> beanParams, OperationResourceInfo ori, int bodyIndex) {
        LinkedList<Object> list = new LinkedList<Object>();
        if (this.isRoot) {
            list.addAll(this.valuesMap.values());
        }
        List methodVars = ori.getURITemplate().getVariables();
        List<Parameter> paramsList = ClientProxyImpl.getParameters(map, ParameterType.PATH);
        LinkedHashMap<String, Parameter> paramsMap = new LinkedHashMap<String, Parameter>();
        for (Parameter p : paramsList) {
            if (p.getName().length() == 0) {
                MultivaluedMap values = InjectionUtils.extractValuesFromBean((Object)params[p.getIndex()], (String)"");
                for (String var : methodVars) {
                    list.addAll((Collection)values.get((Object)var));
                }
                continue;
            }
            paramsMap.put(p.getName(), p);
        }
        HashMap<String, BeanPair> beanParamValues = new HashMap<String, BeanPair>(beanParams.size());
        for (Parameter p : beanParams) {
            beanParamValues.putAll(this.getValuesFromBeanParam(params[p.getIndex()], PathParam.class));
        }
        Object requestBody = bodyIndex == -1 ? null : params[bodyIndex];
        for (String varName : methodVars) {
            Parameter p = (Parameter)paramsMap.remove(varName);
            if (p != null) {
                list.add(this.convertParamValue(params[p.getIndex()], ClientProxyImpl.getParamAnnotations(m, p)));
                continue;
            }
            if (beanParamValues.containsKey(varName)) {
                BeanPair pair = (BeanPair)beanParamValues.get(varName);
                list.add(this.convertParamValue(pair.getValue(), pair.getAnns()));
                continue;
            }
            if (requestBody == null) continue;
            try {
                Method getter = requestBody.getClass().getMethod("get" + StringUtils.capitalize((String)varName), new Class[0]);
                list.add(getter.invoke(requestBody, new Object[0]));
            }
            catch (Exception ex) {}
        }
        block6: for (Parameter p : paramsMap.values()) {
            if (!this.valuesMap.containsKey(p.getName())) continue;
            int index = 0;
            Iterator<String> it = this.valuesMap.keySet().iterator();
            while (it.hasNext()) {
                if (it.next().equals(p.getName()) && index < list.size()) {
                    list.remove(index);
                    list.add(index, this.convertParamValue(params[p.getIndex()], null));
                    continue block6;
                }
                ++index;
            }
        }
        return list;
    }

    private static Annotation[] getParamAnnotations(Method m, Parameter p) {
        return m.getParameterAnnotations()[p.getIndex()];
    }

    private static List<Parameter> getParameters(MultivaluedMap<ParameterType, Parameter> map, ParameterType key) {
        return map.get((Object)key) == null ? Collections.EMPTY_LIST : (List)map.get((Object)key);
    }

    private void handleQueries(Method m, Object[] params, MultivaluedMap<ParameterType, Parameter> map, List<Parameter> beanParams, UriBuilder ub) {
        List<Parameter> qs = ClientProxyImpl.getParameters(map, ParameterType.QUERY);
        for (Parameter p : qs) {
            if (params[p.getIndex()] == null) continue;
            this.addMatrixQueryParamsToBuilder(ub, p.getName(), ParameterType.QUERY, ClientProxyImpl.getParamAnnotations(m, p), params[p.getIndex()]);
        }
        for (Parameter p : beanParams) {
            Map<String, BeanPair> values = this.getValuesFromBeanParam(params[p.getIndex()], QueryParam.class);
            for (Map.Entry<String, BeanPair> entry : values.entrySet()) {
                if (entry.getValue() == null) continue;
                this.addMatrixQueryParamsToBuilder(ub, entry.getKey(), ParameterType.QUERY, entry.getValue().getAnns(), entry.getValue().getValue());
            }
        }
    }

    private Map<String, BeanPair> getValuesFromBeanParam(Object bean, Class<? extends Annotation> annClass) {
        HashMap<String, BeanPair> values = new HashMap<String, BeanPair>();
        for (Method m : bean.getClass().getMethods()) {
            if (!m.getName().startsWith("set")) continue;
            try {
                Object value;
                String propertyName = m.getName().substring(3);
                Annotation annotation = m.getAnnotation(annClass);
                if (annotation != null) {
                    Method getter = bean.getClass().getMethod("get" + propertyName, new Class[0]);
                    Object value2 = getter.invoke(bean, new Object[0]);
                    if (value2 == null) continue;
                    String annotationValue = AnnotationUtils.getAnnotationValue((Annotation)annotation);
                    values.put(annotationValue, new BeanPair(value2, m.getParameterAnnotations()[0]));
                    continue;
                }
                String fieldName = StringUtils.uncapitalize((String)propertyName);
                Field f = ReflectionUtil.getDeclaredField(bean.getClass(), (String)fieldName);
                if (f == null || (annotation = f.getAnnotation(annClass)) == null || (value = ReflectionUtil.accessDeclaredField((Field)f, (Object)bean, Object.class)) == null) continue;
                String annotationValue = AnnotationUtils.getAnnotationValue((Annotation)annotation);
                values.put(annotationValue, new BeanPair(value, f.getAnnotations()));
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return values;
    }

    private void handleMatrixes(Method m, Object[] params, MultivaluedMap<ParameterType, Parameter> map, List<Parameter> beanParams, UriBuilder ub) {
        List<Parameter> mx = ClientProxyImpl.getParameters(map, ParameterType.MATRIX);
        for (Parameter p : mx) {
            if (params[p.getIndex()] == null) continue;
            this.addMatrixQueryParamsToBuilder(ub, p.getName(), ParameterType.MATRIX, ClientProxyImpl.getParamAnnotations(m, p), params[p.getIndex()]);
        }
        for (Parameter p : beanParams) {
            Map<String, BeanPair> values = this.getValuesFromBeanParam(params[p.getIndex()], MatrixParam.class);
            for (Map.Entry<String, BeanPair> entry : values.entrySet()) {
                if (entry.getValue() == null) continue;
                this.addMatrixQueryParamsToBuilder(ub, entry.getKey(), ParameterType.MATRIX, entry.getValue().getAnns(), entry.getValue().getValue());
            }
        }
    }

    private MultivaluedMap<String, String> handleForm(Method m, Object[] params, MultivaluedMap<ParameterType, Parameter> map, List<Parameter> beanParams) {
        MetadataMap form = new MetadataMap();
        List<Parameter> fm = ClientProxyImpl.getParameters(map, ParameterType.FORM);
        for (Parameter p : fm) {
            this.addFormValue((MultivaluedMap<String, String>)form, p.getName(), params[p.getIndex()], ClientProxyImpl.getParamAnnotations(m, p));
        }
        for (Parameter p : beanParams) {
            Map<String, BeanPair> values = this.getValuesFromBeanParam(params[p.getIndex()], FormParam.class);
            for (Map.Entry<String, BeanPair> entry : values.entrySet()) {
                this.addFormValue((MultivaluedMap<String, String>)form, entry.getKey(), entry.getValue().getValue(), entry.getValue().getAnns());
            }
        }
        return form;
    }

    private void addFormValue(MultivaluedMap<String, String> form, String name, Object pValue, Annotation[] anns) {
        if (pValue != null) {
            if (InjectionUtils.isSupportedCollectionOrArray(pValue.getClass())) {
                List<Object> c = pValue.getClass().isArray() ? Arrays.asList((Object[])pValue) : (List<Object>)pValue;
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    FormUtils.addPropertyToForm(form, (String)name, (Object)this.convertParamValue(it.next(), anns));
                }
            } else {
                FormUtils.addPropertyToForm(form, (String)name, (Object)(name.isEmpty() ? pValue : this.convertParamValue(pValue, anns)));
            }
        }
    }

    private List<Attachment> handleMultipart(MultivaluedMap<ParameterType, Parameter> map, OperationResourceInfo ori, Object[] params) {
        LinkedList<Attachment> atts = new LinkedList<Attachment>();
        List<Parameter> fm = ClientProxyImpl.getParameters(map, ParameterType.REQUEST_BODY);
        for (Parameter p : fm) {
            Object partObject;
            Multipart part = ClientProxyImpl.getMultipart(ori, p.getIndex());
            if (part == null || (partObject = params[p.getIndex()]) == null) continue;
            atts.add(new Attachment(part.value(), part.type(), partObject));
        }
        return atts;
    }

    private void handleHeaders(Method m, Object[] params, MultivaluedMap<String, String> headers, List<Parameter> beanParams, MultivaluedMap<ParameterType, Parameter> map) {
        List<Parameter> hs = ClientProxyImpl.getParameters(map, ParameterType.HEADER);
        for (Parameter p : hs) {
            if (params[p.getIndex()] == null) continue;
            headers.add((Object)p.getName(), (Object)this.convertParamValue(params[p.getIndex()], ClientProxyImpl.getParamAnnotations(m, p)));
        }
        for (Parameter p : beanParams) {
            Map<String, BeanPair> values = this.getValuesFromBeanParam(params[p.getIndex()], HeaderParam.class);
            for (Map.Entry<String, BeanPair> entry : values.entrySet()) {
                if (entry.getValue() == null) continue;
                headers.add((Object)entry.getKey(), (Object)this.convertParamValue(entry.getValue().getValue(), entry.getValue().getAnns()));
            }
        }
    }

    private static Multipart getMultipart(OperationResourceInfo ori, int index) {
        Method aMethod = ori.getAnnotatedMethod();
        return aMethod != null ? (Multipart)AnnotationUtils.getAnnotation((Annotation[])aMethod.getParameterAnnotations()[index], Multipart.class) : null;
    }

    private void handleCookies(Method m, Object[] params, MultivaluedMap<String, String> headers, List<Parameter> beanParams, MultivaluedMap<ParameterType, Parameter> map) {
        List<Parameter> cs = ClientProxyImpl.getParameters(map, ParameterType.COOKIE);
        for (Parameter p : cs) {
            if (params[p.getIndex()] == null) continue;
            headers.add((Object)"Cookie", (Object)(p.getName() + '=' + this.convertParamValue(params[p.getIndex()].toString(), ClientProxyImpl.getParamAnnotations(m, p))));
        }
        for (Parameter p : beanParams) {
            Map<String, BeanPair> values = this.getValuesFromBeanParam(params[p.getIndex()], CookieParam.class);
            for (Map.Entry<String, BeanPair> entry : values.entrySet()) {
                if (entry.getValue() == null) continue;
                headers.add((Object)"Cookie", (Object)(entry.getKey() + "=" + this.convertParamValue(entry.getValue().getValue(), entry.getValue().getAnns())));
            }
        }
    }

    /*
     * Loose catch block
     */
    private Object doChainedInvocation(URI uri, MultivaluedMap<String, String> headers, OperationResourceInfo ori, Object body, int bodyIndex, Exchange exchange, Map<String, Object> invocationContext) throws Throwable {
        Bus configuredBus = this.getConfiguration().getBus();
        Bus origBus = BusFactory.getAndSetThreadDefaultBus((Bus)configuredBus);
        ClassLoaderUtils.ClassLoaderHolder origLoader = null;
        try {
            ClassLoader loader = (ClassLoader)configuredBus.getExtension(ClassLoader.class);
            if (loader != null) {
                origLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)loader);
            }
            Message outMessage = this.createMessage(body, ori.getHttpMethod(), headers, uri, exchange, invocationContext, true);
            if (bodyIndex != -1) {
                outMessage.put(Type.class, (Object)ori.getMethodToInvoke().getGenericParameterTypes()[bodyIndex]);
            }
            outMessage.getExchange().setOneWay(ori.isOneway());
            this.setSupportOnewayResponseProperty(outMessage);
            outMessage.setContent(OperationResourceInfo.class, (Object)ori);
            this.setPlainOperationNameProperty(outMessage, ori.getMethodToInvoke().getName());
            outMessage.getExchange().put(Method.class, (Object)ori.getMethodToInvoke());
            outMessage.put((Object)Annotation.class.getName(), (Object)ClientProxyImpl.getMethodAnnotations(ori.getAnnotatedMethod(), bodyIndex));
            if (body != null) {
                outMessage.put((Object)"BODY_INDEX", (Object)bodyIndex);
            }
            outMessage.getInterceptorChain().add((Interceptor)this.bodyWriter);
            Map<String, Object> reqContext = this.getRequestContext(outMessage);
            reqContext.put(OperationResourceInfo.class.getName(), ori);
            reqContext.put("BODY_INDEX", bodyIndex);
            this.doRunInterceptorChain(outMessage);
            Object[] results = this.preProcessResult(outMessage);
            if (results != null && results.length == 1) {
                Object object = results[0];
                return object;
            }
            Object response = null;
            try {
                Object object = response = this.handleResponse(outMessage, ori.getClassResourceInfo().getServiceClass());
                return object;
            }
            catch (Exception ex) {
                response = ex;
                throw ex;
            }
            finally {
                this.completeExchange(response, outMessage.getExchange(), true);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (origLoader != null) {
                origLoader.reset();
            }
            if (origBus != configuredBus) {
                BusFactory.setThreadDefaultBus((Bus)origBus);
            }
        }
    }

    @Override
    protected Object retryInvoke(URI newRequestURI, MultivaluedMap<String, String> headers, Object body, Exchange exchange, Map<String, Object> invContext) throws Throwable {
        Map reqContext = CastUtils.cast((Map)((Map)invContext.get("RequestContext")));
        int bodyIndex = body != null ? (Integer)reqContext.get("BODY_INDEX") : -1;
        OperationResourceInfo ori = (OperationResourceInfo)reqContext.get(OperationResourceInfo.class.getName());
        return this.doChainedInvocation(newRequestURI, headers, ori, body, bodyIndex, exchange, invContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleResponse(Message outMessage, Class<?> serviceCls) throws Throwable {
        try {
            Response r = this.setResponseBuilder(outMessage, outMessage.getExchange()).build();
            ((ResponseImpl)r).setOutMessage(outMessage);
            this.getState().setResponse(r);
            Method method = (Method)outMessage.getExchange().get(Method.class);
            this.checkResponse(method, r, outMessage);
            if (method.getReturnType() == Void.class || method.getReturnType() == Void.TYPE) {
                Object var5_5 = null;
                return var5_5;
            }
            if (method.getReturnType() == Response.class && (r.getEntity() == null || InputStream.class.isAssignableFrom(r.getEntity().getClass()) && ((InputStream)r.getEntity()).available() == 0)) {
                Response response = r;
                return response;
            }
            if (PropertyUtils.isTrue((Object)super.getConfiguration().getResponseContext().get(BUFFER_PROXY_RESPONSE))) {
                r.bufferEntity();
            }
            Class returnType = method.getReturnType();
            Type genericType = InjectionUtils.processGenericTypeIfNeeded(serviceCls, returnType, (Type)method.getGenericReturnType());
            returnType = InjectionUtils.updateParamClassToTypeIfNeeded(returnType, (Type)genericType);
            Object t = this.readBody(r, outMessage, returnType, genericType, method.getDeclaredAnnotations());
            return t;
        }
        finally {
            ClientProviderFactory.getInstance(outMessage).clearThreadLocalProxies();
        }
    }

    @Override
    public Object getInvocationHandler() {
        return this;
    }

    protected static void reportInvalidResourceMethod(Method m, String name) {
        org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message(name, BUNDLE, new Object[]{m.getDeclaringClass().getName(), m.getName()});
        LOG.severe(errorMsg.toString());
        throw new ProcessingException(errorMsg.toString());
    }

    protected static Annotation[] getMethodAnnotations(Method aMethod, int bodyIndex) {
        return aMethod == null || bodyIndex == -1 ? new Annotation[]{} : aMethod.getParameterAnnotations()[bodyIndex];
    }

    private static class BeanPair {
        private Object value;
        private Annotation[] anns;

        public BeanPair(Object value, Annotation[] anns) {
            this.value = value;
            this.anns = anns;
        }

        public Object getValue() {
            return this.value;
        }

        public Annotation[] getAnns() {
            return this.anns;
        }
    }

    private class BodyWriter
    extends AbstractClient.AbstractBodyWriter {
        private BodyWriter() {
        }

        @Override
        protected void doWriteBody(Message outMessage, Object body, Type bodyType, Annotation[] customAnns, OutputStream os) throws Fault {
            OperationResourceInfo ori = (OperationResourceInfo)outMessage.getContent(OperationResourceInfo.class);
            if (ori == null) {
                return;
            }
            Method method = ori.getMethodToInvoke();
            int bodyIndex = (Integer)outMessage.get((Object)"BODY_INDEX");
            Annotation[] anns = customAnns != null ? customAnns : ClientProxyImpl.getMethodAnnotations(ori.getAnnotatedMethod(), bodyIndex);
            try {
                if (bodyIndex != -1) {
                    Class<Object> paramClass = method.getParameterTypes()[bodyIndex];
                    Class<Object> bodyClass = paramClass.isAssignableFrom(body.getClass()) ? paramClass : body.getClass();
                    Type genericType = method.getGenericParameterTypes()[bodyIndex];
                    if (bodyType != null) {
                        genericType = bodyType;
                    }
                    genericType = InjectionUtils.processGenericTypeIfNeeded((Class)ori.getClassResourceInfo().getServiceClass(), bodyClass, (Type)genericType);
                    bodyClass = InjectionUtils.updateParamClassToTypeIfNeeded(bodyClass, (Type)genericType);
                    ClientProxyImpl.this.writeBody(body, outMessage, bodyClass, genericType, anns, os);
                } else {
                    Type paramType = body.getClass();
                    if (bodyType != null) {
                        paramType = bodyType;
                    }
                    ClientProxyImpl.this.writeBody(body, outMessage, body.getClass(), paramType, anns, os);
                }
            }
            catch (Exception ex) {
                throw new Fault((Throwable)ex);
            }
        }
    }
}

