/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.services.task.utils.ClassUtil;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.task.api.TaskAdminService;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.InternalTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAdminServiceImpl
implements TaskAdminService {
    private static final Logger logger = LoggerFactory.getLogger(TaskAdminServiceImpl.class);
    private TaskPersistenceContext persistenceContext;

    public TaskAdminServiceImpl() {
    }

    public TaskAdminServiceImpl(TaskPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public void setPersistenceContext(TaskPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public List<TaskSummary> getActiveTasks() {
        HashMap params = this.persistenceContext.addParametersToMap(new Object[]{"status", Arrays.asList(Status.InProgress)});
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksByStatus", (Map)params, ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getActiveTasks(Date since) {
        HashMap params = this.persistenceContext.addParametersToMap(new Object[]{"status", Arrays.asList(Status.InProgress), "since", since});
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksByStatusSince", (Map)params, ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getCompletedTasks() {
        HashMap params = this.persistenceContext.addParametersToMap(new Object[]{"status", Arrays.asList(Status.Completed)});
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksByStatus", (Map)params, ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getCompletedTasks(Date since) {
        HashMap params = this.persistenceContext.addParametersToMap(new Object[]{"status", Arrays.asList(Status.Completed), "since", since});
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksByStatusSince", (Map)params, ClassUtil.castClass(List.class));
    }

    public List<TaskSummary> getCompletedTasksByProcessId(Long processId) {
        HashMap params = this.persistenceContext.addParametersToMap(new Object[]{"status", Arrays.asList(Status.Completed), "processInstanceId", processId});
        return (List)this.persistenceContext.queryWithParametersInTransaction("TasksByStatusByProcessId", (Map)params, ClassUtil.castClass(List.class));
    }

    public int archiveTasks(List<TaskSummary> tasks) {
        int archivedTasks = 0;
        for (TaskSummary sum : tasks) {
            long taskId = sum.getId();
            Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
            if (task == null) continue;
            ((InternalTask)task).setArchived(Boolean.valueOf(true));
            this.persistenceContext.merge((Object)task);
            ++archivedTasks;
        }
        return archivedTasks;
    }

    public List<TaskSummary> getArchivedTasks() {
        HashMap params = new HashMap();
        return (List)this.persistenceContext.queryWithParametersInTransaction("ArchivedTasks", params, ClassUtil.castClass(List.class));
    }

    public int removeTasks(List<TaskSummary> tasks) {
        int removedTasks = 0;
        for (TaskSummary sum : tasks) {
            long taskId = sum.getId();
            Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
            if (task == null) continue;
            Content content = this.persistenceContext.findContent(Long.valueOf(task.getTaskData().getDocumentContentId()));
            Content outputContent = this.persistenceContext.findContent(Long.valueOf(task.getTaskData().getOutputContentId()));
            if (((InternalTask)task).isArchived().booleanValue()) {
                this.persistenceContext.remove((Object)task);
                if (content != null) {
                    this.persistenceContext.remove((Object)content);
                }
                if (outputContent != null) {
                    this.persistenceContext.remove((Object)outputContent);
                }
                ++removedTasks;
                continue;
            }
            logger.warn(" The Task cannot be removed if it wasn't archived first !!");
        }
        return removedTasks;
    }

    public int removeAllTasks() {
        List tasks = (List)this.persistenceContext.queryStringInTransaction("select t from TaskImpl t", ClassUtil.castClass(List.class));
        int count = 0;
        for (Task t : tasks) {
            this.persistenceContext.removeTask(t);
            ++count;
        }
        return count;
    }
}

