/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.messenger.impl;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.qpid.proton.InterruptException;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.TimeoutException;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.driver.Connector;
import org.apache.qpid.proton.driver.Driver;
import org.apache.qpid.proton.driver.Listener;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.Ssl;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.messenger.Messenger;
import org.apache.qpid.proton.messenger.MessengerException;
import org.apache.qpid.proton.messenger.Status;
import org.apache.qpid.proton.messenger.Tracker;
import org.apache.qpid.proton.messenger.impl.Address;
import org.apache.qpid.proton.messenger.impl.Store;
import org.apache.qpid.proton.messenger.impl.StoreEntry;
import org.apache.qpid.proton.messenger.impl.TrackerImpl;
import org.apache.qpid.proton.messenger.impl.Transform;

public class MessengerImpl
implements Messenger {
    private static final EnumSet<EndpointState> UNINIT = EnumSet.of(EndpointState.UNINITIALIZED);
    private static final EnumSet<EndpointState> ACTIVE = EnumSet.of(EndpointState.ACTIVE);
    private static final EnumSet<EndpointState> CLOSED = EnumSet.of(EndpointState.CLOSED);
    private static final EnumSet<EndpointState> ANY = EnumSet.allOf(EndpointState.class);
    private final Logger _logger = Logger.getLogger("proton.messenger");
    private final String _name;
    private long _timeout = -1L;
    private boolean _blocking = true;
    private long _nextTag = 1L;
    private Driver _driver;
    private LinkCreditMode _credit_mode = LinkCreditMode.LINK_CREDIT_EXPLICIT;
    private final int _credit_batch = 1024;
    private int _credit;
    private int _distributed;
    private int _receivers;
    private int _draining;
    private List<Receiver> _credited = new ArrayList<Receiver>();
    private List<Receiver> _blocked = new ArrayList<Receiver>();
    private long _next_drain;
    private TrackerImpl _incomingTracker;
    private TrackerImpl _outgoingTracker;
    private Store _incomingStore = new Store();
    private Store _outgoingStore = new Store();
    private List<Connector> _awaitingDestruction = new ArrayList<Connector>();
    private int _sendThreshold;
    private Transform _routes = new Transform();
    private Transform _rewrites = new Transform();
    private String _certificate;
    private String _privateKey;
    private String _password;
    private String _trustedDb;
    private String _original;
    private boolean _worked = false;
    private final SentSettled _sentSettled = new SentSettled();
    private final MessageAvailable _messageAvailable = new MessageAvailable();
    private final AllClosed _allClosed = new AllClosed();
    private final WorkPred _workPred = new WorkPred();

    @Deprecated
    public MessengerImpl() {
        this(UUID.randomUUID().toString());
    }

    @Deprecated
    public MessengerImpl(String name) {
        this._name = name;
    }

    @Override
    public void setTimeout(long timeInMillis) {
        this._timeout = timeInMillis;
    }

    @Override
    public long getTimeout() {
        return this._timeout;
    }

    @Override
    public boolean isBlocking() {
        return this._blocking;
    }

    @Override
    public void setBlocking(boolean b) {
        this._blocking = b;
    }

    @Override
    public void setCertificate(String certificate) {
        this._certificate = certificate;
    }

    @Override
    public String getCertificate() {
        return this._certificate;
    }

    @Override
    public void setPrivateKey(String privateKey) {
        this._privateKey = privateKey;
    }

    @Override
    public String getPrivateKey() {
        return this._privateKey;
    }

    @Override
    public void setPassword(String password) {
        this._password = password;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public void setTrustedCertificates(String trusted) {
        this._trustedDb = trusted;
    }

    @Override
    public String getTrustedCertificates() {
        return this._trustedDb;
    }

    @Override
    public void start() throws IOException {
        this._driver = Proton.driver();
    }

    @Override
    public void stop() {
        if (this._driver != null) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine(this + " about to stop");
            }
            for (Connector c : this._driver.connectors()) {
                Connection connection = c.getConnection();
                connection.close();
            }
            for (Listener l : this._driver.listeners()) {
                try {
                    l.close();
                }
                catch (IOException e) {
                    this._logger.log(Level.WARNING, "Error while closing listener", e);
                }
            }
            this.waitUntil(this._allClosed);
        }
    }

    @Override
    public boolean stopped() {
        return this._allClosed.test();
    }

    @Override
    public boolean work(long timeout) throws TimeoutException {
        if (this._driver == null) {
            return false;
        }
        this._worked = false;
        return this.waitUntil(this._workPred, timeout);
    }

    @Override
    public void interrupt() {
        if (this._driver != null) {
            this._driver.wakeup();
        }
    }

    private String defaultRewrite(String address) {
        if (address != null && address.contains("@")) {
            Address addr = new Address(address);
            String scheme = addr.getScheme();
            String host = addr.getHost();
            String port = addr.getPort();
            String name = addr.getName();
            StringBuilder sb = new StringBuilder();
            if (scheme != null) {
                sb.append(scheme).append("://");
            }
            if (host != null) {
                sb.append(host);
            }
            if (port != null) {
                sb.append(":").append(port);
            }
            if (name != null) {
                sb.append("/").append(name);
            }
            return sb.toString();
        }
        return address;
    }

    private void rewriteMessage(Message m) {
        this._original = m.getAddress();
        if (this._rewrites.apply(this._original)) {
            m.setAddress(this._rewrites.result());
        } else {
            m.setAddress(this.defaultRewrite(this._original));
        }
    }

    private void restoreMessage(Message m) {
        m.setAddress(this._original);
    }

    private String routeAddress(String addr) {
        if (this._routes.apply(addr)) {
            return this._routes.result();
        }
        return addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Message m) throws MessengerException {
        if (this._driver == null) {
            throw new IllegalStateException("cannot put while messenger is stopped");
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine(this + " about to put message: " + m);
        }
        StoreEntry entry = this._outgoingStore.put(m.getAddress());
        this._outgoingTracker = new TrackerImpl(TrackerImpl.Type.OUTGOING, this._outgoingStore.trackEntry(entry));
        String routedAddress = this.routeAddress(m.getAddress());
        Address address = new Address(routedAddress);
        if (address.getHost() == null) {
            throw new MessengerException("unable to send to address: " + routedAddress);
        }
        this.rewriteMessage(m);
        try {
            int encoded;
            this.adjustReplyTo(m);
            byte[] buffer = new byte[5120];
            while (true) {
                try {
                    encoded = m.encode(buffer, 0, buffer.length);
                }
                catch (BufferOverflowException e) {
                    buffer = new byte[buffer.length * 2];
                    continue;
                }
                break;
            }
            entry.setEncodedMsg(buffer, encoded);
        }
        finally {
            this.restoreMessage(m);
        }
        Sender sender = this.getLink(address, new SenderFinder(address.getName()));
        this.pumpOut(m.getAddress(), sender);
    }

    private void reclaimLink(Link link2) {
        int credit;
        if (link2 instanceof Receiver && (credit = link2.getCredit()) > 0) {
            this._credit += credit;
            this._distributed -= credit;
        }
        for (Delivery delivery = link2.head(); delivery != null; delivery = delivery.next()) {
            StoreEntry entry = (StoreEntry)delivery.getContext();
            if (entry == null) continue;
            entry.setDelivery(null);
            if (!delivery.isBuffered()) continue;
            entry.setStatus(Status.ABORTED);
        }
        this.linkRemoved(link2);
    }

    private int pumpOut(String address, Sender sender) {
        StoreEntry entry = this._outgoingStore.get(address);
        if (entry == null) {
            sender.drained();
            return 0;
        }
        byte[] tag = String.valueOf(this._nextTag++).getBytes();
        Delivery delivery = sender.delivery(tag);
        entry.setDelivery(delivery);
        this._logger.log(Level.FINE, "Sending on delivery: " + delivery);
        int n = sender.send(entry.getEncodedMsg(), 0, entry.getEncodedLength());
        if (n < 0) {
            this._outgoingStore.freeEntry(entry);
            this._logger.log(Level.WARNING, "Send error: " + n);
            return n;
        }
        sender.advance();
        this._outgoingStore.freeEntry(entry);
        return 0;
    }

    @Override
    public void send() throws TimeoutException {
        this.send(-1);
    }

    @Override
    public void send(int n) throws TimeoutException {
        if (this._driver == null) {
            throw new IllegalStateException("cannot send while messenger is stopped");
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine(this + " about to send");
        }
        if (n == -1) {
            this._sendThreshold = 0;
        } else {
            this._sendThreshold = this.outgoing() - n;
            if (this._sendThreshold < 0) {
                this._sendThreshold = 0;
            }
        }
        this.waitUntil(this._sentSettled);
    }

    @Override
    public void recv(int n) throws TimeoutException {
        if (this._driver == null) {
            throw new IllegalStateException("cannot recv while messenger is stopped");
        }
        if (this._logger.isLoggable(Level.FINE) && n != -1) {
            this._logger.fine(this + " about to wait for up to " + n + " messages to be received");
        }
        if (n == -1) {
            this._credit_mode = LinkCreditMode.LINK_CREDIT_AUTO;
        } else {
            this._credit_mode = LinkCreditMode.LINK_CREDIT_EXPLICIT;
            this._credit = n > this._distributed ? n - this._distributed : 0;
        }
        this.distributeCredit();
        this.waitUntil(this._messageAvailable);
    }

    @Override
    public void recv() throws TimeoutException {
        this.recv(-1);
    }

    @Override
    public int receiving() {
        return this._credit + this._distributed;
    }

    @Override
    public Message get() {
        StoreEntry entry = this._incomingStore.get(null);
        if (entry != null) {
            Message message = Proton.message();
            message.decode(entry.getEncodedMsg(), 0, entry.getEncodedLength());
            this._incomingTracker = new TrackerImpl(TrackerImpl.Type.INCOMING, this._incomingStore.trackEntry(entry));
            this._incomingStore.freeEntry(entry);
            return message;
        }
        return null;
    }

    private int pumpIn(String address, Receiver receiver) {
        Delivery delivery = receiver.current();
        if (delivery.isReadable() && !delivery.isPartial()) {
            StoreEntry entry = this._incomingStore.put(address);
            entry.setDelivery(delivery);
            this._logger.log(Level.FINE, "Readable delivery found: " + delivery);
            int size2 = delivery.pending();
            byte[] buffer = new byte[size2];
            int read2 = receiver.recv(buffer, 0, buffer.length);
            if (read2 != size2) {
                throw new IllegalStateException();
            }
            entry.setEncodedMsg(buffer, size2);
            receiver.advance();
            assert (this._distributed > 0);
            --this._distributed;
            if (!receiver.getDrain() && this._blocked.isEmpty() && this._credit > 0) {
                int max = this.perLinkCredit();
                int lo_thresh = (int)((double)max * 0.2 + 0.5);
                if (receiver.getRemoteCredit() < lo_thresh) {
                    int more = Math.min(this._credit, max - receiver.getRemoteCredit());
                    this._credit -= more;
                    this._distributed += more;
                    receiver.flow(more);
                }
            }
            if (receiver.getRemoteCredit() == 0 && this._credited.contains(receiver)) {
                this._credited.remove(receiver);
                if (receiver.getDrain()) {
                    receiver.setDrain(false);
                    assert (this._draining > 0);
                    --this._draining;
                }
                this._blocked.add(receiver);
            }
        }
        return 0;
    }

    @Override
    public void subscribe(String source) throws MessengerException {
        if (this._driver == null) {
            throw new IllegalStateException("messenger is stopped");
        }
        String routed = this.routeAddress(source);
        Address address = new Address(routed);
        String hostName = address.getHost();
        if (hostName == null) {
            throw new MessengerException("Invalid address (hostname cannot be null): " + routed);
        }
        int port = Integer.valueOf(address.getImpliedPort());
        if (address.isPassive()) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine(this + " about to subscribe to source " + source + " using address " + hostName + ":" + port);
            }
            ListenerContext ctx = new ListenerContext(address);
            this._driver.createListener(hostName, port, ctx);
        } else {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine(this + " about to subscribe to source " + source);
            }
            this.getLink(address, new ReceiverFinder(address.getName()));
        }
    }

    @Override
    public int outgoing() {
        return this._outgoingStore.size() + this.queued(true);
    }

    @Override
    public int incoming() {
        return this._incomingStore.size() + this.queued(false);
    }

    @Override
    public int getIncomingWindow() {
        return this._incomingStore.getWindow();
    }

    @Override
    public void setIncomingWindow(int window) {
        this._incomingStore.setWindow(window);
    }

    @Override
    public int getOutgoingWindow() {
        return this._outgoingStore.getWindow();
    }

    @Override
    public void setOutgoingWindow(int window) {
        this._outgoingStore.setWindow(window);
    }

    @Override
    public Tracker incomingTracker() {
        return this._incomingTracker;
    }

    @Override
    public Tracker outgoingTracker() {
        return this._outgoingTracker;
    }

    private Store getTrackerStore(Tracker tracker) {
        return ((TrackerImpl)tracker).isOutgoing() ? this._outgoingStore : this._incomingStore;
    }

    @Override
    public void reject(Tracker tracker, int flags) {
        int id = ((TrackerImpl)tracker).getSequence();
        this.getTrackerStore(tracker).update(id, Status.REJECTED, flags, false, false);
    }

    @Override
    public void accept(Tracker tracker, int flags) {
        int id = ((TrackerImpl)tracker).getSequence();
        this.getTrackerStore(tracker).update(id, Status.ACCEPTED, flags, false, false);
    }

    @Override
    public void settle(Tracker tracker, int flags) {
        int id = ((TrackerImpl)tracker).getSequence();
        this.getTrackerStore(tracker).update(id, Status.UNKNOWN, flags, true, true);
    }

    @Override
    public Status getStatus(Tracker tracker) {
        int id = ((TrackerImpl)tracker).getSequence();
        StoreEntry e = this.getTrackerStore(tracker).getEntry(id);
        if (e != null) {
            return e.getStatus();
        }
        return Status.UNKNOWN;
    }

    @Override
    public void route(String pattern, String address) {
        this._routes.rule(pattern, address);
    }

    @Override
    public void rewrite(String pattern, String address) {
        this._rewrites.rule(pattern, address);
    }

    private int queued(boolean outgoing) {
        int count = 0;
        if (this._driver != null) {
            for (Connector c : this._driver.connectors()) {
                Connection connection = c.getConnection();
                for (Link link2 : new Links(connection, ACTIVE, ANY)) {
                    if (outgoing) {
                        if (!(link2 instanceof Sender)) continue;
                        count += link2.getQueued();
                        continue;
                    }
                    if (!(link2 instanceof Receiver)) continue;
                    count += link2.getQueued();
                }
            }
        }
        return count;
    }

    private void bringDestruction() {
        for (Connector c : this._awaitingDestruction) {
            c.destroy();
        }
        this._awaitingDestruction.clear();
    }

    private void processAllConnectors() {
        this.distributeCredit();
        for (Connector c : this._driver.connectors()) {
            this.processEndpoints(c);
            try {
                if (!c.process()) continue;
                this._worked = true;
            }
            catch (IOException e) {
                this._logger.log(Level.SEVERE, "Error processing connection", e);
            }
        }
        this.bringDestruction();
        this.distributeCredit();
    }

    private void processActive() {
        Listener l = this._driver.listener();
        while (l != null) {
            this._worked = true;
            Connector c = l.accept();
            Connection connection = Proton.connection();
            connection.setContainer(this._name);
            ListenerContext ctx = (ListenerContext)l.getContext();
            connection.setContext(new ConnectionContext(ctx.getAddress(), c));
            c.setConnection(connection);
            Transport transport = c.getTransport();
            Sasl sasl = c.sasl();
            if (sasl != null) {
                sasl.server();
                sasl.setMechanisms("ANONYMOUS");
                sasl.done(Sasl.SaslOutcome.PN_SASL_OK);
            }
            transport.ssl(ctx.getDomain());
            connection.open();
            l = this._driver.listener();
        }
        Connector c = this._driver.connector();
        while (c != null) {
            this._worked = true;
            if (c.isClosed()) {
                this._awaitingDestruction.add(c);
                this.reclaimCredit(c.getConnection());
            } else {
                this._logger.log(Level.FINE, "Processing active connector " + c);
                try {
                    c.process();
                    this.processEndpoints(c);
                    c.process();
                }
                catch (IOException e) {
                    this._logger.log(Level.SEVERE, "Error processing connection", e);
                }
            }
            c = this._driver.connector();
        }
        this.bringDestruction();
        this.distributeCredit();
    }

    private void processEndpoints(Connector c) {
        Connection connection = c.getConnection();
        if (connection.getLocalState() == EndpointState.UNINITIALIZED) {
            connection.open();
        }
        Delivery delivery = connection.getWorkHead();
        while (delivery != null) {
            Link link2 = delivery.getLink();
            if (delivery.isUpdated()) {
                StoreEntry e;
                if (link2 instanceof Sender) {
                    delivery.disposition(delivery.getRemoteState());
                }
                if ((e = (StoreEntry)delivery.getContext()) != null) {
                    e.updated();
                }
            }
            if (delivery.isReadable()) {
                this.pumpIn(link2.getSource().getAddress(), (Receiver)link2);
            }
            Delivery next = delivery.getWorkNext();
            delivery.clear();
            delivery = next;
        }
        for (Session session : new Sessions(connection, UNINIT, ANY)) {
            session.open();
            this._logger.log(Level.FINE, "Opened session " + session);
        }
        for (Link link3 : new Links(connection, UNINIT, ANY)) {
            if (link3.getRemoteSource() != null) {
                link3.setSource(link3.getRemoteSource().copy());
            }
            if (link3.getRemoteTarget() != null) {
                link3.setTarget(link3.getRemoteTarget().copy());
            }
            this.linkAdded(link3);
            link3.open();
            this._logger.log(Level.FINE, "Opened link " + link3);
        }
        this.distributeCredit();
        for (Link link3 : new Links(connection, ACTIVE, ACTIVE)) {
            if (!(link3 instanceof Sender)) continue;
            this.pumpOut(link3.getTarget().getAddress(), (Sender)link3);
        }
        for (Session session : new Sessions(connection, ACTIVE, CLOSED)) {
            session.close();
        }
        for (Link link3 : new Links(connection, ANY, CLOSED)) {
            if (link3.getLocalState() == EndpointState.ACTIVE) {
                link3.close();
                continue;
            }
            this.reclaimLink(link3);
        }
        if (connection.getRemoteState() == EndpointState.CLOSED && connection.getLocalState() == EndpointState.ACTIVE) {
            connection.close();
        }
    }

    private boolean waitUntil(Predicate condition) throws TimeoutException {
        if (this._blocking) {
            boolean done = this.waitUntil(condition, this._timeout);
            if (!done) {
                this._logger.log(Level.SEVERE, String.format("Timeout when waiting for condition %s after %s ms", condition, this._timeout));
                throw new TimeoutException();
            }
            return done;
        }
        return this.waitUntil(condition, 0L);
    }

    private boolean waitUntil(Predicate condition, long timeout) {
        if (this._driver == null) {
            throw new IllegalStateException("cannot wait while messenger is stopped");
        }
        this.processAllConnectors();
        long now = System.currentTimeMillis();
        long deadline = timeout < 0L ? Long.MAX_VALUE : now + timeout;
        boolean done = false;
        while (!(done = condition.test())) {
            long remaining;
            if (timeout < 0L) {
                remaining = -1L;
            } else {
                remaining = deadline - now;
                if (remaining < 0L) break;
            }
            this.distributeCredit();
            if (this._next_drain != 0L) {
                long wakeup = this._next_drain > now ? this._next_drain - now : 0L;
                remaining = remaining == -1L ? wakeup : Math.min(remaining, wakeup);
            }
            boolean woken = this._driver.doWait(remaining);
            this.processActive();
            if (woken) {
                throw new InterruptException();
            }
            now = System.currentTimeMillis();
        }
        return done;
    }

    private Connection lookup(Address address) {
        for (Connector c : this._driver.connectors()) {
            Connection connection = c.getConnection();
            ConnectionContext ctx = (ConnectionContext)connection.getContext();
            if (!ctx.matches(address)) continue;
            return connection;
        }
        return null;
    }

    private void reclaimCredit(Connection connection) {
        for (Link link2 : new Links(connection, ANY, ANY)) {
            this.reclaimLink(link2);
        }
    }

    private void distributeCredit() {
        int used;
        int max;
        if (this._receivers == 0) {
            return;
        }
        if (this._credit_mode == LinkCreditMode.LINK_CREDIT_AUTO && (max = this._receivers * 1024) > (used = this._distributed + this.incoming())) {
            this._credit = max - used;
        }
        if (this._draining > 0) {
            Iterator<Receiver> itr = this._credited.iterator();
            while (itr.hasNext()) {
                Receiver link2 = itr.next();
                if (!link2.getDrain() || link2.draining()) continue;
                int drained = link2.drained();
                assert (this._distributed >= drained);
                this._distributed -= drained;
                this._credit += drained;
                link2.setDrain(false);
                --this._draining;
                itr.remove();
                this._blocked.add(link2);
            }
        }
        int batch = this.perLinkCredit();
        while (this._credit > 0 && !this._blocked.isEmpty()) {
            Receiver link3 = this._blocked.get(0);
            this._blocked.remove(0);
            int more = Math.min(this._credit, batch);
            this._distributed += more;
            this._credit -= more;
            link3.flow(more);
            this._credited.add(link3);
            ConnectionContext ctx = (ConnectionContext)link3.getSession().getConnection().getContext();
            try {
                ctx.getConnector().process();
            }
            catch (IOException e) {
                this._logger.log(Level.SEVERE, "Error processing connection", e);
            }
        }
        if (this._blocked.isEmpty()) {
            this._next_drain = 0L;
        } else if (this._draining == 0) {
            if (this._next_drain == 0L) {
                this._next_drain = System.currentTimeMillis() + 250L;
            } else if (this._next_drain <= System.currentTimeMillis()) {
                this._next_drain = 0L;
                int needed = this._blocked.size() * batch;
                for (Receiver link4 : this._credited) {
                    if (link4.getDrain()) continue;
                    link4.setDrain(true);
                    needed -= link4.getRemoteCredit();
                    ++this._draining;
                    ConnectionContext ctx = (ConnectionContext)link4.getSession().getConnection().getContext();
                    try {
                        ctx.getConnector().process();
                    }
                    catch (IOException e) {
                        this._logger.log(Level.SEVERE, "Error processing connection", e);
                    }
                    if (needed > 0) continue;
                    break;
                }
            }
        }
    }

    private <C extends Link> C getLink(Address address, LinkFinder<C> finder) {
        Connection connection = this.lookup(address);
        if (connection == null) {
            String host = address.getHost();
            int port = Integer.valueOf(address.getImpliedPort());
            Connector<Object> connector = this._driver.createConnector(host, port, null);
            this._logger.log(Level.FINE, "Connecting to " + host + ":" + port);
            connection = Proton.connection();
            connection.setContainer(this._name);
            connection.setHostname(host);
            connection.setContext(new ConnectionContext(address, connector));
            connector.setConnection(connection);
            Sasl sasl = connector.sasl();
            if (sasl != null) {
                sasl.client();
                sasl.setMechanisms("ANONYMOUS");
            }
            if ("amqps".equalsIgnoreCase(address.getScheme())) {
                Transport transport = connector.getTransport();
                SslDomain domain = this.makeDomain(address, SslDomain.Mode.CLIENT);
                if (this._trustedDb != null) {
                    domain.setPeerAuthentication(SslDomain.VerifyMode.VERIFY_PEER);
                } else {
                    domain.setPeerAuthentication(SslDomain.VerifyMode.ANONYMOUS_PEER);
                }
                Ssl ssl = transport.ssl(domain);
            }
            connection.open();
        }
        for (Link link2 : new Links(connection, ACTIVE, ANY)) {
            C result = finder.test(link2);
            if (result == null) continue;
            return result;
        }
        Session session = connection.session();
        session.open();
        C link3 = finder.create(session);
        this.linkAdded((Link)link3);
        link3.open();
        return link3;
    }

    private void adjustReplyTo(Message m) {
        String original = m.getReplyTo();
        if (original != null) {
            if (original.startsWith("~/")) {
                m.setReplyTo("amqp://" + this._name + "/" + original.substring(2));
            } else if (original.equals("~")) {
                m.setReplyTo("amqp://" + this._name);
            }
        }
    }

    private static boolean matchTarget(Target target, String path) {
        if (target == null) {
            return path.isEmpty();
        }
        return path.equals(target.getAddress());
    }

    private static boolean matchSource(Source source, String path) {
        if (source == null) {
            return path.isEmpty();
        }
        return path.equals(source.getAddress());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MessengerImpl [_name=").append(this._name).append("]");
        return builder.toString();
    }

    private int perLinkCredit() {
        if (this._receivers == 0) {
            return 0;
        }
        int total = this._credit + this._distributed;
        return Math.max(total / this._receivers, 1);
    }

    private void linkAdded(Link link2) {
        if (link2 instanceof Receiver) {
            ++this._receivers;
            this._blocked.add((Receiver)link2);
            link2.setContext(Boolean.TRUE);
        }
    }

    private void linkRemoved(Link _link) {
        if (_link instanceof Receiver && ((Boolean)_link.getContext()).booleanValue()) {
            _link.setContext(Boolean.FALSE);
            Receiver link2 = (Receiver)_link;
            assert (this._receivers > 0);
            --this._receivers;
            if (link2.getDrain()) {
                link2.setDrain(false);
                assert (this._draining > 0);
                --this._draining;
            }
            if (this._blocked.contains(link2)) {
                this._blocked.remove(link2);
            } else if (this._credited.contains(link2)) {
                this._credited.remove(link2);
            } else assert (false);
        }
    }

    private SslDomain makeDomain(Address address, SslDomain.Mode mode) {
        SslDomain domain = Proton.sslDomain();
        domain.init(mode);
        if (this._certificate != null) {
            domain.setCredentials(this._certificate, this._privateKey, this._password);
        }
        if (this._trustedDb != null) {
            domain.setTrustedCaDb(this._trustedDb);
        }
        if ("amqps".equalsIgnoreCase(address.getScheme())) {
            domain.allowUnsecuredClient(false);
        } else {
            domain.allowUnsecuredClient(true);
        }
        return domain;
    }

    private class ListenerContext {
        private Address _address;
        private SslDomain _domain;

        public ListenerContext(Address address) {
            this._address = address;
            this._domain = MessengerImpl.this.makeDomain(address, SslDomain.Mode.SERVER);
        }

        public SslDomain getDomain() {
            return this._domain;
        }

        public Address getAddress() {
            return this._address;
        }
    }

    private class ConnectionContext {
        private Address _address;
        private Connector _connector;

        public ConnectionContext(Address address, Connector connector) {
            this._address = address;
            this._connector = connector;
        }

        public Address getAddress() {
            return this._address;
        }

        public boolean matches(Address address) {
            String host = address.getHost();
            String port = address.getImpliedPort();
            Connection conn = this._connector.getConnection();
            return host.equals(conn.getRemoteContainer()) || this._address.getHost().equals(host) && this._address.getImpliedPort().equals(port);
        }

        public Connector getConnector() {
            return this._connector;
        }
    }

    private static class SessionIterator
    implements Iterator<Session> {
        private final EnumSet<EndpointState> _local;
        private final EnumSet<EndpointState> _remote;
        private Session _next;

        SessionIterator(Connection connection, EnumSet<EndpointState> local, EnumSet<EndpointState> remote) {
            this._local = local;
            this._remote = remote;
            this._next = connection.sessionHead(this._local, this._remote);
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Session next() {
            try {
                Session session = this._next;
                return session;
            }
            finally {
                this._next = this._next.next(this._local, this._remote);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Sessions
    implements Iterable<Session> {
        private final Connection _connection;
        private final EnumSet<EndpointState> _local;
        private final EnumSet<EndpointState> _remote;

        Sessions(Connection connection, EnumSet<EndpointState> local, EnumSet<EndpointState> remote) {
            this._connection = connection;
            this._local = local;
            this._remote = remote;
        }

        @Override
        public Iterator<Session> iterator() {
            return new SessionIterator(this._connection, this._local, this._remote);
        }
    }

    private static class LinkIterator
    implements Iterator<Link> {
        private final EnumSet<EndpointState> _local;
        private final EnumSet<EndpointState> _remote;
        private Link _next;

        LinkIterator(Connection connection, EnumSet<EndpointState> local, EnumSet<EndpointState> remote) {
            this._local = local;
            this._remote = remote;
            this._next = connection.linkHead(this._local, this._remote);
        }

        @Override
        public boolean hasNext() {
            return this._next != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Link next() {
            try {
                Link link2 = this._next;
                return link2;
            }
            finally {
                this._next = this._next.next(this._local, this._remote);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Links
    implements Iterable<Link> {
        private final Connection _connection;
        private final EnumSet<EndpointState> _local;
        private final EnumSet<EndpointState> _remote;

        Links(Connection connection, EnumSet<EndpointState> local, EnumSet<EndpointState> remote) {
            this._connection = connection;
            this._local = local;
            this._remote = remote;
        }

        @Override
        public Iterator<Link> iterator() {
            return new LinkIterator(this._connection, this._local, this._remote);
        }
    }

    private class ReceiverFinder
    implements LinkFinder<Receiver> {
        private final String _path;

        ReceiverFinder(String path) {
            this._path = path == null ? "" : path;
        }

        @Override
        public Receiver test(Link link2) {
            if (link2 instanceof Receiver && MessengerImpl.matchSource((Source)link2.getSource(), this._path)) {
                return (Receiver)link2;
            }
            return null;
        }

        @Override
        public Receiver create(Session session) {
            Receiver receiver = session.receiver(this._path);
            Source source = new Source();
            source.setAddress(this._path);
            receiver.setSource(source);
            Target target = new Target();
            target.setAddress(this._path);
            receiver.setTarget(target);
            if (MessengerImpl.this.getIncomingWindow() > 0) {
                receiver.setSenderSettleMode(SenderSettleMode.UNSETTLED);
                receiver.setReceiverSettleMode(ReceiverSettleMode.SECOND);
            }
            return receiver;
        }
    }

    private class SenderFinder
    implements LinkFinder<Sender> {
        private final String _path;

        SenderFinder(String path) {
            this._path = path == null ? "" : path;
        }

        @Override
        public Sender test(Link link2) {
            if (link2 instanceof Sender && MessengerImpl.matchTarget((Target)link2.getTarget(), this._path)) {
                return (Sender)link2;
            }
            return null;
        }

        @Override
        public Sender create(Session session) {
            Sender sender = session.sender(this._path);
            Target target = new Target();
            target.setAddress(this._path);
            sender.setTarget(target);
            Source source = new Source();
            source.setAddress(this._path);
            sender.setSource(source);
            if (MessengerImpl.this.getOutgoingWindow() > 0) {
                sender.setSenderSettleMode(SenderSettleMode.UNSETTLED);
                sender.setReceiverSettleMode(ReceiverSettleMode.SECOND);
            }
            return sender;
        }
    }

    private static interface LinkFinder<C extends Link> {
        public C test(Link var1);

        public C create(Session var1);
    }

    private class WorkPred
    implements Predicate {
        private WorkPred() {
        }

        @Override
        public boolean test() {
            return MessengerImpl.this._worked;
        }
    }

    private class AllClosed
    implements Predicate {
        private AllClosed() {
        }

        @Override
        public boolean test() {
            if (MessengerImpl.this._driver == null) {
                return true;
            }
            for (Connector c : MessengerImpl.this._driver.connectors()) {
                if (c.isClosed()) continue;
                return false;
            }
            MessengerImpl.this._driver.destroy();
            MessengerImpl.this._driver = null;
            return true;
        }
    }

    private class MessageAvailable
    implements Predicate {
        private MessageAvailable() {
        }

        @Override
        public boolean test() {
            if (MessengerImpl.this._incomingStore.size() > 0) {
                return true;
            }
            for (Connector c : MessengerImpl.this._driver.connectors()) {
                Connection connection = c.getConnection();
                for (Delivery delivery = connection.getWorkHead(); delivery != null; delivery = delivery.getWorkNext()) {
                    if (!delivery.isReadable() || delivery.isPartial()) continue;
                    return true;
                }
            }
            return !MessengerImpl.this._driver.listeners().iterator().hasNext() && !MessengerImpl.this._driver.connectors().iterator().hasNext();
        }
    }

    private class SentSettled
    implements Predicate {
        private SentSettled() {
        }

        @Override
        public boolean test() {
            int total = MessengerImpl.this._outgoingStore.size();
            for (Connector c : MessengerImpl.this._driver.connectors()) {
                Connection connection = c.getConnection();
                for (Link link2 : new Links(connection, ACTIVE, ANY)) {
                    if (!(link2 instanceof Sender)) continue;
                    total += link2.getQueued();
                }
                Iterator<StoreEntry> entries = MessengerImpl.this._outgoingStore.trackedEntries();
                while (entries.hasNext() && total <= MessengerImpl.this._sendThreshold) {
                    Delivery d;
                    StoreEntry e = entries.next();
                    if (e == null || (d = e.getDelivery()) == null || d.getRemoteState() != null || d.remotelySettled()) continue;
                    ++total;
                }
            }
            return total <= MessengerImpl.this._sendThreshold;
        }
    }

    private static interface Predicate {
        public boolean test();
    }

    private static enum LinkCreditMode {
        LINK_CREDIT_EXPLICIT,
        LINK_CREDIT_AUTO;

    }
}

