/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import org.ops4j.pax.cdi.api.BundleScoped;
import org.ops4j.pax.cdi.api.OsgiService;
import org.ops4j.pax.cdi.api.OsgiServiceProvider;
import org.ops4j.pax.cdi.api.PrototypeScoped;
import org.ops4j.pax.cdi.api.SingletonScoped;
import org.ops4j.pax.cdi.extension.impl.BeanBundleImpl;
import org.ops4j.pax.cdi.extension.impl.BundleContextProducer;
import org.ops4j.pax.cdi.extension.impl.BundleEventBridge;
import org.ops4j.pax.cdi.extension.impl.ServiceEventBridge;
import org.ops4j.pax.cdi.extension.impl.client.OsgiInjectionTarget;
import org.ops4j.pax.cdi.extension.impl.client.OsgiServiceBean;
import org.ops4j.pax.cdi.extension.impl.component.ComponentLifecycleManager;
import org.ops4j.pax.cdi.extension.impl.component.ComponentRegistry;
import org.ops4j.pax.cdi.extension.impl.context.BundleScopeContext;
import org.ops4j.pax.cdi.extension.impl.context.PrototypeScopeContext;
import org.ops4j.pax.cdi.extension.impl.context.SingletonScopeContext;
import org.ops4j.pax.cdi.extension.impl.context.SingletonScopedLiteral;
import org.ops4j.pax.cdi.extension.impl.util.AnnotatedTypeWrapper;
import org.ops4j.pax.cdi.extension.impl.util.InjectionPointOsgiUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class OsgiExtension
implements Extension {
    private static Logger log = LoggerFactory.getLogger(OsgiExtension.class);
    private Map<Type, Set<InjectionPoint>> typeToIpMap = new HashMap<Type, Set<InjectionPoint>>();
    private ComponentRegistry componentRegistry = new ComponentRegistry(0);
    private SingletonScopeContext serviceContext;

    public OsgiExtension() {
        log.debug("constructing OsgiExtension");
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager manager) {
        log.debug("beforeBeanDiscovery");
        event.addAnnotatedType(manager.createAnnotatedType(BeanBundleImpl.class));
        event.addAnnotatedType(manager.createAnnotatedType(BundleEventBridge.class));
        event.addAnnotatedType(manager.createAnnotatedType(ServiceEventBridge.class));
        event.addAnnotatedType(manager.createAnnotatedType(BundleContextProducer.class));
        event.addAnnotatedType(manager.createAnnotatedType(ComponentLifecycleManager.class));
        event.addScope(SingletonScoped.class, false, false);
    }

    public <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> event) {
        AnnotatedType type = event.getAnnotatedType();
        if (type.getAnnotation(OsgiServiceProvider.class) == null) {
            return;
        }
        if (type.getAnnotation(PrototypeScoped.class) != null) {
            return;
        }
        if (type.getAnnotation(BundleScoped.class) != null) {
            return;
        }
        if (type.getAnnotation(SingletonScoped.class) != null) {
            return;
        }
        AnnotatedTypeWrapper wrappedType = new AnnotatedTypeWrapper(type, new Annotation[]{new SingletonScopedLiteral()});
        event.setAnnotatedType(wrappedType);
    }

    public <T> void processInjectionTarget(@Observes ProcessInjectionTarget<T> event) {
        log.debug("processInjectionTarget {}", (Object)event.getAnnotatedType().getBaseType());
        boolean overrideRequired = false;
        for (InjectionPoint ip : event.getInjectionTarget().getInjectionPoints()) {
            boolean instanceIp = this.processInjectionPoint(ip);
            overrideRequired |= instanceIp;
        }
        if (overrideRequired) {
            event.setInjectionTarget(new OsgiInjectionTarget(event.getInjectionTarget()));
        }
    }

    private boolean processInjectionPoint(InjectionPoint ip) {
        Type instanceType;
        OsgiService qualifier = (OsgiService)ip.getAnnotated().getAnnotation(OsgiService.class);
        if (qualifier != null) {
            log.debug("service injection point {} with qualifier {}", (Object)ip, (Object)qualifier);
            this.storeServiceInjectionPoint(ip);
        }
        return (instanceType = InjectionPointOsgiUtils.getInstanceType(ip)) != null;
    }

    private void storeServiceInjectionPoint(InjectionPoint injectionPoint) {
        Type key = injectionPoint.getType();
        if (!this.typeToIpMap.containsKey(key)) {
            this.typeToIpMap.put(key, new CopyOnWriteArraySet());
        }
        this.typeToIpMap.get(key).add(injectionPoint);
    }

    public <T> void processBean(@Observes ProcessBean<T> event) {
        Bean bean = event.getBean();
        log.debug("processBean {}", (Object)bean);
        OsgiServiceProvider qualifier = (OsgiServiceProvider)event.getAnnotated().getAnnotation(OsgiServiceProvider.class);
        if (qualifier != null) {
            this.componentRegistry.addComponent(bean);
            for (InjectionPoint ip : bean.getInjectionPoints()) {
                OsgiService annotation = (OsgiService)ip.getAnnotated().getAnnotation(OsgiService.class);
                if (annotation == null) continue;
                this.componentRegistry.addDependency(bean, ip);
            }
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        log.debug("afterBeanDiscovery");
        this.serviceContext = new SingletonScopeContext(beanManager);
        event.addContext((Context)this.serviceContext);
        BundleScopeContext bundleScopeContext = new BundleScopeContext(beanManager);
        event.addContext((Context)bundleScopeContext);
        PrototypeScopeContext prototypeScopeContext = new PrototypeScopeContext(beanManager);
        event.addContext((Context)prototypeScopeContext);
        for (Type type : this.typeToIpMap.keySet()) {
            if (this.isInstance(type)) continue;
            if (type instanceof Class) {
                this.addBean(event, type, this.typeToIpMap.get(type));
                continue;
            }
            InjectionPoint ip = this.typeToIpMap.get(type).iterator().next();
            String msg = "The type of an @OSGi service injection point must not be parameterized. Injection point = " + ip;
            event.addDefinitionError((Throwable)new UnsupportedOperationException(msg));
        }
    }

    private void addBean(AfterBeanDiscovery event, Type type, Set<InjectionPoint> injectionPoints) {
        ArrayList<OsgiService> registeredBeans = new ArrayList<OsgiService>();
        for (InjectionPoint ip : injectionPoints) {
            OsgiService qualifier = (OsgiService)ip.getAnnotated().getAnnotation(OsgiService.class);
            if (registeredBeans.contains(qualifier)) continue;
            log.debug("adding an OSGi service bean {} for {}", (Object)type, (Object)ip);
            event.addBean(new OsgiServiceBean(ip));
            registeredBeans.add(qualifier);
            if (qualifier.dynamic() || this.componentRegistry.isComponent(ip.getBean())) continue;
            this.componentRegistry.addNonComponentDependency(ip);
        }
    }

    private boolean isInstance(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            return Instance.class.isAssignableFrom(rawType);
        }
        return false;
    }

    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    public SingletonScopeContext getServiceContext() {
        return this.serviceContext;
    }
}

