/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https_jetty;

import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.transport.http_jetty.JettyConnectorFactory;
import org.apache.cxf.transport.https_jetty.CXFJettySslSocketConnector;
import org.eclipse.jetty.server.AbstractConnector;

public final class JettySslConnectorFactory
implements JettyConnectorFactory {
    TLSServerParameters tlsServerParameters;
    int maxIdleTime;

    public JettySslConnectorFactory(TLSServerParameters params) {
        this.tlsServerParameters = params;
    }

    public JettySslConnectorFactory(TLSServerParameters params, int maxIdle) {
        this(params);
        this.maxIdleTime = maxIdle;
    }

    @Override
    public AbstractConnector createConnector(int port) {
        return this.createConnector(null, port);
    }

    @Override
    public AbstractConnector createConnector(String host, int port) {
        assert (this.tlsServerParameters != null);
        CXFJettySslSocketConnector secureConnector = new CXFJettySslSocketConnector();
        if (host != null) {
            secureConnector.setHost(host);
        }
        secureConnector.setPort(port);
        if (this.maxIdleTime > 0) {
            secureConnector.setMaxIdleTime(this.maxIdleTime);
        }
        this.decorateCXFJettySslSocketConnector(secureConnector);
        return secureConnector;
    }

    private void decorateCXFJettySslSocketConnector(CXFJettySslSocketConnector con) {
        con.setKeyManagers(this.tlsServerParameters.getKeyManagers());
        con.setTrustManagers(this.tlsServerParameters.getTrustManagers());
        con.setSecureRandom(this.tlsServerParameters.getSecureRandom());
        con.setClientAuthentication(this.tlsServerParameters.getClientAuthentication());
        con.getCxfSslContextFactory().setProtocol(this.tlsServerParameters.getSecureSocketProtocol());
        con.getCxfSslContextFactory().setProvider(this.tlsServerParameters.getJsseProvider());
        con.setCipherSuites(this.tlsServerParameters.getCipherSuites());
        con.setCipherSuitesFilter(this.tlsServerParameters.getCipherSuitesFilter());
        con.setExcludeProtocols(this.tlsServerParameters.getExcludeProtocols());
        con.setIncludeProtocols(this.tlsServerParameters.getIncludeProtocols());
        con.getCxfSslContextFactory().setCertAlias(this.tlsServerParameters.getCertAlias());
    }
}

