/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.camel.commands.AbstractContextCommand;
import org.apache.camel.commands.CamelController;
import org.apache.camel.util.JsonSchemaHelper;

public class EipExplainCommand
extends AbstractContextCommand {
    private String nameOrId;
    private boolean verbose;

    public EipExplainCommand(String name, String nameOrId, boolean verbose) {
        super(name);
        this.verbose = verbose;
        this.nameOrId = nameOrId;
    }

    @Override
    protected Object performContextCommand(CamelController camelController, String contextName, PrintStream out, PrintStream err) throws Exception {
        String json = camelController.explainEipAsJSon(this.context, this.nameOrId, this.verbose);
        if (json == null) {
            return null;
        }
        out.println("Context:       " + this.context);
        List options = JsonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
        Collections.sort(options, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                String kind1 = o1.get("kind");
                String kind2 = o2.get("kind");
                int answer = 0;
                if (kind1 != null && kind2 != null) {
                    answer = -1 * kind1.compareTo(kind2);
                }
                if (answer == 0) {
                    answer = o1.get("name").compareTo(o2.get("name"));
                }
                return answer;
            }
        });
        for (Map option : options) {
            String description;
            String defaultValue;
            String value;
            String deprecated;
            String javaType;
            String type;
            out.print("Option:        ");
            out.println((String)option.get("name"));
            String kind = (String)option.get("kind");
            if (kind != null) {
                out.print("Kind:          ");
                out.println(kind);
            }
            if ((type = (String)option.get("type")) != null) {
                out.print("Type:          ");
                out.println(type);
            }
            if ((javaType = (String)option.get("javaType")) != null) {
                out.print("Java Type:     ");
                out.println(javaType);
            }
            if ((deprecated = (String)option.get("deprecated")) != null) {
                out.print("Deprecated:    ");
                out.println(deprecated);
            }
            if ((value = (String)option.get("value")) != null) {
                out.print("Value:         ");
                out.println(value);
            }
            if ((defaultValue = (String)option.get("defaultValue")) != null) {
                out.print("Default Value: ");
                out.println(defaultValue);
            }
            if ((description = (String)option.get("description")) != null) {
                out.print("Description:   ");
                out.println(description);
            }
            out.println();
        }
        if (options.isEmpty()) {
            out.println();
        }
        return null;
    }
}

