/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.ext.Attachment;
import org.apache.wss4j.common.ext.AttachmentRequestCallback;
import org.apache.wss4j.common.ext.AttachmentResultCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.SOAP11Constants;
import org.apache.wss4j.dom.SOAP12Constants;
import org.apache.wss4j.dom.SOAPConstants;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.CallbackLookup;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class WSSecurityUtil {
    private static final Logger LOG = LoggerFactory.getLogger(WSSecurityUtil.class);
    private static MessageDigest digest;

    private WSSecurityUtil() {
    }

    public static Element getSOAPHeader(Document doc) {
        String soapNamespace = WSSecurityUtil.getSOAPNamespace(doc.getDocumentElement());
        return XMLUtils.getDirectChildElement((Node)doc.getDocumentElement(), (String)"Header", (String)soapNamespace);
    }

    public static Element getSecurityHeader(Document doc, String actor) throws WSSecurityException {
        Element soapHeaderElement = WSSecurityUtil.getSOAPHeader(doc);
        if (soapHeaderElement == null) {
            return null;
        }
        String soapNamespace = WSSecurityUtil.getSOAPNamespace(doc.getDocumentElement());
        return WSSecurityUtil.getSecurityHeader(soapHeaderElement, actor, "http://www.w3.org/2003/05/soap-envelope".equals(soapNamespace));
    }

    public static Element getSecurityHeader(Element soapHeader, String actor, boolean soap12) throws WSSecurityException {
        String actorLocal = "actor";
        String soapNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
        if (soap12) {
            actorLocal = "role";
            soapNamespace = "http://www.w3.org/2003/05/soap-envelope";
        }
        Element foundSecurityHeader = null;
        for (Node currentChild = soapHeader.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            String hActor;
            if (1 != currentChild.getNodeType() || !"Security".equals(currentChild.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(currentChild.getNamespaceURI())) continue;
            Element elem = (Element)currentChild;
            Attr attr = elem.getAttributeNodeNS(soapNamespace, actorLocal);
            String string = hActor = attr != null ? attr.getValue() : null;
            if (!WSSecurityUtil.isActorEqual(actor, hActor)) continue;
            if (foundSecurityHeader != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Two or more security headers have the same actor name: " + actor);
                }
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY);
            }
            foundSecurityHeader = elem;
        }
        return foundSecurityHeader;
    }

    public static boolean isActorEqual(String actor, String hActor) {
        if (!(hActor != null && hActor.length() != 0 || actor != null && actor.length() != 0)) {
            return true;
        }
        return hActor != null && actor != null && hActor.equalsIgnoreCase(actor);
    }

    public static Element getDirectChildElement(Node parentNode, String localName, String namespace) {
        if (parentNode == null) {
            return null;
        }
        for (Node currentChild = parentNode.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (1 != currentChild.getNodeType() || !localName.equals(currentChild.getLocalName()) || !namespace.equals(currentChild.getNamespaceURI())) continue;
            return (Element)currentChild;
        }
        return null;
    }

    public static List<Element> getDirectChildElements(Node fNode, String localName, String namespace) {
        ArrayList<Element> children = new ArrayList<Element>();
        for (Node currentChild = fNode.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (1 != currentChild.getNodeType() || !localName.equals(currentChild.getLocalName()) || !namespace.equals(currentChild.getNamespaceURI())) continue;
            children.add((Element)currentChild);
        }
        return children;
    }

    public static Element findBodyElement(Document doc) {
        Element docElement = doc.getDocumentElement();
        String ns = docElement.getNamespaceURI();
        return WSSecurityUtil.getDirectChildElement(docElement, "Body", ns);
    }

    public static List<Element> findElements(WSEncryptionPart part, CallbackLookup callbackLookup, Document doc) throws WSSecurityException {
        if (part.getElement() != null) {
            return Collections.singletonList(part.getElement());
        }
        String id = part.getId();
        if (id != null) {
            Element foundElement = callbackLookup.getElement(id, null, false);
            return Collections.singletonList(foundElement);
        }
        return callbackLookup.getElements(part.getName(), part.getNamespace());
    }

    public static Element findElement(Node startNode, String name, String namespace) {
        if (startNode == null) {
            return null;
        }
        Node startParent = startNode.getParentNode();
        Node processedNode = null;
        while (startNode != null) {
            if (startNode.getNodeType() == 1 && startNode.getLocalName().equals(name)) {
                String ns = startNode.getNamespaceURI();
                if (ns != null && ns.equals(namespace)) {
                    return (Element)startNode;
                }
                if (!(namespace != null && namespace.length() != 0 || ns != null && ns.length() != 0)) {
                    return (Element)startNode;
                }
            }
            processedNode = startNode;
            if ((startNode = startNode.getFirstChild()) == null) {
                startNode = processedNode.getNextSibling();
            }
            while (startNode == null) {
                if ((processedNode = processedNode.getParentNode()) == startParent) {
                    return null;
                }
                startNode = processedNode.getNextSibling();
            }
        }
        return null;
    }

    public static List<Element> findElements(Node startNode, String name, String namespace) {
        if (startNode == null) {
            return null;
        }
        Node startParent = startNode.getParentNode();
        Node processedNode = null;
        ArrayList<Element> foundNodes = new ArrayList<Element>();
        while (startNode != null) {
            if (startNode.getNodeType() == 1 && startNode.getLocalName().equals(name)) {
                String ns = startNode.getNamespaceURI();
                if (ns != null && ns.equals(namespace)) {
                    foundNodes.add((Element)startNode);
                }
                if (!(namespace != null && namespace.length() != 0 || ns != null && ns.length() != 0)) {
                    foundNodes.add((Element)startNode);
                }
            }
            processedNode = startNode;
            if ((startNode = startNode.getFirstChild()) == null) {
                startNode = processedNode.getNextSibling();
            }
            while (startNode == null) {
                if ((processedNode = processedNode.getParentNode()) == startParent) {
                    return foundNodes;
                }
                startNode = processedNode.getNextSibling();
            }
        }
        return foundNodes;
    }

    public static Element findSAMLAssertionElementById(Node startNode, String value) {
        Element foundElement = null;
        if (startNode == null) {
            return null;
        }
        Node startParent = startNode.getParentNode();
        Node processedNode = null;
        while (startNode != null) {
            Element se;
            if (startNode.getNodeType() == 1 && ((se = (Element)startNode).hasAttributeNS(null, "ID") && value.equals(se.getAttributeNS(null, "ID")) || se.hasAttributeNS(null, "AssertionID") && value.equals(se.getAttributeNS(null, "AssertionID")))) {
                if (foundElement == null) {
                    foundElement = se;
                } else {
                    LOG.warn("Multiple elements with the same 'ID' attribute value!");
                    return null;
                }
            }
            processedNode = startNode;
            if ((startNode = startNode.getFirstChild()) == null) {
                startNode = processedNode.getNextSibling();
            }
            while (startNode == null) {
                if ((processedNode = processedNode.getParentNode()) == startParent) {
                    return foundElement;
                }
                startNode = processedNode.getNextSibling();
            }
        }
        return foundElement;
    }

    public static Element findElementById(Node startNode, String value, boolean checkMultipleElements) {
        Node startParent = startNode.getParentNode();
        Node processedNode = null;
        Element foundElement = null;
        String id = WSSecurityUtil.getIDFromReference(value);
        while (startNode != null) {
            if (startNode.getNodeType() == 1) {
                Element se = (Element)startNode;
                String attributeNS = se.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                if ("".equals(attributeNS) || !id.equals(attributeNS)) {
                    attributeNS = se.getAttributeNS(null, "Id");
                }
                if (!"".equals(attributeNS) && id.equals(attributeNS)) {
                    if (!checkMultipleElements) {
                        return se;
                    }
                    if (foundElement == null) {
                        foundElement = se;
                    } else {
                        LOG.warn("Multiple elements with the same 'Id' attribute value!");
                        return null;
                    }
                }
            }
            processedNode = startNode;
            if ((startNode = startNode.getFirstChild()) == null) {
                startNode = processedNode.getNextSibling();
            }
            while (startNode == null) {
                if ((processedNode = processedNode.getParentNode()) == startParent) {
                    return foundElement;
                }
                startNode = processedNode.getNextSibling();
            }
        }
        return foundElement;
    }

    public static String setNamespace(Element element, String namespace, String prefix) {
        String pre = WSSecurityUtil.getPrefixNS(namespace, element);
        if (pre != null) {
            return pre;
        }
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespace);
        return prefix;
    }

    public static String getPrefixNS(String uri, Node e) {
        while (e != null && e.getNodeType() == 1) {
            NamedNodeMap attrs = e.getAttributes();
            for (int n = 0; n < attrs.getLength(); ++n) {
                Attr a = (Attr)attrs.item(n);
                String name = a.getName();
                if (!name.startsWith("xmlns:") || !a.getNodeValue().equals(uri)) continue;
                return name.substring("xmlns:".length());
            }
            e = e.getParentNode();
        }
        return null;
    }

    public static String getNamespace(String prefix, Node e) {
        while (e != null && e.getNodeType() == 1) {
            Attr attr = null;
            attr = prefix == null ? ((Element)e).getAttributeNodeNS(null, "xmlns") : ((Element)e).getAttributeNodeNS("http://www.w3.org/2000/xmlns/", prefix);
            if (attr != null) {
                return attr.getValue();
            }
            e = e.getParentNode();
        }
        return null;
    }

    public static QName getQNameFromString(String str, Node e) {
        return WSSecurityUtil.getQNameFromString(str, e, false);
    }

    public static QName getFullQNameFromString(String str, Node e) {
        return WSSecurityUtil.getQNameFromString(str, e, true);
    }

    private static QName getQNameFromString(String str, Node e, boolean defaultNS) {
        String ns;
        if (str == null || e == null) {
            return null;
        }
        int idx = str.indexOf(58);
        if (idx > -1) {
            String prefix = str.substring(0, idx);
            String ns2 = XMLUtils.getNamespace((String)prefix, (Node)e);
            if (ns2 == null) {
                return null;
            }
            return new QName(ns2, str.substring(idx + 1));
        }
        if (defaultNS && (ns = XMLUtils.getNamespace(null, (Node)e)) != null) {
            return new QName(ns, str);
        }
        return new QName("", str);
    }

    public static String getStringForQName(QName qname, Element e) {
        String uri = qname.getNamespaceURI();
        String prefix = WSSecurityUtil.getPrefixNS(uri, e);
        if (prefix == null) {
            int i = 1;
            prefix = "ns" + i;
            while (XMLUtils.getNamespace((String)prefix, (Node)e) != null) {
                prefix = "ns" + ++i;
            }
            e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
        }
        return prefix + ":" + qname.getLocalPart();
    }

    public static String getIDFromReference(String ref) {
        if (ref == null) {
            return null;
        }
        String id = ref.trim();
        if (id.length() == 0) {
            return null;
        }
        if (id.charAt(0) == '#') {
            id = id.substring(1);
        }
        return id;
    }

    private static Element createElementInSameNamespace(Element parent, String localName) {
        String qName = localName;
        String prefix = parent.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            qName = prefix + ":" + localName;
        }
        String nsUri = parent.getNamespaceURI();
        return parent.getOwnerDocument().createElementNS(nsUri, qName);
    }

    public static Element prependChildElement(Element parent, Element child) {
        Node firstChild = parent.getFirstChild();
        if (firstChild == null) {
            return (Element)parent.appendChild(child);
        }
        return (Element)parent.insertBefore(child, firstChild);
    }

    public static Element findWsseSecurityHeaderBlock(Document doc, Element envelope, boolean doCreate) throws WSSecurityException {
        return WSSecurityUtil.findWsseSecurityHeaderBlock(doc, envelope, null, doCreate);
    }

    public static Element findWsseSecurityHeaderBlock(Document doc, Element envelope, String actor, boolean doCreate) throws WSSecurityException {
        String soapNamespace = WSSecurityUtil.getSOAPNamespace(doc.getDocumentElement());
        Element header = WSSecurityUtil.getDirectChildElement(doc.getDocumentElement(), "Header", soapNamespace);
        if (header == null) {
            if (doCreate) {
                header = WSSecurityUtil.createElementInSameNamespace(envelope, "Header");
                header = WSSecurityUtil.prependChildElement(envelope, header);
            } else {
                return null;
            }
        }
        String actorLocal = "actor";
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapNamespace)) {
            actorLocal = "role";
        }
        Element foundSecurityHeader = null;
        for (Node currentChild = header.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            String hActor;
            if (1 != currentChild.getNodeType() || !"Security".equals(currentChild.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(currentChild.getNamespaceURI())) continue;
            Element elem = (Element)currentChild;
            Attr attr = elem.getAttributeNodeNS(soapNamespace, actorLocal);
            String string = hActor = attr != null ? attr.getValue() : null;
            if (!WSSecurityUtil.isActorEqual(actor, hActor)) continue;
            if (foundSecurityHeader != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Two or more security headers have the same actor name: " + actor);
                }
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY);
            }
            foundSecurityHeader = elem;
        }
        if (foundSecurityHeader != null) {
            return foundSecurityHeader;
        }
        if (doCreate) {
            foundSecurityHeader = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
            foundSecurityHeader.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            return WSSecurityUtil.prependChildElement(header, foundSecurityHeader);
        }
        return null;
    }

    public static Text createBase64EncodedTextNode(Document doc, byte[] data) {
        return doc.createTextNode(Base64.encode((byte[])data));
    }

    public static SOAPConstants getSOAPConstants(Element startElement) {
        Document doc = startElement.getOwnerDocument();
        String ns = doc.getDocumentElement().getNamespaceURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(ns)) {
            return new SOAP12Constants();
        }
        return new SOAP11Constants();
    }

    public static String getSOAPNamespace(Element startElement) {
        return WSSecurityUtil.getSOAPConstants(startElement).getEnvelopeURI();
    }

    public static Cipher getCipherInstance(String cipherAlgo) throws WSSecurityException {
        try {
            String keyAlgorithm = JCEMapper.translateURItoJCEID((String)cipherAlgo);
            String provider = JCEMapper.getProviderId();
            if (provider == null) {
                return Cipher.getInstance(keyAlgorithm);
            }
            return Cipher.getInstance(keyAlgorithm, provider);
        }
        catch (NoSuchPaddingException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)ex, "unsupportedKeyTransp", new Object[]{"No such padding: " + cipherAlgo});
        }
        catch (NoSuchAlgorithmException ex) {
            if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(cipherAlgo)) {
                try {
                    return Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
                }
                catch (Exception e) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, e, "unsupportedKeyTransp", new Object[]{"No such algorithm: " + cipherAlgo});
                }
            }
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)ex, "unsupportedKeyTransp", new Object[]{"No such algorithm: " + cipherAlgo});
        }
        catch (NoSuchProviderException ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, (Exception)ex, "unsupportedKeyTransp", new Object[]{"No such provider " + JCEMapper.getProviderId() + " for: " + cipherAlgo});
        }
    }

    public static WSSecurityEngineResult fetchActionResult(List<WSSecurityEngineResult> resultList, int action) {
        WSSecurityEngineResult returnResult = null;
        for (WSSecurityEngineResult result : resultList) {
            int resultAction = (Integer)result.get("action");
            if (resultAction != action) continue;
            returnResult = result;
        }
        return returnResult;
    }

    public static List<WSSecurityEngineResult> fetchAllActionResults(List<WSSecurityEngineResult> resultList, int action) {
        return WSSecurityUtil.fetchAllActionResults(resultList, Collections.singletonList(action));
    }

    public static List<WSSecurityEngineResult> fetchAllActionResults(List<WSSecurityEngineResult> resultList, List<Integer> actions) {
        List<WSSecurityEngineResult> actionResultList = Collections.emptyList();
        if (actions == null || actions.isEmpty()) {
            return actionResultList;
        }
        for (WSSecurityEngineResult result : resultList) {
            int resultAction = (Integer)result.get("action");
            if (!actions.contains(resultAction)) continue;
            if (actionResultList.isEmpty()) {
                actionResultList = new ArrayList<WSSecurityEngineResult>();
            }
            actionResultList.add(result);
        }
        return actionResultList;
    }

    public static List<Integer> decodeAction(String action) throws WSSecurityException {
        ArrayList<Integer> actions = new ArrayList<Integer>();
        String actionToParse = action;
        if (actionToParse == null) {
            return actions;
        }
        if ("".equals(actionToParse = actionToParse.trim())) {
            return actions;
        }
        String[] single = actionToParse.split("\\s");
        for (int i = 0; i < single.length; ++i) {
            if (single[i].equals("NoSecurity")) {
                return actions;
            }
            if (single[i].equals("UsernameToken")) {
                actions.add(1);
                continue;
            }
            if (single[i].equals("UsernameTokenNoPassword")) {
                actions.add(8192);
                continue;
            }
            if (single[i].equals("Signature")) {
                actions.add(2);
                continue;
            }
            if (single[i].equals("SignatureDerived")) {
                actions.add(32768);
                continue;
            }
            if (single[i].equals("Encrypt")) {
                actions.add(4);
                continue;
            }
            if (single[i].equals("EncryptDerived")) {
                actions.add(65536);
                continue;
            }
            if (single[i].equals("SAMLTokenUnsigned")) {
                actions.add(8);
                continue;
            }
            if (single[i].equals("SAMLTokenSigned")) {
                actions.add(16);
                continue;
            }
            if (single[i].equals("Timestamp")) {
                actions.add(32);
                continue;
            }
            if (single[i].equals("UsernameTokenSignature")) {
                actions.add(64);
                continue;
            }
            if (single[i].equals("enableSignatureConfirmation")) {
                actions.add(128);
                continue;
            }
            if (single[i].equals("CustomToken")) {
                actions.add(16384);
                continue;
            }
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", new Object[]{"Unknown action defined: " + single[i]});
        }
        return actions;
    }

    public static List<HandlerAction> decodeHandlerAction(String action, WSSConfig wssConfig) throws WSSecurityException {
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        if (action == null) {
            return actions;
        }
        String[] single = action.split(" ");
        for (int i = 0; i < single.length; ++i) {
            if (single[i].equals("NoSecurity")) {
                return actions;
            }
            if (single[i].equals("UsernameToken")) {
                actions.add(new HandlerAction(1));
                continue;
            }
            if (single[i].equals("Signature")) {
                actions.add(new HandlerAction(2));
                continue;
            }
            if (single[i].equals("SignatureDerived")) {
                actions.add(new HandlerAction(32768));
                continue;
            }
            if (single[i].equals("Encrypt")) {
                actions.add(new HandlerAction(4));
                continue;
            }
            if (single[i].equals("EncryptDerived")) {
                actions.add(new HandlerAction(65536));
                continue;
            }
            if (single[i].equals("SAMLTokenUnsigned")) {
                actions.add(new HandlerAction(8));
                continue;
            }
            if (single[i].equals("SAMLTokenSigned")) {
                actions.add(new HandlerAction(16));
                continue;
            }
            if (single[i].equals("Timestamp")) {
                actions.add(new HandlerAction(32));
                continue;
            }
            if (single[i].equals("UsernameTokenSignature")) {
                actions.add(new HandlerAction(64));
                continue;
            }
            if (single[i].equals("enableSignatureConfirmation")) {
                actions.add(new HandlerAction(128));
                continue;
            }
            try {
                int parsedAction = Integer.parseInt(single[i]);
                if (wssConfig.getAction(parsedAction) == null) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", new Object[]{"Unknown action defined: " + single[i]});
                }
                actions.add(new HandlerAction(parsedAction));
                continue;
            }
            catch (NumberFormatException ex) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", new Object[]{"Unknown action defined: " + single[i]});
            }
        }
        return actions;
    }

    public static byte[] generateNonce(int length) throws WSSecurityException {
        try {
            return XMLSecurityConstants.generateBytes((int)length);
        }
        catch (Exception ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex, "empty", new Object[]{"Error in generating nonce of length " + length});
        }
    }

    public static synchronized byte[] generateDigest(byte[] inputBytes) throws WSSecurityException {
        try {
            if (digest == null) {
                digest = MessageDigest.getInstance("SHA-1");
            }
            return digest.digest(inputBytes);
        }
        catch (Exception e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e, "empty", new Object[]{"Error in generating digest"});
        }
    }

    public static List<Node> listChildren(Node parent) {
        ArrayList<Node> ret = new ArrayList<Node>();
        if (parent != null) {
            for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
                ret.add(node);
            }
        }
        return ret;
    }

    public static List<Node> newNodes(List<Node> a, List<Node> b) {
        if (a.size() == 0) {
            return b;
        }
        ArrayList<Node> ret = new ArrayList<Node>();
        if (b.size() == 0) {
            return ret;
        }
        for (Node bnode : b) {
            String bns = bnode.getNamespaceURI();
            String bln = bnode.getLocalName();
            boolean found = false;
            Iterator<Node> apos = a.iterator();
            while (apos.hasNext() && !found) {
                boolean lnmatch;
                boolean nsmatch;
                Node anode = apos.next();
                String ans = anode.getNamespaceURI();
                String aln = anode.getLocalName();
                boolean bl = ans == null ? bns == null : (nsmatch = bns == null ? false : ans.equals(bns));
                boolean bl2 = aln == null ? bln == null : (lnmatch = bln == null ? false : aln.equals(bln));
                if (!nsmatch || !lnmatch) continue;
                found = true;
            }
            if (found) continue;
            ret.add(bnode);
        }
        return ret;
    }

    public static void storeElementInContext(DOMCryptoContext context, Element element) {
        if (element.hasAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id")) {
            context.setIdAttributeNS(element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        }
        if (element.hasAttributeNS(null, "Id")) {
            context.setIdAttributeNS(element, null, "Id");
        }
        if (element.hasAttributeNS(null, "ID")) {
            context.setIdAttributeNS(element, null, "ID");
        }
        if (element.hasAttributeNS(null, "AssertionID")) {
            context.setIdAttributeNS(element, null, "AssertionID");
        }
    }

    public static void verifySignedElement(Element elem, WSDocInfo wsDocInfo) throws WSSecurityException {
        WSSecurityUtil.verifySignedElement(elem, wsDocInfo.getResultsByTag(2));
    }

    public static void verifySignedElement(Element elem, List<WSSecurityEngineResult> signedResults) throws WSSecurityException {
        if (signedResults != null) {
            for (WSSecurityEngineResult signedResult : signedResults) {
                List dataRefs = (List)signedResult.get("data-ref-uris");
                if (dataRefs == null) continue;
                for (WSDataRef dataRef : dataRefs) {
                    if (!WSSecurityUtil.isElementOrAncestorSigned(elem, dataRef.getProtectedElement())) continue;
                    return;
                }
            }
        }
        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, "elementNotSigned", new Object[]{elem});
    }

    private static boolean isElementOrAncestorSigned(Element elem, Element signedElement) throws WSSecurityException {
        Element envelope = elem.getOwnerDocument().getDocumentElement();
        Node cur = elem;
        while (!cur.isSameNode(envelope)) {
            if (cur.getNodeType() == 1 && cur.equals(signedElement)) {
                return true;
            }
            cur = cur.getParentNode();
        }
        return false;
    }

    public static byte[] getBytesFromAttachment(String xopUri, RequestData data) throws WSSecurityException {
        CallbackHandler attachmentCallbackHandler = data.getAttachmentCallbackHandler();
        if (attachmentCallbackHandler == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK);
        }
        String attachmentId = xopUri.substring("cid:".length());
        AttachmentRequestCallback attachmentRequestCallback = new AttachmentRequestCallback();
        attachmentRequestCallback.setAttachmentId(attachmentId);
        try {
            attachmentCallbackHandler.handle(new Callback[]{attachmentRequestCallback});
            List attachments = attachmentRequestCallback.getAttachments();
            if (attachments == null || attachments.isEmpty() || !attachmentId.equals(((Attachment)attachments.get(0)).getId())) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, "empty", new Object[]{"Attachment not found: " + xopUri});
            }
            Attachment attachment = (Attachment)attachments.get(0);
            InputStream inputStream = attachment.getSourceStream();
            return JavaUtils.getBytesFromStream((InputStream)inputStream);
        }
        catch (UnsupportedCallbackException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)e);
        }
        catch (IOException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_CHECK, (Exception)e);
        }
    }

    public static void storeBytesInAttachment(Element parentElement, Document doc, String attachmentId, byte[] bytes, CallbackHandler attachmentCallbackHandler) throws WSSecurityException {
        parentElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xop", "http://www.w3.org/2004/08/xop/include");
        Element xopInclude = doc.createElementNS("http://www.w3.org/2004/08/xop/include", "xop:Include");
        xopInclude.setAttributeNS(null, "href", "cid:" + attachmentId);
        parentElement.appendChild(xopInclude);
        Attachment resultAttachment = new Attachment();
        resultAttachment.setId(attachmentId);
        resultAttachment.setMimeType("application/ciphervalue");
        resultAttachment.setSourceStream((InputStream)new ByteArrayInputStream(bytes));
        AttachmentResultCallback attachmentResultCallback = new AttachmentResultCallback();
        attachmentResultCallback.setAttachmentId(attachmentId);
        attachmentResultCallback.setAttachment(resultAttachment);
        try {
            attachmentCallbackHandler.handle(new Callback[]{attachmentResultCallback});
        }
        catch (Exception e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e);
        }
    }
}

