/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.metatype;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.felix.metatype.AD;
import org.apache.felix.metatype.Attribute;
import org.apache.felix.metatype.Designate;
import org.apache.felix.metatype.DesignateObject;
import org.apache.felix.metatype.MetaData;
import org.apache.felix.metatype.OCD;
import org.apache.felix.metatype.OptionalAttributes;
import org.apache.felix.metatype.internal.Activator;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class MetaDataReader {
    static final String NAMESPACE_1_0 = "http://www.osgi.org/xmlns/metatype/v1.0.0";
    static final String NAMESPACE_1_1 = "http://www.osgi.org/xmlns/metatype/v1.1.0";
    static final String NAMESPACE_1_2 = "http://www.osgi.org/xmlns/metatype/v1.2.0";
    static final String NAMESPACE_1_3 = "http://www.osgi.org/xmlns/metatype/v1.3.0";
    private KXmlParser parser = new KXmlParser();
    private String namespace = "http://www.osgi.org/xmlns/metatype/v1.0.0";
    private static final Set AD_ATTRIBUTES = new HashSet<String>(Arrays.asList("name", "description", "id", "type", "cardinality", "min", "max", "default", "required"));
    private static final Set ATTRIBUTE_ATTRIBUTES = new HashSet<String>(Arrays.asList("adref", "content"));
    private static final Set DESIGNATE_ATTRIBUTES = new HashSet<String>(Arrays.asList("pid", "factoryPid", "bundle", "optional", "merge"));
    private static final Set DESIGNATEOBJECT_ATTRIBUTES = new HashSet<String>(Arrays.asList("ocdref"));
    private static final Set METADATA_ATTRIBUTES = new HashSet<String>(Arrays.asList("localization"));
    private static final Set OCD_ATTRIBUTES = new HashSet<String>(Arrays.asList("name", "description", "id"));

    public MetaData parse(URL url) throws IOException {
        InputStream ins = null;
        try {
            ins = url.openStream();
            this.parser.setProperty("http://xmlpull.org/v1/doc/properties.html#location", url.toString());
            MetaData md = this.parse(ins);
            if (md != null) {
                md.setSource(url);
            }
            MetaData metaData = md;
            return metaData;
        }
        catch (XmlPullParserException e) {
            throw new IOException("XML parsing exception while reading metadata: " + e.getMessage());
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public MetaData parse(InputStream ins) throws IOException {
        MetaData mti = null;
        try {
            this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            this.parser.setInput(ins, null);
            int eventType = this.parser.getEventType();
            while (eventType != 1) {
                String tagName = this.parser.getName();
                if (eventType == 2) {
                    if ("MetaData".equals(tagName)) {
                        mti = this.readMetaData();
                    } else {
                        this.ignoreElement();
                    }
                }
                eventType = this.parser.next();
            }
        }
        catch (XmlPullParserException e) {
            throw new IOException("XML parsing exception while reading metadata: " + e.getMessage());
        }
        return mti;
    }

    private void checkMetatypeNamespace() throws IOException {
        String namespace = this.parser.getNamespace();
        if (namespace != null && !"".equals(namespace.trim())) {
            if (!(NAMESPACE_1_0.equals(namespace) || NAMESPACE_1_1.equals(namespace) || NAMESPACE_1_2.equals(namespace) || NAMESPACE_1_3.equals(namespace))) {
                throw new IOException("Unsupported Namespace: '" + namespace + "'");
            }
            this.namespace = namespace;
        }
    }

    private void readOptionalAttributes(OptionalAttributes entity, Set attributes) {
        int count = this.parser.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String name = this.parser.getAttributeName(i);
            if (attributes.contains(name)) continue;
            String value = this.parser.getAttributeValue(i);
            entity.addOptionalAttribute(name, value);
        }
    }

    private MetaData readMetaData() throws IOException, XmlPullParserException {
        this.checkMetatypeNamespace();
        MetaData mti = this.createMetaData();
        mti.setNamespace(this.namespace);
        mti.setLocalePrefix(this.getOptionalAttribute("localization"));
        this.readOptionalAttributes(mti, METADATA_ATTRIBUTES);
        int eventType = this.parser.next();
        while (eventType != 1) {
            String tagName = this.parser.getName();
            if (eventType == 2) {
                if ("OCD".equals(tagName)) {
                    mti.addObjectClassDefinition(this.readOCD());
                } else if ("Designate".equals(tagName)) {
                    mti.addDesignate(this.readDesignate());
                } else {
                    this.ignoreElement();
                }
            } else if (eventType == 3) {
                if ("MetaData".equals(tagName)) break;
                throw this.unexpectedElement(tagName);
            }
            eventType = this.parser.next();
        }
        return mti;
    }

    private OCD readOCD() throws IOException, XmlPullParserException {
        OCD ocd = this.createOCD();
        ocd.setId(this.getRequiredAttribute("id"));
        ocd.setName(this.getRequiredAttribute("name"));
        ocd.setDescription(this.getOptionalAttribute("description"));
        this.readOptionalAttributes(ocd, OCD_ATTRIBUTES);
        int eventType = this.parser.next();
        while (eventType != 1) {
            String tagName = this.parser.getName();
            if (eventType == 2) {
                if ("AD".equals(tagName)) {
                    ocd.addAttributeDefinition(this.readAD());
                } else if ("Icon".equals(tagName)) {
                    String res = this.getRequiredAttribute("resource");
                    String sizeString = this.getRequiredAttribute("size");
                    try {
                        Integer size = Integer.decode(sizeString);
                        ocd.addIcon(size, res);
                    }
                    catch (NumberFormatException nfe) {
                        Activator.log(4, "readOCD: Icon size '" + sizeString + "' is not a valid number");
                    }
                } else {
                    this.ignoreElement();
                }
            } else if (eventType == 3) {
                if ("OCD".equals(tagName)) {
                    if (this.getNamespaceVersion() < 12 && ocd.getIcons() != null && ocd.getIcons().size() > 1) {
                        throw this.unexpectedElement("Icon");
                    }
                    if (this.getNamespaceVersion() >= 13 || ocd.getAttributeDefinitions() != null) break;
                    throw this.missingElement("AD");
                }
                if (!"Icon".equals(tagName)) {
                    throw this.unexpectedElement(tagName);
                }
            }
            eventType = this.parser.next();
        }
        return ocd;
    }

    private Designate readDesignate() throws IOException, XmlPullParserException {
        String pid = this.getOptionalAttribute("pid");
        String factoryPid = this.getOptionalAttribute("factoryPid");
        if (pid == null && factoryPid == null) {
            this.missingAttribute("pid or factoryPid");
        }
        Designate designate = this.createDesignate();
        designate.setPid(pid);
        designate.setFactoryPid(factoryPid);
        designate.setBundleLocation(this.getOptionalAttribute("bundle"));
        designate.setOptional(this.getOptionalAttribute("optional", false));
        designate.setMerge(this.getOptionalAttribute("merge", false));
        this.readOptionalAttributes(designate, DESIGNATE_ATTRIBUTES);
        int eventType = this.parser.next();
        while (eventType != 1) {
            String tagName = this.parser.getName();
            if (eventType == 2) {
                if ("Object".equals(tagName)) {
                    if (designate.getObject() != null) {
                        throw this.unexpectedElement(tagName);
                    }
                    designate.setObject(this.readObject());
                } else {
                    this.ignoreElement();
                }
            } else if (eventType == 3) {
                if ("Designate".equals(tagName)) {
                    if (designate.getObject() != null) break;
                    throw this.missingElement("Object");
                }
                throw this.unexpectedElement(tagName);
            }
            eventType = this.parser.next();
        }
        return designate;
    }

    private AD readAD() throws IOException, XmlPullParserException {
        AD ad = this.createAD();
        ad.setID(this.getRequiredAttribute("id"));
        ad.setName(this.getOptionalAttribute("name"));
        ad.setDescription(this.getOptionalAttribute("description"));
        ad.setType(this.getRequiredAttribute("type"));
        ad.setCardinality(this.getOptionalAttribute("cardinality", 0));
        ad.setMin(this.getOptionalAttribute("min"));
        ad.setMax(this.getOptionalAttribute("max"));
        ad.setRequired(this.getOptionalAttribute("required", true));
        String dfltValue = this.getOptionalAttribute("default");
        this.readOptionalAttributes(ad, AD_ATTRIBUTES);
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        int eventType = this.parser.next();
        while (eventType != 1) {
            String tagName = this.parser.getName();
            if (eventType == 2) {
                if ("Option".equals(tagName)) {
                    String value = this.getRequiredAttribute("value");
                    String label = this.getRequiredAttribute("label");
                    options.put(value, label);
                } else {
                    this.ignoreElement();
                }
            } else if (eventType == 3) {
                if ("AD".equals(tagName)) break;
                if (!"Option".equals(tagName)) {
                    throw this.unexpectedElement(tagName);
                }
            }
            eventType = this.parser.next();
        }
        ad.setOptions(options);
        if (dfltValue != null) {
            ad.setDefaultValue(dfltValue);
        }
        return ad;
    }

    private DesignateObject readObject() throws IOException, XmlPullParserException {
        DesignateObject oh = this.createDesignateObject();
        oh.setOcdRef(this.getRequiredAttribute("ocdref"));
        this.readOptionalAttributes(oh, DESIGNATEOBJECT_ATTRIBUTES);
        int eventType = this.parser.next();
        while (eventType != 1) {
            String tagName = this.parser.getName();
            if (eventType == 2) {
                if ("Attribute".equals(tagName)) {
                    oh.addAttribute(this.readAttribute());
                } else {
                    this.ignoreElement();
                }
            } else if (eventType == 3) {
                if ("Object".equals(tagName)) break;
                throw this.unexpectedElement(tagName);
            }
            eventType = this.parser.next();
        }
        return oh;
    }

    private Attribute readAttribute() throws IOException, XmlPullParserException {
        Attribute ah = this.createAttribute();
        ah.setAdRef(this.getRequiredAttribute("adref"));
        ah.addContent(this.getOptionalAttribute("content"), true);
        this.readOptionalAttributes(ah, ATTRIBUTE_ATTRIBUTES);
        int eventType = this.parser.next();
        while (eventType != 1) {
            String tagName = this.parser.getName();
            if (eventType == 2) {
                if ("Value".equals(tagName)) {
                    ah.addContent(this.parser.nextText(), false);
                    eventType = this.parser.getEventType();
                } else {
                    this.ignoreElement();
                }
            } else if (eventType == 3) {
                if ("Attribute".equals(tagName)) break;
                if (!"Value".equals(tagName)) {
                    throw this.unexpectedElement(tagName);
                }
            }
            eventType = this.parser.next();
        }
        return ah;
    }

    private String getRequiredAttribute(String attrName) throws XmlPullParserException {
        String attrVal = this.parser.getAttributeValue(null, attrName);
        if (attrVal != null) {
            return attrVal;
        }
        throw this.missingAttribute(attrName);
    }

    private String getOptionalAttribute(String attrName) {
        return this.getOptionalAttribute(attrName, null);
    }

    private String getOptionalAttribute(String attrName, String defaultValue) {
        String attrVal = this.parser.getAttributeValue(null, attrName);
        return attrVal != null ? attrVal : defaultValue;
    }

    private boolean getOptionalAttribute(String attrName, boolean defaultValue) {
        String attrVal = this.parser.getAttributeValue(null, attrName);
        return attrVal != null ? "true".equalsIgnoreCase(attrVal) : defaultValue;
    }

    private int getOptionalAttribute(String attrName, int defaultValue) {
        String attrVal = this.parser.getAttributeValue(null, attrName);
        if (attrVal != null && !"".equals(attrVal)) {
            try {
                return Integer.decode(attrVal);
            }
            catch (NumberFormatException nfe) {
                Activator.log(4, "getOptionalAttribute: Value '" + attrVal + "' of attribute " + attrName + " is not a valid number. Using default value " + defaultValue);
            }
        }
        return defaultValue;
    }

    private int getNamespaceVersion() {
        if (NAMESPACE_1_0.equals(this.namespace)) {
            return 10;
        }
        if (NAMESPACE_1_1.equals(this.namespace)) {
            return 11;
        }
        if (NAMESPACE_1_2.equals(this.namespace)) {
            return 12;
        }
        if (NAMESPACE_1_3.equals(this.namespace)) {
            return 13;
        }
        return Integer.MAX_VALUE;
    }

    private void ignoreElement() throws IOException, XmlPullParserException {
        String ignoredElement = this.parser.getName();
        int depth = 0;
        int eventType = this.parser.next();
        while (eventType != 1) {
            if (eventType == 2) {
                if (ignoredElement.equals(this.parser.getName())) {
                    ++depth;
                }
            } else if (eventType == 3 && ignoredElement.equals(this.parser.getName())) {
                if (depth <= 0) {
                    return;
                }
                --depth;
            }
            eventType = this.parser.next();
        }
    }

    private XmlPullParserException missingAttribute(String attrName) {
        String message = "Missing attribute " + attrName + " in element " + this.parser.getName();
        return new XmlPullParserException(message, this.parser, null);
    }

    private XmlPullParserException missingElement(String elementName) {
        String message = "Missing element " + elementName + " in element " + this.parser.getName();
        return new XmlPullParserException(message, this.parser, null);
    }

    private XmlPullParserException unexpectedElement(String elementName) {
        String message = "Unexpected element " + elementName;
        return new XmlPullParserException(message, this.parser, null);
    }

    protected MetaData createMetaData() {
        return new MetaData();
    }

    protected OCD createOCD() {
        return new OCD();
    }

    protected AD createAD() {
        return new AD();
    }

    protected DesignateObject createDesignateObject() {
        return new DesignateObject();
    }

    protected Attribute createAttribute() {
        return new Attribute();
    }

    protected Designate createDesignate() {
        return new Designate();
    }
}

