/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.unit.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Deque;
import java.util.Enumeration;
import java.util.LinkedList;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class TempBundleDelegatingClassLoader
extends ClassLoader {
    private static final boolean CONTEXT_TRACKING_ENABLED;
    private final Bundle bundle;
    private final ThreadLocal<Deque<Bundle>> currentLoadingBundle = new ThreadLocal<Deque<Bundle>>(){

        @Override
        protected Deque<Bundle> initialValue() {
            return new LinkedList<Bundle>();
        }
    };

    public TempBundleDelegatingClassLoader(Bundle b, ClassLoader parent) {
        super(parent);
        this.bundle = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        String classResName = className.replace('.', '/').concat(".class");
        Bundle currentContext = this.currentLoadingBundle.get().peek();
        InputStream is = currentContext == null ? this.getResourceAsStream(classResName) : this.getResourceInBundleAsStream(classResName, currentContext);
        if (is == null) {
            throw new ClassNotFoundException(className);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        try {
            try {
                int read = is.read(buff);
                while (read > 0) {
                    baos.write(buff, 0, read);
                    read = is.read(buff);
                }
            }
            finally {
                is.close();
            }
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(className, ioe);
        }
        buff = baos.toByteArray();
        if (CONTEXT_TRACKING_ENABLED) {
            this.updateContext(currentContext, className);
        }
        try {
            Class<?> clazz = this.defineClass(className, buff, 0, buff.length);
            return clazz;
        }
        finally {
            if (CONTEXT_TRACKING_ENABLED) {
                this.currentLoadingBundle.get().pop();
            }
        }
    }

    private void updateContext(Bundle currentContext, String className) {
        int idx;
        if (currentContext == null) {
            currentContext = this.bundle;
        }
        String packageName = (idx = className.lastIndexOf(46)) == -1 ? "" : className.substring(0, idx);
        Bundle contextToSet = currentContext;
        BundleWiring wiring = (BundleWiring)currentContext.adapt(BundleWiring.class);
        for (BundleWire wire : wiring.getRequiredWires("osgi.wiring.package")) {
            if (!wire.getCapability().getAttributes().get("osgi.wiring.package").equals(packageName)) continue;
            contextToSet = wire.getProviderWiring().getBundle();
            break;
        }
        this.currentLoadingBundle.get().push(contextToSet);
    }

    @Override
    protected URL findResource(String resName) {
        return this.findResourceInBundle(resName, this.bundle);
    }

    protected URL findResourceInBundle(final String resName, final Bundle inBundle) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return inBundle.getResource(resName);
            }
        });
    }

    private InputStream getResourceInBundleAsStream(String resName, Bundle inBundle) {
        URL url = this.findResourceInBundle(resName, inBundle);
        try {
            return url == null ? null : url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String resName) throws IOException {
        return this.findResourcesInBundle(resName, this.bundle);
    }

    protected Enumeration<URL> findResourcesInBundle(final String resName, final Bundle inBundle) throws IOException {
        Enumeration<URL> resources = null;
        try {
            resources = AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){

                @Override
                public Enumeration<URL> run() throws IOException {
                    return inBundle.getResources(resName);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception thrownException = pae.getException();
            if (thrownException instanceof IOException) {
                throw (IOException)thrownException;
            }
            throw new UndeclaredThrowableException(thrownException);
        }
        return resources;
    }

    static {
        boolean enabled = true;
        try {
            Class.forName("org.osgi.framework.wiring.BundleWiring");
        }
        catch (ClassNotFoundException cnfe) {
            enabled = false;
        }
        CONTEXT_TRACKING_ENABLED = enabled;
    }
}

