/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.11.0
// source: syncer.proto

package proto

import (
	context "context"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type SyncService_Status int32

const (
	SyncService_UNKNOWN SyncService_Status = 0
	SyncService_UP      SyncService_Status = 1
	SyncService_DOWN    SyncService_Status = 2
)

// Enum value maps for SyncService_Status.
var (
	SyncService_Status_name = map[int32]string{
		0: "UNKNOWN",
		1: "UP",
		2: "DOWN",
	}
	SyncService_Status_value = map[string]int32{
		"UNKNOWN": 0,
		"UP":      1,
		"DOWN":    2,
	}
)

func (x SyncService_Status) Enum() *SyncService_Status {
	p := new(SyncService_Status)
	*p = x
	return p
}

func (x SyncService_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SyncService_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_syncer_proto_enumTypes[0].Descriptor()
}

func (SyncService_Status) Type() protoreflect.EnumType {
	return &file_syncer_proto_enumTypes[0]
}

func (x SyncService_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SyncService_Status.Descriptor instead.
func (SyncService_Status) EnumDescriptor() ([]byte, []int) {
	return file_syncer_proto_rawDescGZIP(), []int{5, 0}
}

type SyncInstance_Status int32

const (
	SyncInstance_UNKNOWN      SyncInstance_Status = 0
	SyncInstance_UP           SyncInstance_Status = 1
	SyncInstance_DOWN         SyncInstance_Status = 2
	SyncInstance_STARTING     SyncInstance_Status = 3
	SyncInstance_OUTOFSERVICE SyncInstance_Status = 4
)

// Enum value maps for SyncInstance_Status.
var (
	SyncInstance_Status_name = map[int32]string{
		0: "UNKNOWN",
		1: "UP",
		2: "DOWN",
		3: "STARTING",
		4: "OUTOFSERVICE",
	}
	SyncInstance_Status_value = map[string]int32{
		"UNKNOWN":      0,
		"UP":           1,
		"DOWN":         2,
		"STARTING":     3,
		"OUTOFSERVICE": 4,
	}
)

func (x SyncInstance_Status) Enum() *SyncInstance_Status {
	p := new(SyncInstance_Status)
	*p = x
	return p
}

func (x SyncInstance_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SyncInstance_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_syncer_proto_enumTypes[1].Descriptor()
}

func (SyncInstance_Status) Type() protoreflect.EnumType {
	return &file_syncer_proto_enumTypes[1]
}

func (x SyncInstance_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SyncInstance_Status.Descriptor instead.
func (SyncInstance_Status) EnumDescriptor() ([]byte, []int) {
	return file_syncer_proto_rawDescGZIP(), []int{6, 0}
}

type HealthCheck_Modes int32

const (
	HealthCheck_UNKNOWN HealthCheck_Modes = 0
	HealthCheck_PUSH    HealthCheck_Modes = 1
	HealthCheck_PULL    HealthCheck_Modes = 2
)

// Enum value maps for HealthCheck_Modes.
var (
	HealthCheck_Modes_name = map[int32]string{
		0: "UNKNOWN",
		1: "PUSH",
		2: "PULL",
	}
	HealthCheck_Modes_value = map[string]int32{
		"UNKNOWN": 0,
		"PUSH":    1,
		"PULL":    2,
	}
)

func (x HealthCheck_Modes) Enum() *HealthCheck_Modes {
	p := new(HealthCheck_Modes)
	*p = x
	return p
}

func (x HealthCheck_Modes) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthCheck_Modes) Descriptor() protoreflect.EnumDescriptor {
	return file_syncer_proto_enumTypes[2].Descriptor()
}

func (HealthCheck_Modes) Type() protoreflect.EnumType {
	return &file_syncer_proto_enumTypes[2]
}

func (x HealthCheck_Modes) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthCheck_Modes.Descriptor instead.
func (HealthCheck_Modes) EnumDescriptor() ([]byte, []int) {
	return file_syncer_proto_rawDescGZIP(), []int{8, 0}
}

type PullRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ServiceName string `protobuf:"bytes,1,opt,name=serviceName,proto3" json:"serviceName,omitempty"`
	Options     string `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
	Time        string `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
	Addr        string `protobuf:"bytes,4,opt,name=addr,proto3" json:"addr,omitempty"`
}

func (x *PullRequest) Reset() {
	*x = PullRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_syncer_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PullRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PullRequest) ProtoMessage() {}

func (x *PullRequest) ProtoReflect() protoreflect.Message {
	mi := &file_syncer_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PullRequest.ProtoReflect.Descriptor instead.
func (*PullRequest) Descriptor() ([]byte, []int) {
	return file_syncer_proto_rawDescGZIP(), []int{0}
}

func (x *PullRequest) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *PullRequest) GetOptions() string {
	if x != nil {
		return x.Options
	}
	return ""
}

func (x *PullRequest) GetTime() string {
	if x != nil {
		return x.Time
	}
	return ""
}

func (x *PullRequest) GetAddr() string {
	if x != nil {
		return x.Addr
	}
	return ""
}

type IncrementPullRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Addr   string `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
	Length int64  `protobuf:"varint,2,opt,name=length,proto3" json:"length,omitempty"`
}

func (x *IncrementPullRequest) Reset() {
	*x = IncrementPullRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_syncer_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IncrementPullRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IncrementPullRequest) ProtoMessage() {}

func (x *IncrementPullRequest) ProtoReflect() protoreflect.Message {
	mi := &file_syncer_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IncrementPullRequest.ProtoReflect.Descriptor instead.
func (*IncrementPullRequest) Descriptor() ([]byte, []int) {
	return file_syncer_proto_rawDescGZIP(), []int{1}
}

func (x *IncrementPullRequest) GetAddr() string {
	if x != nil {
		return x.Addr
	}
	return ""
}

func (x *IncrementPullRequest) GetLength() int64 {
	if x != nil {
		return x.Length
	}
	return 0
}

type DeclareRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Addr string `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
}

func (x *DeclareRequest) Reset() {
	*x = DeclareRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_syncer_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeclareRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeclareRequest) ProtoMessage() {}

func (x *DeclareRequest) ProtoReflect() protoreflect.Message {
	mi := &file_syncer_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeclareRequest.ProtoReflect.Descriptor instead.
func (*DeclareRequest) Descriptor() ([]byte, []int) {
	return file_syncer_proto_rawDescGZIP(), []int{2}
}

func (x *DeclareRequest) GetAddr() string {
	if x != nil {
		return x.Addr
	}
	return ""
}

type DeclareResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SyncDataLength int64 `protobuf:"varint,1,opt,name=syncDataLength,proto3" json:"syncDataLength,omitempty"`
}

func (x *DeclareResponse) Reset() {
	*x = DeclareResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_syncer_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeclareResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeclareResponse) ProtoMessage() {}

func (x *DeclareResponse) ProtoReflect() protoreflect.Message {
	mi := &file_syncer_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeclareResponse.ProtoReflect.Descriptor instead.
func (*DeclareResponse) Descriptor() ([]byte, []int) {
	return file_syncer_proto_rawDescGZIP(), []int{3}
}

func (x *DeclareResponse) GetSyncDataLength() int64 {
	if x != nil {
		return x.SyncDataLength
	}
	return 0
}

type SyncData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Services  []*SyncService  `protobuf:"bytes,1,rep,name=services,proto3" json:"services,omitempty"`
	Instances []*SyncInstance `protobuf:"bytes,2,rep,name=instances,proto3" json:"instances,omitempty"`
}

func (x *SyncData) Reset() {
	*x = SyncData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_syncer_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SyncData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncData) ProtoMessage() {}

func (x *SyncData) ProtoReflect() protoreflect.Message {
	mi := &file_syncer_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncData.ProtoReflect.Descriptor instead.
func (*SyncData) Descriptor() ([]byte, []int) {
	return file_syncer_proto_rawDescGZIP(), []int{4}
}

func (x *SyncData) GetServices() []*SyncService {
	if x != nil {
		return x.Services
	}
	return nil
}

func (x *SyncData) GetInstances() []*SyncInstance {
	if x != nil {
		return x.Instances
	}
	return nil
}

type SyncService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ServiceId     string             `protobuf:"bytes,1,opt,name=serviceId,proto3" json:"serviceId,omitempty"`
	App           string             `protobuf:"bytes,2,opt,name=app,proto3" json:"app,omitempty"`
	Name          string             `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Version       string             `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	Status        SyncService_Status `protobuf:"varint,5,opt,name=status,proto3,enum=proto.SyncService_Status" json:"status,omitempty"`
	DomainProject string             `protobuf:"bytes,6,opt,name=domainProject,proto3" json:"domainProject,omitempty"`
	Environment   string             `protobuf:"bytes,7,opt,name=environment,proto3" json:"environment,omitempty"`
	PluginName    string             `protobuf:"bytes,8,opt,name=pluginName,proto3" json:"pluginName,omitempty"`
	Expansions    []*Expansion       `protobuf:"bytes,9,rep,name=expansions,proto3" json:"expansions,omitempty"`
}

func (x *SyncService) Reset() {
	*x = SyncService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_syncer_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SyncService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncService) ProtoMessage() {}

func (x *SyncService) ProtoReflect() protoreflect.Message {
	mi := &file_syncer_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncService.ProtoReflect.Descriptor instead.
func (*SyncService) Descriptor() ([]byte, []int) {
	return file_syncer_proto_rawDescGZIP(), []int{5}
}

func (x *SyncService) GetServiceId() string {
	if x != nil {
		return x.ServiceId
	}
	return ""
}

func (x *SyncService) GetApp() string {
	if x != nil {
		return x.App
	}
	return ""
}

func (x *SyncService) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SyncService) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *SyncService) GetStatus() SyncService_Status {
	if x != nil {
		return x.Status
	}
	return SyncService_UNKNOWN
}

func (x *SyncService) GetDomainProject() string {
	if x != nil {
		return x.DomainProject
	}
	return ""
}

func (x *SyncService) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

func (x *SyncService) GetPluginName() string {
	if x != nil {
		return x.PluginName
	}
	return ""
}

func (x *SyncService) GetExpansions() []*Expansion {
	if x != nil {
		return x.Expansions
	}
	return nil
}

type SyncInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	InstanceId  string              `protobuf:"bytes,1,opt,name=instanceId,proto3" json:"instanceId,omitempty"`
	ServiceId   string              `protobuf:"bytes,2,opt,name=serviceId,proto3" json:"serviceId,omitempty"`
	Endpoints   []string            `protobuf:"bytes,3,rep,name=endpoints,proto3" json:"endpoints,omitempty"`
	HostName    string              `protobuf:"bytes,4,opt,name=hostName,proto3" json:"hostName,omitempty"`
	Status      SyncInstance_Status `protobuf:"varint,5,opt,name=status,proto3,enum=proto.SyncInstance_Status" json:"status,omitempty"`
	HealthCheck *HealthCheck        `protobuf:"bytes,6,opt,name=healthCheck,proto3" json:"healthCheck,omitempty"`
	Version     string              `protobuf:"bytes,7,opt,name=version,proto3" json:"version,omitempty"`
	PluginName  string              `protobuf:"bytes,8,opt,name=pluginName,proto3" json:"pluginName,omitempty"`
	Expansions  []*Expansion        `protobuf:"bytes,9,rep,name=expansions,proto3" json:"expansions,omitempty"`
}

func (x *SyncInstance) Reset() {
	*x = SyncInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_syncer_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SyncInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SyncInstance) ProtoMessage() {}

func (x *SyncInstance) ProtoReflect() protoreflect.Message {
	mi := &file_syncer_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SyncInstance.ProtoReflect.Descriptor instead.
func (*SyncInstance) Descriptor() ([]byte, []int) {
	return file_syncer_proto_rawDescGZIP(), []int{6}
}

func (x *SyncInstance) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *SyncInstance) GetServiceId() string {
	if x != nil {
		return x.ServiceId
	}
	return ""
}

func (x *SyncInstance) GetEndpoints() []string {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

func (x *SyncInstance) GetHostName() string {
	if x != nil {
		return x.HostName
	}
	return ""
}

func (x *SyncInstance) GetStatus() SyncInstance_Status {
	if x != nil {
		return x.Status
	}
	return SyncInstance_UNKNOWN
}

func (x *SyncInstance) GetHealthCheck() *HealthCheck {
	if x != nil {
		return x.HealthCheck
	}
	return nil
}

func (x *SyncInstance) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *SyncInstance) GetPluginName() string {
	if x != nil {
		return x.PluginName
	}
	return ""
}

func (x *SyncInstance) GetExpansions() []*Expansion {
	if x != nil {
		return x.Expansions
	}
	return nil
}

type Expansion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Kind   string            `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	Bytes  []byte            `protobuf:"bytes,2,opt,name=bytes,proto3" json:"bytes,omitempty"`
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Expansion) Reset() {
	*x = Expansion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_syncer_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Expansion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expansion) ProtoMessage() {}

func (x *Expansion) ProtoReflect() protoreflect.Message {
	mi := &file_syncer_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expansion.ProtoReflect.Descriptor instead.
func (*Expansion) Descriptor() ([]byte, []int) {
	return file_syncer_proto_rawDescGZIP(), []int{7}
}

func (x *Expansion) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *Expansion) GetBytes() []byte {
	if x != nil {
		return x.Bytes
	}
	return nil
}

func (x *Expansion) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type HealthCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Mode     HealthCheck_Modes `protobuf:"varint,1,opt,name=mode,proto3,enum=proto.HealthCheck_Modes" json:"mode,omitempty"`
	Port     int32             `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	Interval int32             `protobuf:"varint,3,opt,name=interval,proto3" json:"interval,omitempty"`
	Times    int32             `protobuf:"varint,4,opt,name=times,proto3" json:"times,omitempty"`
	Url      string            `protobuf:"bytes,5,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *HealthCheck) Reset() {
	*x = HealthCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_syncer_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheck) ProtoMessage() {}

func (x *HealthCheck) ProtoReflect() protoreflect.Message {
	mi := &file_syncer_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheck.ProtoReflect.Descriptor instead.
func (*HealthCheck) Descriptor() ([]byte, []int) {
	return file_syncer_proto_rawDescGZIP(), []int{8}
}

func (x *HealthCheck) GetMode() HealthCheck_Modes {
	if x != nil {
		return x.Mode
	}
	return HealthCheck_UNKNOWN
}

func (x *HealthCheck) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *HealthCheck) GetInterval() int32 {
	if x != nil {
		return x.Interval
	}
	return 0
}

func (x *HealthCheck) GetTimes() int32 {
	if x != nil {
		return x.Times
	}
	return 0
}

func (x *HealthCheck) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

type MappingEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ClusterName string `protobuf:"bytes,1,opt,name=clusterName,proto3" json:"clusterName,omitempty"`
	//    Tenant tenant = 2;
	DomainProject string `protobuf:"bytes,2,opt,name=domainProject,proto3" json:"domainProject,omitempty"`
	OrgServiceID  string `protobuf:"bytes,3,opt,name=orgServiceID,proto3" json:"orgServiceID,omitempty"`
	OrgInstanceID string `protobuf:"bytes,4,opt,name=orgInstanceID,proto3" json:"orgInstanceID,omitempty"`
	CurServiceID  string `protobuf:"bytes,5,opt,name=curServiceID,proto3" json:"curServiceID,omitempty"`
	CurInstanceID string `protobuf:"bytes,6,opt,name=curInstanceID,proto3" json:"curInstanceID,omitempty"`
}

func (x *MappingEntry) Reset() {
	*x = MappingEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_syncer_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MappingEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MappingEntry) ProtoMessage() {}

func (x *MappingEntry) ProtoReflect() protoreflect.Message {
	mi := &file_syncer_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MappingEntry.ProtoReflect.Descriptor instead.
func (*MappingEntry) Descriptor() ([]byte, []int) {
	return file_syncer_proto_rawDescGZIP(), []int{9}
}

func (x *MappingEntry) GetClusterName() string {
	if x != nil {
		return x.ClusterName
	}
	return ""
}

func (x *MappingEntry) GetDomainProject() string {
	if x != nil {
		return x.DomainProject
	}
	return ""
}

func (x *MappingEntry) GetOrgServiceID() string {
	if x != nil {
		return x.OrgServiceID
	}
	return ""
}

func (x *MappingEntry) GetOrgInstanceID() string {
	if x != nil {
		return x.OrgInstanceID
	}
	return ""
}

func (x *MappingEntry) GetCurServiceID() string {
	if x != nil {
		return x.CurServiceID
	}
	return ""
}

func (x *MappingEntry) GetCurInstanceID() string {
	if x != nil {
		return x.CurInstanceID
	}
	return ""
}

var File_syncer_proto protoreflect.FileDescriptor

var file_syncer_proto_rawDesc = []byte{
	0x0a, 0x0c, 0x73, 0x79, 0x6e, 0x63, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x05,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x71, 0x0a, 0x0b, 0x50, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x12, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x74, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x61, 0x64, 0x64, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x61, 0x64, 0x64, 0x72, 0x22, 0x42, 0x0a, 0x14, 0x49, 0x6e, 0x63, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x61, 0x64, 0x64, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x22, 0x24, 0x0a, 0x0e,
	0x44, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x61, 0x64,
	0x64, 0x72, 0x22, 0x39, 0x0a, 0x0f, 0x44, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x26, 0x0a, 0x0e, 0x73, 0x79, 0x6e, 0x63, 0x44, 0x61, 0x74,
	0x61, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x73,
	0x79, 0x6e, 0x63, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x22, 0x6d, 0x0a,
	0x08, 0x53, 0x79, 0x6e, 0x63, 0x44, 0x61, 0x74, 0x61, 0x12, 0x2e, 0x0a, 0x08, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52,
	0x08, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x09, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x79, 0x6e, 0x63, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x22, 0xe1, 0x02, 0x0a,
	0x0b, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x1c, 0x0a, 0x09,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x61, 0x70,
	0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x61, 0x70, 0x70, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x53, 0x79, 0x6e, 0x63, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x24, 0x0a,
	0x0d, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4e,
	0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x65, 0x78, 0x70,
	0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x27, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x06,
	0x0a, 0x02, 0x55, 0x50, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x4f, 0x57, 0x4e, 0x10, 0x02,
	0x22, 0xa5, 0x03, 0x0a, 0x0c, 0x53, 0x79, 0x6e, 0x63, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49,
	0x64, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x12,
	0x1c, 0x0a, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x1a, 0x0a,
	0x08, 0x68, 0x6f, 0x73, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x68, 0x6f, 0x73, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x53, 0x79, 0x6e, 0x63, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x34, 0x0a,
	0x0b, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74,
	0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x0b, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a,
	0x0a, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a,
	0x0a, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x10, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0x47, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x55, 0x50, 0x10, 0x01, 0x12, 0x08,
	0x0a, 0x04, 0x44, 0x4f, 0x57, 0x4e, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x52,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x10, 0x0a, 0x0c, 0x4f, 0x55, 0x54, 0x4f, 0x46, 0x53,
	0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x04, 0x22, 0xa6, 0x01, 0x0a, 0x09, 0x45, 0x78, 0x70,
	0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x34, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x45, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xbd, 0x01, 0x0a, 0x0b, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63,
	0x6b, 0x12, 0x2c, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x18, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68,
	0x65, 0x63, 0x6b, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x70,
	0x6f, 0x72, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12,
	0x14, 0x0a, 0x05, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x22, 0x28, 0x0a, 0x05, 0x4d, 0x6f, 0x64, 0x65, 0x73,
	0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x50, 0x55, 0x53, 0x48, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x55, 0x4c, 0x4c, 0x10,
	0x02, 0x22, 0xea, 0x01, 0x0a, 0x0c, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x20, 0x0a, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0d, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x22, 0x0a, 0x0c, 0x6f, 0x72,
	0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x44, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x6f, 0x72, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x44, 0x12, 0x24,
	0x0a, 0x0d, 0x6f, 0x72, 0x67, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x44, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6f, 0x72, 0x67, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x49, 0x44, 0x12, 0x22, 0x0a, 0x0c, 0x63, 0x75, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x49, 0x44, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x44, 0x12, 0x24, 0x0a, 0x0d, 0x63, 0x75, 0x72, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x44, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x63, 0x75, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x44, 0x32, 0xbc,
	0x01, 0x0a, 0x04, 0x53, 0x79, 0x6e, 0x63, 0x12, 0x2d, 0x0a, 0x04, 0x50, 0x75, 0x6c, 0x6c, 0x12,
	0x12, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x50, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x0f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x79, 0x6e, 0x63,
	0x44, 0x61, 0x74, 0x61, 0x22, 0x00, 0x12, 0x44, 0x0a, 0x11, 0x44, 0x65, 0x63, 0x6c, 0x61, 0x72,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x15, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x44, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x44, 0x65, 0x63, 0x6c, 0x61,
	0x72, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x3f, 0x0a, 0x0d,
	0x49, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x75, 0x6c, 0x6c, 0x12, 0x1b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50,
	0x75, 0x6c, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x0f, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x53, 0x79, 0x6e, 0x63, 0x44, 0x61, 0x74, 0x61, 0x22, 0x00, 0x42, 0x09, 0x5a,
	0x07, 0x2e, 0x3b, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_syncer_proto_rawDescOnce sync.Once
	file_syncer_proto_rawDescData = file_syncer_proto_rawDesc
)

func file_syncer_proto_rawDescGZIP() []byte {
	file_syncer_proto_rawDescOnce.Do(func() {
		file_syncer_proto_rawDescData = protoimpl.X.CompressGZIP(file_syncer_proto_rawDescData)
	})
	return file_syncer_proto_rawDescData
}

var file_syncer_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_syncer_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_syncer_proto_goTypes = []interface{}{
	(SyncService_Status)(0),      // 0: proto.SyncService.Status
	(SyncInstance_Status)(0),     // 1: proto.SyncInstance.Status
	(HealthCheck_Modes)(0),       // 2: proto.HealthCheck.Modes
	(*PullRequest)(nil),          // 3: proto.PullRequest
	(*IncrementPullRequest)(nil), // 4: proto.IncrementPullRequest
	(*DeclareRequest)(nil),       // 5: proto.DeclareRequest
	(*DeclareResponse)(nil),      // 6: proto.DeclareResponse
	(*SyncData)(nil),             // 7: proto.SyncData
	(*SyncService)(nil),          // 8: proto.SyncService
	(*SyncInstance)(nil),         // 9: proto.SyncInstance
	(*Expansion)(nil),            // 10: proto.Expansion
	(*HealthCheck)(nil),          // 11: proto.HealthCheck
	(*MappingEntry)(nil),         // 12: proto.MappingEntry
	nil,                          // 13: proto.Expansion.LabelsEntry
}
var file_syncer_proto_depIdxs = []int32{
	8,  // 0: proto.SyncData.services:type_name -> proto.SyncService
	9,  // 1: proto.SyncData.instances:type_name -> proto.SyncInstance
	0,  // 2: proto.SyncService.status:type_name -> proto.SyncService.Status
	10, // 3: proto.SyncService.expansions:type_name -> proto.Expansion
	1,  // 4: proto.SyncInstance.status:type_name -> proto.SyncInstance.Status
	11, // 5: proto.SyncInstance.healthCheck:type_name -> proto.HealthCheck
	10, // 6: proto.SyncInstance.expansions:type_name -> proto.Expansion
	13, // 7: proto.Expansion.labels:type_name -> proto.Expansion.LabelsEntry
	2,  // 8: proto.HealthCheck.mode:type_name -> proto.HealthCheck.Modes
	3,  // 9: proto.Sync.Pull:input_type -> proto.PullRequest
	5,  // 10: proto.Sync.DeclareDataLength:input_type -> proto.DeclareRequest
	4,  // 11: proto.Sync.IncrementPull:input_type -> proto.IncrementPullRequest
	7,  // 12: proto.Sync.Pull:output_type -> proto.SyncData
	6,  // 13: proto.Sync.DeclareDataLength:output_type -> proto.DeclareResponse
	7,  // 14: proto.Sync.IncrementPull:output_type -> proto.SyncData
	12, // [12:15] is the sub-list for method output_type
	9,  // [9:12] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_syncer_proto_init() }
func file_syncer_proto_init() {
	if File_syncer_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_syncer_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PullRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_syncer_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IncrementPullRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_syncer_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeclareRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_syncer_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeclareResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_syncer_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SyncData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_syncer_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SyncService); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_syncer_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SyncInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_syncer_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Expansion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_syncer_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HealthCheck); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_syncer_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MappingEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_syncer_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_syncer_proto_goTypes,
		DependencyIndexes: file_syncer_proto_depIdxs,
		EnumInfos:         file_syncer_proto_enumTypes,
		MessageInfos:      file_syncer_proto_msgTypes,
	}.Build()
	File_syncer_proto = out.File
	file_syncer_proto_rawDesc = nil
	file_syncer_proto_goTypes = nil
	file_syncer_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SyncClient is the client API for Sync service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SyncClient interface {
	Pull(ctx context.Context, in *PullRequest, opts ...grpc.CallOption) (*SyncData, error)
	DeclareDataLength(ctx context.Context, in *DeclareRequest, opts ...grpc.CallOption) (*DeclareResponse, error)
	IncrementPull(ctx context.Context, in *IncrementPullRequest, opts ...grpc.CallOption) (*SyncData, error)
}

type syncClient struct {
	cc *grpc.ClientConn
}

func NewSyncClient(cc *grpc.ClientConn) SyncClient {
	return &syncClient{cc}
}

func (c *syncClient) Pull(ctx context.Context, in *PullRequest, opts ...grpc.CallOption) (*SyncData, error) {
	out := new(SyncData)
	err := c.cc.Invoke(ctx, "/proto.Sync/Pull", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *syncClient) DeclareDataLength(ctx context.Context, in *DeclareRequest, opts ...grpc.CallOption) (*DeclareResponse, error) {
	out := new(DeclareResponse)
	err := c.cc.Invoke(ctx, "/proto.Sync/DeclareDataLength", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *syncClient) IncrementPull(ctx context.Context, in *IncrementPullRequest, opts ...grpc.CallOption) (*SyncData, error) {
	out := new(SyncData)
	err := c.cc.Invoke(ctx, "/proto.Sync/IncrementPull", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SyncServer is the server API for Sync service.
type SyncServer interface {
	Pull(context.Context, *PullRequest) (*SyncData, error)
	DeclareDataLength(context.Context, *DeclareRequest) (*DeclareResponse, error)
	IncrementPull(context.Context, *IncrementPullRequest) (*SyncData, error)
}

// UnimplementedSyncServer can be embedded to have forward compatible implementations.
type UnimplementedSyncServer struct {
}

func (*UnimplementedSyncServer) Pull(context.Context, *PullRequest) (*SyncData, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Pull not implemented")
}
func (*UnimplementedSyncServer) DeclareDataLength(context.Context, *DeclareRequest) (*DeclareResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeclareDataLength not implemented")
}
func (*UnimplementedSyncServer) IncrementPull(context.Context, *IncrementPullRequest) (*SyncData, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IncrementPull not implemented")
}

func RegisterSyncServer(s *grpc.Server, srv SyncServer) {
	s.RegisterService(&_Sync_serviceDesc, srv)
}

func _Sync_Pull_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PullRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SyncServer).Pull(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.Sync/Pull",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SyncServer).Pull(ctx, req.(*PullRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Sync_DeclareDataLength_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeclareRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SyncServer).DeclareDataLength(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.Sync/DeclareDataLength",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SyncServer).DeclareDataLength(ctx, req.(*DeclareRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Sync_IncrementPull_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IncrementPullRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SyncServer).IncrementPull(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.Sync/IncrementPull",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SyncServer).IncrementPull(ctx, req.(*IncrementPullRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Sync_serviceDesc = grpc.ServiceDesc{
	ServiceName: "proto.Sync",
	HandlerType: (*SyncServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Pull",
			Handler:    _Sync_Pull_Handler,
		},
		{
			MethodName: "DeclareDataLength",
			Handler:    _Sync_DeclareDataLength_Handler,
		},
		{
			MethodName: "IncrementPull",
			Handler:    _Sync_IncrementPull_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "syncer.proto",
}
