/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.11.0
// source: servicecenter.proto

package sc

import (
	proto "github.com/golang/protobuf/proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type Schema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SchemaId string `protobuf:"bytes,1,opt,name=schemaId,proto3" json:"schemaId,omitempty"`
	Summary  string `protobuf:"bytes,2,opt,name=summary,proto3" json:"summary,omitempty"`
	Schema   string `protobuf:"bytes,3,opt,name=schema,proto3" json:"schema,omitempty"`
}

func (x *Schema) Reset() {
	*x = Schema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_servicecenter_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Schema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema) ProtoMessage() {}

func (x *Schema) ProtoReflect() protoreflect.Message {
	mi := &file_servicecenter_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema.ProtoReflect.Descriptor instead.
func (*Schema) Descriptor() ([]byte, []int) {
	return file_servicecenter_proto_rawDescGZIP(), []int{0}
}

func (x *Schema) GetSchemaId() string {
	if x != nil {
		return x.SchemaId
	}
	return ""
}

func (x *Schema) GetSummary() string {
	if x != nil {
		return x.Summary
	}
	return ""
}

func (x *Schema) GetSchema() string {
	if x != nil {
		return x.Schema
	}
	return ""
}

type MicroService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ServiceId    string             `protobuf:"bytes,1,opt,name=serviceId,proto3" json:"serviceId,omitempty"`
	AppId        string             `protobuf:"bytes,2,opt,name=appId,proto3" json:"appId,omitempty"`
	ServiceName  string             `protobuf:"bytes,3,opt,name=serviceName,proto3" json:"serviceName,omitempty"`
	Version      string             `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	Description  string             `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	Level        string             `protobuf:"bytes,6,opt,name=level,proto3" json:"level,omitempty"`
	Schemas      []string           `protobuf:"bytes,7,rep,name=schemas,proto3" json:"schemas,omitempty"`
	Paths        []*ServicePath     `protobuf:"bytes,10,rep,name=paths,proto3" json:"paths,omitempty"`
	Status       string             `protobuf:"bytes,8,opt,name=status,proto3" json:"status,omitempty"`
	Properties   map[string]string  `protobuf:"bytes,9,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Timestamp    string             `protobuf:"bytes,11,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Providers    []*MicroServiceKey `protobuf:"bytes,12,rep,name=providers,proto3" json:"providers,omitempty"`
	Alias        string             `protobuf:"bytes,13,opt,name=alias,proto3" json:"alias,omitempty"`
	LBStrategy   map[string]string  `protobuf:"bytes,14,rep,name=LBStrategy,proto3" json:"LBStrategy,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ModTimestamp string             `protobuf:"bytes,15,opt,name=modTimestamp,proto3" json:"modTimestamp,omitempty"`
	Environment  string             `protobuf:"bytes,16,opt,name=environment,proto3" json:"environment,omitempty"`
	RegisterBy   string             `protobuf:"bytes,17,opt,name=registerBy,proto3" json:"registerBy,omitempty"`
	Framework    *FrameWorkProperty `protobuf:"bytes,18,opt,name=framework,proto3" json:"framework,omitempty"`
}

func (x *MicroService) Reset() {
	*x = MicroService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_servicecenter_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MicroService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MicroService) ProtoMessage() {}

func (x *MicroService) ProtoReflect() protoreflect.Message {
	mi := &file_servicecenter_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MicroService.ProtoReflect.Descriptor instead.
func (*MicroService) Descriptor() ([]byte, []int) {
	return file_servicecenter_proto_rawDescGZIP(), []int{1}
}

func (x *MicroService) GetServiceId() string {
	if x != nil {
		return x.ServiceId
	}
	return ""
}

func (x *MicroService) GetAppId() string {
	if x != nil {
		return x.AppId
	}
	return ""
}

func (x *MicroService) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *MicroService) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *MicroService) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *MicroService) GetLevel() string {
	if x != nil {
		return x.Level
	}
	return ""
}

func (x *MicroService) GetSchemas() []string {
	if x != nil {
		return x.Schemas
	}
	return nil
}

func (x *MicroService) GetPaths() []*ServicePath {
	if x != nil {
		return x.Paths
	}
	return nil
}

func (x *MicroService) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *MicroService) GetProperties() map[string]string {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *MicroService) GetTimestamp() string {
	if x != nil {
		return x.Timestamp
	}
	return ""
}

func (x *MicroService) GetProviders() []*MicroServiceKey {
	if x != nil {
		return x.Providers
	}
	return nil
}

func (x *MicroService) GetAlias() string {
	if x != nil {
		return x.Alias
	}
	return ""
}

func (x *MicroService) GetLBStrategy() map[string]string {
	if x != nil {
		return x.LBStrategy
	}
	return nil
}

func (x *MicroService) GetModTimestamp() string {
	if x != nil {
		return x.ModTimestamp
	}
	return ""
}

func (x *MicroService) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

func (x *MicroService) GetRegisterBy() string {
	if x != nil {
		return x.RegisterBy
	}
	return ""
}

func (x *MicroService) GetFramework() *FrameWorkProperty {
	if x != nil {
		return x.Framework
	}
	return nil
}

type MicroServiceInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	InstanceId     string            `protobuf:"bytes,1,opt,name=instanceId,proto3" json:"instanceId,omitempty"`
	ServiceId      string            `protobuf:"bytes,2,opt,name=serviceId,proto3" json:"serviceId,omitempty"`
	Endpoints      []string          `protobuf:"bytes,3,rep,name=endpoints,proto3" json:"endpoints,omitempty"`
	HostName       string            `protobuf:"bytes,4,opt,name=hostName,proto3" json:"hostName,omitempty"`
	Status         string            `protobuf:"bytes,5,opt,name=status,proto3" json:"status,omitempty"`
	Properties     map[string]string `protobuf:"bytes,6,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	HealthCheck    *HealthCheck      `protobuf:"bytes,7,opt,name=healthCheck,proto3" json:"healthCheck,omitempty"`
	Timestamp      string            `protobuf:"bytes,8,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	DataCenterInfo *DataCenterInfo   `protobuf:"bytes,9,opt,name=dataCenterInfo,proto3" json:"dataCenterInfo,omitempty"`
	ModTimestamp   string            `protobuf:"bytes,10,opt,name=modTimestamp,proto3" json:"modTimestamp,omitempty"`
	Version        string            `protobuf:"bytes,11,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *MicroServiceInstance) Reset() {
	*x = MicroServiceInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_servicecenter_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MicroServiceInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MicroServiceInstance) ProtoMessage() {}

func (x *MicroServiceInstance) ProtoReflect() protoreflect.Message {
	mi := &file_servicecenter_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MicroServiceInstance.ProtoReflect.Descriptor instead.
func (*MicroServiceInstance) Descriptor() ([]byte, []int) {
	return file_servicecenter_proto_rawDescGZIP(), []int{2}
}

func (x *MicroServiceInstance) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *MicroServiceInstance) GetServiceId() string {
	if x != nil {
		return x.ServiceId
	}
	return ""
}

func (x *MicroServiceInstance) GetEndpoints() []string {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

func (x *MicroServiceInstance) GetHostName() string {
	if x != nil {
		return x.HostName
	}
	return ""
}

func (x *MicroServiceInstance) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *MicroServiceInstance) GetProperties() map[string]string {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *MicroServiceInstance) GetHealthCheck() *HealthCheck {
	if x != nil {
		return x.HealthCheck
	}
	return nil
}

func (x *MicroServiceInstance) GetTimestamp() string {
	if x != nil {
		return x.Timestamp
	}
	return ""
}

func (x *MicroServiceInstance) GetDataCenterInfo() *DataCenterInfo {
	if x != nil {
		return x.DataCenterInfo
	}
	return nil
}

func (x *MicroServiceInstance) GetModTimestamp() string {
	if x != nil {
		return x.ModTimestamp
	}
	return ""
}

func (x *MicroServiceInstance) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type ServicePath struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path     string            `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Property map[string]string `protobuf:"bytes,2,rep,name=property,proto3" json:"property,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ServicePath) Reset() {
	*x = ServicePath{}
	if protoimpl.UnsafeEnabled {
		mi := &file_servicecenter_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServicePath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServicePath) ProtoMessage() {}

func (x *ServicePath) ProtoReflect() protoreflect.Message {
	mi := &file_servicecenter_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServicePath.ProtoReflect.Descriptor instead.
func (*ServicePath) Descriptor() ([]byte, []int) {
	return file_servicecenter_proto_rawDescGZIP(), []int{3}
}

func (x *ServicePath) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *ServicePath) GetProperty() map[string]string {
	if x != nil {
		return x.Property
	}
	return nil
}

type MicroServiceKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Tenant      string `protobuf:"bytes,1,opt,name=tenant,proto3" json:"tenant,omitempty"`
	Environment string `protobuf:"bytes,2,opt,name=environment,proto3" json:"environment,omitempty"`
	AppId       string `protobuf:"bytes,3,opt,name=appId,proto3" json:"appId,omitempty"`
	ServiceName string `protobuf:"bytes,4,opt,name=serviceName,proto3" json:"serviceName,omitempty"`
	Alias       string `protobuf:"bytes,5,opt,name=alias,proto3" json:"alias,omitempty"`
	Version     string `protobuf:"bytes,6,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *MicroServiceKey) Reset() {
	*x = MicroServiceKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_servicecenter_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MicroServiceKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MicroServiceKey) ProtoMessage() {}

func (x *MicroServiceKey) ProtoReflect() protoreflect.Message {
	mi := &file_servicecenter_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MicroServiceKey.ProtoReflect.Descriptor instead.
func (*MicroServiceKey) Descriptor() ([]byte, []int) {
	return file_servicecenter_proto_rawDescGZIP(), []int{4}
}

func (x *MicroServiceKey) GetTenant() string {
	if x != nil {
		return x.Tenant
	}
	return ""
}

func (x *MicroServiceKey) GetEnvironment() string {
	if x != nil {
		return x.Environment
	}
	return ""
}

func (x *MicroServiceKey) GetAppId() string {
	if x != nil {
		return x.AppId
	}
	return ""
}

func (x *MicroServiceKey) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *MicroServiceKey) GetAlias() string {
	if x != nil {
		return x.Alias
	}
	return ""
}

func (x *MicroServiceKey) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type FrameWorkProperty struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name    string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *FrameWorkProperty) Reset() {
	*x = FrameWorkProperty{}
	if protoimpl.UnsafeEnabled {
		mi := &file_servicecenter_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FrameWorkProperty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FrameWorkProperty) ProtoMessage() {}

func (x *FrameWorkProperty) ProtoReflect() protoreflect.Message {
	mi := &file_servicecenter_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FrameWorkProperty.ProtoReflect.Descriptor instead.
func (*FrameWorkProperty) Descriptor() ([]byte, []int) {
	return file_servicecenter_proto_rawDescGZIP(), []int{5}
}

func (x *FrameWorkProperty) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FrameWorkProperty) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

type HealthCheck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Mode     string `protobuf:"bytes,1,opt,name=mode,proto3" json:"mode,omitempty"`
	Port     int32  `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	Interval int32  `protobuf:"varint,3,opt,name=interval,proto3" json:"interval,omitempty"`
	Times    int32  `protobuf:"varint,4,opt,name=times,proto3" json:"times,omitempty"`
	Url      string `protobuf:"bytes,5,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *HealthCheck) Reset() {
	*x = HealthCheck{}
	if protoimpl.UnsafeEnabled {
		mi := &file_servicecenter_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HealthCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheck) ProtoMessage() {}

func (x *HealthCheck) ProtoReflect() protoreflect.Message {
	mi := &file_servicecenter_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheck.ProtoReflect.Descriptor instead.
func (*HealthCheck) Descriptor() ([]byte, []int) {
	return file_servicecenter_proto_rawDescGZIP(), []int{6}
}

func (x *HealthCheck) GetMode() string {
	if x != nil {
		return x.Mode
	}
	return ""
}

func (x *HealthCheck) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *HealthCheck) GetInterval() int32 {
	if x != nil {
		return x.Interval
	}
	return 0
}

func (x *HealthCheck) GetTimes() int32 {
	if x != nil {
		return x.Times
	}
	return 0
}

func (x *HealthCheck) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

type DataCenterInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Region        string `protobuf:"bytes,2,opt,name=region,proto3" json:"region,omitempty"`
	AvailableZone string `protobuf:"bytes,3,opt,name=availableZone,proto3" json:"availableZone,omitempty"`
}

func (x *DataCenterInfo) Reset() {
	*x = DataCenterInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_servicecenter_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataCenterInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataCenterInfo) ProtoMessage() {}

func (x *DataCenterInfo) ProtoReflect() protoreflect.Message {
	mi := &file_servicecenter_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataCenterInfo.ProtoReflect.Descriptor instead.
func (*DataCenterInfo) Descriptor() ([]byte, []int) {
	return file_servicecenter_proto_rawDescGZIP(), []int{7}
}

func (x *DataCenterInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataCenterInfo) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *DataCenterInfo) GetAvailableZone() string {
	if x != nil {
		return x.AvailableZone
	}
	return ""
}

var File_servicecenter_proto protoreflect.FileDescriptor

var file_servicecenter_proto_rawDesc = []byte{
	0x0a, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x02, 0x73, 0x63, 0x22, 0x56, 0x0a, 0x06, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x49, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x49, 0x64, 0x12,
	0x18, 0x0a, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x22, 0x93, 0x06, 0x0a, 0x0c, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64,
	0x12, 0x14, 0x0a, 0x05, 0x61, 0x70, 0x70, 0x49, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x61, 0x70, 0x70, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x73, 0x12, 0x25, 0x0a, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x0a, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x73, 0x63, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x50, 0x61, 0x74, 0x68, 0x52, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x40, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x73, 0x63, 0x2e, 0x4d, 0x69, 0x63,
	0x72, 0x6f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x12, 0x31, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73,
	0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x73, 0x63, 0x2e, 0x4d, 0x69, 0x63, 0x72,
	0x6f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x09, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x12, 0x40, 0x0a, 0x0a,
	0x4c, 0x42, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x20, 0x2e, 0x73, 0x63, 0x2e, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x4c, 0x42, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x0a, 0x4c, 0x42, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x22,
	0x0a, 0x0c, 0x6d, 0x6f, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6d, 0x6f, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x12, 0x20, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72,
	0x42, 0x79, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x65, 0x72, 0x42, 0x79, 0x12, 0x33, 0x0a, 0x09, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x77, 0x6f, 0x72,
	0x6b, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x73, 0x63, 0x2e, 0x46, 0x72, 0x61,
	0x6d, 0x65, 0x57, 0x6f, 0x72, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x09,
	0x66, 0x72, 0x61, 0x6d, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x1a, 0x3d, 0x0a, 0x0f, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3d, 0x0a, 0x0f, 0x4c, 0x42, 0x53, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xfa, 0x03, 0x0a, 0x14, 0x4d, 0x69, 0x63, 0x72,
	0x6f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x1e, 0x0a, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64,
	0x12, 0x1c, 0x0a, 0x09, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x12, 0x1c,
	0x0a, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x1a, 0x0a, 0x08,
	0x68, 0x6f, 0x73, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08,
	0x68, 0x6f, 0x73, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x48, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x73, 0x63, 0x2e, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x0b, 0x68, 0x65,
	0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0f, 0x2e, 0x73, 0x63, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x52, 0x0b, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x1c, 0x0a,
	0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x3a, 0x0a, 0x0e, 0x64,
	0x61, 0x74, 0x61, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x73, 0x63, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x43, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x22, 0x0a, 0x0c, 0x6d, 0x6f, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6d,
	0x6f, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x18, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x3d, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x99, 0x01, 0x0a, 0x0b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x50, 0x61, 0x74, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x39, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x73, 0x63, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x61, 0x74, 0x68, 0x2e, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x1a, 0x3b, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0xb3, 0x01, 0x0a, 0x0f, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x4b, 0x65, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x0b,
	0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x14,
	0x0a, 0x05, 0x61, 0x70, 0x70, 0x49, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x61,
	0x70, 0x70, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x12, 0x18, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x41, 0x0a, 0x11, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x57,
	0x6f, 0x72, 0x6b, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x79, 0x0a, 0x0b, 0x48, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74,
	0x12, 0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x14, 0x0a, 0x05,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x75, 0x72, 0x6c, 0x22, 0x62, 0x0a, 0x0e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69,
	0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0d, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5a,
	0x6f, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x76, 0x61, 0x69, 0x6c,
	0x61, 0x62, 0x6c, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x42, 0x06, 0x5a, 0x04, 0x2e, 0x3b, 0x73, 0x63,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_servicecenter_proto_rawDescOnce sync.Once
	file_servicecenter_proto_rawDescData = file_servicecenter_proto_rawDesc
)

func file_servicecenter_proto_rawDescGZIP() []byte {
	file_servicecenter_proto_rawDescOnce.Do(func() {
		file_servicecenter_proto_rawDescData = protoimpl.X.CompressGZIP(file_servicecenter_proto_rawDescData)
	})
	return file_servicecenter_proto_rawDescData
}

var file_servicecenter_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_servicecenter_proto_goTypes = []interface{}{
	(*Schema)(nil),               // 0: sc.Schema
	(*MicroService)(nil),         // 1: sc.MicroService
	(*MicroServiceInstance)(nil), // 2: sc.MicroServiceInstance
	(*ServicePath)(nil),          // 3: sc.ServicePath
	(*MicroServiceKey)(nil),      // 4: sc.MicroServiceKey
	(*FrameWorkProperty)(nil),    // 5: sc.FrameWorkProperty
	(*HealthCheck)(nil),          // 6: sc.HealthCheck
	(*DataCenterInfo)(nil),       // 7: sc.DataCenterInfo
	nil,                          // 8: sc.MicroService.PropertiesEntry
	nil,                          // 9: sc.MicroService.LBStrategyEntry
	nil,                          // 10: sc.MicroServiceInstance.PropertiesEntry
	nil,                          // 11: sc.ServicePath.PropertyEntry
}
var file_servicecenter_proto_depIdxs = []int32{
	3,  // 0: sc.MicroService.paths:type_name -> sc.ServicePath
	8,  // 1: sc.MicroService.properties:type_name -> sc.MicroService.PropertiesEntry
	4,  // 2: sc.MicroService.providers:type_name -> sc.MicroServiceKey
	9,  // 3: sc.MicroService.LBStrategy:type_name -> sc.MicroService.LBStrategyEntry
	5,  // 4: sc.MicroService.framework:type_name -> sc.FrameWorkProperty
	10, // 5: sc.MicroServiceInstance.properties:type_name -> sc.MicroServiceInstance.PropertiesEntry
	6,  // 6: sc.MicroServiceInstance.healthCheck:type_name -> sc.HealthCheck
	7,  // 7: sc.MicroServiceInstance.dataCenterInfo:type_name -> sc.DataCenterInfo
	11, // 8: sc.ServicePath.property:type_name -> sc.ServicePath.PropertyEntry
	9,  // [9:9] is the sub-list for method output_type
	9,  // [9:9] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_servicecenter_proto_init() }
func file_servicecenter_proto_init() {
	if File_servicecenter_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_servicecenter_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Schema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_servicecenter_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MicroService); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_servicecenter_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MicroServiceInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_servicecenter_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServicePath); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_servicecenter_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MicroServiceKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_servicecenter_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FrameWorkProperty); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_servicecenter_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HealthCheck); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_servicecenter_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataCenterInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_servicecenter_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_servicecenter_proto_goTypes,
		DependencyIndexes: file_servicecenter_proto_depIdxs,
		MessageInfos:      file_servicecenter_proto_msgTypes,
	}.Build()
	File_servicecenter_proto = out.File
	file_servicecenter_proto_rawDesc = nil
	file_servicecenter_proto_goTypes = nil
	file_servicecenter_proto_depIdxs = nil
}
