/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package mockservicecenter

import (
	"net/http"

	"github.com/apache/servicecomb-service-center/pkg/log"
)

func (m *mockServer) ServiceExistence(rw http.ResponseWriter, req *http.Request) {
	_, err := rw.Write([]byte(`{
    "serviceId": "4042a6a3e5a2893698ae363ea99a69eb63fc51cd"
}`))
	if err != nil {
		log.Error("", err)
	}
}

func (m *mockServer) CreateService(rw http.ResponseWriter, req *http.Request) {
	_, err := rw.Write([]byte(`{
    "serviceId": "4042a6a3e5a2893698ae363ea99a69eb63fc51cd"
}`))
	if err != nil {
		log.Error("", err)
	}
}

func (m *mockServer) DeleteService(rw http.ResponseWriter, req *http.Request) {
	_, err := rw.Write([]byte(`{
    "serviceId": "4042a6a3e5a2893698ae363ea99a69eb63fc51cc"
}`))
	if err != nil {
		log.Error("", err)
	}
}
