/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: services.proto

/*
Package proto is a generated protocol buffer package.

It is generated from these files:
	services.proto

It has these top-level messages:
	ModifySchemasRequest
	Schema
	ModifySchemasResponse
	HeartbeatSetRequest
	HeartbeatSetElement
	HeartbeatSetResponse
	InstanceHbRst
	StService
	StInstance
	StApp
	Statistics
	GetServicesInfoRequest
	GetServicesInfoResponse
	MicroServiceKey
	MicroService
	FrameWorkProperty
	ServiceRule
	AddOrUpdateServiceRule
	ServicePath
	Response
	GetExistenceRequest
	GetExistenceResponse
	CreateServiceRequest
	CreateServiceResponse
	DeleteServiceRequest
	DeleteServiceResponse
	GetServiceRequest
	GetServiceResponse
	GetServicesRequest
	GetServicesResponse
	UpdateServicePropsRequest
	UpdateServicePropsResponse
	GetServiceRulesRequest
	GetServiceRulesResponse
	UpdateServiceRuleRequest
	UpdateServiceRuleResponse
	AddServiceRulesRequest
	AddServiceRulesResponse
	DeleteServiceRulesRequest
	DeleteServiceRulesResponse
	GetServiceTagsRequest
	GetServiceTagsResponse
	UpdateServiceTagRequest
	UpdateServiceTagResponse
	AddServiceTagsRequest
	AddServiceTagsResponse
	DeleteServiceTagsRequest
	DeleteServiceTagsResponse
	HealthCheck
	MicroServiceInstance
	DataCenterInfo
	MicroServiceInstanceKey
	RegisterInstanceRequest
	RegisterInstanceResponse
	UnregisterInstanceRequest
	UnregisterInstanceResponse
	HeartbeatRequest
	HeartbeatResponse
	FindInstancesRequest
	FindInstancesResponse
	GetOneInstanceRequest
	GetOneInstanceResponse
	GetInstancesRequest
	GetInstancesResponse
	UpdateInstanceStatusRequest
	UpdateInstanceStatusResponse
	UpdateInstancePropsRequest
	UpdateInstancePropsResponse
	WatchInstanceRequest
	WatchInstanceResponse
	GetSchemaRequest
	GetAllSchemaRequest
	GetSchemaResponse
	GetAllSchemaResponse
	DeleteSchemaRequest
	DeleteSchemaResponse
	ModifySchemaRequest
	ModifySchemaResponse
	AddDependenciesRequest
	AddDependenciesResponse
	CreateDependenciesRequest
	ConsumerDependency
	CreateDependenciesResponse
	GetDependenciesRequest
	GetConDependenciesResponse
	GetProDependenciesResponse
	ServiceDetail
	GetServiceDetailResponse
	DelServicesRequest
	DelServicesRspInfo
	DelServicesResponse
	GetAppsRequest
	GetAppsResponse
*/
package proto

import proto1 "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto1.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto1.ProtoPackageIsVersion2 // please upgrade the proto package

type ModifySchemasRequest struct {
	ServiceId string    `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	Schemas   []*Schema `protobuf:"bytes,2,rep,name=schemas" json:"schemas,omitempty"`
}

func (m *ModifySchemasRequest) Reset()                    { *m = ModifySchemasRequest{} }
func (m *ModifySchemasRequest) String() string            { return proto1.CompactTextString(m) }
func (*ModifySchemasRequest) ProtoMessage()               {}
func (*ModifySchemasRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *ModifySchemasRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *ModifySchemasRequest) GetSchemas() []*Schema {
	if m != nil {
		return m.Schemas
	}
	return nil
}

type Schema struct {
	SchemaId string `protobuf:"bytes,1,opt,name=schemaId" json:"schemaId,omitempty"`
	Summary  string `protobuf:"bytes,2,opt,name=summary" json:"summary,omitempty"`
	Schema   string `protobuf:"bytes,3,opt,name=schema" json:"schema,omitempty"`
}

func (m *Schema) Reset()                    { *m = Schema{} }
func (m *Schema) String() string            { return proto1.CompactTextString(m) }
func (*Schema) ProtoMessage()               {}
func (*Schema) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Schema) GetSchemaId() string {
	if m != nil {
		return m.SchemaId
	}
	return ""
}

func (m *Schema) GetSummary() string {
	if m != nil {
		return m.Summary
	}
	return ""
}

func (m *Schema) GetSchema() string {
	if m != nil {
		return m.Schema
	}
	return ""
}

type ModifySchemasResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
}

func (m *ModifySchemasResponse) Reset()                    { *m = ModifySchemasResponse{} }
func (m *ModifySchemasResponse) String() string            { return proto1.CompactTextString(m) }
func (*ModifySchemasResponse) ProtoMessage()               {}
func (*ModifySchemasResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *ModifySchemasResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

type HeartbeatSetRequest struct {
	Instances []*HeartbeatSetElement `protobuf:"bytes,1,rep,name=instances" json:"instances,omitempty"`
}

func (m *HeartbeatSetRequest) Reset()                    { *m = HeartbeatSetRequest{} }
func (m *HeartbeatSetRequest) String() string            { return proto1.CompactTextString(m) }
func (*HeartbeatSetRequest) ProtoMessage()               {}
func (*HeartbeatSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *HeartbeatSetRequest) GetInstances() []*HeartbeatSetElement {
	if m != nil {
		return m.Instances
	}
	return nil
}

type HeartbeatSetElement struct {
	ServiceId  string `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	InstanceId string `protobuf:"bytes,2,opt,name=instanceId" json:"instanceId,omitempty"`
}

func (m *HeartbeatSetElement) Reset()                    { *m = HeartbeatSetElement{} }
func (m *HeartbeatSetElement) String() string            { return proto1.CompactTextString(m) }
func (*HeartbeatSetElement) ProtoMessage()               {}
func (*HeartbeatSetElement) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *HeartbeatSetElement) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *HeartbeatSetElement) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

type HeartbeatSetResponse struct {
	Response  *Response        `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	Instances []*InstanceHbRst `protobuf:"bytes,2,rep,name=instances" json:"instances,omitempty"`
}

func (m *HeartbeatSetResponse) Reset()                    { *m = HeartbeatSetResponse{} }
func (m *HeartbeatSetResponse) String() string            { return proto1.CompactTextString(m) }
func (*HeartbeatSetResponse) ProtoMessage()               {}
func (*HeartbeatSetResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *HeartbeatSetResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *HeartbeatSetResponse) GetInstances() []*InstanceHbRst {
	if m != nil {
		return m.Instances
	}
	return nil
}

type InstanceHbRst struct {
	ServiceId  string `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	InstanceId string `protobuf:"bytes,2,opt,name=instanceId" json:"instanceId,omitempty"`
	ErrMessage string `protobuf:"bytes,3,opt,name=errMessage" json:"errMessage,omitempty"`
}

func (m *InstanceHbRst) Reset()                    { *m = InstanceHbRst{} }
func (m *InstanceHbRst) String() string            { return proto1.CompactTextString(m) }
func (*InstanceHbRst) ProtoMessage()               {}
func (*InstanceHbRst) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *InstanceHbRst) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *InstanceHbRst) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *InstanceHbRst) GetErrMessage() string {
	if m != nil {
		return m.ErrMessage
	}
	return ""
}

type StService struct {
	Count       int64 `protobuf:"varint,1,opt,name=count" json:"count,omitempty"`
	OnlineCount int64 `protobuf:"varint,2,opt,name=onlineCount" json:"onlineCount,omitempty"`
}

func (m *StService) Reset()                    { *m = StService{} }
func (m *StService) String() string            { return proto1.CompactTextString(m) }
func (*StService) ProtoMessage()               {}
func (*StService) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *StService) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *StService) GetOnlineCount() int64 {
	if m != nil {
		return m.OnlineCount
	}
	return 0
}

type StInstance struct {
	Count         int64 `protobuf:"varint,1,opt,name=count" json:"count,omitempty"`
	CountByDomain int64 `protobuf:"varint,2,opt,name=countByDomain" json:"countByDomain,omitempty"`
}

func (m *StInstance) Reset()                    { *m = StInstance{} }
func (m *StInstance) String() string            { return proto1.CompactTextString(m) }
func (*StInstance) ProtoMessage()               {}
func (*StInstance) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *StInstance) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *StInstance) GetCountByDomain() int64 {
	if m != nil {
		return m.CountByDomain
	}
	return 0
}

type StApp struct {
	Count int64 `protobuf:"varint,1,opt,name=count" json:"count,omitempty"`
}

func (m *StApp) Reset()                    { *m = StApp{} }
func (m *StApp) String() string            { return proto1.CompactTextString(m) }
func (*StApp) ProtoMessage()               {}
func (*StApp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *StApp) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

type Statistics struct {
	Services  *StService  `protobuf:"bytes,1,opt,name=services" json:"services,omitempty"`
	Instances *StInstance `protobuf:"bytes,2,opt,name=instances" json:"instances,omitempty"`
	Apps      *StApp      `protobuf:"bytes,3,opt,name=apps" json:"apps,omitempty"`
}

func (m *Statistics) Reset()                    { *m = Statistics{} }
func (m *Statistics) String() string            { return proto1.CompactTextString(m) }
func (*Statistics) ProtoMessage()               {}
func (*Statistics) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *Statistics) GetServices() *StService {
	if m != nil {
		return m.Services
	}
	return nil
}

func (m *Statistics) GetInstances() *StInstance {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *Statistics) GetApps() *StApp {
	if m != nil {
		return m.Apps
	}
	return nil
}

type GetServicesInfoRequest struct {
	Options     []string `protobuf:"bytes,1,rep,name=options" json:"options,omitempty"`
	AppId       string   `protobuf:"bytes,2,opt,name=appId" json:"appId,omitempty"`
	ServiceName string   `protobuf:"bytes,3,opt,name=serviceName" json:"serviceName,omitempty"`
	CountOnly   bool     `protobuf:"varint,4,opt,name=countOnly" json:"countOnly,omitempty"`
	WithShared  bool     `protobuf:"varint,5,opt,name=withShared" json:"withShared,omitempty"`
}

func (m *GetServicesInfoRequest) Reset()                    { *m = GetServicesInfoRequest{} }
func (m *GetServicesInfoRequest) String() string            { return proto1.CompactTextString(m) }
func (*GetServicesInfoRequest) ProtoMessage()               {}
func (*GetServicesInfoRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *GetServicesInfoRequest) GetOptions() []string {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *GetServicesInfoRequest) GetAppId() string {
	if m != nil {
		return m.AppId
	}
	return ""
}

func (m *GetServicesInfoRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *GetServicesInfoRequest) GetCountOnly() bool {
	if m != nil {
		return m.CountOnly
	}
	return false
}

func (m *GetServicesInfoRequest) GetWithShared() bool {
	if m != nil {
		return m.WithShared
	}
	return false
}

type GetServicesInfoResponse struct {
	Response          *Response        `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	AllServicesDetail []*ServiceDetail `protobuf:"bytes,2,rep,name=allServicesDetail" json:"allServicesDetail,omitempty"`
	Statistics        *Statistics      `protobuf:"bytes,3,opt,name=statistics" json:"statistics,omitempty"`
}

func (m *GetServicesInfoResponse) Reset()                    { *m = GetServicesInfoResponse{} }
func (m *GetServicesInfoResponse) String() string            { return proto1.CompactTextString(m) }
func (*GetServicesInfoResponse) ProtoMessage()               {}
func (*GetServicesInfoResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *GetServicesInfoResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *GetServicesInfoResponse) GetAllServicesDetail() []*ServiceDetail {
	if m != nil {
		return m.AllServicesDetail
	}
	return nil
}

func (m *GetServicesInfoResponse) GetStatistics() *Statistics {
	if m != nil {
		return m.Statistics
	}
	return nil
}

type MicroServiceKey struct {
	Tenant      string `protobuf:"bytes,1,opt,name=tenant" json:"tenant,omitempty"`
	Project     string `protobuf:"bytes,2,opt,name=project" json:"project,omitempty"`
	AppId       string `protobuf:"bytes,3,opt,name=appId" json:"appId,omitempty"`
	ServiceName string `protobuf:"bytes,4,opt,name=serviceName" json:"serviceName,omitempty"`
	Version     string `protobuf:"bytes,5,opt,name=version" json:"version,omitempty"`
	Environment string `protobuf:"bytes,6,opt,name=environment" json:"environment,omitempty"`
	Alias       string `protobuf:"bytes,7,opt,name=alias" json:"alias,omitempty"`
}

func (m *MicroServiceKey) Reset()                    { *m = MicroServiceKey{} }
func (m *MicroServiceKey) String() string            { return proto1.CompactTextString(m) }
func (*MicroServiceKey) ProtoMessage()               {}
func (*MicroServiceKey) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *MicroServiceKey) GetTenant() string {
	if m != nil {
		return m.Tenant
	}
	return ""
}

func (m *MicroServiceKey) GetProject() string {
	if m != nil {
		return m.Project
	}
	return ""
}

func (m *MicroServiceKey) GetAppId() string {
	if m != nil {
		return m.AppId
	}
	return ""
}

func (m *MicroServiceKey) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *MicroServiceKey) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *MicroServiceKey) GetEnvironment() string {
	if m != nil {
		return m.Environment
	}
	return ""
}

func (m *MicroServiceKey) GetAlias() string {
	if m != nil {
		return m.Alias
	}
	return ""
}

type MicroService struct {
	ServiceId    string             `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	AppId        string             `protobuf:"bytes,2,opt,name=appId" json:"appId,omitempty"`
	ServiceName  string             `protobuf:"bytes,3,opt,name=serviceName" json:"serviceName,omitempty"`
	Version      string             `protobuf:"bytes,4,opt,name=version" json:"version,omitempty"`
	Description  string             `protobuf:"bytes,5,opt,name=description" json:"description,omitempty"`
	Level        string             `protobuf:"bytes,6,opt,name=level" json:"level,omitempty"`
	Schemas      []string           `protobuf:"bytes,7,rep,name=schemas" json:"schemas,omitempty"`
	Paths        []*ServicePath     `protobuf:"bytes,10,rep,name=paths" json:"paths,omitempty"`
	Status       string             `protobuf:"bytes,8,opt,name=status" json:"status,omitempty"`
	Properties   map[string]string  `protobuf:"bytes,9,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Timestamp    string             `protobuf:"bytes,11,opt,name=timestamp" json:"timestamp,omitempty"`
	Providers    []*MicroServiceKey `protobuf:"bytes,12,rep,name=providers" json:"providers,omitempty"`
	Alias        string             `protobuf:"bytes,13,opt,name=alias" json:"alias,omitempty"`
	LBStrategy   map[string]string  `protobuf:"bytes,14,rep,name=LBStrategy" json:"LBStrategy,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	ModTimestamp string             `protobuf:"bytes,15,opt,name=modTimestamp" json:"modTimestamp,omitempty"`
	Environment  string             `protobuf:"bytes,16,opt,name=environment" json:"environment,omitempty"`
	RegisterBy   string             `protobuf:"bytes,17,opt,name=registerBy" json:"registerBy,omitempty"`
	Framework    *FrameWorkProperty `protobuf:"bytes,18,opt,name=framework" json:"framework,omitempty"`
}

func (m *MicroService) Reset()                    { *m = MicroService{} }
func (m *MicroService) String() string            { return proto1.CompactTextString(m) }
func (*MicroService) ProtoMessage()               {}
func (*MicroService) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *MicroService) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *MicroService) GetAppId() string {
	if m != nil {
		return m.AppId
	}
	return ""
}

func (m *MicroService) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *MicroService) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *MicroService) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *MicroService) GetLevel() string {
	if m != nil {
		return m.Level
	}
	return ""
}

func (m *MicroService) GetSchemas() []string {
	if m != nil {
		return m.Schemas
	}
	return nil
}

func (m *MicroService) GetPaths() []*ServicePath {
	if m != nil {
		return m.Paths
	}
	return nil
}

func (m *MicroService) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *MicroService) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *MicroService) GetTimestamp() string {
	if m != nil {
		return m.Timestamp
	}
	return ""
}

func (m *MicroService) GetProviders() []*MicroServiceKey {
	if m != nil {
		return m.Providers
	}
	return nil
}

func (m *MicroService) GetAlias() string {
	if m != nil {
		return m.Alias
	}
	return ""
}

func (m *MicroService) GetLBStrategy() map[string]string {
	if m != nil {
		return m.LBStrategy
	}
	return nil
}

func (m *MicroService) GetModTimestamp() string {
	if m != nil {
		return m.ModTimestamp
	}
	return ""
}

func (m *MicroService) GetEnvironment() string {
	if m != nil {
		return m.Environment
	}
	return ""
}

func (m *MicroService) GetRegisterBy() string {
	if m != nil {
		return m.RegisterBy
	}
	return ""
}

func (m *MicroService) GetFramework() *FrameWorkProperty {
	if m != nil {
		return m.Framework
	}
	return nil
}

type FrameWorkProperty struct {
	Name    string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Version string `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
}

func (m *FrameWorkProperty) Reset()                    { *m = FrameWorkProperty{} }
func (m *FrameWorkProperty) String() string            { return proto1.CompactTextString(m) }
func (*FrameWorkProperty) ProtoMessage()               {}
func (*FrameWorkProperty) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *FrameWorkProperty) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FrameWorkProperty) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

type ServiceRule struct {
	RuleId       string `protobuf:"bytes,1,opt,name=ruleId" json:"ruleId,omitempty"`
	RuleType     string `protobuf:"bytes,2,opt,name=ruleType" json:"ruleType,omitempty"`
	Attribute    string `protobuf:"bytes,3,opt,name=attribute" json:"attribute,omitempty"`
	Pattern      string `protobuf:"bytes,4,opt,name=pattern" json:"pattern,omitempty"`
	Description  string `protobuf:"bytes,5,opt,name=description" json:"description,omitempty"`
	Timestamp    string `protobuf:"bytes,6,opt,name=timestamp" json:"timestamp,omitempty"`
	ModTimestamp string `protobuf:"bytes,7,opt,name=modTimestamp" json:"modTimestamp,omitempty"`
}

func (m *ServiceRule) Reset()                    { *m = ServiceRule{} }
func (m *ServiceRule) String() string            { return proto1.CompactTextString(m) }
func (*ServiceRule) ProtoMessage()               {}
func (*ServiceRule) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *ServiceRule) GetRuleId() string {
	if m != nil {
		return m.RuleId
	}
	return ""
}

func (m *ServiceRule) GetRuleType() string {
	if m != nil {
		return m.RuleType
	}
	return ""
}

func (m *ServiceRule) GetAttribute() string {
	if m != nil {
		return m.Attribute
	}
	return ""
}

func (m *ServiceRule) GetPattern() string {
	if m != nil {
		return m.Pattern
	}
	return ""
}

func (m *ServiceRule) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ServiceRule) GetTimestamp() string {
	if m != nil {
		return m.Timestamp
	}
	return ""
}

func (m *ServiceRule) GetModTimestamp() string {
	if m != nil {
		return m.ModTimestamp
	}
	return ""
}

type AddOrUpdateServiceRule struct {
	RuleType    string `protobuf:"bytes,1,opt,name=ruleType" json:"ruleType,omitempty"`
	Attribute   string `protobuf:"bytes,2,opt,name=attribute" json:"attribute,omitempty"`
	Pattern     string `protobuf:"bytes,3,opt,name=pattern" json:"pattern,omitempty"`
	Description string `protobuf:"bytes,4,opt,name=description" json:"description,omitempty"`
}

func (m *AddOrUpdateServiceRule) Reset()                    { *m = AddOrUpdateServiceRule{} }
func (m *AddOrUpdateServiceRule) String() string            { return proto1.CompactTextString(m) }
func (*AddOrUpdateServiceRule) ProtoMessage()               {}
func (*AddOrUpdateServiceRule) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *AddOrUpdateServiceRule) GetRuleType() string {
	if m != nil {
		return m.RuleType
	}
	return ""
}

func (m *AddOrUpdateServiceRule) GetAttribute() string {
	if m != nil {
		return m.Attribute
	}
	return ""
}

func (m *AddOrUpdateServiceRule) GetPattern() string {
	if m != nil {
		return m.Pattern
	}
	return ""
}

func (m *AddOrUpdateServiceRule) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

type ServicePath struct {
	Path     string            `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	Property map[string]string `protobuf:"bytes,2,rep,name=property" json:"property,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ServicePath) Reset()                    { *m = ServicePath{} }
func (m *ServicePath) String() string            { return proto1.CompactTextString(m) }
func (*ServicePath) ProtoMessage()               {}
func (*ServicePath) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *ServicePath) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *ServicePath) GetProperty() map[string]string {
	if m != nil {
		return m.Property
	}
	return nil
}

type Response struct {
	Code    int32  `protobuf:"varint,1,opt,name=code" json:"code,omitempty"`
	Message string `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
}

func (m *Response) Reset()                    { *m = Response{} }
func (m *Response) String() string            { return proto1.CompactTextString(m) }
func (*Response) ProtoMessage()               {}
func (*Response) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *Response) GetCode() int32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *Response) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type GetExistenceRequest struct {
	Type        string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	AppId       string `protobuf:"bytes,2,opt,name=appId" json:"appId,omitempty"`
	ServiceName string `protobuf:"bytes,3,opt,name=serviceName" json:"serviceName,omitempty"`
	Version     string `protobuf:"bytes,4,opt,name=version" json:"version,omitempty"`
	ServiceId   string `protobuf:"bytes,5,opt,name=serviceId" json:"serviceId,omitempty"`
	SchemaId    string `protobuf:"bytes,6,opt,name=schemaId" json:"schemaId,omitempty"`
	Environment string `protobuf:"bytes,7,opt,name=environment" json:"environment,omitempty"`
}

func (m *GetExistenceRequest) Reset()                    { *m = GetExistenceRequest{} }
func (m *GetExistenceRequest) String() string            { return proto1.CompactTextString(m) }
func (*GetExistenceRequest) ProtoMessage()               {}
func (*GetExistenceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *GetExistenceRequest) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *GetExistenceRequest) GetAppId() string {
	if m != nil {
		return m.AppId
	}
	return ""
}

func (m *GetExistenceRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *GetExistenceRequest) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *GetExistenceRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *GetExistenceRequest) GetSchemaId() string {
	if m != nil {
		return m.SchemaId
	}
	return ""
}

func (m *GetExistenceRequest) GetEnvironment() string {
	if m != nil {
		return m.Environment
	}
	return ""
}

type GetExistenceResponse struct {
	Response  *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	ServiceId string    `protobuf:"bytes,2,opt,name=serviceId" json:"serviceId,omitempty"`
	SchemaId  string    `protobuf:"bytes,3,opt,name=schemaId" json:"schemaId,omitempty"`
	Summary   string    `protobuf:"bytes,4,opt,name=summary" json:"summary,omitempty"`
}

func (m *GetExistenceResponse) Reset()                    { *m = GetExistenceResponse{} }
func (m *GetExistenceResponse) String() string            { return proto1.CompactTextString(m) }
func (*GetExistenceResponse) ProtoMessage()               {}
func (*GetExistenceResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *GetExistenceResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *GetExistenceResponse) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *GetExistenceResponse) GetSchemaId() string {
	if m != nil {
		return m.SchemaId
	}
	return ""
}

func (m *GetExistenceResponse) GetSummary() string {
	if m != nil {
		return m.Summary
	}
	return ""
}

type CreateServiceRequest struct {
	Service   *MicroService             `protobuf:"bytes,1,opt,name=service" json:"service,omitempty"`
	Rules     []*AddOrUpdateServiceRule `protobuf:"bytes,2,rep,name=rules" json:"rules,omitempty"`
	Tags      map[string]string         `protobuf:"bytes,3,rep,name=tags" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Instances []*MicroServiceInstance   `protobuf:"bytes,4,rep,name=instances" json:"instances,omitempty"`
}

func (m *CreateServiceRequest) Reset()                    { *m = CreateServiceRequest{} }
func (m *CreateServiceRequest) String() string            { return proto1.CompactTextString(m) }
func (*CreateServiceRequest) ProtoMessage()               {}
func (*CreateServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *CreateServiceRequest) GetService() *MicroService {
	if m != nil {
		return m.Service
	}
	return nil
}

func (m *CreateServiceRequest) GetRules() []*AddOrUpdateServiceRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

func (m *CreateServiceRequest) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *CreateServiceRequest) GetInstances() []*MicroServiceInstance {
	if m != nil {
		return m.Instances
	}
	return nil
}

type CreateServiceResponse struct {
	Response  *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	ServiceId string    `protobuf:"bytes,2,opt,name=serviceId" json:"serviceId,omitempty"`
}

func (m *CreateServiceResponse) Reset()                    { *m = CreateServiceResponse{} }
func (m *CreateServiceResponse) String() string            { return proto1.CompactTextString(m) }
func (*CreateServiceResponse) ProtoMessage()               {}
func (*CreateServiceResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *CreateServiceResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *CreateServiceResponse) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

type DeleteServiceRequest struct {
	ServiceId string `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	Force     bool   `protobuf:"varint,2,opt,name=force" json:"force,omitempty"`
}

func (m *DeleteServiceRequest) Reset()                    { *m = DeleteServiceRequest{} }
func (m *DeleteServiceRequest) String() string            { return proto1.CompactTextString(m) }
func (*DeleteServiceRequest) ProtoMessage()               {}
func (*DeleteServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *DeleteServiceRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *DeleteServiceRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

type DeleteServiceResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
}

func (m *DeleteServiceResponse) Reset()                    { *m = DeleteServiceResponse{} }
func (m *DeleteServiceResponse) String() string            { return proto1.CompactTextString(m) }
func (*DeleteServiceResponse) ProtoMessage()               {}
func (*DeleteServiceResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *DeleteServiceResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

type GetServiceRequest struct {
	ServiceId string `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
}

func (m *GetServiceRequest) Reset()                    { *m = GetServiceRequest{} }
func (m *GetServiceRequest) String() string            { return proto1.CompactTextString(m) }
func (*GetServiceRequest) ProtoMessage()               {}
func (*GetServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *GetServiceRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

type GetServiceResponse struct {
	Response *Response     `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	Service  *MicroService `protobuf:"bytes,2,opt,name=service" json:"service,omitempty"`
}

func (m *GetServiceResponse) Reset()                    { *m = GetServiceResponse{} }
func (m *GetServiceResponse) String() string            { return proto1.CompactTextString(m) }
func (*GetServiceResponse) ProtoMessage()               {}
func (*GetServiceResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *GetServiceResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *GetServiceResponse) GetService() *MicroService {
	if m != nil {
		return m.Service
	}
	return nil
}

type GetServicesRequest struct {
}

func (m *GetServicesRequest) Reset()                    { *m = GetServicesRequest{} }
func (m *GetServicesRequest) String() string            { return proto1.CompactTextString(m) }
func (*GetServicesRequest) ProtoMessage()               {}
func (*GetServicesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

type GetServicesResponse struct {
	Response *Response       `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	Services []*MicroService `protobuf:"bytes,2,rep,name=services" json:"services,omitempty"`
}

func (m *GetServicesResponse) Reset()                    { *m = GetServicesResponse{} }
func (m *GetServicesResponse) String() string            { return proto1.CompactTextString(m) }
func (*GetServicesResponse) ProtoMessage()               {}
func (*GetServicesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *GetServicesResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *GetServicesResponse) GetServices() []*MicroService {
	if m != nil {
		return m.Services
	}
	return nil
}

type UpdateServicePropsRequest struct {
	ServiceId  string            `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	Properties map[string]string `protobuf:"bytes,2,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *UpdateServicePropsRequest) Reset()                    { *m = UpdateServicePropsRequest{} }
func (m *UpdateServicePropsRequest) String() string            { return proto1.CompactTextString(m) }
func (*UpdateServicePropsRequest) ProtoMessage()               {}
func (*UpdateServicePropsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

func (m *UpdateServicePropsRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *UpdateServicePropsRequest) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

type UpdateServicePropsResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
}

func (m *UpdateServicePropsResponse) Reset()                    { *m = UpdateServicePropsResponse{} }
func (m *UpdateServicePropsResponse) String() string            { return proto1.CompactTextString(m) }
func (*UpdateServicePropsResponse) ProtoMessage()               {}
func (*UpdateServicePropsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *UpdateServicePropsResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

type GetServiceRulesRequest struct {
	ServiceId string `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
}

func (m *GetServiceRulesRequest) Reset()                    { *m = GetServiceRulesRequest{} }
func (m *GetServiceRulesRequest) String() string            { return proto1.CompactTextString(m) }
func (*GetServiceRulesRequest) ProtoMessage()               {}
func (*GetServiceRulesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *GetServiceRulesRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

type GetServiceRulesResponse struct {
	Response *Response      `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	Rules    []*ServiceRule `protobuf:"bytes,2,rep,name=rules" json:"rules,omitempty"`
}

func (m *GetServiceRulesResponse) Reset()                    { *m = GetServiceRulesResponse{} }
func (m *GetServiceRulesResponse) String() string            { return proto1.CompactTextString(m) }
func (*GetServiceRulesResponse) ProtoMessage()               {}
func (*GetServiceRulesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *GetServiceRulesResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *GetServiceRulesResponse) GetRules() []*ServiceRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

type UpdateServiceRuleRequest struct {
	ServiceId string                  `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	RuleId    string                  `protobuf:"bytes,2,opt,name=ruleId" json:"ruleId,omitempty"`
	Rule      *AddOrUpdateServiceRule `protobuf:"bytes,3,opt,name=rule" json:"rule,omitempty"`
}

func (m *UpdateServiceRuleRequest) Reset()                    { *m = UpdateServiceRuleRequest{} }
func (m *UpdateServiceRuleRequest) String() string            { return proto1.CompactTextString(m) }
func (*UpdateServiceRuleRequest) ProtoMessage()               {}
func (*UpdateServiceRuleRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *UpdateServiceRuleRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *UpdateServiceRuleRequest) GetRuleId() string {
	if m != nil {
		return m.RuleId
	}
	return ""
}

func (m *UpdateServiceRuleRequest) GetRule() *AddOrUpdateServiceRule {
	if m != nil {
		return m.Rule
	}
	return nil
}

type UpdateServiceRuleResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
}

func (m *UpdateServiceRuleResponse) Reset()                    { *m = UpdateServiceRuleResponse{} }
func (m *UpdateServiceRuleResponse) String() string            { return proto1.CompactTextString(m) }
func (*UpdateServiceRuleResponse) ProtoMessage()               {}
func (*UpdateServiceRuleResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *UpdateServiceRuleResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

type AddServiceRulesRequest struct {
	ServiceId string                    `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	Rules     []*AddOrUpdateServiceRule `protobuf:"bytes,2,rep,name=rules" json:"rules,omitempty"`
}

func (m *AddServiceRulesRequest) Reset()                    { *m = AddServiceRulesRequest{} }
func (m *AddServiceRulesRequest) String() string            { return proto1.CompactTextString(m) }
func (*AddServiceRulesRequest) ProtoMessage()               {}
func (*AddServiceRulesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *AddServiceRulesRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *AddServiceRulesRequest) GetRules() []*AddOrUpdateServiceRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

type AddServiceRulesResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	RuleIds  []string  `protobuf:"bytes,2,rep,name=RuleIds" json:"RuleIds,omitempty"`
}

func (m *AddServiceRulesResponse) Reset()                    { *m = AddServiceRulesResponse{} }
func (m *AddServiceRulesResponse) String() string            { return proto1.CompactTextString(m) }
func (*AddServiceRulesResponse) ProtoMessage()               {}
func (*AddServiceRulesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *AddServiceRulesResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *AddServiceRulesResponse) GetRuleIds() []string {
	if m != nil {
		return m.RuleIds
	}
	return nil
}

type DeleteServiceRulesRequest struct {
	ServiceId string   `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	RuleIds   []string `protobuf:"bytes,2,rep,name=ruleIds" json:"ruleIds,omitempty"`
}

func (m *DeleteServiceRulesRequest) Reset()                    { *m = DeleteServiceRulesRequest{} }
func (m *DeleteServiceRulesRequest) String() string            { return proto1.CompactTextString(m) }
func (*DeleteServiceRulesRequest) ProtoMessage()               {}
func (*DeleteServiceRulesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

func (m *DeleteServiceRulesRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *DeleteServiceRulesRequest) GetRuleIds() []string {
	if m != nil {
		return m.RuleIds
	}
	return nil
}

type DeleteServiceRulesResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
}

func (m *DeleteServiceRulesResponse) Reset()                    { *m = DeleteServiceRulesResponse{} }
func (m *DeleteServiceRulesResponse) String() string            { return proto1.CompactTextString(m) }
func (*DeleteServiceRulesResponse) ProtoMessage()               {}
func (*DeleteServiceRulesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *DeleteServiceRulesResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

type GetServiceTagsRequest struct {
	ServiceId string `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
}

func (m *GetServiceTagsRequest) Reset()                    { *m = GetServiceTagsRequest{} }
func (m *GetServiceTagsRequest) String() string            { return proto1.CompactTextString(m) }
func (*GetServiceTagsRequest) ProtoMessage()               {}
func (*GetServiceTagsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func (m *GetServiceTagsRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

type GetServiceTagsResponse struct {
	Response *Response         `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	Tags     map[string]string `protobuf:"bytes,2,rep,name=tags" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *GetServiceTagsResponse) Reset()                    { *m = GetServiceTagsResponse{} }
func (m *GetServiceTagsResponse) String() string            { return proto1.CompactTextString(m) }
func (*GetServiceTagsResponse) ProtoMessage()               {}
func (*GetServiceTagsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{41} }

func (m *GetServiceTagsResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *GetServiceTagsResponse) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

type UpdateServiceTagRequest struct {
	ServiceId string `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	Key       string `protobuf:"bytes,2,opt,name=key" json:"key,omitempty"`
	Value     string `protobuf:"bytes,3,opt,name=value" json:"value,omitempty"`
}

func (m *UpdateServiceTagRequest) Reset()                    { *m = UpdateServiceTagRequest{} }
func (m *UpdateServiceTagRequest) String() string            { return proto1.CompactTextString(m) }
func (*UpdateServiceTagRequest) ProtoMessage()               {}
func (*UpdateServiceTagRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{42} }

func (m *UpdateServiceTagRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *UpdateServiceTagRequest) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *UpdateServiceTagRequest) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

type UpdateServiceTagResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
}

func (m *UpdateServiceTagResponse) Reset()                    { *m = UpdateServiceTagResponse{} }
func (m *UpdateServiceTagResponse) String() string            { return proto1.CompactTextString(m) }
func (*UpdateServiceTagResponse) ProtoMessage()               {}
func (*UpdateServiceTagResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{43} }

func (m *UpdateServiceTagResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

type AddServiceTagsRequest struct {
	ServiceId string            `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	Tags      map[string]string `protobuf:"bytes,2,rep,name=tags" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *AddServiceTagsRequest) Reset()                    { *m = AddServiceTagsRequest{} }
func (m *AddServiceTagsRequest) String() string            { return proto1.CompactTextString(m) }
func (*AddServiceTagsRequest) ProtoMessage()               {}
func (*AddServiceTagsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{44} }

func (m *AddServiceTagsRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *AddServiceTagsRequest) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

type AddServiceTagsResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
}

func (m *AddServiceTagsResponse) Reset()                    { *m = AddServiceTagsResponse{} }
func (m *AddServiceTagsResponse) String() string            { return proto1.CompactTextString(m) }
func (*AddServiceTagsResponse) ProtoMessage()               {}
func (*AddServiceTagsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{45} }

func (m *AddServiceTagsResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

type DeleteServiceTagsRequest struct {
	ServiceId string   `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	Keys      []string `protobuf:"bytes,2,rep,name=keys" json:"keys,omitempty"`
}

func (m *DeleteServiceTagsRequest) Reset()                    { *m = DeleteServiceTagsRequest{} }
func (m *DeleteServiceTagsRequest) String() string            { return proto1.CompactTextString(m) }
func (*DeleteServiceTagsRequest) ProtoMessage()               {}
func (*DeleteServiceTagsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{46} }

func (m *DeleteServiceTagsRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *DeleteServiceTagsRequest) GetKeys() []string {
	if m != nil {
		return m.Keys
	}
	return nil
}

type DeleteServiceTagsResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
}

func (m *DeleteServiceTagsResponse) Reset()                    { *m = DeleteServiceTagsResponse{} }
func (m *DeleteServiceTagsResponse) String() string            { return proto1.CompactTextString(m) }
func (*DeleteServiceTagsResponse) ProtoMessage()               {}
func (*DeleteServiceTagsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{47} }

func (m *DeleteServiceTagsResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

type HealthCheck struct {
	Mode     string `protobuf:"bytes,1,opt,name=mode" json:"mode,omitempty"`
	Port     int32  `protobuf:"varint,2,opt,name=port" json:"port,omitempty"`
	Interval int32  `protobuf:"varint,3,opt,name=interval" json:"interval,omitempty"`
	Times    int32  `protobuf:"varint,4,opt,name=times" json:"times,omitempty"`
	Url      string `protobuf:"bytes,5,opt,name=url" json:"url,omitempty"`
}

func (m *HealthCheck) Reset()                    { *m = HealthCheck{} }
func (m *HealthCheck) String() string            { return proto1.CompactTextString(m) }
func (*HealthCheck) ProtoMessage()               {}
func (*HealthCheck) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{48} }

func (m *HealthCheck) GetMode() string {
	if m != nil {
		return m.Mode
	}
	return ""
}

func (m *HealthCheck) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *HealthCheck) GetInterval() int32 {
	if m != nil {
		return m.Interval
	}
	return 0
}

func (m *HealthCheck) GetTimes() int32 {
	if m != nil {
		return m.Times
	}
	return 0
}

func (m *HealthCheck) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

type MicroServiceInstance struct {
	InstanceId     string            `protobuf:"bytes,1,opt,name=instanceId" json:"instanceId,omitempty"`
	ServiceId      string            `protobuf:"bytes,2,opt,name=serviceId" json:"serviceId,omitempty"`
	Endpoints      []string          `protobuf:"bytes,3,rep,name=endpoints" json:"endpoints,omitempty"`
	HostName       string            `protobuf:"bytes,4,opt,name=hostName" json:"hostName,omitempty"`
	Status         string            `protobuf:"bytes,5,opt,name=status" json:"status,omitempty"`
	Properties     map[string]string `protobuf:"bytes,6,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	HealthCheck    *HealthCheck      `protobuf:"bytes,7,opt,name=healthCheck" json:"healthCheck,omitempty"`
	Timestamp      string            `protobuf:"bytes,8,opt,name=timestamp" json:"timestamp,omitempty"`
	DataCenterInfo *DataCenterInfo   `protobuf:"bytes,9,opt,name=dataCenterInfo" json:"dataCenterInfo,omitempty"`
	ModTimestamp   string            `protobuf:"bytes,10,opt,name=modTimestamp" json:"modTimestamp,omitempty"`
	Version        string            `protobuf:"bytes,11,opt,name=version" json:"version,omitempty"`
}

func (m *MicroServiceInstance) Reset()                    { *m = MicroServiceInstance{} }
func (m *MicroServiceInstance) String() string            { return proto1.CompactTextString(m) }
func (*MicroServiceInstance) ProtoMessage()               {}
func (*MicroServiceInstance) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{49} }

func (m *MicroServiceInstance) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *MicroServiceInstance) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *MicroServiceInstance) GetEndpoints() []string {
	if m != nil {
		return m.Endpoints
	}
	return nil
}

func (m *MicroServiceInstance) GetHostName() string {
	if m != nil {
		return m.HostName
	}
	return ""
}

func (m *MicroServiceInstance) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *MicroServiceInstance) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *MicroServiceInstance) GetHealthCheck() *HealthCheck {
	if m != nil {
		return m.HealthCheck
	}
	return nil
}

func (m *MicroServiceInstance) GetTimestamp() string {
	if m != nil {
		return m.Timestamp
	}
	return ""
}

func (m *MicroServiceInstance) GetDataCenterInfo() *DataCenterInfo {
	if m != nil {
		return m.DataCenterInfo
	}
	return nil
}

func (m *MicroServiceInstance) GetModTimestamp() string {
	if m != nil {
		return m.ModTimestamp
	}
	return ""
}

func (m *MicroServiceInstance) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

type DataCenterInfo struct {
	Name          string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Region        string `protobuf:"bytes,2,opt,name=region" json:"region,omitempty"`
	AvailableZone string `protobuf:"bytes,3,opt,name=availableZone" json:"availableZone,omitempty"`
}

func (m *DataCenterInfo) Reset()                    { *m = DataCenterInfo{} }
func (m *DataCenterInfo) String() string            { return proto1.CompactTextString(m) }
func (*DataCenterInfo) ProtoMessage()               {}
func (*DataCenterInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{50} }

func (m *DataCenterInfo) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DataCenterInfo) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *DataCenterInfo) GetAvailableZone() string {
	if m != nil {
		return m.AvailableZone
	}
	return ""
}

type MicroServiceInstanceKey struct {
	InstanceId string `protobuf:"bytes,1,opt,name=instanceId" json:"instanceId,omitempty"`
	ServiceId  string `protobuf:"bytes,2,opt,name=serviceId" json:"serviceId,omitempty"`
}

func (m *MicroServiceInstanceKey) Reset()                    { *m = MicroServiceInstanceKey{} }
func (m *MicroServiceInstanceKey) String() string            { return proto1.CompactTextString(m) }
func (*MicroServiceInstanceKey) ProtoMessage()               {}
func (*MicroServiceInstanceKey) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{51} }

func (m *MicroServiceInstanceKey) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *MicroServiceInstanceKey) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

type RegisterInstanceRequest struct {
	Instance *MicroServiceInstance `protobuf:"bytes,1,opt,name=instance" json:"instance,omitempty"`
}

func (m *RegisterInstanceRequest) Reset()                    { *m = RegisterInstanceRequest{} }
func (m *RegisterInstanceRequest) String() string            { return proto1.CompactTextString(m) }
func (*RegisterInstanceRequest) ProtoMessage()               {}
func (*RegisterInstanceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{52} }

func (m *RegisterInstanceRequest) GetInstance() *MicroServiceInstance {
	if m != nil {
		return m.Instance
	}
	return nil
}

type RegisterInstanceResponse struct {
	Response   *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	InstanceId string    `protobuf:"bytes,2,opt,name=instanceId" json:"instanceId,omitempty"`
}

func (m *RegisterInstanceResponse) Reset()                    { *m = RegisterInstanceResponse{} }
func (m *RegisterInstanceResponse) String() string            { return proto1.CompactTextString(m) }
func (*RegisterInstanceResponse) ProtoMessage()               {}
func (*RegisterInstanceResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{53} }

func (m *RegisterInstanceResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *RegisterInstanceResponse) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

type UnregisterInstanceRequest struct {
	ServiceId  string `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	InstanceId string `protobuf:"bytes,2,opt,name=instanceId" json:"instanceId,omitempty"`
}

func (m *UnregisterInstanceRequest) Reset()                    { *m = UnregisterInstanceRequest{} }
func (m *UnregisterInstanceRequest) String() string            { return proto1.CompactTextString(m) }
func (*UnregisterInstanceRequest) ProtoMessage()               {}
func (*UnregisterInstanceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{54} }

func (m *UnregisterInstanceRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *UnregisterInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

type UnregisterInstanceResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
}

func (m *UnregisterInstanceResponse) Reset()                    { *m = UnregisterInstanceResponse{} }
func (m *UnregisterInstanceResponse) String() string            { return proto1.CompactTextString(m) }
func (*UnregisterInstanceResponse) ProtoMessage()               {}
func (*UnregisterInstanceResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{55} }

func (m *UnregisterInstanceResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

type HeartbeatRequest struct {
	ServiceId  string `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	InstanceId string `protobuf:"bytes,2,opt,name=instanceId" json:"instanceId,omitempty"`
}

func (m *HeartbeatRequest) Reset()                    { *m = HeartbeatRequest{} }
func (m *HeartbeatRequest) String() string            { return proto1.CompactTextString(m) }
func (*HeartbeatRequest) ProtoMessage()               {}
func (*HeartbeatRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{56} }

func (m *HeartbeatRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *HeartbeatRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

type HeartbeatResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
}

func (m *HeartbeatResponse) Reset()                    { *m = HeartbeatResponse{} }
func (m *HeartbeatResponse) String() string            { return proto1.CompactTextString(m) }
func (*HeartbeatResponse) ProtoMessage()               {}
func (*HeartbeatResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{57} }

func (m *HeartbeatResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

type FindInstancesRequest struct {
	ConsumerServiceId string   `protobuf:"bytes,1,opt,name=consumerServiceId" json:"consumerServiceId,omitempty"`
	AppId             string   `protobuf:"bytes,2,opt,name=appId" json:"appId,omitempty"`
	ServiceName       string   `protobuf:"bytes,3,opt,name=serviceName" json:"serviceName,omitempty"`
	VersionRule       string   `protobuf:"bytes,4,opt,name=versionRule" json:"versionRule,omitempty"`
	Tags              []string `protobuf:"bytes,5,rep,name=tags" json:"tags,omitempty"`
	Environment       string   `protobuf:"bytes,6,opt,name=environment" json:"environment,omitempty"`
}

func (m *FindInstancesRequest) Reset()                    { *m = FindInstancesRequest{} }
func (m *FindInstancesRequest) String() string            { return proto1.CompactTextString(m) }
func (*FindInstancesRequest) ProtoMessage()               {}
func (*FindInstancesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{58} }

func (m *FindInstancesRequest) GetConsumerServiceId() string {
	if m != nil {
		return m.ConsumerServiceId
	}
	return ""
}

func (m *FindInstancesRequest) GetAppId() string {
	if m != nil {
		return m.AppId
	}
	return ""
}

func (m *FindInstancesRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *FindInstancesRequest) GetVersionRule() string {
	if m != nil {
		return m.VersionRule
	}
	return ""
}

func (m *FindInstancesRequest) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *FindInstancesRequest) GetEnvironment() string {
	if m != nil {
		return m.Environment
	}
	return ""
}

type FindInstancesResponse struct {
	Response  *Response               `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	Instances []*MicroServiceInstance `protobuf:"bytes,2,rep,name=instances" json:"instances,omitempty"`
}

func (m *FindInstancesResponse) Reset()                    { *m = FindInstancesResponse{} }
func (m *FindInstancesResponse) String() string            { return proto1.CompactTextString(m) }
func (*FindInstancesResponse) ProtoMessage()               {}
func (*FindInstancesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{59} }

func (m *FindInstancesResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *FindInstancesResponse) GetInstances() []*MicroServiceInstance {
	if m != nil {
		return m.Instances
	}
	return nil
}

type GetOneInstanceRequest struct {
	ConsumerServiceId  string   `protobuf:"bytes,1,opt,name=consumerServiceId" json:"consumerServiceId,omitempty"`
	ProviderServiceId  string   `protobuf:"bytes,2,opt,name=providerServiceId" json:"providerServiceId,omitempty"`
	ProviderInstanceId string   `protobuf:"bytes,3,opt,name=providerInstanceId" json:"providerInstanceId,omitempty"`
	Tags               []string `protobuf:"bytes,4,rep,name=tags" json:"tags,omitempty"`
}

func (m *GetOneInstanceRequest) Reset()                    { *m = GetOneInstanceRequest{} }
func (m *GetOneInstanceRequest) String() string            { return proto1.CompactTextString(m) }
func (*GetOneInstanceRequest) ProtoMessage()               {}
func (*GetOneInstanceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{60} }

func (m *GetOneInstanceRequest) GetConsumerServiceId() string {
	if m != nil {
		return m.ConsumerServiceId
	}
	return ""
}

func (m *GetOneInstanceRequest) GetProviderServiceId() string {
	if m != nil {
		return m.ProviderServiceId
	}
	return ""
}

func (m *GetOneInstanceRequest) GetProviderInstanceId() string {
	if m != nil {
		return m.ProviderInstanceId
	}
	return ""
}

func (m *GetOneInstanceRequest) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

type GetOneInstanceResponse struct {
	Response *Response             `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	Instance *MicroServiceInstance `protobuf:"bytes,2,opt,name=instance" json:"instance,omitempty"`
}

func (m *GetOneInstanceResponse) Reset()                    { *m = GetOneInstanceResponse{} }
func (m *GetOneInstanceResponse) String() string            { return proto1.CompactTextString(m) }
func (*GetOneInstanceResponse) ProtoMessage()               {}
func (*GetOneInstanceResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{61} }

func (m *GetOneInstanceResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *GetOneInstanceResponse) GetInstance() *MicroServiceInstance {
	if m != nil {
		return m.Instance
	}
	return nil
}

type GetInstancesRequest struct {
	ConsumerServiceId string   `protobuf:"bytes,1,opt,name=consumerServiceId" json:"consumerServiceId,omitempty"`
	ProviderServiceId string   `protobuf:"bytes,2,opt,name=providerServiceId" json:"providerServiceId,omitempty"`
	Tags              []string `protobuf:"bytes,3,rep,name=tags" json:"tags,omitempty"`
}

func (m *GetInstancesRequest) Reset()                    { *m = GetInstancesRequest{} }
func (m *GetInstancesRequest) String() string            { return proto1.CompactTextString(m) }
func (*GetInstancesRequest) ProtoMessage()               {}
func (*GetInstancesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{62} }

func (m *GetInstancesRequest) GetConsumerServiceId() string {
	if m != nil {
		return m.ConsumerServiceId
	}
	return ""
}

func (m *GetInstancesRequest) GetProviderServiceId() string {
	if m != nil {
		return m.ProviderServiceId
	}
	return ""
}

func (m *GetInstancesRequest) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

type GetInstancesResponse struct {
	Response  *Response               `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	Instances []*MicroServiceInstance `protobuf:"bytes,2,rep,name=instances" json:"instances,omitempty"`
}

func (m *GetInstancesResponse) Reset()                    { *m = GetInstancesResponse{} }
func (m *GetInstancesResponse) String() string            { return proto1.CompactTextString(m) }
func (*GetInstancesResponse) ProtoMessage()               {}
func (*GetInstancesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{63} }

func (m *GetInstancesResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *GetInstancesResponse) GetInstances() []*MicroServiceInstance {
	if m != nil {
		return m.Instances
	}
	return nil
}

type UpdateInstanceStatusRequest struct {
	ServiceId  string `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	InstanceId string `protobuf:"bytes,2,opt,name=instanceId" json:"instanceId,omitempty"`
	Status     string `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
}

func (m *UpdateInstanceStatusRequest) Reset()                    { *m = UpdateInstanceStatusRequest{} }
func (m *UpdateInstanceStatusRequest) String() string            { return proto1.CompactTextString(m) }
func (*UpdateInstanceStatusRequest) ProtoMessage()               {}
func (*UpdateInstanceStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{64} }

func (m *UpdateInstanceStatusRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *UpdateInstanceStatusRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *UpdateInstanceStatusRequest) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

type UpdateInstanceStatusResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
}

func (m *UpdateInstanceStatusResponse) Reset()                    { *m = UpdateInstanceStatusResponse{} }
func (m *UpdateInstanceStatusResponse) String() string            { return proto1.CompactTextString(m) }
func (*UpdateInstanceStatusResponse) ProtoMessage()               {}
func (*UpdateInstanceStatusResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{65} }

func (m *UpdateInstanceStatusResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

type UpdateInstancePropsRequest struct {
	ServiceId  string            `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	InstanceId string            `protobuf:"bytes,2,opt,name=instanceId" json:"instanceId,omitempty"`
	Properties map[string]string `protobuf:"bytes,3,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *UpdateInstancePropsRequest) Reset()                    { *m = UpdateInstancePropsRequest{} }
func (m *UpdateInstancePropsRequest) String() string            { return proto1.CompactTextString(m) }
func (*UpdateInstancePropsRequest) ProtoMessage()               {}
func (*UpdateInstancePropsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{66} }

func (m *UpdateInstancePropsRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *UpdateInstancePropsRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *UpdateInstancePropsRequest) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

type UpdateInstancePropsResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
}

func (m *UpdateInstancePropsResponse) Reset()                    { *m = UpdateInstancePropsResponse{} }
func (m *UpdateInstancePropsResponse) String() string            { return proto1.CompactTextString(m) }
func (*UpdateInstancePropsResponse) ProtoMessage()               {}
func (*UpdateInstancePropsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{67} }

func (m *UpdateInstancePropsResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

type WatchInstanceRequest struct {
	SelfServiceId string `protobuf:"bytes,1,opt,name=selfServiceId" json:"selfServiceId,omitempty"`
}

func (m *WatchInstanceRequest) Reset()                    { *m = WatchInstanceRequest{} }
func (m *WatchInstanceRequest) String() string            { return proto1.CompactTextString(m) }
func (*WatchInstanceRequest) ProtoMessage()               {}
func (*WatchInstanceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{68} }

func (m *WatchInstanceRequest) GetSelfServiceId() string {
	if m != nil {
		return m.SelfServiceId
	}
	return ""
}

type WatchInstanceResponse struct {
	Response *Response             `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	Action   string                `protobuf:"bytes,2,opt,name=action" json:"action,omitempty"`
	Key      *MicroServiceKey      `protobuf:"bytes,3,opt,name=key" json:"key,omitempty"`
	Instance *MicroServiceInstance `protobuf:"bytes,4,opt,name=instance" json:"instance,omitempty"`
}

func (m *WatchInstanceResponse) Reset()                    { *m = WatchInstanceResponse{} }
func (m *WatchInstanceResponse) String() string            { return proto1.CompactTextString(m) }
func (*WatchInstanceResponse) ProtoMessage()               {}
func (*WatchInstanceResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{69} }

func (m *WatchInstanceResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *WatchInstanceResponse) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

func (m *WatchInstanceResponse) GetKey() *MicroServiceKey {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *WatchInstanceResponse) GetInstance() *MicroServiceInstance {
	if m != nil {
		return m.Instance
	}
	return nil
}

type GetSchemaRequest struct {
	ServiceId string `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	SchemaId  string `protobuf:"bytes,2,opt,name=schemaId" json:"schemaId,omitempty"`
}

func (m *GetSchemaRequest) Reset()                    { *m = GetSchemaRequest{} }
func (m *GetSchemaRequest) String() string            { return proto1.CompactTextString(m) }
func (*GetSchemaRequest) ProtoMessage()               {}
func (*GetSchemaRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{70} }

func (m *GetSchemaRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *GetSchemaRequest) GetSchemaId() string {
	if m != nil {
		return m.SchemaId
	}
	return ""
}

type GetAllSchemaRequest struct {
	ServiceId  string `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	WithSchema bool   `protobuf:"varint,2,opt,name=withSchema" json:"withSchema,omitempty"`
}

func (m *GetAllSchemaRequest) Reset()                    { *m = GetAllSchemaRequest{} }
func (m *GetAllSchemaRequest) String() string            { return proto1.CompactTextString(m) }
func (*GetAllSchemaRequest) ProtoMessage()               {}
func (*GetAllSchemaRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{71} }

func (m *GetAllSchemaRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *GetAllSchemaRequest) GetWithSchema() bool {
	if m != nil {
		return m.WithSchema
	}
	return false
}

type GetSchemaResponse struct {
	Response      *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	Schema        string    `protobuf:"bytes,2,opt,name=schema" json:"schema,omitempty"`
	SchemaSummary string    `protobuf:"bytes,3,opt,name=schemaSummary" json:"schemaSummary,omitempty"`
}

func (m *GetSchemaResponse) Reset()                    { *m = GetSchemaResponse{} }
func (m *GetSchemaResponse) String() string            { return proto1.CompactTextString(m) }
func (*GetSchemaResponse) ProtoMessage()               {}
func (*GetSchemaResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{72} }

func (m *GetSchemaResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *GetSchemaResponse) GetSchema() string {
	if m != nil {
		return m.Schema
	}
	return ""
}

func (m *GetSchemaResponse) GetSchemaSummary() string {
	if m != nil {
		return m.SchemaSummary
	}
	return ""
}

type GetAllSchemaResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	Schemas  []*Schema `protobuf:"bytes,2,rep,name=schemas" json:"schemas,omitempty"`
}

func (m *GetAllSchemaResponse) Reset()                    { *m = GetAllSchemaResponse{} }
func (m *GetAllSchemaResponse) String() string            { return proto1.CompactTextString(m) }
func (*GetAllSchemaResponse) ProtoMessage()               {}
func (*GetAllSchemaResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{73} }

func (m *GetAllSchemaResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *GetAllSchemaResponse) GetSchemas() []*Schema {
	if m != nil {
		return m.Schemas
	}
	return nil
}

type DeleteSchemaRequest struct {
	ServiceId string `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	SchemaId  string `protobuf:"bytes,2,opt,name=schemaId" json:"schemaId,omitempty"`
}

func (m *DeleteSchemaRequest) Reset()                    { *m = DeleteSchemaRequest{} }
func (m *DeleteSchemaRequest) String() string            { return proto1.CompactTextString(m) }
func (*DeleteSchemaRequest) ProtoMessage()               {}
func (*DeleteSchemaRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{74} }

func (m *DeleteSchemaRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *DeleteSchemaRequest) GetSchemaId() string {
	if m != nil {
		return m.SchemaId
	}
	return ""
}

type DeleteSchemaResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
}

func (m *DeleteSchemaResponse) Reset()                    { *m = DeleteSchemaResponse{} }
func (m *DeleteSchemaResponse) String() string            { return proto1.CompactTextString(m) }
func (*DeleteSchemaResponse) ProtoMessage()               {}
func (*DeleteSchemaResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{75} }

func (m *DeleteSchemaResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

type ModifySchemaRequest struct {
	ServiceId string `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	SchemaId  string `protobuf:"bytes,2,opt,name=schemaId" json:"schemaId,omitempty"`
	Schema    string `protobuf:"bytes,3,opt,name=schema" json:"schema,omitempty"`
	Summary   string `protobuf:"bytes,4,opt,name=summary" json:"summary,omitempty"`
}

func (m *ModifySchemaRequest) Reset()                    { *m = ModifySchemaRequest{} }
func (m *ModifySchemaRequest) String() string            { return proto1.CompactTextString(m) }
func (*ModifySchemaRequest) ProtoMessage()               {}
func (*ModifySchemaRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{76} }

func (m *ModifySchemaRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *ModifySchemaRequest) GetSchemaId() string {
	if m != nil {
		return m.SchemaId
	}
	return ""
}

func (m *ModifySchemaRequest) GetSchema() string {
	if m != nil {
		return m.Schema
	}
	return ""
}

func (m *ModifySchemaRequest) GetSummary() string {
	if m != nil {
		return m.Summary
	}
	return ""
}

type ModifySchemaResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
}

func (m *ModifySchemaResponse) Reset()                    { *m = ModifySchemaResponse{} }
func (m *ModifySchemaResponse) String() string            { return proto1.CompactTextString(m) }
func (*ModifySchemaResponse) ProtoMessage()               {}
func (*ModifySchemaResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{77} }

func (m *ModifySchemaResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

type AddDependenciesRequest struct {
	Dependencies []*ConsumerDependency `protobuf:"bytes,1,rep,name=dependencies" json:"dependencies,omitempty"`
}

func (m *AddDependenciesRequest) Reset()                    { *m = AddDependenciesRequest{} }
func (m *AddDependenciesRequest) String() string            { return proto1.CompactTextString(m) }
func (*AddDependenciesRequest) ProtoMessage()               {}
func (*AddDependenciesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{78} }

func (m *AddDependenciesRequest) GetDependencies() []*ConsumerDependency {
	if m != nil {
		return m.Dependencies
	}
	return nil
}

type AddDependenciesResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
}

func (m *AddDependenciesResponse) Reset()                    { *m = AddDependenciesResponse{} }
func (m *AddDependenciesResponse) String() string            { return proto1.CompactTextString(m) }
func (*AddDependenciesResponse) ProtoMessage()               {}
func (*AddDependenciesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{79} }

func (m *AddDependenciesResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

type CreateDependenciesRequest struct {
	Dependencies []*ConsumerDependency `protobuf:"bytes,1,rep,name=dependencies" json:"dependencies,omitempty"`
}

func (m *CreateDependenciesRequest) Reset()                    { *m = CreateDependenciesRequest{} }
func (m *CreateDependenciesRequest) String() string            { return proto1.CompactTextString(m) }
func (*CreateDependenciesRequest) ProtoMessage()               {}
func (*CreateDependenciesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{80} }

func (m *CreateDependenciesRequest) GetDependencies() []*ConsumerDependency {
	if m != nil {
		return m.Dependencies
	}
	return nil
}

type ConsumerDependency struct {
	Consumer  *MicroServiceKey   `protobuf:"bytes,1,opt,name=consumer" json:"consumer,omitempty"`
	Providers []*MicroServiceKey `protobuf:"bytes,2,rep,name=providers" json:"providers,omitempty"`
	Override  bool               `protobuf:"varint,3,opt,name=override" json:"override,omitempty"`
}

func (m *ConsumerDependency) Reset()                    { *m = ConsumerDependency{} }
func (m *ConsumerDependency) String() string            { return proto1.CompactTextString(m) }
func (*ConsumerDependency) ProtoMessage()               {}
func (*ConsumerDependency) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{81} }

func (m *ConsumerDependency) GetConsumer() *MicroServiceKey {
	if m != nil {
		return m.Consumer
	}
	return nil
}

func (m *ConsumerDependency) GetProviders() []*MicroServiceKey {
	if m != nil {
		return m.Providers
	}
	return nil
}

func (m *ConsumerDependency) GetOverride() bool {
	if m != nil {
		return m.Override
	}
	return false
}

type CreateDependenciesResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
}

func (m *CreateDependenciesResponse) Reset()                    { *m = CreateDependenciesResponse{} }
func (m *CreateDependenciesResponse) String() string            { return proto1.CompactTextString(m) }
func (*CreateDependenciesResponse) ProtoMessage()               {}
func (*CreateDependenciesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{82} }

func (m *CreateDependenciesResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

type GetDependenciesRequest struct {
	ServiceId  string `protobuf:"bytes,1,opt,name=serviceId" json:"serviceId,omitempty"`
	SameDomain bool   `protobuf:"varint,2,opt,name=sameDomain" json:"sameDomain,omitempty"`
	NoSelf     bool   `protobuf:"varint,3,opt,name=noSelf" json:"noSelf,omitempty"`
}

func (m *GetDependenciesRequest) Reset()                    { *m = GetDependenciesRequest{} }
func (m *GetDependenciesRequest) String() string            { return proto1.CompactTextString(m) }
func (*GetDependenciesRequest) ProtoMessage()               {}
func (*GetDependenciesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{83} }

func (m *GetDependenciesRequest) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *GetDependenciesRequest) GetSameDomain() bool {
	if m != nil {
		return m.SameDomain
	}
	return false
}

func (m *GetDependenciesRequest) GetNoSelf() bool {
	if m != nil {
		return m.NoSelf
	}
	return false
}

type GetConDependenciesResponse struct {
	Response  *Response       `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	Providers []*MicroService `protobuf:"bytes,2,rep,name=providers" json:"providers,omitempty"`
}

func (m *GetConDependenciesResponse) Reset()                    { *m = GetConDependenciesResponse{} }
func (m *GetConDependenciesResponse) String() string            { return proto1.CompactTextString(m) }
func (*GetConDependenciesResponse) ProtoMessage()               {}
func (*GetConDependenciesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{84} }

func (m *GetConDependenciesResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *GetConDependenciesResponse) GetProviders() []*MicroService {
	if m != nil {
		return m.Providers
	}
	return nil
}

type GetProDependenciesResponse struct {
	Response  *Response       `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	Consumers []*MicroService `protobuf:"bytes,2,rep,name=consumers" json:"consumers,omitempty"`
}

func (m *GetProDependenciesResponse) Reset()                    { *m = GetProDependenciesResponse{} }
func (m *GetProDependenciesResponse) String() string            { return proto1.CompactTextString(m) }
func (*GetProDependenciesResponse) ProtoMessage()               {}
func (*GetProDependenciesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{85} }

func (m *GetProDependenciesResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *GetProDependenciesResponse) GetConsumers() []*MicroService {
	if m != nil {
		return m.Consumers
	}
	return nil
}

// 服务详情
type ServiceDetail struct {
	MicroService         *MicroService           `protobuf:"bytes,1,opt,name=microService" json:"microService,omitempty"`
	Instances            []*MicroServiceInstance `protobuf:"bytes,2,rep,name=instances" json:"instances,omitempty"`
	SchemaInfos          []*Schema               `protobuf:"bytes,3,rep,name=schemaInfos" json:"schemaInfos,omitempty"`
	Rules                []*ServiceRule          `protobuf:"bytes,4,rep,name=rules" json:"rules,omitempty"`
	Providers            []*MicroService         `protobuf:"bytes,5,rep,name=providers" json:"providers,omitempty"`
	Consumers            []*MicroService         `protobuf:"bytes,6,rep,name=consumers" json:"consumers,omitempty"`
	Tags                 map[string]string       `protobuf:"bytes,7,rep,name=tags" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	MicroServiceVersions []string                `protobuf:"bytes,8,rep,name=microServiceVersions" json:"microServiceVersions,omitempty"`
	Statics              *Statistics             `protobuf:"bytes,9,opt,name=statics" json:"statics,omitempty"`
}

func (m *ServiceDetail) Reset()                    { *m = ServiceDetail{} }
func (m *ServiceDetail) String() string            { return proto1.CompactTextString(m) }
func (*ServiceDetail) ProtoMessage()               {}
func (*ServiceDetail) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{86} }

func (m *ServiceDetail) GetMicroService() *MicroService {
	if m != nil {
		return m.MicroService
	}
	return nil
}

func (m *ServiceDetail) GetInstances() []*MicroServiceInstance {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *ServiceDetail) GetSchemaInfos() []*Schema {
	if m != nil {
		return m.SchemaInfos
	}
	return nil
}

func (m *ServiceDetail) GetRules() []*ServiceRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

func (m *ServiceDetail) GetProviders() []*MicroService {
	if m != nil {
		return m.Providers
	}
	return nil
}

func (m *ServiceDetail) GetConsumers() []*MicroService {
	if m != nil {
		return m.Consumers
	}
	return nil
}

func (m *ServiceDetail) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *ServiceDetail) GetMicroServiceVersions() []string {
	if m != nil {
		return m.MicroServiceVersions
	}
	return nil
}

func (m *ServiceDetail) GetStatics() *Statistics {
	if m != nil {
		return m.Statics
	}
	return nil
}

// 服务详情返回信息
type GetServiceDetailResponse struct {
	Response *Response      `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	Service  *ServiceDetail `protobuf:"bytes,2,opt,name=service" json:"service,omitempty"`
}

func (m *GetServiceDetailResponse) Reset()                    { *m = GetServiceDetailResponse{} }
func (m *GetServiceDetailResponse) String() string            { return proto1.CompactTextString(m) }
func (*GetServiceDetailResponse) ProtoMessage()               {}
func (*GetServiceDetailResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{87} }

func (m *GetServiceDetailResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *GetServiceDetailResponse) GetService() *ServiceDetail {
	if m != nil {
		return m.Service
	}
	return nil
}

// 删除服务请求
type DelServicesRequest struct {
	ServiceIds []string `protobuf:"bytes,1,rep,name=serviceIds" json:"serviceIds,omitempty"`
	Force      bool     `protobuf:"varint,2,opt,name=force" json:"force,omitempty"`
}

func (m *DelServicesRequest) Reset()                    { *m = DelServicesRequest{} }
func (m *DelServicesRequest) String() string            { return proto1.CompactTextString(m) }
func (*DelServicesRequest) ProtoMessage()               {}
func (*DelServicesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{88} }

func (m *DelServicesRequest) GetServiceIds() []string {
	if m != nil {
		return m.ServiceIds
	}
	return nil
}

func (m *DelServicesRequest) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

// 删除服务响应内容
type DelServicesRspInfo struct {
	ErrMessage string `protobuf:"bytes,1,opt,name=errMessage" json:"errMessage,omitempty"`
	ServiceId  string `protobuf:"bytes,2,opt,name=serviceId" json:"serviceId,omitempty"`
}

func (m *DelServicesRspInfo) Reset()                    { *m = DelServicesRspInfo{} }
func (m *DelServicesRspInfo) String() string            { return proto1.CompactTextString(m) }
func (*DelServicesRspInfo) ProtoMessage()               {}
func (*DelServicesRspInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{89} }

func (m *DelServicesRspInfo) GetErrMessage() string {
	if m != nil {
		return m.ErrMessage
	}
	return ""
}

func (m *DelServicesRspInfo) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

// 删除服务响应
type DelServicesResponse struct {
	Response *Response             `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	Services []*DelServicesRspInfo `protobuf:"bytes,2,rep,name=services" json:"services,omitempty"`
}

func (m *DelServicesResponse) Reset()                    { *m = DelServicesResponse{} }
func (m *DelServicesResponse) String() string            { return proto1.CompactTextString(m) }
func (*DelServicesResponse) ProtoMessage()               {}
func (*DelServicesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{90} }

func (m *DelServicesResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *DelServicesResponse) GetServices() []*DelServicesRspInfo {
	if m != nil {
		return m.Services
	}
	return nil
}

type GetAppsRequest struct {
	Environment string `protobuf:"bytes,1,opt,name=environment" json:"environment,omitempty"`
	WithShared  bool   `protobuf:"varint,2,opt,name=withShared" json:"withShared,omitempty"`
}

func (m *GetAppsRequest) Reset()                    { *m = GetAppsRequest{} }
func (m *GetAppsRequest) String() string            { return proto1.CompactTextString(m) }
func (*GetAppsRequest) ProtoMessage()               {}
func (*GetAppsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{91} }

func (m *GetAppsRequest) GetEnvironment() string {
	if m != nil {
		return m.Environment
	}
	return ""
}

func (m *GetAppsRequest) GetWithShared() bool {
	if m != nil {
		return m.WithShared
	}
	return false
}

type GetAppsResponse struct {
	Response *Response `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	AppIds   []string  `protobuf:"bytes,2,rep,name=appIds" json:"appIds,omitempty"`
}

func (m *GetAppsResponse) Reset()                    { *m = GetAppsResponse{} }
func (m *GetAppsResponse) String() string            { return proto1.CompactTextString(m) }
func (*GetAppsResponse) ProtoMessage()               {}
func (*GetAppsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{92} }

func (m *GetAppsResponse) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *GetAppsResponse) GetAppIds() []string {
	if m != nil {
		return m.AppIds
	}
	return nil
}

func init() {
	proto1.RegisterType((*ModifySchemasRequest)(nil), "proto.ModifySchemasRequest")
	proto1.RegisterType((*Schema)(nil), "proto.Schema")
	proto1.RegisterType((*ModifySchemasResponse)(nil), "proto.ModifySchemasResponse")
	proto1.RegisterType((*HeartbeatSetRequest)(nil), "proto.HeartbeatSetRequest")
	proto1.RegisterType((*HeartbeatSetElement)(nil), "proto.HeartbeatSetElement")
	proto1.RegisterType((*HeartbeatSetResponse)(nil), "proto.HeartbeatSetResponse")
	proto1.RegisterType((*InstanceHbRst)(nil), "proto.InstanceHbRst")
	proto1.RegisterType((*StService)(nil), "proto.StService")
	proto1.RegisterType((*StInstance)(nil), "proto.StInstance")
	proto1.RegisterType((*StApp)(nil), "proto.StApp")
	proto1.RegisterType((*Statistics)(nil), "proto.Statistics")
	proto1.RegisterType((*GetServicesInfoRequest)(nil), "proto.GetServicesInfoRequest")
	proto1.RegisterType((*GetServicesInfoResponse)(nil), "proto.GetServicesInfoResponse")
	proto1.RegisterType((*MicroServiceKey)(nil), "proto.MicroServiceKey")
	proto1.RegisterType((*MicroService)(nil), "proto.MicroService")
	proto1.RegisterType((*FrameWorkProperty)(nil), "proto.FrameWorkProperty")
	proto1.RegisterType((*ServiceRule)(nil), "proto.ServiceRule")
	proto1.RegisterType((*AddOrUpdateServiceRule)(nil), "proto.AddOrUpdateServiceRule")
	proto1.RegisterType((*ServicePath)(nil), "proto.ServicePath")
	proto1.RegisterType((*Response)(nil), "proto.Response")
	proto1.RegisterType((*GetExistenceRequest)(nil), "proto.GetExistenceRequest")
	proto1.RegisterType((*GetExistenceResponse)(nil), "proto.GetExistenceResponse")
	proto1.RegisterType((*CreateServiceRequest)(nil), "proto.CreateServiceRequest")
	proto1.RegisterType((*CreateServiceResponse)(nil), "proto.CreateServiceResponse")
	proto1.RegisterType((*DeleteServiceRequest)(nil), "proto.DeleteServiceRequest")
	proto1.RegisterType((*DeleteServiceResponse)(nil), "proto.DeleteServiceResponse")
	proto1.RegisterType((*GetServiceRequest)(nil), "proto.GetServiceRequest")
	proto1.RegisterType((*GetServiceResponse)(nil), "proto.GetServiceResponse")
	proto1.RegisterType((*GetServicesRequest)(nil), "proto.GetServicesRequest")
	proto1.RegisterType((*GetServicesResponse)(nil), "proto.GetServicesResponse")
	proto1.RegisterType((*UpdateServicePropsRequest)(nil), "proto.UpdateServicePropsRequest")
	proto1.RegisterType((*UpdateServicePropsResponse)(nil), "proto.UpdateServicePropsResponse")
	proto1.RegisterType((*GetServiceRulesRequest)(nil), "proto.GetServiceRulesRequest")
	proto1.RegisterType((*GetServiceRulesResponse)(nil), "proto.GetServiceRulesResponse")
	proto1.RegisterType((*UpdateServiceRuleRequest)(nil), "proto.UpdateServiceRuleRequest")
	proto1.RegisterType((*UpdateServiceRuleResponse)(nil), "proto.UpdateServiceRuleResponse")
	proto1.RegisterType((*AddServiceRulesRequest)(nil), "proto.AddServiceRulesRequest")
	proto1.RegisterType((*AddServiceRulesResponse)(nil), "proto.AddServiceRulesResponse")
	proto1.RegisterType((*DeleteServiceRulesRequest)(nil), "proto.DeleteServiceRulesRequest")
	proto1.RegisterType((*DeleteServiceRulesResponse)(nil), "proto.DeleteServiceRulesResponse")
	proto1.RegisterType((*GetServiceTagsRequest)(nil), "proto.GetServiceTagsRequest")
	proto1.RegisterType((*GetServiceTagsResponse)(nil), "proto.GetServiceTagsResponse")
	proto1.RegisterType((*UpdateServiceTagRequest)(nil), "proto.UpdateServiceTagRequest")
	proto1.RegisterType((*UpdateServiceTagResponse)(nil), "proto.UpdateServiceTagResponse")
	proto1.RegisterType((*AddServiceTagsRequest)(nil), "proto.AddServiceTagsRequest")
	proto1.RegisterType((*AddServiceTagsResponse)(nil), "proto.AddServiceTagsResponse")
	proto1.RegisterType((*DeleteServiceTagsRequest)(nil), "proto.DeleteServiceTagsRequest")
	proto1.RegisterType((*DeleteServiceTagsResponse)(nil), "proto.DeleteServiceTagsResponse")
	proto1.RegisterType((*HealthCheck)(nil), "proto.HealthCheck")
	proto1.RegisterType((*MicroServiceInstance)(nil), "proto.MicroServiceInstance")
	proto1.RegisterType((*DataCenterInfo)(nil), "proto.DataCenterInfo")
	proto1.RegisterType((*MicroServiceInstanceKey)(nil), "proto.MicroServiceInstanceKey")
	proto1.RegisterType((*RegisterInstanceRequest)(nil), "proto.RegisterInstanceRequest")
	proto1.RegisterType((*RegisterInstanceResponse)(nil), "proto.RegisterInstanceResponse")
	proto1.RegisterType((*UnregisterInstanceRequest)(nil), "proto.UnregisterInstanceRequest")
	proto1.RegisterType((*UnregisterInstanceResponse)(nil), "proto.UnregisterInstanceResponse")
	proto1.RegisterType((*HeartbeatRequest)(nil), "proto.HeartbeatRequest")
	proto1.RegisterType((*HeartbeatResponse)(nil), "proto.HeartbeatResponse")
	proto1.RegisterType((*FindInstancesRequest)(nil), "proto.FindInstancesRequest")
	proto1.RegisterType((*FindInstancesResponse)(nil), "proto.FindInstancesResponse")
	proto1.RegisterType((*GetOneInstanceRequest)(nil), "proto.GetOneInstanceRequest")
	proto1.RegisterType((*GetOneInstanceResponse)(nil), "proto.GetOneInstanceResponse")
	proto1.RegisterType((*GetInstancesRequest)(nil), "proto.GetInstancesRequest")
	proto1.RegisterType((*GetInstancesResponse)(nil), "proto.GetInstancesResponse")
	proto1.RegisterType((*UpdateInstanceStatusRequest)(nil), "proto.UpdateInstanceStatusRequest")
	proto1.RegisterType((*UpdateInstanceStatusResponse)(nil), "proto.UpdateInstanceStatusResponse")
	proto1.RegisterType((*UpdateInstancePropsRequest)(nil), "proto.UpdateInstancePropsRequest")
	proto1.RegisterType((*UpdateInstancePropsResponse)(nil), "proto.UpdateInstancePropsResponse")
	proto1.RegisterType((*WatchInstanceRequest)(nil), "proto.WatchInstanceRequest")
	proto1.RegisterType((*WatchInstanceResponse)(nil), "proto.WatchInstanceResponse")
	proto1.RegisterType((*GetSchemaRequest)(nil), "proto.GetSchemaRequest")
	proto1.RegisterType((*GetAllSchemaRequest)(nil), "proto.GetAllSchemaRequest")
	proto1.RegisterType((*GetSchemaResponse)(nil), "proto.GetSchemaResponse")
	proto1.RegisterType((*GetAllSchemaResponse)(nil), "proto.GetAllSchemaResponse")
	proto1.RegisterType((*DeleteSchemaRequest)(nil), "proto.DeleteSchemaRequest")
	proto1.RegisterType((*DeleteSchemaResponse)(nil), "proto.DeleteSchemaResponse")
	proto1.RegisterType((*ModifySchemaRequest)(nil), "proto.ModifySchemaRequest")
	proto1.RegisterType((*ModifySchemaResponse)(nil), "proto.ModifySchemaResponse")
	proto1.RegisterType((*AddDependenciesRequest)(nil), "proto.AddDependenciesRequest")
	proto1.RegisterType((*AddDependenciesResponse)(nil), "proto.AddDependenciesResponse")
	proto1.RegisterType((*CreateDependenciesRequest)(nil), "proto.CreateDependenciesRequest")
	proto1.RegisterType((*ConsumerDependency)(nil), "proto.ConsumerDependency")
	proto1.RegisterType((*CreateDependenciesResponse)(nil), "proto.CreateDependenciesResponse")
	proto1.RegisterType((*GetDependenciesRequest)(nil), "proto.GetDependenciesRequest")
	proto1.RegisterType((*GetConDependenciesResponse)(nil), "proto.GetConDependenciesResponse")
	proto1.RegisterType((*GetProDependenciesResponse)(nil), "proto.GetProDependenciesResponse")
	proto1.RegisterType((*ServiceDetail)(nil), "proto.ServiceDetail")
	proto1.RegisterType((*GetServiceDetailResponse)(nil), "proto.GetServiceDetailResponse")
	proto1.RegisterType((*DelServicesRequest)(nil), "proto.DelServicesRequest")
	proto1.RegisterType((*DelServicesRspInfo)(nil), "proto.DelServicesRspInfo")
	proto1.RegisterType((*DelServicesResponse)(nil), "proto.DelServicesResponse")
	proto1.RegisterType((*GetAppsRequest)(nil), "proto.GetAppsRequest")
	proto1.RegisterType((*GetAppsResponse)(nil), "proto.GetAppsResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ServiceCtrl service

type ServiceCtrlClient interface {
	Exist(ctx context.Context, in *GetExistenceRequest, opts ...grpc.CallOption) (*GetExistenceResponse, error)
	Create(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*CreateServiceResponse, error)
	Delete(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*DeleteServiceResponse, error)
	GetOne(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*GetServiceResponse, error)
	GetServices(ctx context.Context, in *GetServicesRequest, opts ...grpc.CallOption) (*GetServicesResponse, error)
	UpdateProperties(ctx context.Context, in *UpdateServicePropsRequest, opts ...grpc.CallOption) (*UpdateServicePropsResponse, error)
	AddRule(ctx context.Context, in *AddServiceRulesRequest, opts ...grpc.CallOption) (*AddServiceRulesResponse, error)
	GetRule(ctx context.Context, in *GetServiceRulesRequest, opts ...grpc.CallOption) (*GetServiceRulesResponse, error)
	UpdateRule(ctx context.Context, in *UpdateServiceRuleRequest, opts ...grpc.CallOption) (*UpdateServiceRuleResponse, error)
	DeleteRule(ctx context.Context, in *DeleteServiceRulesRequest, opts ...grpc.CallOption) (*DeleteServiceRulesResponse, error)
	AddTags(ctx context.Context, in *AddServiceTagsRequest, opts ...grpc.CallOption) (*AddServiceTagsResponse, error)
	GetTags(ctx context.Context, in *GetServiceTagsRequest, opts ...grpc.CallOption) (*GetServiceTagsResponse, error)
	UpdateTag(ctx context.Context, in *UpdateServiceTagRequest, opts ...grpc.CallOption) (*UpdateServiceTagResponse, error)
	DeleteTags(ctx context.Context, in *DeleteServiceTagsRequest, opts ...grpc.CallOption) (*DeleteServiceTagsResponse, error)
	GetSchemaInfo(ctx context.Context, in *GetSchemaRequest, opts ...grpc.CallOption) (*GetSchemaResponse, error)
	GetAllSchemaInfo(ctx context.Context, in *GetAllSchemaRequest, opts ...grpc.CallOption) (*GetAllSchemaResponse, error)
	DeleteSchema(ctx context.Context, in *DeleteSchemaRequest, opts ...grpc.CallOption) (*DeleteSchemaResponse, error)
	ModifySchema(ctx context.Context, in *ModifySchemaRequest, opts ...grpc.CallOption) (*ModifySchemaResponse, error)
	ModifySchemas(ctx context.Context, in *ModifySchemasRequest, opts ...grpc.CallOption) (*ModifySchemasResponse, error)
	AddDependenciesForMicroServices(ctx context.Context, in *AddDependenciesRequest, opts ...grpc.CallOption) (*AddDependenciesResponse, error)
	CreateDependenciesForMicroServices(ctx context.Context, in *CreateDependenciesRequest, opts ...grpc.CallOption) (*CreateDependenciesResponse, error)
	GetProviderDependencies(ctx context.Context, in *GetDependenciesRequest, opts ...grpc.CallOption) (*GetProDependenciesResponse, error)
	GetConsumerDependencies(ctx context.Context, in *GetDependenciesRequest, opts ...grpc.CallOption) (*GetConDependenciesResponse, error)
	DeleteServices(ctx context.Context, in *DelServicesRequest, opts ...grpc.CallOption) (*DelServicesResponse, error)
}

type serviceCtrlClient struct {
	cc *grpc.ClientConn
}

func NewServiceCtrlClient(cc *grpc.ClientConn) ServiceCtrlClient {
	return &serviceCtrlClient{cc}
}

func (c *serviceCtrlClient) Exist(ctx context.Context, in *GetExistenceRequest, opts ...grpc.CallOption) (*GetExistenceResponse, error) {
	out := new(GetExistenceResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/exist", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) Create(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*CreateServiceResponse, error) {
	out := new(CreateServiceResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/create", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) Delete(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*DeleteServiceResponse, error) {
	out := new(DeleteServiceResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/delete", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) GetOne(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*GetServiceResponse, error) {
	out := new(GetServiceResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/getOne", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) GetServices(ctx context.Context, in *GetServicesRequest, opts ...grpc.CallOption) (*GetServicesResponse, error) {
	out := new(GetServicesResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/getServices", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) UpdateProperties(ctx context.Context, in *UpdateServicePropsRequest, opts ...grpc.CallOption) (*UpdateServicePropsResponse, error) {
	out := new(UpdateServicePropsResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/updateProperties", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) AddRule(ctx context.Context, in *AddServiceRulesRequest, opts ...grpc.CallOption) (*AddServiceRulesResponse, error) {
	out := new(AddServiceRulesResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/addRule", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) GetRule(ctx context.Context, in *GetServiceRulesRequest, opts ...grpc.CallOption) (*GetServiceRulesResponse, error) {
	out := new(GetServiceRulesResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/getRule", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) UpdateRule(ctx context.Context, in *UpdateServiceRuleRequest, opts ...grpc.CallOption) (*UpdateServiceRuleResponse, error) {
	out := new(UpdateServiceRuleResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/updateRule", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) DeleteRule(ctx context.Context, in *DeleteServiceRulesRequest, opts ...grpc.CallOption) (*DeleteServiceRulesResponse, error) {
	out := new(DeleteServiceRulesResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/deleteRule", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) AddTags(ctx context.Context, in *AddServiceTagsRequest, opts ...grpc.CallOption) (*AddServiceTagsResponse, error) {
	out := new(AddServiceTagsResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/addTags", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) GetTags(ctx context.Context, in *GetServiceTagsRequest, opts ...grpc.CallOption) (*GetServiceTagsResponse, error) {
	out := new(GetServiceTagsResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/getTags", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) UpdateTag(ctx context.Context, in *UpdateServiceTagRequest, opts ...grpc.CallOption) (*UpdateServiceTagResponse, error) {
	out := new(UpdateServiceTagResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/updateTag", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) DeleteTags(ctx context.Context, in *DeleteServiceTagsRequest, opts ...grpc.CallOption) (*DeleteServiceTagsResponse, error) {
	out := new(DeleteServiceTagsResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/deleteTags", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) GetSchemaInfo(ctx context.Context, in *GetSchemaRequest, opts ...grpc.CallOption) (*GetSchemaResponse, error) {
	out := new(GetSchemaResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/getSchemaInfo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) GetAllSchemaInfo(ctx context.Context, in *GetAllSchemaRequest, opts ...grpc.CallOption) (*GetAllSchemaResponse, error) {
	out := new(GetAllSchemaResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/getAllSchemaInfo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) DeleteSchema(ctx context.Context, in *DeleteSchemaRequest, opts ...grpc.CallOption) (*DeleteSchemaResponse, error) {
	out := new(DeleteSchemaResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/deleteSchema", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) ModifySchema(ctx context.Context, in *ModifySchemaRequest, opts ...grpc.CallOption) (*ModifySchemaResponse, error) {
	out := new(ModifySchemaResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/modifySchema", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) ModifySchemas(ctx context.Context, in *ModifySchemasRequest, opts ...grpc.CallOption) (*ModifySchemasResponse, error) {
	out := new(ModifySchemasResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/modifySchemas", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) AddDependenciesForMicroServices(ctx context.Context, in *AddDependenciesRequest, opts ...grpc.CallOption) (*AddDependenciesResponse, error) {
	out := new(AddDependenciesResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/addDependenciesForMicroServices", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) CreateDependenciesForMicroServices(ctx context.Context, in *CreateDependenciesRequest, opts ...grpc.CallOption) (*CreateDependenciesResponse, error) {
	out := new(CreateDependenciesResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/createDependenciesForMicroServices", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) GetProviderDependencies(ctx context.Context, in *GetDependenciesRequest, opts ...grpc.CallOption) (*GetProDependenciesResponse, error) {
	out := new(GetProDependenciesResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/getProviderDependencies", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) GetConsumerDependencies(ctx context.Context, in *GetDependenciesRequest, opts ...grpc.CallOption) (*GetConDependenciesResponse, error) {
	out := new(GetConDependenciesResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/getConsumerDependencies", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceCtrlClient) DeleteServices(ctx context.Context, in *DelServicesRequest, opts ...grpc.CallOption) (*DelServicesResponse, error) {
	out := new(DelServicesResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceCtrl/deleteServices", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ServiceCtrl service

type ServiceCtrlServer interface {
	Exist(context.Context, *GetExistenceRequest) (*GetExistenceResponse, error)
	Create(context.Context, *CreateServiceRequest) (*CreateServiceResponse, error)
	Delete(context.Context, *DeleteServiceRequest) (*DeleteServiceResponse, error)
	GetOne(context.Context, *GetServiceRequest) (*GetServiceResponse, error)
	GetServices(context.Context, *GetServicesRequest) (*GetServicesResponse, error)
	UpdateProperties(context.Context, *UpdateServicePropsRequest) (*UpdateServicePropsResponse, error)
	AddRule(context.Context, *AddServiceRulesRequest) (*AddServiceRulesResponse, error)
	GetRule(context.Context, *GetServiceRulesRequest) (*GetServiceRulesResponse, error)
	UpdateRule(context.Context, *UpdateServiceRuleRequest) (*UpdateServiceRuleResponse, error)
	DeleteRule(context.Context, *DeleteServiceRulesRequest) (*DeleteServiceRulesResponse, error)
	AddTags(context.Context, *AddServiceTagsRequest) (*AddServiceTagsResponse, error)
	GetTags(context.Context, *GetServiceTagsRequest) (*GetServiceTagsResponse, error)
	UpdateTag(context.Context, *UpdateServiceTagRequest) (*UpdateServiceTagResponse, error)
	DeleteTags(context.Context, *DeleteServiceTagsRequest) (*DeleteServiceTagsResponse, error)
	GetSchemaInfo(context.Context, *GetSchemaRequest) (*GetSchemaResponse, error)
	GetAllSchemaInfo(context.Context, *GetAllSchemaRequest) (*GetAllSchemaResponse, error)
	DeleteSchema(context.Context, *DeleteSchemaRequest) (*DeleteSchemaResponse, error)
	ModifySchema(context.Context, *ModifySchemaRequest) (*ModifySchemaResponse, error)
	ModifySchemas(context.Context, *ModifySchemasRequest) (*ModifySchemasResponse, error)
	AddDependenciesForMicroServices(context.Context, *AddDependenciesRequest) (*AddDependenciesResponse, error)
	CreateDependenciesForMicroServices(context.Context, *CreateDependenciesRequest) (*CreateDependenciesResponse, error)
	GetProviderDependencies(context.Context, *GetDependenciesRequest) (*GetProDependenciesResponse, error)
	GetConsumerDependencies(context.Context, *GetDependenciesRequest) (*GetConDependenciesResponse, error)
	DeleteServices(context.Context, *DelServicesRequest) (*DelServicesResponse, error)
}

func RegisterServiceCtrlServer(s *grpc.Server, srv ServiceCtrlServer) {
	s.RegisterService(&_ServiceCtrl_serviceDesc, srv)
}

func _ServiceCtrl_Exist_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExistenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).Exist(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/Exist",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).Exist(ctx, req.(*GetExistenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/Create",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).Create(ctx, req.(*CreateServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/Delete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).Delete(ctx, req.(*DeleteServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_GetOne_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).GetOne(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/GetOne",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).GetOne(ctx, req.(*GetServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_GetServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).GetServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/GetServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).GetServices(ctx, req.(*GetServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_UpdateProperties_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServicePropsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).UpdateProperties(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/UpdateProperties",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).UpdateProperties(ctx, req.(*UpdateServicePropsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_AddRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddServiceRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).AddRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/AddRule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).AddRule(ctx, req.(*AddServiceRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_GetRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).GetRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/GetRule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).GetRule(ctx, req.(*GetServiceRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_UpdateRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).UpdateRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/UpdateRule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).UpdateRule(ctx, req.(*UpdateServiceRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_DeleteRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).DeleteRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/DeleteRule",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).DeleteRule(ctx, req.(*DeleteServiceRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_AddTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddServiceTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).AddTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/AddTags",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).AddTags(ctx, req.(*AddServiceTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_GetTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).GetTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/GetTags",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).GetTags(ctx, req.(*GetServiceTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_UpdateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).UpdateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/UpdateTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).UpdateTag(ctx, req.(*UpdateServiceTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_DeleteTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).DeleteTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/DeleteTags",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).DeleteTags(ctx, req.(*DeleteServiceTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_GetSchemaInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).GetSchemaInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/GetSchemaInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).GetSchemaInfo(ctx, req.(*GetSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_GetAllSchemaInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAllSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).GetAllSchemaInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/GetAllSchemaInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).GetAllSchemaInfo(ctx, req.(*GetAllSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_DeleteSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).DeleteSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/DeleteSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).DeleteSchema(ctx, req.(*DeleteSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_ModifySchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifySchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).ModifySchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/ModifySchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).ModifySchema(ctx, req.(*ModifySchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_ModifySchemas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifySchemasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).ModifySchemas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/ModifySchemas",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).ModifySchemas(ctx, req.(*ModifySchemasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_AddDependenciesForMicroServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddDependenciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).AddDependenciesForMicroServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/AddDependenciesForMicroServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).AddDependenciesForMicroServices(ctx, req.(*AddDependenciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_CreateDependenciesForMicroServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDependenciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).CreateDependenciesForMicroServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/CreateDependenciesForMicroServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).CreateDependenciesForMicroServices(ctx, req.(*CreateDependenciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_GetProviderDependencies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDependenciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).GetProviderDependencies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/GetProviderDependencies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).GetProviderDependencies(ctx, req.(*GetDependenciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_GetConsumerDependencies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDependenciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).GetConsumerDependencies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/GetConsumerDependencies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).GetConsumerDependencies(ctx, req.(*GetDependenciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceCtrl_DeleteServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DelServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceCtrlServer).DeleteServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceCtrl/DeleteServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceCtrlServer).DeleteServices(ctx, req.(*DelServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ServiceCtrl_serviceDesc = grpc.ServiceDesc{
	ServiceName: "proto.ServiceCtrl",
	HandlerType: (*ServiceCtrlServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "exist",
			Handler:    _ServiceCtrl_Exist_Handler,
		},
		{
			MethodName: "create",
			Handler:    _ServiceCtrl_Create_Handler,
		},
		{
			MethodName: "delete",
			Handler:    _ServiceCtrl_Delete_Handler,
		},
		{
			MethodName: "getOne",
			Handler:    _ServiceCtrl_GetOne_Handler,
		},
		{
			MethodName: "getServices",
			Handler:    _ServiceCtrl_GetServices_Handler,
		},
		{
			MethodName: "updateProperties",
			Handler:    _ServiceCtrl_UpdateProperties_Handler,
		},
		{
			MethodName: "addRule",
			Handler:    _ServiceCtrl_AddRule_Handler,
		},
		{
			MethodName: "getRule",
			Handler:    _ServiceCtrl_GetRule_Handler,
		},
		{
			MethodName: "updateRule",
			Handler:    _ServiceCtrl_UpdateRule_Handler,
		},
		{
			MethodName: "deleteRule",
			Handler:    _ServiceCtrl_DeleteRule_Handler,
		},
		{
			MethodName: "addTags",
			Handler:    _ServiceCtrl_AddTags_Handler,
		},
		{
			MethodName: "getTags",
			Handler:    _ServiceCtrl_GetTags_Handler,
		},
		{
			MethodName: "updateTag",
			Handler:    _ServiceCtrl_UpdateTag_Handler,
		},
		{
			MethodName: "deleteTags",
			Handler:    _ServiceCtrl_DeleteTags_Handler,
		},
		{
			MethodName: "getSchemaInfo",
			Handler:    _ServiceCtrl_GetSchemaInfo_Handler,
		},
		{
			MethodName: "getAllSchemaInfo",
			Handler:    _ServiceCtrl_GetAllSchemaInfo_Handler,
		},
		{
			MethodName: "deleteSchema",
			Handler:    _ServiceCtrl_DeleteSchema_Handler,
		},
		{
			MethodName: "modifySchema",
			Handler:    _ServiceCtrl_ModifySchema_Handler,
		},
		{
			MethodName: "modifySchemas",
			Handler:    _ServiceCtrl_ModifySchemas_Handler,
		},
		{
			MethodName: "addDependenciesForMicroServices",
			Handler:    _ServiceCtrl_AddDependenciesForMicroServices_Handler,
		},
		{
			MethodName: "createDependenciesForMicroServices",
			Handler:    _ServiceCtrl_CreateDependenciesForMicroServices_Handler,
		},
		{
			MethodName: "getProviderDependencies",
			Handler:    _ServiceCtrl_GetProviderDependencies_Handler,
		},
		{
			MethodName: "getConsumerDependencies",
			Handler:    _ServiceCtrl_GetConsumerDependencies_Handler,
		},
		{
			MethodName: "deleteServices",
			Handler:    _ServiceCtrl_DeleteServices_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "services.proto",
}

// Client API for ServiceInstanceCtrl service

type ServiceInstanceCtrlClient interface {
	Register(ctx context.Context, in *RegisterInstanceRequest, opts ...grpc.CallOption) (*RegisterInstanceResponse, error)
	Unregister(ctx context.Context, in *UnregisterInstanceRequest, opts ...grpc.CallOption) (*UnregisterInstanceResponse, error)
	Heartbeat(ctx context.Context, in *HeartbeatRequest, opts ...grpc.CallOption) (*HeartbeatResponse, error)
	Find(ctx context.Context, in *FindInstancesRequest, opts ...grpc.CallOption) (*FindInstancesResponse, error)
	GetInstances(ctx context.Context, in *GetInstancesRequest, opts ...grpc.CallOption) (*GetInstancesResponse, error)
	GetOneInstance(ctx context.Context, in *GetOneInstanceRequest, opts ...grpc.CallOption) (*GetOneInstanceResponse, error)
	UpdateStatus(ctx context.Context, in *UpdateInstanceStatusRequest, opts ...grpc.CallOption) (*UpdateInstanceStatusResponse, error)
	UpdateInstanceProperties(ctx context.Context, in *UpdateInstancePropsRequest, opts ...grpc.CallOption) (*UpdateInstancePropsResponse, error)
	Watch(ctx context.Context, in *WatchInstanceRequest, opts ...grpc.CallOption) (ServiceInstanceCtrl_WatchClient, error)
	HeartbeatSet(ctx context.Context, in *HeartbeatSetRequest, opts ...grpc.CallOption) (*HeartbeatSetResponse, error)
}

type serviceInstanceCtrlClient struct {
	cc *grpc.ClientConn
}

func NewServiceInstanceCtrlClient(cc *grpc.ClientConn) ServiceInstanceCtrlClient {
	return &serviceInstanceCtrlClient{cc}
}

func (c *serviceInstanceCtrlClient) Register(ctx context.Context, in *RegisterInstanceRequest, opts ...grpc.CallOption) (*RegisterInstanceResponse, error) {
	out := new(RegisterInstanceResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceInstanceCtrl/register", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceInstanceCtrlClient) Unregister(ctx context.Context, in *UnregisterInstanceRequest, opts ...grpc.CallOption) (*UnregisterInstanceResponse, error) {
	out := new(UnregisterInstanceResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceInstanceCtrl/unregister", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceInstanceCtrlClient) Heartbeat(ctx context.Context, in *HeartbeatRequest, opts ...grpc.CallOption) (*HeartbeatResponse, error) {
	out := new(HeartbeatResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceInstanceCtrl/heartbeat", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceInstanceCtrlClient) Find(ctx context.Context, in *FindInstancesRequest, opts ...grpc.CallOption) (*FindInstancesResponse, error) {
	out := new(FindInstancesResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceInstanceCtrl/find", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceInstanceCtrlClient) GetInstances(ctx context.Context, in *GetInstancesRequest, opts ...grpc.CallOption) (*GetInstancesResponse, error) {
	out := new(GetInstancesResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceInstanceCtrl/getInstances", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceInstanceCtrlClient) GetOneInstance(ctx context.Context, in *GetOneInstanceRequest, opts ...grpc.CallOption) (*GetOneInstanceResponse, error) {
	out := new(GetOneInstanceResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceInstanceCtrl/getOneInstance", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceInstanceCtrlClient) UpdateStatus(ctx context.Context, in *UpdateInstanceStatusRequest, opts ...grpc.CallOption) (*UpdateInstanceStatusResponse, error) {
	out := new(UpdateInstanceStatusResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceInstanceCtrl/updateStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceInstanceCtrlClient) UpdateInstanceProperties(ctx context.Context, in *UpdateInstancePropsRequest, opts ...grpc.CallOption) (*UpdateInstancePropsResponse, error) {
	out := new(UpdateInstancePropsResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceInstanceCtrl/updateInstanceProperties", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceInstanceCtrlClient) Watch(ctx context.Context, in *WatchInstanceRequest, opts ...grpc.CallOption) (ServiceInstanceCtrl_WatchClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_ServiceInstanceCtrl_serviceDesc.Streams[0], c.cc, "/proto.ServiceInstanceCtrl/watch", opts...)
	if err != nil {
		return nil, err
	}
	x := &serviceInstanceCtrlWatchClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ServiceInstanceCtrl_WatchClient interface {
	Recv() (*WatchInstanceResponse, error)
	grpc.ClientStream
}

type serviceInstanceCtrlWatchClient struct {
	grpc.ClientStream
}

func (x *serviceInstanceCtrlWatchClient) Recv() (*WatchInstanceResponse, error) {
	m := new(WatchInstanceResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *serviceInstanceCtrlClient) HeartbeatSet(ctx context.Context, in *HeartbeatSetRequest, opts ...grpc.CallOption) (*HeartbeatSetResponse, error) {
	out := new(HeartbeatSetResponse)
	err := grpc.Invoke(ctx, "/proto.ServiceInstanceCtrl/heartbeatSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ServiceInstanceCtrl service

type ServiceInstanceCtrlServer interface {
	Register(context.Context, *RegisterInstanceRequest) (*RegisterInstanceResponse, error)
	Unregister(context.Context, *UnregisterInstanceRequest) (*UnregisterInstanceResponse, error)
	Heartbeat(context.Context, *HeartbeatRequest) (*HeartbeatResponse, error)
	Find(context.Context, *FindInstancesRequest) (*FindInstancesResponse, error)
	GetInstances(context.Context, *GetInstancesRequest) (*GetInstancesResponse, error)
	GetOneInstance(context.Context, *GetOneInstanceRequest) (*GetOneInstanceResponse, error)
	UpdateStatus(context.Context, *UpdateInstanceStatusRequest) (*UpdateInstanceStatusResponse, error)
	UpdateInstanceProperties(context.Context, *UpdateInstancePropsRequest) (*UpdateInstancePropsResponse, error)
	Watch(*WatchInstanceRequest, ServiceInstanceCtrl_WatchServer) error
	HeartbeatSet(context.Context, *HeartbeatSetRequest) (*HeartbeatSetResponse, error)
}

func RegisterServiceInstanceCtrlServer(s *grpc.Server, srv ServiceInstanceCtrlServer) {
	s.RegisterService(&_ServiceInstanceCtrl_serviceDesc, srv)
}

func _ServiceInstanceCtrl_Register_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceInstanceCtrlServer).Register(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceInstanceCtrl/Register",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceInstanceCtrlServer).Register(ctx, req.(*RegisterInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceInstanceCtrl_Unregister_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UnregisterInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceInstanceCtrlServer).Unregister(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceInstanceCtrl/Unregister",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceInstanceCtrlServer).Unregister(ctx, req.(*UnregisterInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceInstanceCtrl_Heartbeat_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HeartbeatRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceInstanceCtrlServer).Heartbeat(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceInstanceCtrl/Heartbeat",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceInstanceCtrlServer).Heartbeat(ctx, req.(*HeartbeatRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceInstanceCtrl_Find_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceInstanceCtrlServer).Find(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceInstanceCtrl/Find",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceInstanceCtrlServer).Find(ctx, req.(*FindInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceInstanceCtrl_GetInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceInstanceCtrlServer).GetInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceInstanceCtrl/GetInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceInstanceCtrlServer).GetInstances(ctx, req.(*GetInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceInstanceCtrl_GetOneInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOneInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceInstanceCtrlServer).GetOneInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceInstanceCtrl/GetOneInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceInstanceCtrlServer).GetOneInstance(ctx, req.(*GetOneInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceInstanceCtrl_UpdateStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceInstanceCtrlServer).UpdateStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceInstanceCtrl/UpdateStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceInstanceCtrlServer).UpdateStatus(ctx, req.(*UpdateInstanceStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceInstanceCtrl_UpdateInstanceProperties_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstancePropsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceInstanceCtrlServer).UpdateInstanceProperties(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceInstanceCtrl/UpdateInstanceProperties",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceInstanceCtrlServer).UpdateInstanceProperties(ctx, req.(*UpdateInstancePropsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceInstanceCtrl_Watch_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(WatchInstanceRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ServiceInstanceCtrlServer).Watch(m, &serviceInstanceCtrlWatchServer{stream})
}

type ServiceInstanceCtrl_WatchServer interface {
	Send(*WatchInstanceResponse) error
	grpc.ServerStream
}

type serviceInstanceCtrlWatchServer struct {
	grpc.ServerStream
}

func (x *serviceInstanceCtrlWatchServer) Send(m *WatchInstanceResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _ServiceInstanceCtrl_HeartbeatSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HeartbeatSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceInstanceCtrlServer).HeartbeatSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.ServiceInstanceCtrl/HeartbeatSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceInstanceCtrlServer).HeartbeatSet(ctx, req.(*HeartbeatSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ServiceInstanceCtrl_serviceDesc = grpc.ServiceDesc{
	ServiceName: "proto.ServiceInstanceCtrl",
	HandlerType: (*ServiceInstanceCtrlServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "register",
			Handler:    _ServiceInstanceCtrl_Register_Handler,
		},
		{
			MethodName: "unregister",
			Handler:    _ServiceInstanceCtrl_Unregister_Handler,
		},
		{
			MethodName: "heartbeat",
			Handler:    _ServiceInstanceCtrl_Heartbeat_Handler,
		},
		{
			MethodName: "find",
			Handler:    _ServiceInstanceCtrl_Find_Handler,
		},
		{
			MethodName: "getInstances",
			Handler:    _ServiceInstanceCtrl_GetInstances_Handler,
		},
		{
			MethodName: "getOneInstance",
			Handler:    _ServiceInstanceCtrl_GetOneInstance_Handler,
		},
		{
			MethodName: "updateStatus",
			Handler:    _ServiceInstanceCtrl_UpdateStatus_Handler,
		},
		{
			MethodName: "updateInstanceProperties",
			Handler:    _ServiceInstanceCtrl_UpdateInstanceProperties_Handler,
		},
		{
			MethodName: "heartbeatSet",
			Handler:    _ServiceInstanceCtrl_HeartbeatSet_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "watch",
			Handler:       _ServiceInstanceCtrl_Watch_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "services.proto",
}

// Client API for GovernServiceCtrl service

type GovernServiceCtrlClient interface {
	GetServiceDetail(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*GetServiceDetailResponse, error)
	GetServicesInfo(ctx context.Context, in *GetServicesInfoRequest, opts ...grpc.CallOption) (*GetServicesInfoResponse, error)
	GetApplications(ctx context.Context, in *GetAppsRequest, opts ...grpc.CallOption) (*GetAppsResponse, error)
}

type governServiceCtrlClient struct {
	cc *grpc.ClientConn
}

func NewGovernServiceCtrlClient(cc *grpc.ClientConn) GovernServiceCtrlClient {
	return &governServiceCtrlClient{cc}
}

func (c *governServiceCtrlClient) GetServiceDetail(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*GetServiceDetailResponse, error) {
	out := new(GetServiceDetailResponse)
	err := grpc.Invoke(ctx, "/proto.GovernServiceCtrl/getServiceDetail", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *governServiceCtrlClient) GetServicesInfo(ctx context.Context, in *GetServicesInfoRequest, opts ...grpc.CallOption) (*GetServicesInfoResponse, error) {
	out := new(GetServicesInfoResponse)
	err := grpc.Invoke(ctx, "/proto.GovernServiceCtrl/getServicesInfo", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *governServiceCtrlClient) GetApplications(ctx context.Context, in *GetAppsRequest, opts ...grpc.CallOption) (*GetAppsResponse, error) {
	out := new(GetAppsResponse)
	err := grpc.Invoke(ctx, "/proto.GovernServiceCtrl/getApplications", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for GovernServiceCtrl service

type GovernServiceCtrlServer interface {
	GetServiceDetail(context.Context, *GetServiceRequest) (*GetServiceDetailResponse, error)
	GetServicesInfo(context.Context, *GetServicesInfoRequest) (*GetServicesInfoResponse, error)
	GetApplications(context.Context, *GetAppsRequest) (*GetAppsResponse, error)
}

func RegisterGovernServiceCtrlServer(s *grpc.Server, srv GovernServiceCtrlServer) {
	s.RegisterService(&_GovernServiceCtrl_serviceDesc, srv)
}

func _GovernServiceCtrl_GetServiceDetail_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GovernServiceCtrlServer).GetServiceDetail(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.GovernServiceCtrl/GetServiceDetail",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GovernServiceCtrlServer).GetServiceDetail(ctx, req.(*GetServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GovernServiceCtrl_GetServicesInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServicesInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GovernServiceCtrlServer).GetServicesInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.GovernServiceCtrl/GetServicesInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GovernServiceCtrlServer).GetServicesInfo(ctx, req.(*GetServicesInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GovernServiceCtrl_GetApplications_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAppsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GovernServiceCtrlServer).GetApplications(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.GovernServiceCtrl/GetApplications",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GovernServiceCtrlServer).GetApplications(ctx, req.(*GetAppsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _GovernServiceCtrl_serviceDesc = grpc.ServiceDesc{
	ServiceName: "proto.GovernServiceCtrl",
	HandlerType: (*GovernServiceCtrlServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "getServiceDetail",
			Handler:    _GovernServiceCtrl_GetServiceDetail_Handler,
		},
		{
			MethodName: "getServicesInfo",
			Handler:    _GovernServiceCtrl_GetServicesInfo_Handler,
		},
		{
			MethodName: "getApplications",
			Handler:    _GovernServiceCtrl_GetApplications_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "services.proto",
}

func init() { proto1.RegisterFile("services.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 3330 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x3b, 0x4b, 0x6f, 0x1c, 0xc7,
	0xd1, 0x98, 0xe5, 0x2e, 0x77, 0xb7, 0xf8, 0x10, 0xd9, 0x22, 0xc5, 0xd1, 0xea, 0x45, 0xb5, 0xfd,
	0x7d, 0x16, 0x60, 0x7f, 0xb4, 0x45, 0xbf, 0x1f, 0xfa, 0x60, 0x8a, 0x94, 0x28, 0x8a, 0x52, 0x24,
	0xcf, 0xca, 0x16, 0xe2, 0x20, 0x88, 0x87, 0xbb, 0xcd, 0xdd, 0x89, 0x66, 0x67, 0x26, 0x33, 0xb3,
	0x94, 0x17, 0x08, 0x1c, 0x04, 0x46, 0x8e, 0xc9, 0x21, 0x97, 0x00, 0x49, 0x4e, 0x39, 0x25, 0xf9,
	0x03, 0x39, 0x04, 0x41, 0xee, 0x01, 0x72, 0x0b, 0x90, 0x93, 0xff, 0x41, 0xce, 0x39, 0x07, 0xfd,
	0x98, 0x99, 0xee, 0x99, 0xde, 0x07, 0x87, 0x72, 0x4e, 0x3b, 0xdd, 0x5d, 0x5d, 0x5d, 0x5d, 0x55,
	0x5d, 0x5d, 0x8f, 0x5e, 0x58, 0x8e, 0x48, 0x78, 0xe2, 0x74, 0x48, 0xb4, 0x15, 0x84, 0x7e, 0xec,
	0xa3, 0x1a, 0xfb, 0xc1, 0xdf, 0x87, 0xb5, 0x87, 0x7e, 0xd7, 0x39, 0x1e, 0xb5, 0x3b, 0x7d, 0x32,
	0xb0, 0x23, 0x8b, 0xfc, 0x68, 0x48, 0xa2, 0x18, 0x5d, 0x86, 0xa6, 0x98, 0x70, 0xd0, 0x35, 0x8d,
	0x4d, 0xe3, 0x46, 0xd3, 0xca, 0x3a, 0xd0, 0x2b, 0x50, 0x8f, 0x38, 0xbc, 0x59, 0xd9, 0x9c, 0xbb,
	0xb1, 0xb0, 0xbd, 0xc4, 0xb1, 0x6e, 0x71, 0x2c, 0x56, 0x32, 0x8a, 0x3f, 0x83, 0x79, 0xde, 0x85,
	0x5a, 0xd0, 0xe0, 0x9d, 0x29, 0xbe, 0xb4, 0x8d, 0x4c, 0xa8, 0x47, 0xc3, 0xc1, 0xc0, 0x0e, 0x47,
	0x66, 0x85, 0x0d, 0x25, 0x4d, 0x74, 0x01, 0xe6, 0x39, 0x94, 0x39, 0xc7, 0x06, 0x44, 0x0b, 0xef,
	0xc1, 0x7a, 0x8e, 0xec, 0x28, 0xf0, 0xbd, 0x88, 0xa0, 0x57, 0xa1, 0x11, 0x8a, 0x6f, 0xb6, 0xcc,
	0xc2, 0xf6, 0x39, 0x41, 0x5a, 0x02, 0x62, 0xa5, 0x00, 0xf8, 0x11, 0x9c, 0xbf, 0x47, 0xec, 0x30,
	0x3e, 0x22, 0x76, 0xdc, 0x26, 0x71, 0xb2, 0xf7, 0xf7, 0xa0, 0xe9, 0x78, 0x51, 0x6c, 0x7b, 0x1d,
	0x12, 0x99, 0x06, 0xdb, 0x5f, 0x4b, 0x20, 0x91, 0xc1, 0xef, 0xb8, 0x64, 0x40, 0xbc, 0xd8, 0xca,
	0x80, 0x71, 0x5b, 0x45, 0x28, 0x20, 0xa6, 0x30, 0xf3, 0x2a, 0x40, 0x82, 0xe1, 0xa0, 0x2b, 0x18,
	0x20, 0xf5, 0xe0, 0xe7, 0xb0, 0xa6, 0x52, 0x59, 0x62, 0xab, 0x68, 0x5b, 0xde, 0x13, 0x97, 0xd9,
	0x9a, 0x80, 0x3e, 0x10, 0xfd, 0xf7, 0x8e, 0xac, 0x48, 0xd9, 0xcd, 0x00, 0x96, 0x94, 0xb1, 0xb3,
	0xed, 0x83, 0x8e, 0x93, 0x30, 0x7c, 0x48, 0xa2, 0xc8, 0xee, 0x11, 0x21, 0x4f, 0xa9, 0x07, 0xef,
	0x42, 0xb3, 0x1d, 0xb7, 0x39, 0x3a, 0xb4, 0x06, 0xb5, 0x8e, 0x3f, 0xf4, 0x62, 0xb6, 0xcc, 0x9c,
	0xc5, 0x1b, 0x68, 0x13, 0x16, 0x7c, 0xcf, 0x75, 0x3c, 0xb2, 0xcb, 0xc6, 0x2a, 0x6c, 0x4c, 0xee,
	0xc2, 0xf7, 0x00, 0xda, 0x71, 0x42, 0xf5, 0x18, 0x2c, 0x2f, 0xc3, 0x12, 0xfb, 0xb8, 0x3d, 0xda,
	0xf3, 0x07, 0xb6, 0xe3, 0x09, 0x3c, 0x6a, 0x27, 0xbe, 0x02, 0xb5, 0x76, 0xbc, 0x13, 0x04, 0x7a,
	0x24, 0xf8, 0xe7, 0x06, 0x5d, 0xc9, 0x8e, 0x9d, 0x28, 0x76, 0x3a, 0x11, 0x7a, 0x0d, 0x1a, 0xc9,
	0x01, 0x13, 0xc2, 0x58, 0x49, 0x8e, 0x44, 0xb2, 0x27, 0x2b, 0x85, 0x40, 0xaf, 0xab, 0xd2, 0xa0,
	0xe0, 0xab, 0x29, 0x78, 0x42, 0xbd, 0x24, 0x0a, 0xb4, 0x09, 0x55, 0x3b, 0x08, 0x22, 0xc6, 0xb5,
	0x85, 0xed, 0xc5, 0x14, 0x76, 0x27, 0x08, 0x2c, 0x36, 0x82, 0x7f, 0x6f, 0xc0, 0x85, 0x7d, 0x92,
	0xac, 0x15, 0x1d, 0x78, 0xc7, 0x7e, 0xa2, 0xcf, 0x26, 0xd4, 0xfd, 0x20, 0x76, 0x7c, 0x8f, 0x6b,
	0x73, 0xd3, 0x4a, 0x9a, 0x74, 0x6b, 0x76, 0x10, 0xa4, 0xd2, 0xe2, 0x0d, 0xca, 0x65, 0x41, 0xe9,
	0x77, 0xec, 0x41, 0x22, 0x29, 0xb9, 0x8b, 0x2a, 0x02, 0xe3, 0xc2, 0x23, 0xcf, 0x1d, 0x99, 0xd5,
	0x4d, 0xe3, 0x46, 0xc3, 0xca, 0x3a, 0xa8, 0xa0, 0x9f, 0x3b, 0x71, 0xbf, 0xdd, 0xb7, 0x43, 0xd2,
	0x35, 0x6b, 0x6c, 0x58, 0xea, 0xc1, 0x7f, 0x31, 0x60, 0xa3, 0x40, 0x6a, 0x19, 0xa5, 0xbe, 0x0d,
	0xab, 0xb6, 0xeb, 0x26, 0x78, 0xf6, 0x48, 0x6c, 0x3b, 0x6e, 0x4e, 0xb9, 0xc5, 0x20, 0x1f, 0xb3,
	0x8a, 0xe0, 0xe8, 0x26, 0x40, 0x94, 0x8a, 0x51, 0xf0, 0x37, 0x93, 0x45, 0x32, 0x60, 0x49, 0x40,
	0xf8, 0xef, 0x06, 0x9c, 0x7b, 0xe8, 0x74, 0x42, 0x5f, 0xa0, 0x3a, 0x24, 0xcc, 0x50, 0xc5, 0xc4,
	0xb3, 0x85, 0x96, 0x34, 0x2d, 0xd1, 0xa2, 0xbc, 0x0f, 0x42, 0xff, 0x87, 0xa4, 0x13, 0x27, 0xa6,
	0x4d, 0x34, 0x33, 0xde, 0xcf, 0x4d, 0xe0, 0x7d, 0xb5, 0xc8, 0x7b, 0x13, 0xea, 0x27, 0x24, 0x8c,
	0x1c, 0xdf, 0x63, 0xac, 0x6d, 0x5a, 0x49, 0x93, 0xce, 0x25, 0xde, 0x89, 0x13, 0xfa, 0x1e, 0xb5,
	0x3a, 0xe6, 0x3c, 0x9f, 0x2b, 0x75, 0xb1, 0x35, 0x5d, 0xc7, 0x8e, 0xcc, 0xba, 0x58, 0x93, 0x36,
	0xf0, 0xef, 0xe6, 0x61, 0x51, 0xde, 0xcf, 0x94, 0x73, 0x5e, 0x56, 0x69, 0x24, 0xc2, 0xab, 0x05,
	0xc2, 0xbb, 0x24, 0xea, 0x84, 0x0e, 0x53, 0x4b, 0xb1, 0x2d, 0xb9, 0x8b, 0xae, 0xe9, 0x92, 0x13,
	0xe2, 0x8a, 0x4d, 0xf1, 0x06, 0xbb, 0x37, 0xc4, 0x35, 0x54, 0xe7, 0x8a, 0x2d, 0x9a, 0xe8, 0x06,
	0xd4, 0x02, 0x3b, 0xee, 0x47, 0x26, 0x30, 0x6d, 0x40, 0xaa, 0x36, 0x3c, 0xb6, 0xe3, 0xbe, 0xc5,
	0x01, 0xd8, 0x0d, 0x13, 0xdb, 0xf1, 0x30, 0x32, 0x1b, 0xe2, 0x86, 0x61, 0x2d, 0xb4, 0x0b, 0x10,
	0x84, 0x7e, 0x40, 0xc2, 0xd8, 0x21, 0x91, 0xd9, 0x64, 0x68, 0x5e, 0x12, 0x68, 0x64, 0x66, 0x6d,
	0x3d, 0x4e, 0xa1, 0xee, 0x78, 0x71, 0x38, 0xb2, 0xa4, 0x69, 0x94, 0x91, 0xb1, 0x33, 0x20, 0x51,
	0x6c, 0x0f, 0x02, 0x73, 0x81, 0x33, 0x32, 0xed, 0x40, 0x6f, 0x41, 0x33, 0x08, 0xfd, 0x13, 0xa7,
	0x4b, 0xc2, 0xc8, 0x5c, 0x64, 0x2b, 0x5c, 0xd0, 0xac, 0x70, 0x48, 0x46, 0x56, 0x06, 0x98, 0xc9,
	0x70, 0x49, 0x92, 0x21, 0x25, 0xf7, 0xc1, 0xed, 0x76, 0x1c, 0xda, 0x31, 0xe9, 0x8d, 0xcc, 0xe5,
	0xf1, 0xe4, 0x66, 0x50, 0x82, 0xdc, 0xac, 0x03, 0x61, 0x58, 0x1c, 0xf8, 0xdd, 0x27, 0x29, 0xc5,
	0xe7, 0xd8, 0x0a, 0x4a, 0x5f, 0x5e, 0xc9, 0x56, 0x8a, 0x4a, 0x76, 0x15, 0x20, 0x24, 0x3d, 0x27,
	0x8a, 0x49, 0x78, 0x7b, 0x64, 0xae, 0x72, 0x3b, 0x9f, 0xf5, 0xa0, 0x77, 0xa0, 0x79, 0x1c, 0xda,
	0x03, 0xf2, 0xdc, 0x0f, 0x9f, 0x99, 0x88, 0x1d, 0x38, 0x53, 0x50, 0x7a, 0x97, 0xf6, 0x3f, 0xf5,
	0xc3, 0x67, 0x82, 0xa9, 0x23, 0x2b, 0x03, 0x6d, 0xdd, 0x82, 0x73, 0x39, 0x5e, 0xa3, 0x15, 0x98,
	0x7b, 0x46, 0x46, 0x42, 0x45, 0xe9, 0x27, 0xe5, 0xce, 0x89, 0xed, 0x0e, 0x49, 0xa2, 0x9c, 0xac,
	0xf1, 0x41, 0xe5, 0x3d, 0x83, 0x4e, 0xcf, 0xed, 0xfd, 0x34, 0xd3, 0xf1, 0x0e, 0xac, 0x16, 0xa8,
	0x43, 0x08, 0xaa, 0x1e, 0xd5, 0x76, 0x8e, 0x81, 0x7d, 0xcb, 0x6a, 0x5e, 0x51, 0xd4, 0x1c, 0x7f,
	0x63, 0xc0, 0x42, 0x72, 0x17, 0x0c, 0x5d, 0x42, 0x55, 0x2f, 0x1c, 0xba, 0xd9, 0x19, 0x13, 0x2d,
	0xea, 0x2a, 0xd1, 0xaf, 0x27, 0xa3, 0x20, 0xa1, 0x23, 0x6d, 0x53, 0x8d, 0xb2, 0xe3, 0x38, 0x74,
	0x8e, 0x86, 0x71, 0x72, 0xc8, 0xb2, 0x0e, 0x66, 0x6d, 0xec, 0x38, 0x26, 0x61, 0x7a, 0xc4, 0x44,
	0x73, 0x86, 0x23, 0xa6, 0xe8, 0xea, 0x7c, 0x5e, 0x57, 0xf3, 0xaa, 0x51, 0x2f, 0xaa, 0x06, 0xfe,
	0x85, 0x01, 0x17, 0x76, 0xba, 0xdd, 0x47, 0xe1, 0xa7, 0x41, 0xd7, 0x8e, 0x89, 0xbc, 0x55, 0x79,
	0x4b, 0xc6, 0xa4, 0x2d, 0x55, 0x26, 0x6c, 0x69, 0x6e, 0xe2, 0x96, 0xaa, 0x85, 0x2d, 0xe1, 0xdf,
	0x66, 0x0c, 0xa7, 0x47, 0x9e, 0x8a, 0x8b, 0x1e, 0xfa, 0x44, 0x5c, 0xf4, 0x1b, 0x7d, 0x04, 0x0d,
	0x71, 0x60, 0x47, 0xe2, 0xea, 0xd8, 0x2c, 0x1a, 0x8b, 0xe4, 0x90, 0x8b, 0x33, 0x93, 0xce, 0x68,
	0x7d, 0x08, 0x4b, 0xca, 0xd0, 0xa9, 0x54, 0xea, 0x3d, 0x68, 0xa4, 0xf7, 0x1e, 0x82, 0x6a, 0xc7,
	0xef, 0x72, 0xe6, 0xd4, 0x2c, 0xf6, 0x4d, 0xb7, 0x3e, 0x10, 0xde, 0x92, 0xd0, 0x24, 0xd1, 0xc4,
	0xff, 0x34, 0xe0, 0xfc, 0x3e, 0x89, 0xef, 0x7c, 0x49, 0xcf, 0x14, 0x75, 0x15, 0xc4, 0x4d, 0x8f,
	0xa0, 0x1a, 0x67, 0x2c, 0x66, 0xdf, 0xdf, 0x82, 0xb9, 0x56, 0xae, 0x87, 0x5a, 0xfe, 0x7a, 0x90,
	0x1d, 0xfd, 0xf9, 0x9c, 0xa3, 0x9f, 0x33, 0x1e, 0xf5, 0x82, 0xf1, 0xc0, 0xbf, 0x32, 0x60, 0x4d,
	0xdd, 0x59, 0x19, 0xc7, 0x40, 0xa1, 0xb0, 0x32, 0x89, 0xc2, 0xb9, 0xf1, 0xa1, 0x48, 0x55, 0x09,
	0x45, 0xf0, 0x1f, 0x2a, 0xb0, 0xb6, 0x1b, 0x12, 0x49, 0xb1, 0x05, 0xd3, 0xff, 0x0f, 0xea, 0x02,
	0xb7, 0x20, 0xec, 0xbc, 0xc6, 0xee, 0x5a, 0x09, 0x0c, 0x7a, 0x13, 0x6a, 0x54, 0xf5, 0x13, 0x2f,
	0xfc, 0x8a, 0x00, 0xd6, 0x1f, 0x1c, 0x8b, 0xc3, 0xa2, 0xf7, 0xa1, 0x1a, 0xdb, 0x3d, 0xea, 0x9f,
	0xd0, 0x39, 0xff, 0x23, 0xe6, 0xe8, 0xc8, 0xd9, 0x7a, 0x62, 0xf7, 0xc4, 0x4d, 0xc4, 0xa6, 0xa0,
	0xf7, 0x65, 0x5f, 0xb3, 0xca, 0xe6, 0x5f, 0xd2, 0x10, 0xa8, 0xf1, 0x3a, 0x5b, 0xef, 0x42, 0x33,
	0xc5, 0x76, 0x2a, 0xcd, 0x3e, 0x82, 0xf5, 0x1c, 0x6d, 0x2f, 0x5c, 0x8a, 0xf8, 0x3e, 0xac, 0xed,
	0x11, 0x97, 0x14, 0xc4, 0x31, 0xd5, 0x79, 0x39, 0xf6, 0xc3, 0x0e, 0xa7, 0xb9, 0x61, 0xf1, 0x06,
	0x0d, 0x27, 0x73, 0xb8, 0xca, 0x84, 0x93, 0x37, 0x61, 0x35, 0x73, 0x6b, 0x67, 0x22, 0x07, 0x07,
	0x80, 0xe4, 0x29, 0x65, 0xb8, 0x24, 0xa9, 0x5f, 0x65, 0xba, 0xfa, 0xe1, 0x35, 0x79, 0xc5, 0x24,
	0xdc, 0xc7, 0x11, 0xb3, 0x27, 0x59, 0x6f, 0x19, 0x42, 0x5e, 0x97, 0x42, 0x20, 0xae, 0xdb, 0x5a,
	0x4a, 0x52, 0x20, 0xfc, 0x37, 0x03, 0x2e, 0x2a, 0x1a, 0x4f, 0x4d, 0xe9, 0x8c, 0x19, 0x88, 0xc7,
	0x8a, 0x7b, 0xc6, 0x97, 0x7b, 0x43, 0x2c, 0x37, 0x16, 0xe7, 0x24, 0x5f, 0xed, 0x8c, 0xee, 0x05,
	0x3e, 0x80, 0x96, 0x6e, 0xdd, 0x32, 0x7a, 0xf4, 0x8e, 0x1c, 0xc9, 0x51, 0x2b, 0x10, 0xcd, 0xaa,
	0x4c, 0x1b, 0x85, 0x79, 0x65, 0x04, 0x79, 0x43, 0xb5, 0x50, 0x39, 0xe7, 0x59, 0x32, 0x4b, 0xf8,
	0x6b, 0x03, 0xcc, 0xa2, 0xcd, 0x9a, 0x49, 0x80, 0x99, 0xf3, 0x53, 0x51, 0x9c, 0x9f, 0x9b, 0x50,
	0xa5, 0x5f, 0x22, 0x12, 0x9b, 0x62, 0x1d, 0x19, 0x28, 0xbe, 0x97, 0x53, 0x23, 0x4e, 0x44, 0x19,
	0xce, 0x3f, 0x63, 0x0e, 0xcc, 0xa9, 0x39, 0x5f, 0xca, 0xa6, 0xe3, 0x2f, 0x60, 0xa3, 0xb0, 0x58,
	0x19, 0x71, 0x99, 0x50, 0xb7, 0x18, 0xef, 0xf8, 0xf2, 0x4d, 0x2b, 0x69, 0xe2, 0x36, 0x5c, 0x54,
	0xcd, 0xda, 0xec, 0x3b, 0x32, 0xa1, 0x1e, 0xaa, 0x48, 0x45, 0x93, 0x2a, 0xba, 0x0e, 0x69, 0x19,
	0x76, 0xbf, 0x0d, 0xeb, 0x99, 0xc2, 0xd2, 0x9b, 0x66, 0x36, 0x3d, 0xff, 0xb3, 0x92, 0xea, 0xe0,
	0xf3, 0xca, 0x30, 0xee, 0x43, 0x71, 0xa9, 0x72, 0xa1, 0xbd, 0x22, 0x00, 0xf5, 0x98, 0xf3, 0xd7,
	0x6a, 0xf9, 0xbb, 0xf1, 0x07, 0xb0, 0xa1, 0xa8, 0xc4, 0x13, 0xbb, 0x37, 0x9b, 0x48, 0xc4, 0x22,
	0x15, 0xcd, 0x22, 0x73, 0xd2, 0x22, 0x78, 0x3f, 0x77, 0x26, 0xd9, 0x02, 0x65, 0xc4, 0xf3, 0x47,
	0x03, 0xd6, 0x33, 0x0d, 0x9d, 0x59, 0x3e, 0xe8, 0x03, 0x85, 0xaf, 0xff, 0x9b, 0x1d, 0x86, 0x22,
	0xa6, 0x17, 0xc7, 0xd6, 0x3b, 0xf2, 0xd1, 0x2d, 0xad, 0x13, 0xf8, 0x01, 0x98, 0x8a, 0x76, 0xcf,
	0xbe, 0x6b, 0x04, 0xd5, 0x67, 0x64, 0x94, 0x1c, 0x17, 0xf6, 0x4d, 0x2d, 0x93, 0x06, 0x5b, 0x19,
	0xba, 0x46, 0xb0, 0x70, 0x8f, 0xd8, 0x6e, 0xdc, 0xdf, 0xed, 0x93, 0xce, 0x33, 0xba, 0xd8, 0x20,
	0x09, 0x17, 0x9a, 0x16, 0xfb, 0x66, 0xd1, 0x8d, 0x1f, 0xf2, 0x3c, 0x53, 0xcd, 0x62, 0xdf, 0xd4,
	0xd5, 0x75, 0xbc, 0x98, 0x84, 0x27, 0xb6, 0xcb, 0x94, 0xa4, 0x66, 0xa5, 0x6d, 0xca, 0x4b, 0x16,
	0xdf, 0x31, 0x47, 0xb7, 0x66, 0xf1, 0x06, 0xe5, 0xf9, 0x30, 0x74, 0x85, 0x5b, 0x4f, 0x3f, 0xf1,
	0xd7, 0x55, 0x58, 0xd3, 0x79, 0x8a, 0xb9, 0x84, 0xaf, 0x51, 0x48, 0xf8, 0x4e, 0xf6, 0xc2, 0x2f,
	0x43, 0x93, 0x78, 0xdd, 0xc0, 0x77, 0xbc, 0x98, 0xfb, 0xb5, 0x4d, 0x2b, 0xeb, 0xa0, 0x84, 0xf7,
	0xfd, 0x28, 0x96, 0x92, 0x60, 0x69, 0x5b, 0x4a, 0xd9, 0xd4, 0x94, 0x94, 0xcd, 0xa1, 0xe2, 0x13,
	0xcc, 0x33, 0xed, 0x7b, 0x75, 0x82, 0xab, 0x3b, 0x31, 0x75, 0xf3, 0x16, 0x2c, 0xf4, 0x33, 0x86,
	0xb3, 0x50, 0x25, 0xbb, 0x0a, 0x25, 0x51, 0x58, 0x32, 0x98, 0x1a, 0x44, 0x37, 0xf2, 0x41, 0xf4,
	0x2d, 0x58, 0xee, 0xda, 0xb1, 0xbd, 0x4b, 0xa8, 0x08, 0x0e, 0xbc, 0x63, 0xdf, 0x6c, 0x32, 0xb4,
	0xeb, 0x02, 0xed, 0x9e, 0x32, 0x68, 0xe5, 0x80, 0x0b, 0x31, 0x38, 0x68, 0xd2, 0x33, 0x52, 0xd4,
	0xb6, 0xa0, 0x44, 0x6d, 0x67, 0xf5, 0x6f, 0x8e, 0x60, 0x59, 0x25, 0x4f, 0x9b, 0xfc, 0xa0, 0xb7,
	0x3a, 0xe9, 0x65, 0xb9, 0x0f, 0xd1, 0x42, 0x2f, 0xc3, 0x92, 0x7d, 0x62, 0x3b, 0xae, 0x7d, 0xe4,
	0x92, 0xcf, 0x7d, 0x2f, 0xb1, 0x58, 0x6a, 0x27, 0x7e, 0x0a, 0x1b, 0x3a, 0x39, 0x1d, 0x92, 0xd1,
	0xd9, 0x74, 0x0d, 0x5b, 0xb0, 0x61, 0x89, 0x04, 0x54, 0x1a, 0xe7, 0x88, 0x43, 0xfd, 0x2e, 0x3d,
	0x21, 0xbc, 0x4b, 0x9c, 0xc2, 0x89, 0xd1, 0x51, 0x0a, 0x8c, 0x7b, 0x60, 0x16, 0x71, 0x96, 0xb9,
	0x86, 0xa6, 0xd5, 0x7f, 0xbe, 0x0b, 0x17, 0x3f, 0xf5, 0xc2, 0x31, 0xe4, 0x9f, 0xad, 0xb4, 0x44,
	0x9d, 0x56, 0x0d, 0xea, 0x32, 0x06, 0xea, 0x31, 0xac, 0xa4, 0x55, 0xaa, 0x17, 0x43, 0xdc, 0xc7,
	0xb0, 0x2a, 0x61, 0x2c, 0x43, 0xd3, 0x3f, 0x0c, 0x58, 0xbb, 0xeb, 0x78, 0xdd, 0x64, 0x67, 0xa9,
	0x25, 0x7f, 0x0d, 0x56, 0x3b, 0xbe, 0x17, 0x0d, 0x07, 0x24, 0x6c, 0xe7, 0x08, 0x2c, 0x0e, 0x94,
	0xce, 0xa0, 0x6c, 0xc2, 0x82, 0x38, 0x7c, 0xd4, 0x47, 0x4a, 0x12, 0x54, 0x52, 0x17, 0xcb, 0xd7,
	0xd0, 0x9b, 0xb2, 0xc6, 0xef, 0x0c, 0x16, 0xaf, 0x4f, 0xcd, 0xe2, 0xe3, 0x9f, 0xc0, 0x7a, 0x6e,
	0x57, 0x65, 0xd4, 0xee, 0xfd, 0x62, 0x45, 0x70, 0xc6, 0xbc, 0x00, 0xfe, 0x93, 0xc1, 0x1c, 0xb7,
	0x47, 0x1e, 0xc9, 0xab, 0xe3, 0xe9, 0x18, 0xfb, 0x1a, 0xac, 0x26, 0x79, 0xed, 0x76, 0xee, 0xf0,
	0x16, 0x07, 0xd0, 0x16, 0xa0, 0xa4, 0xf3, 0x20, 0xd3, 0x1b, 0xce, 0x77, 0xcd, 0x48, 0xca, 0xdc,
	0x6a, 0xc6, 0x5c, 0xfc, 0x15, 0xf3, 0x1c, 0x15, 0xc2, 0xcb, 0xf0, 0x4e, 0x36, 0x1a, 0x95, 0xd3,
	0x18, 0x8d, 0x9f, 0xf1, 0xc4, 0xdd, 0x19, 0x15, 0xf2, 0x74, 0x7c, 0x43, 0x52, 0xee, 0x28, 0xe3,
	0xc3, 0x9a, 0x4a, 0xc6, 0x7f, 0x59, 0x83, 0x22, 0xb8, 0xc4, 0x7d, 0xd4, 0x64, 0xb0, 0xcd, 0xae,
	0xf0, 0x17, 0x62, 0x38, 0x24, 0xff, 0x60, 0x4e, 0xf6, 0x0f, 0xf0, 0x21, 0x5c, 0xd6, 0x2f, 0x5a,
	0xc6, 0xb6, 0xfc, 0xcb, 0x48, 0x02, 0xfe, 0x04, 0xdb, 0x29, 0xb2, 0x17, 0xd3, 0x76, 0xf0, 0x89,
	0xe2, 0xc9, 0xf0, 0xa4, 0xdf, 0x4d, 0x25, 0xbb, 0xa1, 0x5b, 0xf4, 0xdb, 0x4c, 0x6f, 0xdc, 0xcf,
	0x0b, 0xec, 0x0c, 0xf9, 0x8d, 0x8f, 0x60, 0xed, 0xa9, 0x1d, 0x77, 0xfa, 0x79, 0xe3, 0xf1, 0x32,
	0x2c, 0x45, 0xc4, 0x3d, 0xce, 0x1f, 0x00, 0xb5, 0x13, 0xff, 0xd5, 0x80, 0xf5, 0xdc, 0xf4, 0x32,
	0xca, 0x7b, 0x01, 0xe6, 0xed, 0x4e, 0x2c, 0x79, 0x2a, 0xbc, 0x85, 0x6e, 0x70, 0xa6, 0xf0, 0xf4,
	0xc3, 0xb8, 0x72, 0x1c, 0x63, 0x96, 0x6c, 0x04, 0xaa, 0xa7, 0x31, 0x02, 0x0f, 0x60, 0x85, 0x06,
	0x99, 0xfc, 0xa9, 0xcc, 0x4c, 0xfa, 0x22, 0x67, 0xac, 0x2b, 0x6a, 0xc6, 0x1a, 0xb7, 0x99, 0x45,
	0xd9, 0x71, 0xdd, 0xd3, 0x20, 0x4c, 0x4a, 0xf4, 0xfc, 0x6d, 0x4d, 0x45, 0x2a, 0xd1, 0xf3, 0xf7,
	0x35, 0x5f, 0xf1, 0x54, 0xa6, 0xc0, 0x58, 0x92, 0xbf, 0x51, 0x86, 0x3d, 0x7d, 0xb9, 0xc3, 0x84,
	0xcc, 0xbe, 0xda, 0x22, 0xcd, 0x2e, 0x3c, 0x41, 0xa5, 0x13, 0xbb, 0xcc, 0x3e, 0x49, 0x9b, 0x2a,
	0x43, 0xc2, 0xcc, 0xaf, 0x94, 0x1e, 0xc1, 0x79, 0x11, 0xa6, 0xbd, 0x20, 0x99, 0xec, 0xa6, 0xb9,
	0xe9, 0xf2, 0xe4, 0xe3, 0x9f, 0x1a, 0x70, 0x5e, 0x7e, 0xe4, 0x74, 0x66, 0xb2, 0xc6, 0xbd, 0xa6,
	0x9a, 0x50, 0xf4, 0xd8, 0x55, 0x9f, 0x87, 0x95, 0xdb, 0xc8, 0x53, 0x16, 0x9a, 0xef, 0x91, 0x80,
	0x78, 0x5d, 0xe2, 0x75, 0x9c, 0xec, 0xda, 0xbb, 0x05, 0x8b, 0x5d, 0xa9, 0x5b, 0x3c, 0xb6, 0xba,
	0x98, 0x94, 0x37, 0xc4, 0xc5, 0x97, 0xce, 0x1c, 0x59, 0x0a, 0x38, 0xbe, 0xcb, 0x32, 0x68, 0x2a,
	0xe2, 0x32, 0x04, 0x7e, 0x0e, 0x17, 0x79, 0xb9, 0xe2, 0x5b, 0xa0, 0xf1, 0xd7, 0x06, 0xa0, 0x22,
	0x10, 0xda, 0x86, 0x46, 0x72, 0xaf, 0x0b, 0xfa, 0xc6, 0xd9, 0x9a, 0x14, 0x4e, 0x7d, 0x2f, 0x50,
	0x99, 0xf5, 0xbd, 0x40, 0x0b, 0x1a, 0xfe, 0x09, 0x09, 0x43, 0xa7, 0xcb, 0x9d, 0xd4, 0x86, 0x95,
	0xb6, 0xa9, 0xff, 0xaf, 0xdb, 0x78, 0x19, 0x1e, 0x7a, 0xcc, 0xb3, 0xd2, 0x31, 0x70, 0xaa, 0x25,
	0x8a, 0xec, 0x01, 0x91, 0x5e, 0x62, 0x35, 0x2c, 0xa9, 0x87, 0xea, 0xac, 0xe7, 0xb7, 0x89, 0x7b,
	0x2c, 0x88, 0x17, 0x2d, 0xfc, 0x63, 0x68, 0xed, 0x93, 0x78, 0xd7, 0xf7, 0xce, 0x4c, 0x3a, 0xba,
	0x59, 0xe4, 0xab, 0xb6, 0x72, 0x91, 0x41, 0x89, 0xd5, 0x1f, 0x87, 0xfe, 0x0b, 0x59, 0x3d, 0x91,
	0xf0, 0xe4, 0xd5, 0x53, 0x28, 0xfc, 0xcb, 0x2a, 0x2c, 0x29, 0x0f, 0x9b, 0xd0, 0xbb, 0xb0, 0x38,
	0x90, 0x80, 0x27, 0x15, 0x22, 0x15, 0xc0, 0x33, 0xf8, 0x70, 0xe8, 0x75, 0x58, 0x10, 0x96, 0xc5,
	0x3b, 0xf6, 0x13, 0x2f, 0x25, 0x67, 0x62, 0x65, 0x88, 0xac, 0xae, 0x50, 0x9d, 0x52, 0x57, 0x50,
	0x25, 0x52, 0x9b, 0x45, 0x22, 0x2a, 0x1b, 0xe7, 0x67, 0x61, 0x23, 0xda, 0x16, 0x8e, 0x71, 0x9d,
	0x41, 0x5f, 0xd5, 0xbd, 0x18, 0x2b, 0x54, 0x53, 0xb7, 0x61, 0x4d, 0xe6, 0xdf, 0x67, 0x3c, 0x98,
	0x8b, 0xcc, 0x06, 0x73, 0xae, 0xb5, 0x63, 0xe8, 0x55, 0xa8, 0xb3, 0xd7, 0x63, 0x9d, 0x48, 0xe4,
	0x7b, 0x34, 0xef, 0xcb, 0x12, 0x88, 0xf2, 0x09, 0xd0, 0xe7, 0x60, 0x66, 0xa9, 0x6b, 0xf1, 0xde,
	0xad, 0x94, 0x42, 0x6e, 0xe5, 0x0b, 0x8a, 0xfa, 0xb7, 0x74, 0x69, 0x45, 0xf1, 0x3e, 0xa0, 0x3d,
	0xe2, 0xe6, 0x2a, 0x8a, 0xec, 0x5c, 0x27, 0x87, 0x3c, 0x79, 0x77, 0x28, 0xf5, 0x8c, 0x29, 0xc4,
	0x5a, 0x2a, 0xae, 0x28, 0x60, 0x99, 0x26, 0xf5, 0xe5, 0xa8, 0x91, 0x7f, 0x39, 0x3a, 0x25, 0xf9,
	0x33, 0x62, 0xb7, 0xfb, 0xd9, 0x6a, 0x9b, 0x6f, 0x17, 0x6a, 0x9b, 0xc9, 0x05, 0x50, 0x24, 0x57,
	0xaa, 0x70, 0x5a, 0xb0, 0x4c, 0xdd, 0x98, 0x20, 0x8b, 0x0b, 0x72, 0xd1, 0xbd, 0xa1, 0x7d, 0x3e,
	0x25, 0xbd, 0x9e, 0xac, 0x14, 0x5e, 0x4f, 0x7e, 0x06, 0xe7, 0x52, 0x9c, 0x65, 0x1d, 0xdf, 0x20,
	0xc8, 0x0a, 0x3b, 0xa2, 0xb5, 0xfd, 0xcd, 0x72, 0xfa, 0x58, 0x66, 0x37, 0x0e, 0x5d, 0xf4, 0x31,
	0xd4, 0xc8, 0x97, 0x4e, 0x14, 0xa3, 0x56, 0x56, 0x18, 0xc9, 0x3f, 0x38, 0x69, 0x5d, 0xd2, 0x8e,
	0x89, 0x95, 0x76, 0x61, 0xbe, 0xc3, 0x6e, 0x17, 0x74, 0x69, 0xc2, 0x83, 0x85, 0xd6, 0x65, 0xfd,
	0x60, 0x86, 0xa4, 0xcb, 0x5c, 0xa9, 0x14, 0x89, 0xae, 0xea, 0x9f, 0x22, 0xd1, 0x97, 0xf1, 0x6f,
	0xc1, 0x7c, 0x8f, 0x85, 0xfd, 0xc8, 0x2c, 0x54, 0x79, 0x12, 0x0c, 0x17, 0x35, 0x23, 0x62, 0xfa,
	0x1e, 0x2c, 0xf4, 0xb2, 0xea, 0x38, 0x2a, 0x42, 0x26, 0xe2, 0x6d, 0xb5, 0x74, 0x43, 0x02, 0xcb,
	0x53, 0x58, 0x19, 0xb2, 0x10, 0x2a, 0x8b, 0xc3, 0xd0, 0xe6, 0xb4, 0x92, 0x75, 0xeb, 0xfa, 0x04,
	0x08, 0x81, 0xf8, 0x1e, 0xd4, 0xed, 0x6e, 0x97, 0x25, 0x94, 0xae, 0x14, 0x8a, 0x2d, 0x72, 0xcd,
	0xaf, 0x75, 0x75, 0xdc, 0x70, 0x86, 0xa9, 0x47, 0x62, 0x05, 0x93, 0xbe, 0x12, 0x9d, 0x62, 0x1a,
	0x57, 0x70, 0x7e, 0x04, 0xc0, 0x37, 0xcb, 0x90, 0x5d, 0xd3, 0x6d, 0x42, 0xaa, 0x15, 0xb7, 0x36,
	0xc7, 0x03, 0x08, 0x84, 0x9f, 0x00, 0x70, 0x3d, 0x60, 0x08, 0x37, 0xb5, 0xe2, 0x96, 0x09, 0xbc,
	0x3e, 0x01, 0x42, 0xa0, 0xbc, 0xcb, 0xf8, 0x46, 0xad, 0x2d, 0xba, 0x3c, 0xa9, 0x48, 0xd5, 0xba,
	0x32, 0x66, 0x34, 0xc3, 0xd3, 0x23, 0xb1, 0x82, 0x47, 0x5b, 0xd6, 0x6c, 0x5d, 0x99, 0x58, 0x62,
	0x44, 0x0f, 0xa0, 0xc9, 0x79, 0xf6, 0xc4, 0xee, 0xa1, 0xab, 0x3a, 0x8e, 0x64, 0xb5, 0xc2, 0xd6,
	0xb5, 0xb1, 0xe3, 0x99, 0x04, 0x38, 0xc3, 0x18, 0x61, 0xd7, 0x74, 0xec, 0x90, 0x69, 0xdb, 0x1c,
	0x0f, 0x90, 0xbe, 0xb6, 0x5e, 0xea, 0x25, 0x31, 0x21, 0x33, 0xcb, 0x1b, 0xd2, 0x76, 0xe4, 0x08,
	0xa5, 0x65, 0x16, 0x07, 0x04, 0x8e, 0x43, 0x58, 0xe9, 0x49, 0x71, 0x1d, 0x43, 0x23, 0x9d, 0x99,
	0x7c, 0x14, 0x2b, 0xdb, 0x97, 0x62, 0x30, 0xb8, 0x4f, 0x3d, 0xf3, 0x2c, 0xca, 0x4a, 0x11, 0x69,
	0x62, 0xb9, 0xd6, 0x25, 0xed, 0x58, 0x86, 0x68, 0x20, 0x45, 0x39, 0x29, 0x22, 0x4d, 0xf4, 0x95,
	0x22, 0xd2, 0x86, 0x45, 0xf7, 0x61, 0x49, 0x46, 0x14, 0x21, 0x1d, 0x74, 0x94, 0xb7, 0x59, 0xfa,
	0x7f, 0xb2, 0x7c, 0x01, 0xd7, 0x6c, 0x35, 0xb8, 0xb9, 0xeb, 0x87, 0xb2, 0x2b, 0x13, 0xc9, 0xa7,
	0x5d, 0xe3, 0x78, 0xcb, 0xa7, 0x5d, 0xeb, 0xa6, 0x3a, 0x80, 0x3b, 0x05, 0xef, 0xbf, 0xb0, 0xc8,
	0xa6, 0x62, 0x9e, 0x75, 0xeb, 0x5c, 0x9f, 0x00, 0x21, 0x96, 0xfa, 0x1e, 0x6c, 0xf4, 0x98, 0xbf,
	0xcc, 0xbc, 0x35, 0x19, 0x44, 0x36, 0x34, 0x93, 0x90, 0x4f, 0x70, 0xb7, 0x39, 0xf2, 0x42, 0x90,
	0x75, 0x3a, 0xe4, 0xe3, 0x22, 0x89, 0x7d, 0x58, 0xee, 0xca, 0x47, 0x22, 0x33, 0xff, 0x45, 0xa7,
	0xa7, 0xd5, 0xd2, 0x0d, 0x71, 0x44, 0xdb, 0xbf, 0x99, 0x87, 0xf3, 0x39, 0x6f, 0x9a, 0xdd, 0xb3,
	0x87, 0xf4, 0xf2, 0xe6, 0x15, 0x98, 0xf4, 0xd0, 0x8f, 0x29, 0x56, 0xa5, 0x87, 0x7e, 0x6c, 0xe1,
	0xe9, 0x13, 0x80, 0x61, 0x5a, 0xd0, 0xc9, 0x6e, 0x97, 0x71, 0xe5, 0xa3, 0xec, 0x76, 0x19, 0x5f,
	0x05, 0xfa, 0x7f, 0x68, 0xf6, 0x93, 0x32, 0x4c, 0x7a, 0xe4, 0xf3, 0xa5, 0x9e, 0xf4, 0xc8, 0x17,
	0x2b, 0x36, 0x3b, 0x50, 0x3d, 0x76, 0xbc, 0x6e, 0x7a, 0x14, 0x74, 0x05, 0x99, 0xf4, 0x28, 0xe8,
	0xeb, 0x1a, 0xfb, 0xb0, 0xd8, 0x93, 0xb2, 0xd5, 0xb2, 0xc5, 0x28, 0x60, 0xba, 0xa4, 0x1d, 0x13,
	0x88, 0x1e, 0xc2, 0x72, 0x4f, 0x49, 0xff, 0xcb, 0x06, 0xbb, 0x58, 0xce, 0x90, 0x0d, 0xb6, 0xae,
	0x66, 0xf0, 0x14, 0x16, 0xb9, 0xc1, 0xe6, 0x89, 0x64, 0x84, 0xb5, 0x29, 0x5a, 0x25, 0xb5, 0xdd,
	0x7a, 0x69, 0x22, 0x8c, 0x40, 0x6c, 0x83, 0x39, 0x2c, 0x64, 0x5b, 0x85, 0xcb, 0x70, 0x7d, 0x6a,
	0x1e, 0xb8, 0x85, 0x27, 0x81, 0xa4, 0x3e, 0x4d, 0xed, 0xb9, 0x1d, 0x77, 0xfa, 0xa9, 0x5c, 0x74,
	0x29, 0xd9, 0x54, 0x2e, 0xda, 0x84, 0xeb, 0x1b, 0x06, 0x95, 0x4c, 0x5f, 0xfa, 0x6f, 0x1a, 0xd2,
	0xfd, 0x4f, 0x2e, 0x2f, 0x19, 0xdd, 0x9f, 0xd9, 0xb6, 0xff, 0x6d, 0xc0, 0xea, 0xbe, 0x7f, 0x42,
	0x42, 0x4f, 0xf6, 0x41, 0x1f, 0xb2, 0xeb, 0x42, 0x0d, 0x75, 0xc7, 0x7b, 0x70, 0xd7, 0x0a, 0x23,
	0xb9, 0x30, 0xe8, 0x31, 0x9c, 0xeb, 0xa9, 0xff, 0x3b, 0xd2, 0xb8, 0x39, 0xf2, 0x5f, 0xa7, 0x34,
	0x6e, 0x8e, 0xfa, 0x77, 0xa5, 0x8f, 0x19, 0xc6, 0x9d, 0x20, 0x70, 0x9d, 0x8e, 0xcd, 0xff, 0x53,
	0xb5, 0x2e, 0x5d, 0x59, 0x99, 0xe3, 0xdf, 0xba, 0x90, 0xef, 0xe6, 0x18, 0x6e, 0xbf, 0x01, 0xaf,
	0x74, 0xfc, 0xc1, 0x56, 0x7f, 0x68, 0x3f, 0x27, 0xce, 0x56, 0x60, 0xdb, 0xd1, 0x56, 0x27, 0x22,
	0x5b, 0x22, 0x84, 0xe0, 0xa7, 0x32, 0x1c, 0x6d, 0xd9, 0x81, 0xf3, 0x39, 0xff, 0xcb, 0xe6, 0xd1,
	0x3c, 0xfb, 0x79, 0xf3, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x98, 0xc3, 0x2f, 0x48, 0xd2, 0x39,
	0x00, 0x00,
}
