/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.format;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoFactory;
import com.esotericsoftware.kryo.pool.KryoPool;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.servicecomb.saga.omega.format.MessageFormat;
import org.apache.servicecomb.saga.omega.transaction.OmegaException;

public class KryoMessageFormat
implements MessageFormat {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final KryoFactory factory = Kryo::new;
    private static final KryoPool pool = new KryoPool.Builder(factory).softReferences().build();

    public byte[] serialize(Object[] objects) {
        Output output = new Output(4096, -1);
        Kryo kryo = pool.borrow();
        kryo.writeObjectOrNull(output, (Object)objects, Object[].class);
        pool.release(kryo);
        return output.toBytes();
    }

    public Object[] deserialize(byte[] message) {
        try {
            Input input = new Input((InputStream)new ByteArrayInputStream(message));
            Kryo kryo = pool.borrow();
            Object[] objects = (Object[])kryo.readObjectOrNull(input, Object[].class);
            pool.release(kryo);
            return objects;
        }
        catch (KryoException e) {
            throw new OmegaException("Unable to deserialize message", (Throwable)e);
        }
    }
}

