/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.transaction;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.apache.servicecomb.saga.omega.context.OmegaContext;
import org.apache.servicecomb.saga.omega.context.annotations.SagaStart;
import org.apache.servicecomb.saga.omega.transaction.MessageSender;
import org.apache.servicecomb.saga.omega.transaction.OmegaException;
import org.apache.servicecomb.saga.omega.transaction.SagaStartAnnotationProcessor;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class SagaStartAspect {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SagaStartAnnotationProcessor sagaStartAnnotationProcessor;
    private final OmegaContext context;

    public SagaStartAspect(MessageSender sender, OmegaContext context) {
        this.context = context;
        this.sagaStartAnnotationProcessor = new SagaStartAnnotationProcessor(context, sender);
    }

    @Around(value="execution(@org.apache.servicecomb.saga.omega.context.annotations.SagaStart * *(..)) && @annotation(sagaStart)")
    Object advise(ProceedingJoinPoint joinPoint, SagaStart sagaStart) throws Throwable {
        this.initializeOmegaContext();
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        this.sagaStartAnnotationProcessor.preIntercept(this.context.globalTxId(), method.toString(), sagaStart.timeout(), "", 0, new Object[0]);
        LOG.debug("Initialized context {} before execution of method {}", (Object)this.context, (Object)method.toString());
        try {
            Object result = joinPoint.proceed();
            this.sagaStartAnnotationProcessor.postIntercept(this.context.globalTxId(), method.toString());
            LOG.debug("Transaction with context {} has finished.", (Object)this.context);
            Object object = result;
            return object;
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof OmegaException)) {
                this.sagaStartAnnotationProcessor.onError(this.context.globalTxId(), method.toString(), throwable);
                LOG.error("Transaction {} failed.", (Object)this.context.globalTxId());
            }
            throw throwable;
        }
        finally {
            this.context.clear();
        }
    }

    private void initializeOmegaContext() {
        this.context.setLocalTxId(this.context.newGlobalTxId());
    }
}

