/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.transaction;

import org.apache.servicecomb.saga.omega.context.OmegaContext;
import org.apache.servicecomb.saga.omega.transaction.AlphaResponse;
import org.apache.servicecomb.saga.omega.transaction.EventAwareInterceptor;
import org.apache.servicecomb.saga.omega.transaction.MessageSender;
import org.apache.servicecomb.saga.omega.transaction.TxAbortedEvent;
import org.apache.servicecomb.saga.omega.transaction.TxEndedEvent;
import org.apache.servicecomb.saga.omega.transaction.TxStartedEvent;

class CompensableInterceptor
implements EventAwareInterceptor {
    private final OmegaContext context;
    private final MessageSender sender;

    CompensableInterceptor(OmegaContext context, MessageSender sender) {
        this.sender = sender;
        this.context = context;
    }

    @Override
    public AlphaResponse preIntercept(String parentTxId, String compensationMethod, int timeout, String retriesMethod, int retries, Object ... message) {
        return this.sender.send(new TxStartedEvent(this.context.globalTxId(), this.context.localTxId(), parentTxId, compensationMethod, timeout, retriesMethod, retries, message));
    }

    @Override
    public void postIntercept(String parentTxId, String compensationMethod) {
        this.sender.send(new TxEndedEvent(this.context.globalTxId(), this.context.localTxId(), parentTxId, compensationMethod));
    }

    @Override
    public void onError(String parentTxId, String compensationMethod, Throwable throwable) {
        this.sender.send(new TxAbortedEvent(this.context.globalTxId(), this.context.localTxId(), parentTxId, compensationMethod, throwable));
    }
}

