/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.connector.grpc;

import io.grpc.stub.StreamObserver;
import java.lang.invoke.MethodHandles;
import org.apache.servicecomb.saga.omega.transaction.MessageDeserializer;
import org.apache.servicecomb.saga.omega.transaction.MessageHandler;
import org.apache.servicecomb.saga.pack.contract.grpc.GrpcCompensateCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcCompensateStreamObserver
implements StreamObserver<GrpcCompensateCommand> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MessageHandler messageHandler;
    private final Runnable errorHandler;
    private final MessageDeserializer deserializer;

    GrpcCompensateStreamObserver(MessageHandler messageHandler, Runnable errorHandler, MessageDeserializer deserializer) {
        this.messageHandler = messageHandler;
        this.errorHandler = errorHandler;
        this.deserializer = deserializer;
    }

    public void onNext(GrpcCompensateCommand command) {
        LOG.info("Received compensate command, global tx id: {}, local tx id: {}, compensation method: {}", new Object[]{command.getGlobalTxId(), command.getLocalTxId(), command.getCompensationMethod()});
        this.messageHandler.onReceive(command.getGlobalTxId(), command.getLocalTxId(), command.getParentTxId().isEmpty() ? null : command.getParentTxId(), command.getCompensationMethod(), this.deserializer.deserialize(command.getPayloads().toByteArray()));
    }

    public void onError(Throwable t) {
        LOG.error("failed to process grpc compensate command.", t);
        this.errorHandler.run();
    }

    public void onCompleted() {
    }
}

