/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.connector.grpc;

import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.function.Function;
import org.apache.servicecomb.saga.omega.connector.grpc.GrpcCompensateStreamObserver;
import org.apache.servicecomb.saga.omega.context.ServiceConfig;
import org.apache.servicecomb.saga.omega.transaction.AlphaResponse;
import org.apache.servicecomb.saga.omega.transaction.MessageDeserializer;
import org.apache.servicecomb.saga.omega.transaction.MessageHandler;
import org.apache.servicecomb.saga.omega.transaction.MessageSender;
import org.apache.servicecomb.saga.omega.transaction.MessageSerializer;
import org.apache.servicecomb.saga.omega.transaction.TxEvent;
import org.apache.servicecomb.saga.pack.contract.grpc.GrpcAck;
import org.apache.servicecomb.saga.pack.contract.grpc.GrpcServiceConfig;
import org.apache.servicecomb.saga.pack.contract.grpc.GrpcTxEvent;
import org.apache.servicecomb.saga.pack.contract.grpc.TxEventServiceGrpc;

public class GrpcClientMessageSender
implements MessageSender {
    private final String target;
    private final TxEventServiceGrpc.TxEventServiceStub asyncEventService;
    private final MessageSerializer serializer;
    private final TxEventServiceGrpc.TxEventServiceBlockingStub blockingEventService;
    private final GrpcCompensateStreamObserver compensateStreamObserver;
    private final GrpcServiceConfig serviceConfig;

    public GrpcClientMessageSender(String address, ManagedChannel channel, MessageSerializer serializer, MessageDeserializer deserializer, ServiceConfig serviceConfig, Function<MessageSender, Runnable> errorHandlerFactory, MessageHandler handler) {
        this.target = address;
        this.asyncEventService = TxEventServiceGrpc.newStub((Channel)channel);
        this.blockingEventService = TxEventServiceGrpc.newBlockingStub((Channel)channel);
        this.serializer = serializer;
        this.compensateStreamObserver = new GrpcCompensateStreamObserver(handler, errorHandlerFactory.apply(this), deserializer);
        this.serviceConfig = this.serviceConfig(serviceConfig.serviceName(), serviceConfig.instanceId());
    }

    public void onConnected() {
        this.asyncEventService.onConnected(this.serviceConfig, (StreamObserver)this.compensateStreamObserver);
    }

    public void onDisconnected() {
        this.blockingEventService.onDisconnected(this.serviceConfig);
    }

    public String target() {
        return this.target;
    }

    public AlphaResponse send(TxEvent event) {
        GrpcAck grpcAck = this.blockingEventService.onTxEvent(this.convertEvent(event));
        return new AlphaResponse(grpcAck.getAborted());
    }

    private GrpcTxEvent convertEvent(TxEvent event) {
        ByteString payloads = ByteString.copyFrom((byte[])this.serializer.serialize(event.payloads()));
        GrpcTxEvent.Builder builder = GrpcTxEvent.newBuilder().setServiceName(this.serviceConfig.getServiceName()).setInstanceId(this.serviceConfig.getInstanceId()).setTimestamp(event.timestamp()).setGlobalTxId(event.globalTxId()).setLocalTxId(event.localTxId()).setParentTxId(event.parentTxId() == null ? "" : event.parentTxId()).setType(event.type().name()).setTimeout(event.timeout()).setCompensationMethod(event.compensationMethod()).setRetryMethod(event.retryMethod() == null ? "" : event.retryMethod()).setRetries(event.retries()).setPayloads(payloads);
        return builder.build();
    }

    private GrpcServiceConfig serviceConfig(String serviceName, String instanceId) {
        return GrpcServiceConfig.newBuilder().setServiceName(serviceName).setInstanceId(instanceId).build();
    }
}

