/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.omega.transport.dubbo;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import java.lang.invoke.MethodHandles;
import org.apache.servicecomb.saga.omega.context.OmegaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Activate(group={"provider"})
public class SagaDubboProviderFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired(required=false)
    private OmegaContext omegaContext;

    public void setOmegaContext(OmegaContext omegaContext) {
        this.omegaContext = omegaContext;
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (this.omegaContext != null) {
            String globalTxId = invocation.getAttachment("X-Pack-Global-Transaction-Id");
            if (globalTxId == null) {
                LOG.info("no such omega context global id: {}", (Object)"X-Pack-Global-Transaction-Id");
            } else {
                this.omegaContext.setGlobalTxId(globalTxId);
                this.omegaContext.setLocalTxId(invocation.getAttachment("X-Pack-Local-Transaction-Id"));
                LOG.info("Added {} {} and {} {} to omegaContext", new Object[]{"X-Pack-Global-Transaction-Id", this.omegaContext.globalTxId(), "X-Pack-Local-Transaction-Id", this.omegaContext.localTxId()});
            }
            invocation.getAttachments().put("X-Pack-Global-Transaction-Id", null);
            invocation.getAttachments().put("X-Pack-Local-Transaction-Id", null);
        } else {
            LOG.debug("Cannot find omegaContext");
        }
        if (invoker != null) {
            return invoker.invoke(invocation);
        }
        return null;
    }
}

