/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.alpha.core;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.BlockingQueue;
import org.apache.servicecomb.saga.alpha.core.OmegaCallback;
import org.apache.servicecomb.saga.alpha.core.TxEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushBackOmegaCallback
implements OmegaCallback {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final BlockingQueue<Runnable> pendingCompensations;
    private final OmegaCallback underlying;

    public PushBackOmegaCallback(BlockingQueue<Runnable> pendingCompensations, OmegaCallback underlying) {
        this.pendingCompensations = pendingCompensations;
        this.underlying = underlying;
    }

    @Override
    public void compensate(TxEvent event) {
        try {
            this.underlying.compensate(event);
        }
        catch (Exception e) {
            this.logError(event, e);
            this.pendingCompensations.offer(() -> this.compensate(event));
        }
    }

    private void logError(TxEvent event, Exception e) {
        LOG.error("Failed to {} service [{}] instance [{}] with method [{}], global tx id [{}] and local tx id [{}]", new Object[]{event.retries() == 0 ? "compensate" : "retry", event.serviceName(), event.instanceId(), event.retries() == 0 ? event.compensationMethod() : event.retryMethod(), event.globalTxId(), event.localTxId(), e});
    }
}

