/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.alpha.core;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.saga.alpha.core.Command;
import org.apache.servicecomb.saga.alpha.core.CommandRepository;
import org.apache.servicecomb.saga.alpha.core.OmegaCallback;
import org.apache.servicecomb.saga.alpha.core.TaskStatus;
import org.apache.servicecomb.saga.alpha.core.TxEvent;
import org.apache.servicecomb.saga.alpha.core.TxEventRepository;
import org.apache.servicecomb.saga.alpha.core.TxTimeout;
import org.apache.servicecomb.saga.alpha.core.TxTimeoutRepository;
import org.apache.servicecomb.saga.common.EventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventScanner
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final byte[] EMPTY_PAYLOAD = new byte[0];
    private final ScheduledExecutorService scheduler;
    private final TxEventRepository eventRepository;
    private final CommandRepository commandRepository;
    private final TxTimeoutRepository timeoutRepository;
    private final OmegaCallback omegaCallback;
    private final int eventPollingInterval;
    private long nextEndedEventId;
    private long nextCompensatedEventId;

    public EventScanner(ScheduledExecutorService scheduler, TxEventRepository eventRepository, CommandRepository commandRepository, TxTimeoutRepository timeoutRepository, OmegaCallback omegaCallback, int eventPollingInterval) {
        this.scheduler = scheduler;
        this.eventRepository = eventRepository;
        this.commandRepository = commandRepository;
        this.timeoutRepository = timeoutRepository;
        this.omegaCallback = omegaCallback;
        this.eventPollingInterval = eventPollingInterval;
    }

    @Override
    public void run() {
        this.pollEvents();
    }

    private void pollEvents() {
        this.scheduler.scheduleWithFixedDelay(() -> {
            this.updateTimeoutStatus();
            this.findTimeoutEvents();
            this.abortTimeoutEvents();
            this.saveUncompensatedEventsToCommands();
            this.compensate();
            this.updateCompensatedCommands();
            this.deleteDuplicateSagaEndedEvents();
            this.updateTransactionStatus();
        }, 0L, this.eventPollingInterval, TimeUnit.MILLISECONDS);
    }

    private void findTimeoutEvents() {
        this.eventRepository.findTimeoutEvents().forEach(event -> {
            LOG.info("Found timeout event {}", event);
            this.timeoutRepository.save(this.txTimeoutOf((TxEvent)event));
        });
    }

    private void updateTimeoutStatus() {
        this.timeoutRepository.markTimeoutAsDone();
    }

    private void saveUncompensatedEventsToCommands() {
        this.eventRepository.findFirstUncompensatedEventByIdGreaterThan(this.nextEndedEventId, EventType.TxEndedEvent.name()).forEach(event -> {
            LOG.info("Found uncompensated event {}", event);
            this.nextEndedEventId = event.id();
            this.commandRepository.saveCompensationCommands(event.globalTxId());
        });
    }

    private void updateCompensatedCommands() {
        this.eventRepository.findFirstCompensatedEventByIdGreaterThan(this.nextCompensatedEventId).ifPresent(event -> {
            LOG.info("Found compensated event {}", event);
            this.nextCompensatedEventId = event.id();
            this.updateCompensationStatus((TxEvent)event);
        });
    }

    private void deleteDuplicateSagaEndedEvents() {
        try {
            this.eventRepository.deleteDuplicateEvents(EventType.SagaEndedEvent.name());
        }
        catch (Exception e) {
            LOG.warn("Failed to delete duplicate event", (Throwable)e);
        }
    }

    private void updateCompensationStatus(TxEvent event) {
        this.commandRepository.markCommandAsDone(event.globalTxId(), event.localTxId());
        LOG.info("Transaction with globalTxId {} and localTxId {} was compensated", (Object)event.globalTxId(), (Object)event.localTxId());
        this.markSagaEnded(event);
    }

    private void abortTimeoutEvents() {
        this.timeoutRepository.findFirstTimeout().forEach(timeout -> {
            LOG.info("Found timeout event {} to abort", timeout);
            this.eventRepository.save(this.toTxAbortedEvent((TxTimeout)timeout));
            if (timeout.type().equals(EventType.TxStartedEvent.name())) {
                this.eventRepository.findTxStartedEvent(timeout.globalTxId(), timeout.localTxId()).ifPresent(this.omegaCallback::compensate);
            }
        });
    }

    private void updateTransactionStatus() {
        this.eventRepository.findFirstAbortedGlobalTransaction().ifPresent(this::markGlobalTxEndWithEvents);
    }

    private void markSagaEnded(TxEvent event) {
        if (this.commandRepository.findUncompletedCommands(event.globalTxId()).isEmpty()) {
            this.markGlobalTxEndWithEvent(event);
        }
    }

    private void markGlobalTxEndWithEvent(TxEvent event) {
        this.eventRepository.save(this.toSagaEndedEvent(event));
        LOG.info("Marked end of transaction with globalTxId {}", (Object)event.globalTxId());
    }

    private void markGlobalTxEndWithEvents(List<TxEvent> events) {
        events.forEach(this::markGlobalTxEndWithEvent);
    }

    private TxEvent toTxAbortedEvent(TxTimeout timeout) {
        return new TxEvent(timeout.serviceName(), timeout.instanceId(), timeout.globalTxId(), timeout.localTxId(), timeout.parentTxId(), EventType.TxAbortedEvent.name(), "", "Transaction timeout".getBytes());
    }

    private TxEvent toSagaEndedEvent(TxEvent event) {
        return new TxEvent(event.serviceName(), event.instanceId(), event.globalTxId(), event.globalTxId(), null, EventType.SagaEndedEvent.name(), "", EMPTY_PAYLOAD);
    }

    private void compensate() {
        this.commandRepository.findFirstCommandToCompensate().forEach(command -> {
            LOG.info("Compensating transaction with globalTxId {} and localTxId {}", (Object)command.globalTxId(), (Object)command.localTxId());
            this.omegaCallback.compensate(this.txStartedEventOf((Command)command));
        });
    }

    private TxEvent txStartedEventOf(Command command) {
        return new TxEvent(command.serviceName(), command.instanceId(), command.globalTxId(), command.localTxId(), command.parentTxId(), EventType.TxStartedEvent.name(), command.compensationMethod(), command.payloads());
    }

    private TxTimeout txTimeoutOf(TxEvent event) {
        return new TxTimeout(event.id(), event.serviceName(), event.instanceId(), event.globalTxId(), event.localTxId(), event.parentTxId(), event.type(), event.expiryTime(), TaskStatus.NEW.name());
    }
}

