/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.saga.alpha.core;

import java.util.Collections;
import java.util.Map;
import org.apache.servicecomb.saga.alpha.core.AlphaException;
import org.apache.servicecomb.saga.alpha.core.OmegaCallback;
import org.apache.servicecomb.saga.alpha.core.TxEvent;

public class CompositeOmegaCallback
implements OmegaCallback {
    private final Map<String, Map<String, OmegaCallback>> callbacks;

    public CompositeOmegaCallback(Map<String, Map<String, OmegaCallback>> callbacks) {
        this.callbacks = callbacks;
    }

    @Override
    public void compensate(TxEvent event) {
        Map serviceCallbacks = this.callbacks.getOrDefault(event.serviceName(), Collections.emptyMap());
        if (serviceCallbacks.isEmpty()) {
            throw new AlphaException("No such omega callback found for service " + event.serviceName());
        }
        OmegaCallback omegaCallback = (OmegaCallback)serviceCallbacks.get(event.instanceId());
        if (omegaCallback == null) {
            omegaCallback = (OmegaCallback)serviceCallbacks.values().iterator().next();
        }
        try {
            omegaCallback.compensate(event);
        }
        catch (Exception e) {
            serviceCallbacks.values().remove(omegaCallback);
            throw e;
        }
    }
}

